/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.WebBillManpowerActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.app.DefaultApplicationManager;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.DataTypeEnum;
import com.kingdee.bos.workflow.metas.IAssign;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.util.StoreUtils;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentHandleFacade;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.message.Assign;
import com.kingdee.eas.base.message.AssignReadFactory;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.BillWebUtil;
import com.kingdee.eas.base.message.IAssignRead;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.IMsgSendRecord;
import com.kingdee.eas.base.message.Message;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.MessageViewConfig;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgSendRecordFactory;
import com.kingdee.eas.base.message.MsgSourceStatus;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.URLInfo;
import com.kingdee.eas.base.message.app.msgcount.ClassificationStatCacheManager;
import com.kingdee.eas.base.message.util.MessageUtil;
import com.kingdee.eas.base.myeas.IMessageOption;
import com.kingdee.eas.base.myeas.MessageOptionFactory;
import com.kingdee.eas.base.myeas.MessageOptionInfo;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.receiver.BasReceiverCollection;
import com.kingdee.eas.base.receiver.BasReceiverInfo;
import com.kingdee.eas.base.receiver.util.receiver.ReceiverMessageUtils;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.mobile.IMobileMessageAssign;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.mobile.MobileMessageAssignFactory;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class ProcessCenterUtil {
    static Logger logger = Logger.getLogger((String)ProcessCenterUtil.class.getName());
    private static final String RESOURCE = "com.kingdee.eas.base.message.MessageCenter";
    private static String URLNAME = "url";
    private static String FAILURE = "failure";
    private static String SUCCESS = "success";
    private static String LOG = "log";
    private static Locale locale = ContextUtils.getLocaleFromEnv();
    private static Locale EN = new Locale("L1");
    private static Locale ZH_CN = new Locale("L2");
    private static Locale ZH_HK = new Locale("L3");

    public static boolean canGetWebUrl(String assignId, Context ctx) {
        boolean result = false;
        try {
            EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
            String uiName = (String)service.getAssignmentArgument(assignId, true).get("UIClassName");
            if (!StringUtils.isEmpty((String)uiName)) {
                logger.debug((Object)("UIClassName -> " + uiName));
                String name = uiName.substring(uiName.lastIndexOf(".") + 1, uiName.length());
                String bizPackgeName = uiName.substring(0, uiName.lastIndexOf("."));
                MetaDataPK metaPK = new MetaDataPK(bizPackgeName, name);
                UIObjectCtrl ctrl = new UIObjectCtrl(ctx);
                UIObjectInfo ui = ctrl.getValue((IMetaDataPK)metaPK);
                Map map = ui.getExtendedProperties();
                if (map != null && map.size() > 0 && !StringUtils.isEmpty((String)((String)map.get("url")))) {
                    logger.debug((Object)("URL -> " + (String)map.get("url")));
                    result = true;
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u521d\u59cb\u5316\u5de5\u4f5c\u6d41\u670d\u52a1\u9519\u8bef", (Throwable)e);
        }
        return result;
    }

    public static URLInfo getUrlInfos(String assignmentIDs, Context ctx) {
        URLInfo info = new URLInfo();
        IEnactmentService service = null;
        String[] idArray = assignmentIDs.split(";");
        boolean isMultiAssign = false;
        try {
            String url = "";
            String bizPackgeName = "";
            String bizFunName = "";
            String bizOperation = "";
            MetaDataPK metaPK = null;
            OperationInfo oper = null;
            FunctionObjectInfo function = null;
            UIObjectInfo ui = null;
            Map map = new HashMap();
            String assignUrl = "";
            String[] bizObjectID = null;
            String billID = "";
            IMetaDataLoader dataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
            AssignmentInfo[] assInfos = null;
            if (idArray.length > 1) {
                assInfos = iEnactmentService.getAssignmentById(idArray, DataTypeEnum.RUNTIME);
                isMultiAssign = true;
            } else {
                AssignmentInfo assInfo = iEnactmentService.getAssignmentById(assignmentIDs);
                assInfos = new AssignmentInfo[]{assInfo};
            }
            for (int i = 0; i < assInfos.length; ++i) {
                bizPackgeName = assInfos[i].getBizPackage();
                bizFunName = assInfos[i].getBizFunction();
                bizOperation = assInfos[i].getBizOperation();
                bizObjectID = assInfos[i].getBizObjectIdArray();
                if (WfAssignmentState.CANCELED.equals((Object)assInfos[i].getState())) {
                    info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"taskcancel", (Locale)ProcessCenterUtil.getLocale(ctx)));
                    return info;
                }
                if (WfAssignmentState.REJECTED.equals((Object)assInfos[i].getState())) {
                    info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"taskreject", (Locale)ProcessCenterUtil.getLocale(ctx)));
                    return info;
                }
                if (WfAssignmentState.COMPLETED.equals((Object)assInfos[i].getState())) {
                    info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"taskcomplete", (Locale)ProcessCenterUtil.getLocale(ctx)));
                    return info;
                }
                Map m = iEnactmentService.getActivityDefAndActivityInstInfo(assInfos[i].getAssignmentId());
                Object act = m.get("ACTIVITYDEF");
                if (act instanceof WebBillManpowerActivityDef) {
                    String webUrl = ((WebBillManpowerActivityDef)act).getUrl();
                    if (webUrl != null && !webUrl.equals("")) {
                        assignUrl = "/easweb" + webUrl;
                        info.setURL(assignUrl);
                        info.setUIStatus(((WebBillManpowerActivityDef)act).getUiState());
                    }
                } else {
                    ActivityInstInfo instInfo;
                    metaPK = new MetaDataPK(bizPackgeName, bizFunName);
                    function = dataLoader.getFunction((IMetaDataPK)metaPK);
                    oper = ProcessCenterUtil.getOperation(bizOperation, function);
                    if (oper == null || oper.getUiActionRef() == null) {
                        throw new WfException("UI is null");
                    }
                    service = EnactmentServiceProxy.getEnacementService((Context)ctx);
                    String dynamicURL = "";
                    dynamicURL = ProcessCenterUtil.getWaf2DynamicPageURL(service, assInfos[i]);
                    if ("".equals(dynamicURL) && bizObjectID != null && bizObjectID[0] != null) {
                        ProcessInstInfo[] processInstInfos = service.getAllProcessInstancesByBizobjId(bizObjectID[0]);
                        for (int j = 0; j < processInstInfos.length; ++j) {
                            AssignmentInfo[] assignmentInfos = service.getAssignmentAllByProcInstId(processInstInfos[j].getProcInstId());
                            if (!StringUtils.isEmpty((String)dynamicURL)) break;
                            for (int l = 0; l < assignmentInfos.length && StringUtils.isEmpty((String)(dynamicURL = ProcessCenterUtil.getWaf2DynamicPageURL(service, assignmentInfos[l]))); ++l) {
                            }
                        }
                    }
                    if (StringUtils.isEmpty((String)dynamicURL) && bizObjectID != null && bizObjectID[0] != null) {
                        BOSUuid id = BOSUuid.read((String)bizObjectID[0]);
                        EntityObjectInfo billObject = dataLoader.getEntity(id.getType());
                        dynamicURL = ProcessCenterUtil.getWAF2SolutionURL(billObject, "edit", ctx, bizObjectID[0]);
                    }
                    if (dynamicURL != null && !"".equals(dynamicURL)) {
                        assignUrl = dynamicURL;
                        instInfo = iEnactmentService.getActivityInstByActInstId(assInfos[i].getActInstId());
                        ActivityDef def = iEnactmentService.getActDefByActInstInfo(instInfo);
                        if (!(def instanceof ApproveActivityDef) && !(def instanceof ManualDecisionActivityDef)) {
                            assignUrl = assignUrl + "&operateState=EDIT";
                        }
                    }
                    if (StringUtils.isEmpty((String)assignUrl)) {
                        ui = oper.getUiActionRef().getUIObjectRef();
                        if (ui != null) {
                            map = ui.getExtendedProperties();
                        }
                        assignUrl = (String)map.get(URLNAME);
                    }
                    if (bizObjectID != null && bizObjectID[0] != null) {
                        ActivityDef def;
                        billID = bizObjectID[0];
                        if ("09DEC9DC".equals(BOSUuid.read((String)billID).getType().toString())) {
                            service = EnactmentServiceProxy.getEnacementService((Context)ctx);
                            if (assignUrl != null && bizFunName.equals("MultiApproveUIFunction")) {
                                Map argumentMap = service.getAssignmentArgument(assInfos[i].getAssignmentId(), true);
                                String editUIName = (String)argumentMap.get("UIClassName");
                                if (StringUtils.isEmpty((String)billID)) {
                                    billID = argumentMap.get("ID").toString();
                                }
                                if (StringUtils.isEmpty((String)billID)) {
                                    billID = argumentMap.get("billID").toString();
                                }
                                String[] editURlStr = null;
                                if (!StringUtils.isEmpty((String)billID) && StringUtils.isEmpty((String)editUIName)) {
                                    editUIName = ProcessCenterUtil.getEditUIClassByBillId(billID, ctx);
                                }
                                if ((editURlStr = ProcessCenterUtil.getURLByClassName(editUIName, ctx))[0] == null || "".equals(editURlStr[0])) {
                                    assignUrl = "";
                                }
                            }
                        } else if (StringUtils.isEmpty((String)assignUrl) && !StringUtils.isEmpty((String)(assignUrl = StoreUtils.getWebUIurl((String)billID, (Context)ctx))) && !((def = iEnactmentService.getActDefByActInstInfo(instInfo = iEnactmentService.getActivityInstByActInstId(assInfos[i].getActInstId()))) instanceof ApproveActivityDef) && !(def instanceof ManualDecisionActivityDef)) {
                            assignUrl = assignUrl + "&operateState=EDIT";
                        }
                    } else {
                        logger.error((Object)"ProcessCenterUtil# bizObjectID is null :");
                    }
                    if (map != null) {
                        if (assignUrl != null) {
                            if (i == 0) {
                                info.setURL(assignUrl);
                                url = assignUrl;
                            } else if (assignUrl != null && !assignUrl.equals(url)) {
                                info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"notSameType", (Locale)ProcessCenterUtil.getLocale(ctx)));
                                return info;
                            }
                        }
                        if (!isMultiAssign) {
                            if (map.get("height") != null) {
                                info.setHeight((String)map.get("height"));
                            }
                            if (map.get("width") != null) {
                                info.setWidth((String)map.get("width"));
                            }
                            if (map.get("openWay") != null) {
                                info.setOpenWay((String)map.get("openWay"));
                            }
                            if (map.get("editpage") != null) {
                                info.setEditPage((String)map.get("editpage"));
                            }
                        }
                    }
                }
                if (isMultiAssign) continue;
                if (bizObjectID != null && bizObjectID[0] != null) {
                    billID = bizObjectID[0];
                    info.setBillID(billID);
                }
                String cusStatus = null;
                String actInstId = assInfos[i].getActInstId();
                ActivityInstInfo actInstInfo = iEnactmentService.getActivityInstByActInstId(actInstId);
                ActivityDef actDef = iEnactmentService.getActDefByActInstInfo(actInstInfo);
                if (actDef != null && actDef.getActivityHeader().getExtendedAttributes().get("customUIStatus") != null) {
                    ExtendedAttributeDef attrDef = actDef.getActivityHeader().getExtendedAttributes().get("customUIStatus");
                    cusStatus = attrDef.getValue();
                }
                logger.info((Object)("ProcessCenterUtil#get customUIStatus from ActivityDef: " + cusStatus));
                info.setUIStatus(cusStatus);
                String decisionItems = "";
                if (!(actDef instanceof ApproveActivityDef)) continue;
                decisionItems = ProcessCenterUtil.getCustomDecisiones(actDef, "manualDecisionItems");
                info.setDecisionItems(decisionItems);
            }
        }
        catch (WfException we) {
            logger.error((Object)"WfException", (Throwable)we);
            info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)ProcessCenterUtil.getLocale(ctx)));
        }
        catch (BOSException be) {
            logger.error((Object)"BOSException", (Throwable)be);
            info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)ProcessCenterUtil.getLocale(ctx)));
        }
        catch (Exception e) {
            logger.error((Object)EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)ProcessCenterUtil.getLocale(ctx)), (Throwable)e);
            info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)ProcessCenterUtil.getLocale(ctx)));
        }
        return info;
    }

    public static Locale getLocale(Context ctx) {
        if (ctx == null) {
            return locale;
        }
        if (ctx.getLocale() == null) {
            return locale;
        }
        return ctx.getLocale();
    }

    private static OperationInfo getOperation(String bizOperation, FunctionObjectInfo function) {
        OperationInfo oper = null;
        OperationCollection operCol = function.getOperation();
        for (int i = 0; i < operCol.size(); ++i) {
            if (!StringUtils.equalsIgnoreCase((String)operCol.get(i).getName(), (String)bizOperation)) continue;
            oper = operCol.get(i);
            break;
        }
        return oper;
    }

    public static String getEditUIClassByBillId(String billId, Context ctx) {
        BOSUuid id = BOSUuid.read((String)billId);
        BOSObjectType type = id.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo vo = loader.getEntity(type);
        String editUi = vo.getExtendedProperty("editUI");
        return editUi;
    }

    public static String getCustomDecisiones(ActivityDef actDef, String propertyKey) {
        ExtendedAttributeDef att = actDef.getActivityHeader().getExtendedAttributes().get(propertyKey);
        String propertyValue = "";
        if (att != null) {
            propertyValue = att.getValue();
        }
        if (StringUtils.isEmpty((String)propertyValue)) {
            ApproveActivityDef temp = null;
            if (actDef instanceof ApproveActivityDef) {
                temp = (ApproveActivityDef)actDef;
                propertyValue = temp.getManualDecisionItems(locale);
            }
        }
        return propertyValue;
    }

    public static String[] getDynamicEditURLByBillId(String billId, Context ctx) {
        BOSUuid id = BOSUuid.read((String)billId);
        BOSObjectType type = id.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo vo = loader.getEntity(type);
        if (vo != null) {
            String v = vo.getExtendedProperty("isDynamic");
            String editpk = vo.getExtendedProperty("webEditUI");
            if ("true".equalsIgnoreCase(v) && !StringUtils.isEmpty((String)editpk)) {
                return new String[]{"/winlet/edit/editUIProxy.jsf", editpk};
            }
        }
        return null;
    }

    public static String getWebfullyTaskProcName(String assignId, Context ctx) {
        String procDefName = ProcessCenterUtil.getProNameByAssign(assignId, ctx);
        if (!StringUtils.isEmpty((String)procDefName) && ProcessCenterUtil.isWebTask(assignId, procDefName, ctx)) {
            logger.info((Object)("getWebfullyTaskProcName procDefName: " + procDefName));
            return procDefName;
        }
        return "";
    }

    public static String getProNameByAssign(String assignId, Context ctx) {
        String defName = null;
        try {
            EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
            AssignmentInfo wholeInfo = service.getAssignmentById(assignId);
            Locale locale = ProcessCenterUtil.getLocale(ctx);
            defName = wholeInfo.getProcDefName(locale);
        }
        catch (BOSException e) {
            logger.error((Object)"\u521d\u59cb\u5316\u5de5\u4f5c\u6d41\u670d\u52a1\u9519\u8bef", (Throwable)e);
        }
        return defName;
    }

    public static boolean isWebTask(String assignmentId, String proName, Context ctx) {
        boolean webTag = false;
        try {
            IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
            if (BillWebUtil.isHasWebHtml(ctx, assignmentId, proName)) {
                int type = service.getActTypeByAssignment(assignmentId);
                logger.info((Object)("type is " + type));
                if (3 == type) {
                    String status = service.getStatusByAssignment(assignmentId);
                    logger.info((Object)("status is " + status));
                    if (StringUtils.isEmpty((String)status)) {
                        webTag = true;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)("webTag is " + webTag));
        return webTag;
    }

    public static boolean isWebBill(String assignmentId, String proName, Context ctx) {
        boolean webTag = false;
        try {
            if (BillWebUtil.isHasWebHtml(ctx, assignmentId, proName)) {
                webTag = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return webTag;
    }

    public static String getUrlFromProcdef(Context ctx, ProcessDef def, String billID) throws Exception {
        if (def == null) {
            return null;
        }
        ActivityCollection actColl = def.getActivitys();
        logger.info((Object)("actColl.size() = " + actColl.size()));
        for (int i = 0; i < actColl.size(); ++i) {
            String url;
            ApproveActivityDef approDef;
            ExtendedAttributeDef extend;
            ActivityDef act = actColl.get(i);
            if (act instanceof WebBillManpowerActivityDef) {
                StringBuffer webUrl = new StringBuffer(((WebBillManpowerActivityDef)act).getUrl());
                logger.info((Object)("webUrl = " + webUrl));
                if (webUrl.length() > 0) {
                    if (webUrl.indexOf("?") > 0) {
                        webUrl.append("&pk=").append(StringUtils.replace((String)billID, (String)"+", (String)"%2B"));
                    } else {
                        webUrl.append("?pk=").append(StringUtils.replace((String)billID, (String)"+", (String)"%2B"));
                    }
                    logger.info((Object)("WebBillManpowerActivityDef webUrl = " + webUrl));
                    return webUrl.toString();
                }
            } else if (act instanceof ApproveActivityDef && (extend = (approDef = (ApproveActivityDef)act).getActivityHeader().getExtendedAttributes().get("isWebBillApprove")) != null && "true".equalsIgnoreCase(extend.getValue())) {
                ExtendedAttributeDef extend1 = approDef.getActivityHeader().getExtendedAttributes().get("WebBillApproveUrl");
                logger.info((Object)("extend1.getValue() = " + extend1.getValue()));
                if (extend1 != null && !StringUtils.isEmpty((String)extend1.getValue())) {
                    url = extend1.getValue();
                    if (url.indexOf("?") > 0) {
                        url = url + "&pk=";
                        url = url + StringUtils.replace((String)billID, (String)"+", (String)"%2B");
                    } else {
                        url = url + "?pk=";
                        url = url + StringUtils.replace((String)billID, (String)"+", (String)"%2B");
                    }
                    return url;
                }
            }
            if (!(act instanceof ManpowerActivityDef)) continue;
            IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
            AssignmentInfo[] assignmentInfos = service.getAssignmentByActInstId(((ManpowerActivityDef)act).getID());
            for (int j = 0; j < assignmentInfos.length; ++j) {
                url = ProcessCenterUtil.getWaf2DynamicPageURL(service, assignmentInfos[j]);
                if (StringUtils.isEmpty((String)url)) continue;
                StringBuffer billUrl = new StringBuffer();
                billUrl.append("/easweb/").append(url).append("&billId=").append(URLEncoder.encode(billID, "UTF-8")).append("&operateState=VIEW");
                return billUrl.toString();
            }
        }
        return null;
    }

    private static String openWebfullyBill(String sourceId, Context ctx) {
        StringBuffer billUrl = new StringBuffer();
        String proName = ProcessCenterUtil.getWebfullyBillProcName(sourceId, ctx);
        if (!StringUtils.isEmpty((String)proName)) {
            try {
                billUrl.append("/easportal").append("/html/portlet/messagecenter/msgViewers/Bill.jsp?assigmentId=").append(URLEncoder.encode(sourceId, "UTF-8")).append("&proName=").append(URLEncoder.encode(proName, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return billUrl.toString();
    }

    public static URLInfo getEditUrlInfoById(String id, Context ctx) {
        URLInfo info = new URLInfo();
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            info = id.endsWith("WFWKITEM") ? ProcessCenterUtil.getEditUrlInfoByAssignId(id, ctx) : (id.endsWith("WFPCINST") ? ProcessCenterUtil.getEditUrlInfoByProcInstId(id, ctx, svc) : ProcessCenterUtil.getEditUrlInfoByBillId(id, ctx, svc));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return info;
    }

    private static String openWebBill(String url, String sourceId, String billId, String operateState, boolean isApprovePage) throws Exception {
        StringBuffer billUrl = new StringBuffer();
        String EASPORTAL_PATH = "/easportal";
        String EASWEB_PATH = "/easweb";
        try {
            if (url.indexOf("/shr/") >= 0) {
                StringBuffer tUrl = new StringBuffer(url);
                if (url.indexOf("pureWFBillUrl") < 0) {
                    ProcessCenterUtil.appendParam(tUrl, "pureWFBillUrl", "true", false);
                }
                if (url.indexOf("isShrBill") < 0) {
                    ProcessCenterUtil.appendParam(tUrl, "isShrBill", "true", false);
                }
                url = tUrl.toString();
            }
            if (url.indexOf("pureWFBillUrl") > -1) {
                billUrl.append(url);
                billUrl.append("&billId=");
                billUrl.append(URLEncoder.encode(billId, "UTF-8"));
                billUrl.append("&assigmentId=");
                billUrl.append(URLEncoder.encode(sourceId, "UTF-8"));
            } else if (url.indexOf("dynamicForm.do?") > -1) {
                billUrl.append(EASWEB_PATH).append(url).append("&billId=").append(URLEncoder.encode(billId, "UTF-8"));
            } else if (url.endsWith(".do") || url.endsWith(".jsp")) {
                billUrl.append(url.endsWith("Page.do") ? EASWEB_PATH : EASPORTAL_PATH).append(url).append(url.endsWith("Page.do") ? "?billId=" : "?id=").append(URLEncoder.encode(billId, "UTF-8"));
            } else if (url.indexOf(".do?") > 0 || url.indexOf(".jsp?") > 0) {
                billUrl.append(url.indexOf("Page.do?") > 0 ? EASWEB_PATH : EASPORTAL_PATH).append(url).append(url.indexOf("Page.do?") > 0 ? "&billId=" : "&id=").append(URLEncoder.encode(billId, "UTF-8"));
            } else {
                String wafURL = EASWEB_PATH + url;
                boolean isFind = true;
                int queryStringIdx = wafURL.indexOf("?");
                if (queryStringIdx <= 0) {
                    isFind = false;
                }
                String prefix = wafURL.substring(0, queryStringIdx + 1);
                String queryString = wafURL.substring(queryStringIdx + 1);
                if (isApprovePage) {
                    if (isFind) {
                        billUrl.append(prefix).append(queryString);
                        billUrl.append("&billId=" + URLEncoder.encode(billId, "UTF-8"));
                    } else {
                        billUrl.append(wafURL);
                        billUrl.append("?billId=" + URLEncoder.encode(billId, "UTF-8"));
                    }
                    billUrl.append("&status=").append(operateState);
                } else {
                    billUrl.append(EASPORTAL_PATH).append("/html/portlet/messagecenter/msgViewers/Bill.jsp?assigmentId=").append(URLEncoder.encode(sourceId, "UTF-8")).append("&iswaf=true&wafURL=");
                    if (isFind) {
                        billUrl.append(URLEncoder.encode(prefix, "UTF-8")).append(queryString);
                    } else {
                        billUrl.append(URLEncoder.encode(wafURL, "UTF-8"));
                    }
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        url = billUrl.toString();
        if (url.indexOf("operateState") == -1) {
            url = url + "&operateState=" + operateState;
        }
        return url;
    }

    private static String openWebBill(String url, String billId) throws Exception {
        StringBuffer billUrl = new StringBuffer();
        String EASPORTAL_PATH = "/easportal";
        String EASWEB_PATH = "/easweb";
        try {
            if (url.indexOf("/shr/") >= 0) {
                StringBuffer tUrl = new StringBuffer(url);
                if (url.indexOf("pureWFBillUrl") < 0) {
                    ProcessCenterUtil.appendParam(tUrl, "pureWFBillUrl", "true", false);
                }
                if (url.indexOf("isShrBill") < 0) {
                    ProcessCenterUtil.appendParam(tUrl, "isShrBill", "true", false);
                }
                url = tUrl.toString();
            }
            if (url.indexOf("pureWFBillUrl") > -1) {
                billUrl.append(url);
                billUrl.append("&billId=");
                billUrl.append(URLEncoder.encode(billId, "UTF-8"));
                billUrl.append("&assigmentId=");
            } else if (url.indexOf("dynamicForm.do?") > -1) {
                billUrl.append(EASWEB_PATH).append(url).append("&billId=").append(URLEncoder.encode(billId, "UTF-8"));
            } else if (url.endsWith(".do") || url.endsWith(".jsp")) {
                billUrl.append(url.endsWith("Page.do") ? EASWEB_PATH : EASPORTAL_PATH).append(url).append(url.endsWith("Page.do") ? "?billId=" : "?id=").append(URLEncoder.encode(billId, "UTF-8"));
            } else {
                String wafURL = EASWEB_PATH + url;
                boolean isFind = true;
                int queryStringIdx = wafURL.indexOf("?");
                if (queryStringIdx <= 0) {
                    isFind = false;
                }
                String prefix = wafURL.substring(0, queryStringIdx + 1);
                String queryString = wafURL.substring(queryStringIdx + 1);
                if (isFind) {
                    billUrl.append(prefix).append(queryString);
                    billUrl.append("&billId=" + URLEncoder.encode(billId, "UTF-8"));
                } else {
                    billUrl.append(wafURL);
                    billUrl.append("?billId=" + URLEncoder.encode(billId, "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        url = billUrl.toString();
        if (url.indexOf("operateState") == -1) {
            url = url + "&operateState=VIEW&hasToolbar=false";
        }
        return url;
    }

    private static URLInfo getEditUrlInfoByProcInstId(String procInstID, Context ctx, IEnactmentService svc) {
        int len;
        URLInfo info = new URLInfo();
        boolean isIncludeHst = false;
        boolean isCanUrgent = false;
        if (procInstID.startsWith("nIncludeHis~!~")) {
            isIncludeHst = true;
            procInstID = procInstID.substring(14);
        }
        if (procInstID.endsWith("~!~1")) {
            isCanUrgent = true;
            len = procInstID.length();
            procInstID = procInstID.substring(0, len - 4);
        } else if (procInstID.endsWith("~!~0")) {
            isCanUrgent = false;
            len = procInstID.length();
            procInstID = procInstID.substring(0, len - 4);
        }
        Map map = new HashMap();
        map = ProcessCenterUtil.getSubProcInstInfo(svc, procInstID, map);
        List assignIdList = (List)map.get("assign");
        if (assignIdList != null && assignIdList.size() > 0) {
            for (int i = 0; i < assignIdList.size(); ++i) {
                info = ProcessCenterUtil.getEditUrlInfoByAssignId(assignIdList.get(i).toString(), ctx);
                if (StringUtils.isEmpty((String)info.getURL())) continue;
                return info;
            }
        }
        String billID = "";
        HashMap bizObjmap = new HashMap();
        try {
            bizObjmap = ProcessCenterUtil.getBizObjIdByProcInst(ctx, procInstID, isCanUrgent, isIncludeHst);
            if (bizObjmap.size() <= 0) {
                logger.error((Object)"getBizObjIdByProcInst\u83b7\u53d6\u5355\u636e\u5931\u8d25");
            } else if (bizObjmap.size() >= 1) {
                billID = (String)bizObjmap.keySet().toArray()[0];
            }
            if (StringUtils.isEmpty((String)billID)) {
                billID = svc.getBizObjIdByProcessInstanceId(procInstID);
            }
            if (billID != null) {
                billID = billID.replaceAll(" ", "+");
                info.setBillID(billID);
            }
            String url = "";
            List actInstIdList = (List)map.get("actinst");
            if (actInstIdList != null && actInstIdList.size() > 0) {
                for (int i = actInstIdList.size() - 1; i > -1; --i) {
                    String actInstId = actInstIdList.get(i).toString();
                    ActivityInstInfo actInstInfo = svc.getActivityInstByActInstId(actInstId);
                    url = ProcessCenterUtil.getWaf2DynamicPageURL(svc, actInstInfo);
                    String operateState = "VIEW";
                    ActivityInstInfo instInfo = svc.getActivityInstByActInstId(actInstId);
                    ActivityDef def = svc.getActDefByActInstInfo(instInfo);
                    ExtendedAttributeCollection extendAttrCol = def.getActivityHeader().getExtendedAttributes();
                    ExtendedAttributeDef value = extendAttrCol.get("customUIStatus");
                    String string = operateState = value == null ? "VIEW" : value.getValue();
                    if (StringUtils.isEmpty((String)url)) {
                        ActivityDef act = svc.getActDefByActInstInfo(actInstInfo);
                        url = ProcessCenterUtil.getEditUrl(act, svc, ctx, billID, actInstId, operateState);
                    }
                    if (StringUtils.isEmpty((String)url)) continue;
                    AssignmentInfo[] assigninfo = svc.getAssignmentByActInstId(actInstId);
                    String assignId = "";
                    if (assigninfo != null && assigninfo.length > 0) {
                        assignId = assigninfo[0].getAssignmentId();
                    }
                    url = ProcessCenterUtil.openWebBill(url, assignId, billID, operateState, false);
                    info.setURL(url);
                    return info;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            info.setErrorMsg(e.getMessage());
        }
        return info;
    }

    private static URLInfo getEditUrlInfoByBillId(String billID, Context ctx, IEnactmentService svc) {
        URLInfo info = new URLInfo();
        try {
            if (billID != null) {
                billID = billID.replaceAll(" ", "+");
            }
            info.setBillID(billID);
            ProcessInstInfo[] instInfos = svc.getProcessInstanceByHoldedObjectId(billID);
            if (instInfos.length == 0) {
                instInfos = svc.getAllProcessInstancesByBizobjId(billID);
            }
            for (int i = 0; i < instInfos.length; ++i) {
                ProcessInstInfo procInstInfo = instInfos[i];
                String procInstId = procInstInfo.getProcInstId();
                if (StringUtils.isEmpty((String)procInstId) || StringUtils.isEmpty((String)(info = ProcessCenterUtil.getEditUrlInfoByProcInstId(procInstId, ctx, svc)).getURL())) continue;
                return info;
            }
        }
        catch (Exception e) {
            logger.error((Object)EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)ProcessCenterUtil.getLocale(ctx)), (Throwable)e);
            info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)ProcessCenterUtil.getLocale(ctx)));
        }
        logger.info((Object)("getEditUrlInfo1 url = " + info.getURL()));
        return info;
    }

    private static Map getSubProcInstInfo(IEnactmentService svc, String procInstId, Map map) {
        block8: {
            ActivityInstInfo[] actinfos = null;
            ArrayList<String> assignIdList = (ArrayList<String>)map.get("assign");
            ArrayList<String> actInstIdList = (ArrayList<String>)map.get("actinst");
            try {
                if (actInstIdList == null) {
                    actInstIdList = new ArrayList<String>();
                }
                if (assignIdList == null) {
                    assignIdList = new ArrayList<String>();
                }
                if ((actinfos = svc.getActInstMetaArrayByProcInstId(procInstId)) == null || actinfos.length <= 0) break block8;
                for (int i = 0; i < actinfos.length; ++i) {
                    String subprocinst;
                    ActivityInstInfo actinfo = actinfos[i];
                    ActivityDef actdef = svc.getActDefByActInstInfo(actinfo);
                    if (!(actdef instanceof ManpowerActivityDef) && !(actdef instanceof SubflowActivityDef)) continue;
                    String state = actinfo.getState();
                    String actInstId = actinfo.getActInstId();
                    if (actdef instanceof ManpowerActivityDef && !StringUtils.isEmpty((String)actInstId)) {
                        actInstIdList.add(actInstId);
                        map.put("actinst", actInstIdList);
                    }
                    if ("open.not_running.not_started".equals(state)) {
                        AssignmentInfo[] assigninfo;
                        if (StringUtils.isEmpty((String)actInstId) || (assigninfo = svc.getAssignmentByActInstId(actInstId)) == null || assigninfo.length <= 0) continue;
                        for (int j = 0; j < assigninfo.length; ++j) {
                            String assignId = assigninfo[j].getAssignmentId();
                            if (StringUtils.isEmpty((String)assignId)) continue;
                            assignIdList.add(assignId);
                            map.put("assign", assignIdList);
                        }
                        continue;
                    }
                    if (!"open.running".equals(state) || StringUtils.isEmpty((String)(subprocinst = actinfo.getSubProcInstId()))) continue;
                    map = ProcessCenterUtil.getSubProcInstInfo(svc, subprocinst, map);
                }
            }
            catch (WfException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private static Map getParameterMap(Context ctx, String actInstId) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine((Context)ctx);
        WfActivity wfActivity = wfEngine.getActivityInst(actInstId);
        ManpowerActivityDef actDef = (ManpowerActivityDef)wfActivity.getDefinition();
        Map parameterMap = DefaultApplicationManager.getParameterMap((WfActivity)wfActivity, (ProcessContext)wfActivity.container().getProcessContext(), (ActualParameterCollection)actDef.getActualParameters(), (FormalParameterCollection)actDef.getRelatedApplication().getFormalParameters(), (boolean)true);
        ArrayList argList = DefaultApplicationManager.getInvokeArgs((WfActivity)wfActivity, (ActualParameterCollection)actDef.getActualParameters(), (FormalParameterCollection)actDef.getRelatedApplication().getFormalParameters(), (Map)parameterMap, (boolean)true);
        Map argumentMap = DefaultApplicationManager.getInvokeArgs((ArrayList)argList, (FormalParameterCollection)actDef.getRelatedApplication().getFormalParameters());
        return argumentMap;
    }

    private static String getEditUrl(ActivityDef act, IEnactmentService svc, Context ctx, String billID, String actInstId, String UIStatus) throws Exception {
        ExtendedAttributeDef extend;
        ManpowerActivityDef actDef;
        ExtendedAttributeDef extend1;
        String url = "";
        BOSUuid id = BOSUuid.read((String)billID);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo billObject = loader.getEntity(id.getType());
        if (billObject == null) {
            throw new IllegalArgumentException("BillObject is null");
        }
        String s = "edit";
        if (UIStatus == null || UIStatus.length() == 0 || UIStatus.equalsIgnoreCase("findview") || UIStatus.equalsIgnoreCase("view")) {
            s = "view";
        }
        if (act instanceof WebBillManpowerActivityDef) {
            Map argumentMap = ProcessCenterUtil.getParameterMap(ctx, actInstId);
            StringBuffer webUrl = new StringBuffer(((WebBillManpowerActivityDef)act).getUrl());
            if (webUrl.length() > 0) {
                Iterator it = argumentMap.keySet().iterator();
                while (it.hasNext()) {
                    String paraName = it.next().toString();
                    if (!"formid".equalsIgnoreCase(paraName)) continue;
                    String paraValue = null;
                    try {
                        paraValue = StringUtils.replace((String)URLEncoder.encode(String.valueOf(argumentMap.get(paraName)), "utf-8"), (String)"+", (String)"%2B");
                    }
                    catch (Exception ex) {
                        paraValue = "";
                    }
                    webUrl.append(webUrl.indexOf("?") < 0 ? "?" : "&").append(paraName).append("=").append(paraValue);
                    break;
                }
                logger.info((Object)("WebBillManpowerActivityDef webUrl = " + webUrl.toString()));
                url = webUrl.toString();
            }
        } else if (act instanceof ApproveActivityDef) {
            ExtendedAttributeDef extend12;
            ApproveActivityDef approDef = (ApproveActivityDef)act;
            ExtendedAttributeDef extend2 = approDef.getActivityHeader().getExtendedAttributes().get("isWebBillApprove");
            if (extend2 != null && "true".equalsIgnoreCase(extend2.getValue()) && (extend12 = approDef.getActivityHeader().getExtendedAttributes().get("WebBillApproveUrl")) != null && !StringUtils.isEmpty((String)extend12.getValue())) {
                url = extend12.getValue();
                logger.info((Object)("ApproveActivityDef url = " + extend12.getValue()));
            }
        } else if (act instanceof ManualDecisionActivityDef && (extend1 = (actDef = (ManpowerActivityDef)act).getActivityHeader().getExtendedAttributes().get("isWebBillManualDecision")) != null && "true".equalsIgnoreCase(extend1.getValue()) && (extend = actDef.getActivityHeader().getExtendedAttributes().get("WebBillManualDecisionUrl")) != null && !StringUtils.isEmpty((String)extend.getValue())) {
            url = extend.getValue();
        }
        if (StringUtils.isEmpty((String)url)) {
            url = ProcessCenterUtil.getWAF2SolutionURL(billObject, s, ctx, billID);
        }
        if (StringUtils.isEmpty((String)url)) {
            WfEngine wfEngine = EngineUtil.getEngine((Context)ctx);
            WfActivity wfActivity = wfEngine.getActivityInst(actInstId);
            String procdefHashValue = svc.getProcessInstInfo(wfActivity.getProcInstId()).getProcDefHashValue();
            ProcessDef def = svc.getProcessDefByDefineHashValue(procdefHashValue);
            url = ProcessCenterUtil.getUrlFromProcdef(ctx, def, billID);
        }
        if (StringUtils.isEmpty((String)url)) {
            url = ProcessCenterUtil.getWebBillURL(ctx, billID);
        }
        if (StringUtils.isEmpty((String)url)) {
            url = StoreUtils.getWebUIurl((String)billID, (Context)ctx);
        }
        if (StringUtils.isEmpty((String)url)) {
            String editUIName = null;
            if (!StringUtils.isEmpty((String)billID) && "09DEC9DC".equals(BOSUuid.read((String)billID).getType().toString())) {
                Map argumentMap = ProcessCenterUtil.getParameterMap(ctx, actInstId);
                editUIName = (String)argumentMap.get("UIClassName");
            }
            if (StringUtils.isEmpty(editUIName)) {
                editUIName = ProcessCenterUtil.getEditUIClassByBillId(billID, ctx);
            }
            String[] results = ProcessCenterUtil.getURLByClassName(editUIName, ctx);
            url = results[0];
        }
        return url;
    }

    private static String getAppSolutionID(String pk, IObjectValue model, String viewtype, Context ctx) {
        BOSObjectType type = null;
        if (pk == null && model.get("id") != null) {
            pk = model.get("id").toString();
        }
        if (pk == null) {
            return null;
        }
        type = BOSUuid.read((String)pk).getType();
        try {
            IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
            ICoreBillBase iBillBase = (ICoreBillBase)obj;
            return iBillBase.getAppSolutionID((IObjectPK)new ObjectUuidPK(pk), model, viewtype);
        }
        catch (BOSException e) {
            logger.error((Object)("invoke getAppSolutionID error" + e.getMessage()), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)("invoke getAppSolutionID error" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    public static IObjectValue getObjectValueById(Context ctx, String billId) throws WfException {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
        IORMappingDAO dao = null;
        IObjectValue model = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)pk.getObjectType(), (Context)ctx, (Connection)cn);
            model = dao.getValue((IObjectPK)pk);
        }
        catch (DataAccessException e) {
            logger.warn((Object)("createObjectValueByBoId throw DataAccessException error " + e.getMessage()));
            throw new WfException((Throwable)e, true);
        }
        catch (SQLException e) {
            logger.warn((Object)("createObjectValueByBoId throw SQLException error " + e.getMessage()));
            throw new WfException((Throwable)e, true);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return model;
    }

    private static String getWAF2SolutionURL(EntityObjectInfo entityObjectInfo, String type, Context ctx, String billId) {
        String entityName = entityObjectInfo.getFullName();
        String appid = null;
        String url = null;
        try {
            IObjectValue objValue = ProcessCenterUtil.getObjectValueById(ctx, billId);
            if (objValue instanceof CoreBillBaseInfo) {
                appid = ProcessCenterUtil.getAppSolutionID(null, (IObjectValue)((CoreBillBaseInfo)objValue), type, ctx);
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        if (!StringUtils.isEmpty(appid)) {
            url = ProcessCenterUtil.getURLByAppID(ctx, appid, type, entityName);
        }
        if (StringUtils.isEmpty(url)) {
            try {
                StringBuffer querySql = new StringBuffer("select fid FID from t_dyn_appsolution A where (fapptype='bizbill' or fapptype='bizunit') and fmainentity ='" + entityName + "'");
                querySql.append(" AND  FMENULONGNUMBER not like '%cust!%'");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
                while (rs.next() && StringUtils.isEmpty((String)(url = ProcessCenterUtil.getURLByAppID(ctx, appid = rs.getString("FID"), type, entityName)))) {
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return url;
    }

    private static String getURLByAppID(Context ctx, String appid, String type, String entityName) {
        String url = ProcessCenterUtil.getDynamicEditUrl(ctx, appid, type, entityName);
        if (StringUtils.isEmpty((String)url) && "view".equals(type)) {
            url = ProcessCenterUtil.getDynamicEditUrl(ctx, appid, "edit", entityName);
        }
        return url;
    }

    private static String getDynamicEditUrl(Context ctx, String appid, String type, String entityName) {
        try {
            String sql = "select  FWEBUIOBJECTNAME,fentityobjectname from  T_DYN_DynamicConfigure  where fpagetype =?  and fdependID is null ";
            sql = sql + " and FAPPSOLUTIONID=? ";
            sql = sql + " and fpkg <> 'com.kingdee.eas.fi.vc.vc'";
            sql = sql + " and fentityobjectname = ? ";
            sql = sql + " order by FISDEFAULT desc,FLASTMETAUPDATETIME asc ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{type, appid, entityName});
            String uipk = null;
            while (rs.next()) {
                uipk = rs.getString("FWEBUIOBJECTNAME");
                if (StringUtils.isEmpty((String)uipk)) continue;
                return "/dynamicForm.do?event=initialize&method=initalize&uipk=" + uipk;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static URLInfo getEditUrlInfoByAssign(String assignid, Context ctx) {
        return ProcessCenterUtil.getEditUrlInfoByAssignIdInner(assignid, ctx, true);
    }

    private static URLInfo getEditUrlInfoByAssignId(String assignId, Context ctx) {
        return ProcessCenterUtil.getEditUrlInfoByAssignIdInner(assignId, ctx, false);
    }

    private static URLInfo getEditUrlInfoByAssignIdInner(String assignid, Context ctx, boolean isApprovePage) {
        URLInfo info = new URLInfo();
        try {
            String url;
            String operateState;
            ExtendedAttributeDef extend;
            ExtendedAttributeDef extend1;
            ManualDecisionActivityDef actDef;
            Map m;
            Object act;
            if (!assignid.endsWith("WFWKITEM")) {
                return info;
            }
            EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
            AssignmentInfo assInfo = service.getAssignmentById(assignid);
            String[] bizObjectID = assInfo.getBizObjectIdArray();
            String billID = "";
            if (bizObjectID != null && bizObjectID[0] != null) {
                billID = bizObjectID[0];
                info.setBillID(billID);
            }
            if (billID != null) {
                billID = billID.replaceAll(" ", "+");
            }
            if ((act = (m = service.getActivityDefAndActivityInstInfo(assInfo.getAssignmentId())).get("ACTIVITYDEF")) instanceof WebBillManpowerActivityDef) {
                Map argumentMap = service.getAssignmentArgument(assInfo.getAssignmentId(), true);
                StringBuffer webUrl = new StringBuffer(((WebBillManpowerActivityDef)act).getUrl());
                if (webUrl.length() > 0) {
                    Iterator it = argumentMap.keySet().iterator();
                    while (it.hasNext()) {
                        String paraName = it.next().toString();
                        if (!"formid".equalsIgnoreCase(paraName)) continue;
                        String paraValue = null;
                        try {
                            paraValue = StringUtils.replace((String)URLEncoder.encode(String.valueOf(argumentMap.get(paraName)), "utf-8"), (String)"+", (String)"%2B");
                        }
                        catch (Exception ex) {
                            paraValue = "";
                        }
                        webUrl.append(webUrl.indexOf("?") < 0 ? "?" : "&").append(paraName).append("=").append(paraValue);
                        break;
                    }
                    logger.info((Object)("WebBillManpowerActivityDef webUrl = " + webUrl.toString()));
                    info.setURL(webUrl.toString());
                }
            } else if (act instanceof ApproveActivityDef) {
                ExtendedAttributeDef extend12;
                ApproveActivityDef approDef = (ApproveActivityDef)act;
                ExtendedAttributeDef extend2 = approDef.getActivityHeader().getExtendedAttributes().get("isWebBillApprove");
                if (extend2 != null && "true".equalsIgnoreCase(extend2.getValue()) && (extend12 = approDef.getActivityHeader().getExtendedAttributes().get("WebBillApproveUrl")) != null && !StringUtils.isEmpty((String)extend12.getValue())) {
                    info.setURL(extend12.getValue());
                    logger.info((Object)("ApproveActivityDef url = " + extend12.getValue()));
                }
            } else if (act instanceof ManualDecisionActivityDef) {
                actDef = (ManualDecisionActivityDef)act;
                extend1 = actDef.getActivityHeader().getExtendedAttributes().get("isWebBillManualDecision");
                if (extend1 != null && "true".equalsIgnoreCase(extend1.getValue()) && (extend = actDef.getActivityHeader().getExtendedAttributes().get("WebBillManualDecisionUrl")) != null && !StringUtils.isEmpty((String)extend.getValue())) {
                    info.setURL(extend.getValue());
                    logger.info((Object)("ManualDecisionActivityDef url = " + extend.getValue()));
                }
            } else if (act instanceof ManpowerActivityDef && (extend = (extend1 = (actDef = (ManpowerActivityDef)act).getRelatedApplication().getExtendedAttributes()).get("CustomWebBillUrl")) != null && !StringUtils.isEmpty((String)extend.getValue())) {
                info.setURL(extend.getValue());
                logger.info((Object)("ManpowerActivityDef url = " + extend.getValue()));
            }
            ExtendedAttributeCollection extendAttrCol = ((ActivityDef)act).getActivityHeader().getExtendedAttributes();
            ExtendedAttributeDef value = extendAttrCol.get("customUIStatus");
            String string = operateState = value == null ? "VIEW" : value.getValue();
            if (StringUtils.isEmpty((String)operateState)) {
                operateState = "VIEW";
            }
            if (WfAssignmentState.ACCEPTED != assInfo.getState() && WfAssignmentState.ASSIGNED != assInfo.getState()) {
                operateState = "VIEW";
            }
            if (StringUtils.isEmpty((String)info.getURL())) {
                url = ProcessCenterUtil.getWaf2DynamicPageURL((IEnactmentService)service, assInfo);
                if (StringUtils.isEmpty((String)url)) {
                    BOSUuid id = BOSUuid.read((String)billID);
                    IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                    EntityObjectInfo billObject = loader.getEntity(id.getType());
                    if (billObject == null) {
                        throw new IllegalArgumentException("BillObject is null");
                    }
                    String s = "edit";
                    if (StringUtils.isEmpty((String)operateState) || operateState.equalsIgnoreCase("findview") || operateState.equalsIgnoreCase("view")) {
                        s = "view";
                    }
                    url = ProcessCenterUtil.getWAF2SolutionURL(billObject, s, ctx, billID);
                }
                logger.info((Object)("WAF2 url = " + url));
                info.setURL(url);
            }
            if (StringUtils.isEmpty((String)info.getURL()) && !StringUtils.isEmpty((String)(url = ProcessCenterUtil.getProcessPropertyCustomeURL((IEnactmentService)service, assInfo.getProcInstId(), assInfo.getProcDefId())))) {
                info.setURL(url);
                logger.info((Object)("\u83b7\u53d6\u6d41\u7a0b\u5c5e\u6027\u4e0a\u7684\u81ea\u5b9a\u4e49\u7684 url = " + url));
            }
            if (StringUtils.isEmpty((String)info.getURL()) && !StringUtils.isEmpty((String)(url = ProcessCenterUtil.getWebBillURL(ctx, billID)))) {
                info.setURL(url);
                logger.info((Object)("BOS \u52a8\u6001web\u5355\u636e Url = " + info.getURL()));
            }
            if (StringUtils.isEmpty((String)info.getURL())) {
                String editUIName = null;
                if (!StringUtils.isEmpty((String)billID) && "09DEC9DC".equals(BOSUuid.read((String)billID).getType().toString())) {
                    service = EnactmentServiceProxy.getEnacementService((Context)ctx);
                    Map argumentMap = service.getAssignmentArgument(assInfo.getAssignmentId(), true);
                    editUIName = (String)argumentMap.get("UIClassName");
                }
                if (StringUtils.isEmpty(editUIName)) {
                    editUIName = ProcessCenterUtil.getEditUIClassByBillId(billID, ctx);
                }
                if (!StringUtils.isEmpty(editUIName)) {
                    String[] results = ProcessCenterUtil.getURLByClassName(editUIName, ctx);
                    info.setURL(results[0]);
                    info.setHeight(results[1]);
                    info.setWidth(results[2]);
                    info.setOpenWay(results[3]);
                    logger.info((Object)("UIClassName\u6269\u5c55\u5c5e\u6027 url" + info.getURL()));
                }
            }
            if (!StringUtils.isEmpty((String)info.getURL())) {
                url = info.getURL() + "&assignState=" + assInfo.getState().getValue();
                info.setURL(url);
            }
            if (!StringUtils.isEmpty((String)info.getURL())) {
                url = ProcessCenterUtil.openWebBill(info.getURL(), assignid, billID, operateState, isApprovePage);
                url = url + "&assignState=" + assInfo.getState().getValue() + "&proInstId=" + assInfo.getProcInstId();
                info.setURL(url);
            }
        }
        catch (Exception e) {
            logger.error((Object)EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)ProcessCenterUtil.getLocale(ctx)), (Throwable)e);
            info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)ProcessCenterUtil.getLocale(ctx)));
        }
        logger.info((Object)("getEditUrlInfoByAssign1 url = " + info.getURL()));
        return info;
    }

    public static URLInfo getEditUrlInfoByProcInst(String procInstID, Context ctx) {
        int len;
        boolean isIncludeHst = false;
        boolean isCanUrgent = false;
        if (procInstID.startsWith("nIncludeHis~!~")) {
            isIncludeHst = true;
            procInstID = procInstID.substring(14);
        }
        if (procInstID.endsWith("~!~1")) {
            isCanUrgent = true;
            len = procInstID.length();
            procInstID = procInstID.substring(0, len - 4);
        } else if (procInstID.endsWith("~!~0")) {
            isCanUrgent = false;
            len = procInstID.length();
            procInstID = procInstID.substring(0, len - 4);
        }
        String billID = "";
        HashMap bizObjmap = new HashMap();
        URLInfo info = new URLInfo();
        try {
            bizObjmap = ProcessCenterUtil.getBizObjIdByProcInst(ctx, procInstID, isCanUrgent, isIncludeHst);
            if (bizObjmap.size() <= 0) {
                logger.error((Object)"getBizObjIdByProcInst\u83b7\u53d6\u5355\u636e\u5931\u8d25");
            } else if (bizObjmap.size() >= 1) {
                billID = (String)bizObjmap.keySet().toArray()[0];
            }
            if (StringUtils.isEmpty((String)billID)) {
                IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
                billID = svc.getBizObjIdByProcessInstanceId(procInstID);
            }
            if (billID != null) {
                billID = billID.replaceAll(" ", "+");
                info.setBillID(billID);
            }
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
            ProcessInstInfo[] instInfos = iEnactmentService.getProcessInstanceByHoldedObjectId(billID);
            logger.info((Object)("_getUrlByBillID-instInfos.length = " + instInfos.length));
            if (instInfos.length == 0) {
                instInfos = iEnactmentService.getAllProcessInstancesByBizobjId(billID);
            }
            logger.info((Object)("_getUrlByBillID-instInfos.length 2 = " + instInfos.length));
            for (int k = 0; k < instInfos.length; ++k) {
                String hashValue = instInfos[k].getProcDefHashValue();
                ProcessDef def = iEnactmentService.getProcessDefByDefineHashValue(hashValue);
                ActivityCollection actColl = def.getActivitys();
                logger.info((Object)("_getUrlByBillID-actColl.size() = " + actColl.size()));
                for (int i = 0; i < actColl.size(); ++i) {
                    ApproveActivityDef approDef;
                    ExtendedAttributeDef extend;
                    ActivityDef act = actColl.get(i);
                    if (act instanceof WebBillManpowerActivityDef) {
                        StringBuffer webUrl = new StringBuffer(((WebBillManpowerActivityDef)act).getUrl());
                        logger.info((Object)("webUrl = " + webUrl));
                        if (webUrl.length() > 0) {
                            if (webUrl.indexOf("?") > 0) {
                                webUrl.append("&pk=").append(StringUtils.replace((String)billID, (String)"+", (String)"%2B"));
                            } else {
                                webUrl.append("?pk=").append(StringUtils.replace((String)billID, (String)"+", (String)"%2B"));
                            }
                            logger.info((Object)("_getUrlByBillID-WebBillManpowerActivityDef webUrl = " + webUrl));
                            info.setURL(webUrl.toString());
                            return info;
                        }
                    } else if (act instanceof ApproveActivityDef && (extend = (approDef = (ApproveActivityDef)act).getActivityHeader().getExtendedAttributes().get("isWebBillApprove")) != null && "true".equalsIgnoreCase(extend.getValue())) {
                        ExtendedAttributeDef extend1 = approDef.getActivityHeader().getExtendedAttributes().get("WebBillApproveUrl");
                        logger.info((Object)("extend1.getValue() = " + extend1.getValue()));
                        if (extend1 != null && !StringUtils.isEmpty((String)extend1.getValue())) {
                            String extUrl = extend1.getValue();
                            if (extUrl.indexOf("?") > 0) {
                                extUrl = extUrl + "&pk=";
                                extUrl = extUrl + StringUtils.replace((String)billID, (String)"+", (String)"%2B");
                            } else {
                                extUrl = extUrl + "?pk=";
                                extUrl = extUrl + StringUtils.replace((String)billID, (String)"+", (String)"%2B");
                            }
                            logger.info((Object)("_getUrlByBillID-ApproveActivityDef url by billid = " + extUrl));
                            info.setURL(extUrl.toString());
                            return info;
                        }
                    }
                    if (!(act instanceof ManpowerActivityDef)) continue;
                    IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
                    ActivityInstInfo[] activityInstInfos = service.getActInstMetaArrayByProcInstId(procInstID);
                    for (int j = 0; j < activityInstInfos.length; ++j) {
                        String url = ProcessCenterUtil.getWaf2DynamicPageURL(service, activityInstInfos[j]);
                        if (StringUtils.isEmpty((String)url)) continue;
                        StringBuffer billUrl = new StringBuffer();
                        billUrl.append("/easweb/").append(url).append("&billId=").append(URLEncoder.encode(info.getBillID(), "UTF-8")).append("&operateState=VIEW");
                        info.setURL(billUrl.toString());
                        return info;
                    }
                }
                if (info.getURL() != null) break;
            }
            if (!StringUtils.isEmpty((String)info.getURL())) {
                logger.info((Object)("end :" + info.getURL()));
                return info;
            }
            String editUrl = StoreUtils.getWebUIurl((String)billID, (Context)ctx);
            if (editUrl != null) {
                info.setURL(editUrl);
                return info;
            }
            String className = ProcessCenterUtil.getEditUIClassByBillId(billID, ctx);
            if (className != null) {
                String name = className.substring(className.lastIndexOf(".") + 1, className.length());
                UIObjectCtrl ctrl = new UIObjectCtrl(ctx);
                String bizPackgeName = className.substring(0, className.lastIndexOf("."));
                MetaDataPK metaPK = new MetaDataPK(bizPackgeName, name);
                UIObjectInfo ui = ctrl.getValue((IMetaDataPK)metaPK);
                Map map = ui.getExtendedProperties();
                if (map != null && map.size() > 0) {
                    info.setURL((String)map.get("url"));
                    info.setHeight((String)map.get("height"));
                    info.setWidth((String)map.get("width"));
                    info.setOpenWay((String)map.get("openWay"));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            info.setErrorMsg(e.getMessage());
        }
        return info;
    }

    public static URLInfo getBillViewUrlByProcInstId(String procInstId, Context ctx, String billState) {
        URLInfo info = new URLInfo();
        String billID = "";
        IEnactmentService svc = null;
        ActivityInstInfo[] actinfos = null;
        try {
            svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            billID = svc.getBizObjIdByProcessInstanceId(procInstId);
            if (billID != null) {
                billID = billID.replaceAll(" ", "+");
                info.setBillID(billID);
            }
            if ((actinfos = svc.getActInstMetaArrayByProcInstId(procInstId)) != null && actinfos.length > 0) {
                for (int i = 0; i < actinfos.length; ++i) {
                    String url;
                    ExtendedAttributeCollection extendAttrCol;
                    ExtendedAttributeDef value;
                    String operateState;
                    ActivityInstInfo actinfo = actinfos[i];
                    ActivityDef actdef = svc.getActDefByActInstInfo(actinfo);
                    if (actdef instanceof WebBillManpowerActivityDef) {
                        StringBuffer webUrl = new StringBuffer(((WebBillManpowerActivityDef)actdef).getUrl());
                        logger.info((Object)("webUrl = " + webUrl));
                        if (webUrl.length() > 0) {
                            if (webUrl.indexOf("?") > 0) {
                                webUrl.append("&pk=").append(StringUtils.replace((String)billID, (String)"+", (String)"%2B"));
                            } else {
                                webUrl.append("?pk=").append(StringUtils.replace((String)billID, (String)"+", (String)"%2B"));
                            }
                            logger.info((Object)("_getUrlByBillID-WebBillManpowerActivityDef webUrl = " + webUrl));
                            info.setURL(ProcessCenterUtil.openWebBill(webUrl.toString(), billID));
                            return info;
                        }
                    }
                    if (!(actdef instanceof ManpowerActivityDef)) continue;
                    ManpowerActivityDef act = (ManpowerActivityDef)actdef;
                    ExtendedAttributeCollection extend1 = act.getRelatedApplication().getExtendedAttributes();
                    ExtendedAttributeDef extend = extend1.get("CustomWebBillUrl");
                    if (extend != null && !StringUtils.isEmpty((String)extend.getValue())) {
                        info.setURL(extend.getValue());
                        logger.info((Object)("ManpowerActivityDef url = " + extend.getValue()));
                    }
                    String string = operateState = (value = (extendAttrCol = act.getActivityHeader().getExtendedAttributes()).get("customUIStatus")) == null ? "VIEW" : value.getValue();
                    if (StringUtils.isEmpty((String)operateState)) {
                        operateState = "VIEW";
                    }
                    if (StringUtils.isEmpty((String)info.getURL())) {
                        url = ProcessCenterUtil.getWaf2DynamicPageURL(svc, actinfo);
                        if (StringUtils.isEmpty((String)url)) {
                            BOSUuid id = BOSUuid.read((String)billID);
                            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                            EntityObjectInfo billObject = loader.getEntity(id.getType());
                            if (billObject == null) {
                                throw new IllegalArgumentException("BillObject is null");
                            }
                            String s = "edit";
                            if (StringUtils.isEmpty((String)operateState) || operateState.equalsIgnoreCase("findview") || operateState.equalsIgnoreCase("view")) {
                                s = "view";
                            }
                            if (!StringUtils.isEmpty((String)billState)) {
                                s = billState.toLowerCase();
                                operateState = billState.toUpperCase();
                            }
                            url = ProcessCenterUtil.getWAF2SolutionURL(billObject, s, ctx, billID);
                        }
                        logger.info((Object)("WAF2 url = " + url));
                        info.setURL(url);
                    }
                    if (StringUtils.isEmpty((String)info.getURL()) && !StringUtils.isEmpty((String)(url = ProcessCenterUtil.getProcessPropertyCustomeURL(svc, actinfo.getProcInstId(), actinfo.getProcDefId())))) {
                        info.setURL(url);
                        logger.info((Object)("\u83b7\u53d6\u6d41\u7a0b\u5c5e\u6027\u4e0a\u7684\u81ea\u5b9a\u4e49\u7684 url = " + url));
                    }
                    if (StringUtils.isEmpty((String)info.getURL())) {
                        url = ProcessCenterUtil.getWebBillURL(ctx, billID);
                        if (StringUtils.isEmpty((String)url)) {
                            String editUIName = null;
                            if (!StringUtils.isEmpty((String)billID) && "09DEC9DC".equals(BOSUuid.read((String)billID).getType().toString())) {
                                Map argumentMap = ProcessCenterUtil.getParameterMap(ctx, actinfo.getActInstId());
                                editUIName = (String)argumentMap.get("UIClassName");
                            }
                            if (StringUtils.isEmpty(editUIName)) {
                                editUIName = ProcessCenterUtil.getEditUIClassByBillId(billID, ctx);
                            }
                            String[] results = ProcessCenterUtil.getURLByClassName(editUIName, ctx);
                            url = results[0];
                        } else {
                            info.setURL(url);
                        }
                    }
                    if (StringUtils.isEmpty((String)info.getURL())) continue;
                    if (!StringUtils.isEmpty((String)billState)) {
                        operateState = billState.toUpperCase();
                    }
                    url = info.getURL();
                    url = url + "&operateState=" + operateState;
                    url = ProcessCenterUtil.openWebBill(url, billID);
                    url = url + "&proInstId=" + actinfo.getProcInstId();
                    info.setURL(url);
                    return info;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            info.setErrorMsg(e.getMessage());
        }
        return info;
    }

    private static String getWaf2DynamicPageURL(IEnactmentService service, AssignmentInfo assignInfo) throws Exception {
        ActivityDef def;
        ActivityInstInfo instInfo = service.getActivityInstByActInstId(assignInfo.getActInstId());
        String waf2UiPK = ProcessCenterUtil.getWaf2UIPk(service, instInfo, def = service.getActDefByActInstInfo(instInfo));
        if (waf2UiPK != null) {
            StringBuffer url = new StringBuffer("/dynamicForm.do");
            ProcessCenterUtil.appendParam(url, "method", "initalize", false);
            ProcessCenterUtil.appendParam(url, "event", "initialize", false);
            ProcessCenterUtil.appendParam(url, "uipk", waf2UiPK, true);
            return url.toString();
        }
        return "";
    }

    private static String getWaf2DynamicPageURL(IEnactmentService service, ActivityInstInfo activityInstInfo) throws Exception {
        String waf2UiPK;
        ActivityDef def = service.getActDefByActInstInfo(activityInstInfo);
        if (def instanceof ManpowerActivityDef && (waf2UiPK = ProcessCenterUtil.getWaf2UIPk(service, activityInstInfo, def)) != null) {
            StringBuffer url = new StringBuffer("/dynamicForm.do");
            ProcessCenterUtil.appendParam(url, "method", "initalize", false);
            ProcessCenterUtil.appendParam(url, "event", "initialize", false);
            ProcessCenterUtil.appendParam(url, "uipk", waf2UiPK, true);
            return url.toString();
        }
        return "";
    }

    private static String getWaf2UIPk(IEnactmentService service, ActivityInstInfo activityInstInfo, ActivityDef def) throws WfException {
        String uiPk = service.getUIPkFromDB(activityInstInfo.getProcDefId(), def.getID(), "waf2UI");
        if (uiPk != null && uiPk.trim().length() > 0) {
            return uiPk;
        }
        ExtendedAttributeCollection extendAttrCol = ((ManpowerActivityDef)def).getRelatedApplication().getExtendedAttributes();
        ExtendedAttributeDef waf2UiPK = extendAttrCol.get("Waf2UIPK");
        if (waf2UiPK != null && !"".equals(waf2UiPK.getValue())) {
            return waf2UiPK.getValue();
        }
        return null;
    }

    private static String getProcessPropertyCustomeURL(IEnactmentService service, String procinstId, String procdefId) throws Exception {
        ExtendedAttributeDef procWebBillApproveUrl;
        Context ctx = service.getContext();
        String sql = "select distinct fparentprocdefid from t_wfr_procinst where fprocinstid='" + procinstId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String procdefIdTemp = null;
        ProcessDefInfo processDefInfo = null;
        while (rowSet.next()) {
            procdefIdTemp = rowSet.getString("fparentprocdefid");
        }
        processDefInfo = procdefIdTemp == null ? service.getProcessDefInfo(procdefId) : service.getProcessDefInfo(procdefIdTemp);
        ProcessDef processDef = service.getProcessDefByDefineHashValue(processDefInfo.getMd5HashValue());
        ExtendedAttributeCollection procExAttributeCollection = processDef.getExtendedAttributes();
        ExtendedAttributeDef procWaf2UiPK = procExAttributeCollection.get("Waf2UIPK");
        if (procWaf2UiPK != null && !"".equals(procWaf2UiPK.getValue())) {
            StringBuffer url = new StringBuffer("/dynamicForm.do");
            ProcessCenterUtil.appendParam(url, "method", "initalize", false);
            ProcessCenterUtil.appendParam(url, "event", "initialize", false);
            ProcessCenterUtil.appendParam(url, "uipk", procWaf2UiPK.getValue(), true);
            return url.toString();
        }
        ExtendedAttributeDef extend = procExAttributeCollection.get("isWebBillApprove");
        if (extend != null && "true".equalsIgnoreCase(extend.getValue()) && (procWebBillApproveUrl = procExAttributeCollection.get("WebBillApproveUrl")) != null && !StringUtils.isEmpty((String)procWebBillApproveUrl.getValue())) {
            logger.info((Object)("ApproveActivityDef url = " + procWebBillApproveUrl.getValue()));
            return procWebBillApproveUrl.getValue();
        }
        return "";
    }

    protected static HashMap getBizObjIdByProcInst(Context ctx, String procInst, boolean isCanUrgent, boolean isIncludeHst) throws BOSException, EASBizException {
        String sqlTempHst;
        String sqlTempDetail;
        StringBuffer Tempsql;
        HashMap<String, String> bizObjIDMap = new HashMap<String, String>();
        String subject = "FSUBJECT_" + ctx.getLocale();
        String actdefName = "FACTDEFNAME_" + ctx.getLocale();
        StringBuffer sql = null;
        if (!isCanUrgent) {
            String currentUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String sqlInitor = "select FINITIATORID from t_wfr_procinst where FPROCINSTID = ?";
            Object[] param = new String[]{procInst};
            if (isIncludeHst) {
                sqlInitor = sqlInitor + " union select FINITIATORID from t_wfr_procinstHst where FPROCINSTID = ?";
                param = new String[]{procInst, procInst};
            }
            try {
                IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sqlInitor, (Object[])param);
                while (row.next()) {
                    String id = row.getString("FINITIATORID");
                    if (!id.equalsIgnoreCase(currentUser)) continue;
                    isCanUrgent = true;
                    break;
                }
            }
            catch (SQLException e) {
                logger.error((Object)"\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u4e3a\u7533\u8bf7\u4eba\u51fa\u9519", (Throwable)e);
            }
        }
        if (isCanUrgent) {
            Tempsql = new StringBuffer(" (select  A.FBIZOBJID,A.fcreatedtime,A.").append(actdefName);
            Tempsql.append(" from t_wfr_assign A inner  join t_wfr_procinst B on A.FPROCINSTID = B.FPROCINSTID and B.FINITIATORID = ? and B.FPROCINSTID in ('" + procInst.replaceAll("\uff01", "','") + "') ");
            Tempsql.append(" ) ");
            sqlTempDetail = Tempsql.toString().replaceAll("t_wfr_assign", "t_wfr_assignDetail");
            Tempsql.append(" Union ").append(sqlTempDetail);
            if (isIncludeHst) {
                sqlTempHst = sqlTempDetail.replaceAll("t_wfr_assignDetail", "t_wfr_assignHst").replaceAll("t_wfr_procinst", "t_wfr_procinstHst");
                Tempsql.append(" Union ").append(sqlTempHst);
            }
            sql = new StringBuffer("select  * from ( ").append(Tempsql).append(" ) c order by c.fcreatedtime desc");
        } else {
            Tempsql = new StringBuffer(" (select  A.FBIZOBJID,A.FASSIGNID,A.").append(subject).append(",A.FPROCINSTID,A.").append(actdefName).append(",A.FACTDEFID,B.FPROCINSTID ");
            Tempsql.append(" from t_wfr_assign A inner join t_wfr_procinst B on A.FPROCINSTID = B.FPROCINSTID");
            Tempsql.append(" where A.FPERSONUSERID = ? \t and B.FPROCINSTID in ('" + procInst.replaceAll("\uff01", "','") + "') ) ");
            sqlTempDetail = Tempsql.toString().replaceAll("t_wfr_assign", "t_wfr_assignDetail");
            Tempsql.append(" Union ").append(sqlTempDetail);
            if (isIncludeHst) {
                sqlTempHst = sqlTempDetail.replaceAll("t_wfr_assignDetail", "t_wfr_assignHst").replaceAll("t_wfr_procinst", "t_wfr_procinstHst");
                Tempsql.append(" Union ").append(sqlTempHst);
            }
            sql = Tempsql;
        }
        String currentUserID = ctx.getCaller().toString();
        Object[] param = null;
        param = isCanUrgent ? (!isIncludeHst ? new String[]{currentUserID, currentUserID} : new String[]{currentUserID, currentUserID, currentUserID}) : (!isIncludeHst ? new String[]{currentUserID, currentUserID} : new String[]{currentUserID, currentUserID, currentUserID});
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            if (row != null) {
                while (row.next()) {
                    String objID = row.getString("FBIZOBJID");
                    String actdef = null;
                    actdef = bizObjIDMap.get(objID) == null ? row.getString(actdefName) : bizObjIDMap.get(objID) + row.getString(actdefName);
                    bizObjIDMap.put(objID, actdef);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519", (Throwable)e);
        }
        return bizObjIDMap;
    }

    public static String getWebBillURL(Context ctx, String billID) {
        String[] dynamicEditUrl = ProcessCenterUtil.getDynamicEditURLByBillId(billID, ctx);
        if (dynamicEditUrl != null && dynamicEditUrl.length == 2) {
            StringBuffer urlStr = new StringBuffer(dynamicEditUrl[0]);
            if (!StringUtils.isEmpty((String)dynamicEditUrl[1])) {
                urlStr.append(urlStr.indexOf("?") < 0 ? "?" : "&").append("uipk").append("=").append(dynamicEditUrl[1]);
            }
            logger.info((Object)("getWebBillURL-urlStr.toString()= " + urlStr.toString()));
            return urlStr.toString();
        }
        String webUIurl = StoreUtils.getWebUIurl((String)billID, (Context)ctx);
        if (webUIurl != null) {
            logger.info((Object)("getWebBillURL-webUIurl= " + webUIurl));
            return webUIurl;
        }
        return "";
    }

    public static String[] getURLByClassName(String className, Context ctx) {
        String[] result = new String[4];
        try {
            if (className != null) {
                String name = className.substring(className.lastIndexOf(".") + 1, className.length());
                UIObjectCtrl ctrl = new UIObjectCtrl(ctx);
                String bizPackgeName = className.substring(0, className.lastIndexOf("."));
                MetaDataPK metaPK = new MetaDataPK(bizPackgeName, name);
                UIObjectInfo ui = ctrl.getValue((IMetaDataPK)metaPK);
                Map map = ui.getExtendedProperties();
                if (map != null && map.size() > 0) {
                    result[0] = (String)map.get("url");
                    if (StringUtils.isEmpty((String)result[0])) {
                        logger.warn((Object)("UI " + className + "URL"));
                    }
                    result[1] = (String)map.get("height");
                    result[2] = (String)map.get("width");
                    result[3] = (String)map.get("openWay");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("get url error: " + className), (Throwable)e);
        }
        return result;
    }

    public static String getWebfullyBillProcName(String assignId, Context ctx) {
        String procDefName = ProcessCenterUtil.getProNameByAssign(assignId, ctx);
        if (!StringUtils.isEmpty((String)procDefName) && ProcessCenterUtil.isWebBill(assignId, procDefName, ctx)) {
            logger.info((Object)("getWebfullyBillProcName procDefName: " + procDefName));
            return procDefName;
        }
        return "";
    }

    public static URLInfo getEditUrlInfoByBillId(String billID, Context ctx) {
        URLInfo info = new URLInfo();
        try {
            if (billID != null) {
                billID = billID.replaceAll(" ", "+");
            }
            info.setBillID(billID);
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
            ProcessInstInfo[] instInfos = iEnactmentService.getProcessInstanceByHoldedObjectId(billID);
            logger.info((Object)("instInfos.length = " + instInfos.length));
            if (instInfos.length == 0) {
                instInfos = iEnactmentService.getAllProcessInstancesByBizobjId(billID);
            }
            logger.info((Object)("instInfos.length 2 = " + instInfos.length));
            for (int k = 0; k < instInfos.length; ++k) {
                String hashValue = instInfos[k].getProcDefHashValue();
                ProcessDef def = iEnactmentService.getProcessDefByDefineHashValue(hashValue);
                ActivityCollection actColl = def.getActivitys();
                logger.info((Object)("actColl.size() = " + actColl.size()));
                for (int i = 0; i < actColl.size(); ++i) {
                    ApproveActivityDef approDef;
                    ExtendedAttributeDef extend;
                    ActivityDef act = actColl.get(i);
                    if (act instanceof WebBillManpowerActivityDef) {
                        StringBuffer webUrl = new StringBuffer(((WebBillManpowerActivityDef)act).getUrl());
                        logger.info((Object)("webUrl = " + webUrl));
                        if (webUrl.length() > 0) {
                            if (webUrl.indexOf("?") > 0) {
                                webUrl.append("&pk=").append(StringUtils.replace((String)billID, (String)"+", (String)"%2B"));
                            } else {
                                webUrl.append("?pk=").append(StringUtils.replace((String)billID, (String)"+", (String)"%2B"));
                            }
                            logger.info((Object)("WebBillManpowerActivityDef webUrl = " + webUrl));
                            info.setURL(webUrl.toString());
                            return info;
                        }
                    } else if (act instanceof ApproveActivityDef && (extend = (approDef = (ApproveActivityDef)act).getActivityHeader().getExtendedAttributes().get("isWebBillApprove")) != null && "true".equalsIgnoreCase(extend.getValue())) {
                        ExtendedAttributeDef extend1 = approDef.getActivityHeader().getExtendedAttributes().get("WebBillApproveUrl");
                        logger.info((Object)("extend1.getValue() = " + extend1.getValue()));
                        if (extend1 != null && !StringUtils.isEmpty((String)extend1.getValue())) {
                            String url = extend1.getValue();
                            if (url.indexOf("?") > 0) {
                                url = url + "&pk=";
                                url = url + StringUtils.replace((String)billID, (String)"+", (String)"%2B");
                            } else {
                                url = url + "?pk=";
                                url = url + StringUtils.replace((String)billID, (String)"+", (String)"%2B");
                            }
                            info.setURL(url);
                            logger.info((Object)("ApproveActivityDef url by billid = " + url));
                            return info;
                        }
                    }
                    if (!(act instanceof ManpowerActivityDef)) continue;
                    IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
                    ProcessInstInfo[] processInstInfos = service.getAllProcessInstancesByBizobjId(billID);
                    for (int j = 0; j < processInstInfos.length; ++j) {
                        AssignmentInfo[] assignmentInfos = service.getAssignmentAllByProcInstId(processInstInfos[j].getProcInstId());
                        for (int l = 0; l < assignmentInfos.length; ++l) {
                            String url = ProcessCenterUtil.getWaf2DynamicPageURL(service, assignmentInfos[l]);
                            if (StringUtils.isEmpty((String)url)) continue;
                            StringBuffer billUrl = new StringBuffer();
                            billUrl.append("/easweb/").append(url).append("&billId=").append(URLEncoder.encode(info.getBillID(), "UTF-8")).append("&operateState=VIEW");
                            info.setURL(billUrl.toString());
                            return info;
                        }
                    }
                }
            }
            String myUrl = ProcessCenterUtil.getWebBillURL(ctx, billID);
            if (!StringUtils.isEmpty((String)myUrl)) {
                info.setURL(myUrl);
                logger.info((Object)("getEditUrlInfo myUrl = " + info.getURL()));
                return info;
            }
            String className = ProcessCenterUtil.getEditUIClassByBillId(billID, ctx);
            logger.info((Object)("className = " + className));
            String[] results = ProcessCenterUtil.getURLByClassName(className, ctx);
            info.setURL(results[0]);
            info.setHeight(results[1]);
            info.setWidth(results[2]);
            info.setOpenWay(results[3]);
        }
        catch (Exception e) {
            logger.error((Object)EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)ProcessCenterUtil.getLocale(ctx)), (Throwable)e);
            info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)ProcessCenterUtil.getLocale(ctx)));
        }
        logger.info((Object)("getEditUrlInfo1 url = " + info.getURL()));
        return info;
    }

    public static String isBillSupportWeb(String assignId, Context ctx) {
        try {
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
            AssignmentInfo assInfo = iEnactmentService.getAssignmentById(assignId);
            String[] bizObjectID = assInfo.getBizObjectIdArray();
            if (bizObjectID != null && bizObjectID[0] != null) {
                return ProcessCenterUtil.isWebSupport(bizObjectID[0]);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"isBillSupportWeb\u5224\u65ad\u5df2\u529e\u6d41\u7a0b\u5355\u636e\u662f\u5426\u652f\u6301web\u51fa\u9519", (Throwable)e);
        }
        return "false";
    }

    public static String isWebSupport(String billID) {
        try {
            BOSObjectType objectType = new ObjectUuidPK(billID).getObjectType();
            EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(objectType);
            if (entityObjectInfo != null) {
                String isDynamic = entityObjectInfo.getExtendedProperty("isDynamic");
                if ("true".equalsIgnoreCase(isDynamic)) {
                    return "true";
                }
                String webSupport = entityObjectInfo.getExtendedProperty("isSupportWeb");
                if ("true".equalsIgnoreCase(webSupport)) {
                    return "true";
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"get entity by bill id error", (Throwable)ex);
            return "false";
        }
        return "false";
    }

    public static boolean setReadStatus(String idStr, int status, int msgType, Context ctx) {
        boolean flag = false;
        IMessageCenter messageCenter = null;
        try {
            logger.debug((Object)("idStr=" + idStr + ",status=" + status + ",msgType=" + msgType));
            messageCenter = MessageCenterFactory.getLocalInstance(ctx);
            messageCenter.setReadStatus(idStr, MsgStatus.getEnum(status), MsgType.getEnum(msgType));
            flag = true;
        }
        catch (Exception e) {
            logger.error((Object)"\u8bbe\u7f6e\u6d88\u606f\u9605\u8bfb\u72b6\u6001\u62a5\u9519", (Throwable)e);
            flag = false;
        }
        return flag;
    }

    public static void setMessageOrg(boolean isOrg) {
        try {
            IMessageCenter iMessage = MessageCenterFactory.getRemoteInstance();
            iMessage.setOrg(isOrg);
        }
        catch (Exception e) {
            logger.error((Object)"\u8bbe\u7f6e\u6d88\u606f\u5408\u5e76\u53c2\u6570\u51fa\u9519", (Throwable)e);
        }
    }

    public static void setMessageCombine(boolean isCombine) {
        try {
            IMessageCenter iMessage = MessageCenterFactory.getRemoteInstance();
            iMessage.setCombine(isCombine);
        }
        catch (Exception e) {
            logger.error((Object)"\u8bbe\u7f6e\u6d88\u606f\u5408\u5e76\u53c2\u6570\u51fa\u9519", (Throwable)e);
        }
    }

    public static boolean deleteSendInstantMsg(String msgIds, String ifHistory, Context ctx) {
        boolean result;
        block6: {
            result = false;
            try {
                IMsgSendRecord msgSendRecord = MsgSendRecordFactory.getLocalInstance(ctx);
                if (StringUtils.isEmpty((String)msgIds)) break block6;
                String[] ids = msgIds.split(";");
                int n = ids.length;
                if (Boolean.parseBoolean(ifHistory)) {
                    for (int i = 0; i < n; ++i) {
                        msgSendRecord.deleteSendMsgHst(ids[i]);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        msgSendRecord.deleteSendMsg(ids[i]);
                    }
                }
                result = true;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public static void delReceiveInstantMsg(String msgIds, String ifHistory, Context ctx) {
        if (Boolean.parseBoolean(ifHistory)) {
            ProcessCenterUtil.delRecInstHstMsg(msgIds, ctx);
        } else {
            ProcessCenterUtil.delRecInstMsg(msgIds, ctx);
        }
    }

    public static void delRecInstHstMsg(String msgIds, Context ctx) {
        if (!StringUtils.isEmpty((String)msgIds)) {
            ProcessCenterUtil.delAttachmentByMsgIds(msgIds, ctx);
            ProcessCenterUtil.delBMCHstMessage(msgIds, ctx);
        }
    }

    public static void delRecInstMsg(String msgIds, Context ctx) {
        if (!StringUtils.isEmpty((String)msgIds)) {
            ProcessCenterUtil.delAttachmentByMsgIds(msgIds, ctx);
            ProcessCenterUtil.deleteBMCMessage(msgIds, ctx);
        }
    }

    public static void delAttachmentByMsgIds(String msgIds, Context ctx) {
        if (!StringUtils.isEmpty((String)msgIds)) {
            String[] idArray = msgIds.split(";");
            AttachmentServerManager attmanager = AttachmentManagerFactory.getServerManager((Context)ctx);
            for (int i = 0; i < idArray.length; ++i) {
                try {
                    attmanager.deleteAttachemtsByBoID(idArray[i]);
                    continue;
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static boolean delBMCMessage(String msgIds, String ifHistory, Context ctx) {
        boolean result = false;
        result = Boolean.parseBoolean(ifHistory) ? ProcessCenterUtil.delBMCHstMessage(msgIds, ctx) : ProcessCenterUtil.deleteBMCMessage(msgIds, ctx);
        return result;
    }

    public static boolean deleteBMCMessage(String msgIds, Context ctx) {
        boolean result = false;
        if (!StringUtils.isEmpty((String)msgIds)) {
            String[] idArray = msgIds.split(";");
            ObjectUuidPK[] pkArray = new ObjectUuidPK[idArray.length];
            StringBuffer sql = new StringBuffer();
            sql.append(" (");
            Object[] params = new Object[idArray.length + 1];
            for (int i = 0; i < idArray.length; ++i) {
                pkArray[i] = new ObjectUuidPK(idArray[i]);
                if (i == idArray.length - 1) {
                    sql.append("?) ");
                } else {
                    sql.append("?,");
                }
                params[i] = idArray[i];
            }
            String sqlStr = "select 1 from t_bas_message where fid in " + sql.toString() + " and freceiver=?";
            params[idArray.length] = ctx.getCaller().toString();
            IBMCMessage iBMCMessage = null;
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])params);
                if (!rs.next()) {
                    return false;
                }
                iBMCMessage = BMCMessageFactory.getLocalInstance(ctx);
                iBMCMessage.delete((IObjectPK[])pkArray);
                result = true;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public static boolean delBMCHstMessage(String msgIds, Context ctx) {
        boolean flag = false;
        if (!StringUtils.isEmpty((String)msgIds)) {
            String[] msgId = msgIds.split(";");
            StringBuffer sql = new StringBuffer();
            sql.append("delete from T_BAS_MessageHst where FID in");
            for (int i = 0; i < msgId.length; ++i) {
                if (i == 0) {
                    sql.append("('").append(msgId[0]).append("'");
                    continue;
                }
                sql.append(",'").append(msgId[i]).append("'");
            }
            sql.append(")");
            try {
                DbUtil.execute((Context)ctx, (String)sql.toString());
                flag = true;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                flag = false;
            }
        }
        return flag;
    }

    public static boolean delOfficeMsg(String msgIds, String ifHistory, Context ctx) {
        boolean result = false;
        if (!StringUtils.isEmpty((String)msgIds)) {
            String[] msgId = msgIds.split(";");
            StringBuffer sql = new StringBuffer();
            sql.append("delete from t_bas_messageyr where FID in");
            for (int i = 0; i < msgId.length; ++i) {
                if (i == 0) {
                    sql.append("('").append(msgId[0]).append("'");
                    continue;
                }
                sql.append(",'").append(msgId[i]).append("'");
            }
            sql.append(")");
            try {
                DbUtil.execute((Context)ctx, (String)sql.toString());
                result = true;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public static boolean setOfficeMsgReadStatus(String msgId, String ifHistory, String status, Context ctx) {
        boolean result = false;
        if (!StringUtils.isEmpty((String)msgId)) {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_BAS_Messageyr set FStatus = ").append(status).append(" where FID = ?");
            try {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{msgId});
                result = true;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result = true;
            }
        }
        return result;
    }

    public static String getProcInstIdByAssignId(String assignId, Context ctx) {
        String procInstId = "";
        AssignmentInfo assignInfo = null;
        EnactmentService enactServ = new EnactmentService(ctx);
        try {
            assignInfo = enactServ.getAssignmentById(assignId);
        }
        catch (WfException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
        procInstId = assignInfo.getProcInstId();
        return procInstId;
    }

    public static String[] getMessageViewConfig(String msgId, String sourceIds, Context ctx) {
        String[] info = new String[]{"", "", "", "", ""};
        String prefix = sourceIds.substring(0, sourceIds.indexOf("::"));
        Object obj = MessageViewConfig.getInstance(true).getConfigByPrefix(prefix);
        if (obj != null) {
            HashMap map = (HashMap)obj;
            if (map.get("web") != null) {
                info[0] = map.get("web").toString();
            }
            info[1] = map.get("width").toString();
            info[2] = map.get("height").toString();
            info[3] = map.get("model").equals("true") ? "0" : "2";
            logger.info((Object)("--getMessageViewConfig--webUrl--" + map.get("web")));
            logger.info((Object)("--getMessageViewConfig--sourceIds--" + sourceIds));
        } else {
            info[4] = "no message view config";
        }
        try {
            IMessageCenter messageCenter = MessageCenterFactory.getLocalInstance(ctx);
            messageCenter.setReadStatus("'" + msgId + "'", MsgStatus.getEnum(10), MsgType.getEnum(0));
        }
        catch (Exception e) {
            logger.error((Object)"getMessageViewConfig\u8bbe\u7f6e\u6d88\u606f\u9605\u8bfb\u72b6\u6001\u62a5\u9519", (Throwable)e);
        }
        return info;
    }

    public static List getMessages(String msgIds, Context ctx) {
        ArrayList<Message> list = new ArrayList<Message>();
        String[] msgId = new String[]{};
        msgId = msgIds.split(";");
        int length = msgId.length;
        String locale = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FType, FBizType, FSender_" + locale + ",FStatus, FSourceStatus, FSourceID, FSourceIDs, FReceiver").append(" from T_BAS_Message where FID IN");
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sql.append("('").append(msgId[0]).append("'");
                continue;
            }
            sql.append(",'").append(msgId[i]).append("'");
        }
        sql.append(")");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            while (rs.next()) {
                String sourceids = "";
                Message message = new Message();
                message.setLocale(ctx.getLocale());
                message.setID(rs.getString(1));
                message.setType(rs.getInt(2));
                message.setBizType(rs.getInt(3));
                message.setSender(rs.getString(4));
                message.setStatus(rs.getInt(5));
                message.setSourceStatus(rs.getInt(6));
                message.setSourceID(rs.getString(7));
                sourceids = rs.getString(8);
                if (!StringUtils.isEmpty((String)sourceids)) {
                    sourceids = sourceids.replaceAll("[|]", "^!^");
                }
                message.setSourceIDs(sourceids);
                message.setReceiver(rs.getString(9));
                message.setSendTime(new Timestamp(System.currentTimeMillis()));
                message.setReceiveTime(new Timestamp(System.currentTimeMillis()));
                message.setEndTime(new Timestamp(System.currentTimeMillis()));
                String urgentBizType = message.getBizType() + "";
                if (urgentBizType.equals("40")) {
                    if (message.getSourceID() == null || message.getSourceID().length() <= 0) {
                        message.setWebSupport(false);
                    } else {
                        IAssign assign = AssignFactory.getLocalInstance((Context)ctx);
                        if (assign.exists((IObjectPK)new ObjectUuidPK(message.getSourceID()))) {
                            AssignReadInfo assignReadInfo = AssignReadFactory.getLocalInstance(ctx).getAssignReadInfo("where assignID ='" + message.getSourceID() + "'");
                            if (assignReadInfo.isIsWebSupport()) {
                                message.setWebSupport(true);
                            } else {
                                message.setWebSupport(false);
                            }
                        }
                    }
                }
                list.add(message);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public static List getMessagesHst(String msgIds, Context ctx) {
        ArrayList<Message> list = new ArrayList<Message>();
        String[] msgId = new String[]{};
        msgId = msgIds.split(";");
        int length = msgId.length;
        String locale = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FType, FBizType, FSender_" + locale + ",FStatus, FSourceStatus, FSourceID, FSourceIDs, FReceiver").append(" from T_BAS_MessageHst where FID IN");
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sql.append("('").append(msgId[0]).append("'");
                continue;
            }
            sql.append(",'").append(msgId[i]).append("'");
        }
        sql.append(")");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            while (rs.next()) {
                String sourceids = "";
                Message message = new Message();
                message.setLocale(ctx.getLocale());
                message.setID(rs.getString(1));
                message.setType(rs.getInt(2));
                message.setBizType(rs.getInt(3));
                message.setSender(rs.getString(4));
                message.setStatus(rs.getInt(5));
                message.setSourceStatus(rs.getInt(6));
                message.setSourceID(rs.getString(7));
                sourceids = rs.getString(8);
                if (!StringUtils.isEmpty((String)sourceids)) {
                    sourceids = sourceids.replaceAll("[|]", "^!^");
                }
                message.setSourceIDs(sourceids);
                message.setReceiver(rs.getString(9));
                message.setSendTime(new Timestamp(System.currentTimeMillis()));
                message.setReceiveTime(new Timestamp(System.currentTimeMillis()));
                message.setEndTime(new Timestamp(System.currentTimeMillis()));
                String urgentBizType = message.getBizType() + "";
                if (urgentBizType.equals("40")) {
                    if (message.getSourceID() == null || message.getSourceID().length() <= 0) {
                        message.setWebSupport(false);
                    } else {
                        IAssign assign = AssignFactory.getLocalInstance((Context)ctx);
                        if (assign.exists((IObjectPK)new ObjectUuidPK(message.getSourceID()))) {
                            AssignReadInfo assignReadInfo = AssignReadFactory.getLocalInstance(ctx).getAssignReadInfo("where assignID ='" + message.getSourceID() + "'");
                            if (assignReadInfo.isIsWebSupport()) {
                                message.setWebSupport(true);
                            } else {
                                message.setWebSupport(false);
                            }
                        }
                    }
                }
                list.add(message);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public static List getPendingAssignments(String assignIds, Context ctx) {
        ArrayList<Message> list = new ArrayList<Message>();
        String[] assignId = new String[]{};
        assignId = assignIds.split(";");
        int length = assignId.length;
        String locale = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select b.FID, 10 as FType, 0 as FBizType, b.FSender_" + locale + ",b.FStatus, a.FSTATE,a.FASSIGNID,b.FIsWebSupport ").append(" from T_WFR_Assign a,T_BAS_AssignRead b ").append(" where a.FASSIGNID = b.FASSIGNID and b.FASSIGNID IN");
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sql.append("('").append(assignId[i]).append("'");
                continue;
            }
            sql.append(",'").append(assignId[i]).append("'");
        }
        sql.append(")");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (rs != null) {
            try {
                while (rs.next()) {
                    Message message = new Message();
                    message.setLocale(ctx.getLocale());
                    message.setID(rs.getString(1));
                    message.setType(rs.getInt(2));
                    message.setBizType(rs.getInt(3));
                    message.setSender(rs.getString(4));
                    message.setStatus(rs.getInt(5));
                    message.setSourceStatus(rs.getInt(6));
                    message.setSourceID(rs.getString(7));
                    message.setWebSupport(rs.getBoolean(8));
                    list.add(message);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public static List getAlreadyAssignments(String assignIds, Context ctx) {
        ArrayList<Message> list = new ArrayList<Message>();
        String[] assignId = new String[]{};
        assignId = assignIds.split(";");
        int length = assignId.length;
        StringBuffer sql = new StringBuffer();
        sql.append("select 10 as FType, 0 as FBizType,FSTATE,FASSIGNID ").append(" from T_WFR_AssignDetail ").append(" where FASSIGNID IN");
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sql.append("('").append(assignId[i]).append("'");
                continue;
            }
            sql.append(",'").append(assignId[i]).append("'");
        }
        sql.append(")");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (rs != null) {
            try {
                while (rs.next()) {
                    Message message = new Message();
                    message.setLocale(ctx.getLocale());
                    message.setType(rs.getInt(1));
                    message.setBizType(rs.getInt(2));
                    message.setSourceStatus(rs.getInt(3));
                    message.setSourceID(rs.getString(4));
                    list.add(message);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public static List getAlreadyAssignmentsHst(String assignIds, Context ctx) {
        ArrayList<Message> list = new ArrayList<Message>();
        String[] assignId = new String[]{};
        assignId = assignIds.split(";");
        int length = assignId.length;
        StringBuffer sql = new StringBuffer();
        sql.append("select 10 as FType, 0 as FBizType,FSTATE,FASSIGNID ").append(" from T_WFR_AssignHst ").append(" where FASSIGNID IN");
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sql.append("('").append(assignId[i]).append("'");
                continue;
            }
            sql.append(",'").append(assignId[i]).append("'");
        }
        sql.append(")");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (rs != null) {
            try {
                while (rs.next()) {
                    Message message = new Message();
                    message.setLocale(ctx.getLocale());
                    message.setType(rs.getInt(1));
                    message.setBizType(rs.getInt(2));
                    message.setSourceStatus(rs.getInt(3));
                    message.setSourceID(rs.getString(4));
                    list.add(message);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public static List getMySketchs(String sketchIds, Context ctx) {
        if (StringUtils.isEmpty((String)sketchIds)) {
            return null;
        }
        String[] sketchId = new String[]{};
        sketchId = sketchIds.split(";");
        int length = sketchId.length;
        ArrayList<String[]> list = null;
        String local = ctx.getLocale().toString();
        StringBuffer idSql = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                idSql.append("('").append(sketchId[i]).append("'");
                continue;
            }
            idSql.append(",'").append(sketchId[i]).append("'");
        }
        idSql.append(")");
        StringBuffer sql = new StringBuffer();
        sql.append("select A.FID,A.FBizObjID,A.FProcDefID,A.FCreatorID,A.FCreatedTime,B.FName_" + local + " from ");
        sql.append("T_WFR_TempBizProcRelation A join t_wfr_procdef B on A.FProcDefID = B.FProcdefid  where FID IN");
        sql.append(idSql.toString());
        sql.append(" and B.FINNERVERSION = (select max(c.FINNERVERSION) from T_WFR_PROCDEF C");
        sql.append(" where C.FPROCDEFID = B.FPROCDEFID and C.FENABLE = 1 ) Order by A.FCreatedTime DESC");
        logger.info((Object)("getMySketchSql=" + sql));
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        if (rs != null) {
            try {
                list = new ArrayList<String[]>();
                String[] rowSet = null;
                while (rs.next()) {
                    rowSet = new String[]{rs.getString("fid"), rs.getString("FName_" + local), rs.getString("FCreatedTime").substring(0, 19), rs.getString("FBizObjID"), rs.getString("FProcDefID")};
                    list.add(rowSet);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public static void deleteSketches(String sketchIds, Context ctx) {
        String[] idArray = sketchIds.split(";");
        StringBuffer idBuffer = new StringBuffer();
        for (int i = 0; i < idArray.length; ++i) {
            if (i == 0) {
                idBuffer.append("'" + idArray[i] + "'");
                continue;
            }
            idBuffer.append(",'" + idArray[i] + "'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_WFR_TempBizProcRelation where fid in(");
        sql.append(idBuffer.toString());
        sql.append(")");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static List getAttachments(String msgIds, Context ctx) {
        List list = new ArrayList();
        String[] msgId = msgIds.split(";");
        try {
            IAttachmentHandleFacade iAttachHandler = AttachmentHandleFacadeFactory.getLocalInstance((Context)ctx);
            if (iAttachHandler == null) {
                return null;
            }
            list = iAttachHandler.getWebAttachment(msgId[0]);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public static List getMyUrgentInfoByProcInst(String procInstId, Context ctx) {
        if (StringUtils.isEmpty((String)procInstId)) {
            return null;
        }
        IEnactmentService service = null;
        ArrayList<Assign> list = new ArrayList<Assign>();
        AssignmentInfo[] assignInfoArray = null;
        ActivityInstInfo[] actInstInfoArray = null;
        try {
            service = EnactmentServiceFactory.createEnactService((Context)ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6EnactmentService\u8fdc\u7a0b\u63a5\u53e3\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
        }
        try {
            actInstInfoArray = service.getActInstMetaArrayByProcInstId(procInstId);
        }
        catch (WfException e2) {
            logger.error((Object)("\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid\u83b7\u53d6\u6d3b\u52a8\u5b9e\u4f8b\u51fa\u9519\uff1a" + e2.getMessage()), (Throwable)e2);
        }
        if (actInstInfoArray != null && actInstInfoArray.length > 0) {
            for (int i = 0; i < actInstInfoArray.length; ++i) {
                ActivityInstInfo actInstInfo = actInstInfoArray[i];
                String state = actInstInfo.getState();
                if (!state.equalsIgnoreCase("open.not_running.not_started")) continue;
                String actInstId = actInstInfo.getActInstId();
                try {
                    assignInfoArray = service.getAssignmentByActInstId(actInstId);
                }
                catch (WfException e) {
                    logger.error((Object)("\u6839\u636e\u6d3b\u52a8\u5b9e\u4f8bid\u83b7\u53d6\u4efb\u52a1\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
                }
                if (assignInfoArray == null || assignInfoArray.length <= 0) continue;
                IUser iUser = null;
                try {
                    iUser = UserFactory.getLocalInstance((Context)ctx);
                }
                catch (BOSException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
                for (int j = 0; j < assignInfoArray.length; ++j) {
                    if (assignInfoArray[j].getState() != WfAssignmentState.ACCEPTED && assignInfoArray[j].getState() != WfAssignmentState.ASSIGNED) continue;
                    Assign assign = new Assign();
                    assign.setAssignID(assignInfoArray[j].getAssignmentId());
                    assign.setSubject(assignInfoArray[j].getSubject(locale));
                    assign.setBody(assignInfoArray[j].getBody(locale));
                    assign.setActInstID(assignInfoArray[j].getActInstId());
                    assign.setActdefName(assignInfoArray[j].getActDefName(locale));
                    assign.setPersonUserID(assignInfoArray[j].getUserId());
                    assign.setPersonUserName(assignInfoArray[j].getUserName(locale));
                    String userId = assignInfoArray[j].getUserId();
                    String userNumber = "";
                    UserInfo userInfo = null;
                    try {
                        userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(userId));
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    userNumber = userInfo.getNumber();
                    if (!StringUtils.isEmpty((String)userNumber)) {
                        assign.setUserNumber(userNumber);
                    }
                    list.add(assign);
                }
            }
        }
        return list;
    }

    public static String mapToString(Map map) {
        StringBuffer sb = new StringBuffer("[{");
        Set keyset = map.keySet();
        Iterator iter = keyset.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            sb.append("'" + key + "':'" + map.get(key) + "'");
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}]");
        return sb.toString();
    }

    public static int[] getNewMessageCenterCounts(Context ctx, String userId, boolean isweb) throws BOSException, EASBizException {
        int[] counts = new int[]{0, 0, 0, 0, 0, 0, 1};
        String locale = ctx.getLocale().toString();
        String serverName = "";
        serverName = locale.equalsIgnoreCase("l1") ? "Server" : (locale.equalsIgnoreCase("l3") ? "\u670d\u52d9\u5668" : "\u670d\u52a1\u5668");
        StringBuffer unreadSql = new StringBuffer();
        unreadSql.append("SELECT COUNT(a.FASSIGNID) AS COUNT from T_WFR_Assign a  ,T_BAS_AssignRead b where a.FASSIGNID = b.FASSIGNID and a.FSTATE in(1,2) and a.FIsSendMsg=1 and a.FPERSONUSERID = ?  AND FStatus = ? ");
        Object[] unreadTaskParams = new Object[]{userId, new Integer(0)};
        StringBuffer unreadMsgSql = new StringBuffer();
        unreadMsgSql.append("SELECT COUNT(FID) AS COUNT FROM T_BAS_Message WHERE FReceiver = ? AND FType = ? AND FStatus = ? AND FSENDER_");
        unreadMsgSql.append(ctx.getLocale());
        unreadMsgSql.append("<>'");
        unreadMsgSql.append(serverName);
        unreadMsgSql.append("'");
        unreadMsgSql.append(" and ((FSOURCEIDS not like 'PASS%' or FSOURCEIDS is null) and (ftitle_l2 not like '\u4f20\u9605\u53cd\u9988%' or ftitle_l1 not like 'Reply%' or ftitle_l3 not like '\u50b3\u95b1\u53cd\u994b%') and not exists (select 'x' from t_wfr_assign where t_wfr_assign.FASSIGNID=T_BAS_Message.FSOURCEID) and not exists (select 'x' from t_wfr_AssignDetail where t_wfr_AssignDetail.FASSIGNID=T_BAS_Message.FSOURCEID))");
        Object[] unreadMsgParams = new Object[]{userId, new Integer(0), new Integer(0)};
        StringBuffer undisposSql = new StringBuffer();
        Object[] undisposeParams = null;
        if (MessageUtil.isFD(ctx)) {
            undisposSql.append("SELECT COUNT(a.FASSIGNID) AS COUNT from T_WFR_Assign a  ,T_BAS_AssignRead b where a.FASSIGNID = b.FASSIGNID and a.FSTATE in(1,2) and a.FIsSendMsg=1 and a.FPERSONUSERID = ? ");
            undisposeParams = new Object[]{userId};
        } else {
            undisposSql.append("SELECT COUNT(a.FASSIGNID) AS COUNT from T_WFR_Assign a  ,T_BAS_AssignRead b where a.FASSIGNID = b.FASSIGNID and a.FSTATE in(1,2) and a.FIsSendMsg=1 and a.FPERSONUSERID = ?  AND FStatus = ? ");
            undisposeParams = new Object[]{userId, new Integer(0)};
        }
        StringBuffer unreadNoticeSql = new StringBuffer();
        unreadNoticeSql.append("SELECT COUNT(FID) AS COUNT FROM T_BAS_Message WHERE FReceiver = ? AND FType = ? AND FBizType = ? AND FStatus = ? ");
        Object[] unreadInstanceMsgParams = new Object[]{userId, new Integer(40), new Integer(20), new Integer(0)};
        Object[] unreadWorkFlowParams = new Object[]{userId, new Integer(0), new Integer(0), new Integer(0)};
        Object[] unreadFornWarnParams = new Object[]{userId, new Integer(0), new Integer(10), new Integer(0)};
        Object[] unreadAskMsgParams = new Object[]{userId, new Integer(0), new Integer(40), new Integer(0)};
        Object[] unreadBackMsgParams = new Object[]{userId, new Integer(0), new Integer(50), new Integer(0)};
        try {
            IRowSet unreadInstanceMsgRowSet;
            IRowSet undisposeTaskRowSet;
            IRowSet unreadMsgRowSet;
            IRowSet unreadTaskRowSet = DbUtil.executeQuery((Context)ctx, (String)unreadSql.toString(), (Object[])unreadTaskParams);
            if (unreadTaskRowSet.next()) {
                counts[0] = unreadTaskRowSet.getInt("COUNT");
            }
            if ((unreadMsgRowSet = DbUtil.executeQuery((Context)ctx, (String)unreadMsgSql.toString(), (Object[])unreadMsgParams)).next()) {
                counts[1] = unreadMsgRowSet.getInt("COUNT");
            }
            if ((undisposeTaskRowSet = DbUtil.executeQuery((Context)ctx, (String)undisposSql.toString(), (Object[])undisposeParams)).next()) {
                counts[2] = undisposeTaskRowSet.getInt("COUNT");
            }
            if ((unreadInstanceMsgRowSet = DbUtil.executeQuery((Context)ctx, (String)unreadNoticeSql.toString(), (Object[])unreadInstanceMsgParams)).next()) {
                counts[3] = unreadInstanceMsgRowSet.getInt("COUNT");
            }
            IMessageOption imo = MessageOptionFactory.getLocalInstance((Context)ctx);
            String userID = userId;
            MessageOptionInfo info = null;
            boolean hasOption = imo.checkOptionInfo(userID);
            info = hasOption ? (MessageOptionInfo)imo.getUserOptionInfo(userID) : (MessageOptionInfo)imo.getUserOptionInfo("00000000-0000-0000-0000-00000000000013B7DE7F");
            String awakeMsgtype = info.getAwakeMsgType();
            if (awakeMsgtype != null) {
                IRowSet unreadBackMsgSet;
                IRowSet unreadAskMsgSet;
                IRowSet unreadFornWarnSet;
                IRowSet unreadworkflowSet;
                if (awakeMsgtype.indexOf("2") > 0 && (unreadworkflowSet = DbUtil.executeQuery((Context)ctx, (String)unreadNoticeSql.toString(), (Object[])unreadWorkFlowParams)).next()) {
                    counts[4] = counts[4] + unreadworkflowSet.getInt("COUNT");
                }
                if (awakeMsgtype.indexOf("3") > 0 && (unreadFornWarnSet = DbUtil.executeQuery((Context)ctx, (String)unreadNoticeSql.toString(), (Object[])unreadFornWarnParams)).next()) {
                    counts[4] = counts[4] + unreadFornWarnSet.getInt("COUNT");
                }
                if (awakeMsgtype.indexOf("4") > 0 && (unreadAskMsgSet = DbUtil.executeQuery((Context)ctx, (String)unreadNoticeSql.toString(), (Object[])unreadAskMsgParams)).next()) {
                    counts[4] = counts[4] + unreadAskMsgSet.getInt("COUNT");
                }
                if (awakeMsgtype.indexOf("5") > 0 && (unreadBackMsgSet = DbUtil.executeQuery((Context)ctx, (String)unreadNoticeSql.toString(), (Object[])unreadBackMsgParams)).next()) {
                    counts[4] = counts[4] + unreadBackMsgSet.getInt("COUNT");
                }
            }
            if (isweb) {
                String haseOA = "false";
                IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
                haseOA = iParam.getParamValue(null, "OFFICE001");
                if ("true".equals(haseOA)) {
                    Object[] params = new Object[]{userId};
                    StringBuffer sqlOABf = new StringBuffer();
                    sqlOABf.append(" select count(FID) from T_BAS_Messageyr where FReceiver = ? and FType=50 and FStatus=0 ");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlOABf.toString(), (Object[])params);
                    while (rs.next()) {
                        counts[5] = rs.getInt(1);
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return counts;
    }

    public static String getBillIdByProcInstId(String procInstId, Context ctx) {
        String billId = "";
        IEnactmentService service = null;
        try {
            service = EnactmentServiceFactory.createEnactService((Context)ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            billId = service.getBizObjIdByProcessInstanceId(procInstId);
        }
        catch (WfException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return billId;
    }

    public static List getUrgentAssignIdByProcInstId(String procInstId, Context ctx) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty((String)procInstId)) {
            return list;
        }
        IEnactmentService service = null;
        IAssignRead iAssignRead = null;
        AssignReadInfo assignReadInfo = new AssignReadInfo();
        AssignmentInfo[] assignInfoArray = null;
        Object[] actInstInfoArray = null;
        try {
            service = EnactmentServiceFactory.createEnactService((Context)ctx);
            iAssignRead = AssignReadFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6EnactmentService\u8fdc\u7a0b\u63a5\u53e3\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
        }
        try {
            actInstInfoArray = service.getActInstMetaArrayByProcInstIdAndActInstState(procInstId, "open.not_running.not_started");
            HashSet<String> procSet = new HashSet<String>();
            procSet.add(procInstId);
            while (procSet.size() > 0) {
                WfEngine wfEngine = EngineUtil.getEngine((Context)ctx);
                HashSet<String> tempProc = new HashSet<String>();
                for (String proc : procSet) {
                    ProcessInstInfo[] processInsts = wfEngine.getProcessInstancesByParentProcInstId(proc);
                    for (int i = 0; i < processInsts.length; ++i) {
                        if (!"open.running".equals(processInsts[i].getState())) continue;
                        String procinstID = processInsts[i].getProcInstId();
                        tempProc.add(procinstID);
                        Object[] actInstInfoArrayTemp = service.getActInstMetaArrayByProcInstIdAndActInstState(procinstID, "open.not_running.not_started");
                        actInstInfoArray = (ActivityInstInfo[])ArrayUtils.addAll((Object[])actInstInfoArray, (Object[])actInstInfoArrayTemp);
                    }
                }
                procSet = tempProc;
            }
        }
        catch (WfException e2) {
            logger.error((Object)("\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid\u83b7\u53d6\u6d3b\u52a8\u5b9e\u4f8b\u51fa\u9519\uff1a" + e2.getMessage()), (Throwable)e2);
        }
        if (actInstInfoArray != null && actInstInfoArray.length > 0) {
            for (int i = 0; i < actInstInfoArray.length; ++i) {
                ActivityInstInfo actInstInfo = actInstInfoArray[i];
                String actInstId = actInstInfo.getActInstId();
                try {
                    assignInfoArray = service.getAssignmentByActInstId(actInstId);
                }
                catch (WfException e) {
                    logger.error((Object)("\u6839\u636e\u6d3b\u52a8\u5b9e\u4f8bid\u83b7\u53d6\u4efb\u52a1\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
                }
                if (assignInfoArray == null || assignInfoArray.length <= 0) continue;
                for (int j = 0; j < assignInfoArray.length; ++j) {
                    if (assignInfoArray[j].getState() != WfAssignmentState.ACCEPTED && assignInfoArray[j].getState() != WfAssignmentState.ASSIGNED) continue;
                    String id = assignInfoArray[j].getAssignmentId();
                    try {
                        if (!Boolean.valueOf(assignInfoArray[j].getAssignInfo().getValues().get("issendmsg").toString()).booleanValue()) continue;
                        assignReadInfo = iAssignRead.getAssignReadInfo("where assignID='" + id + "'");
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    if (assignReadInfo == null) continue;
                    list.add(id);
                }
            }
        }
        return list;
    }

    public static List getMyUrgentInfosByAssignIds(String assignIds, Context ctx) {
        String[] assignId = assignIds.split(";");
        ArrayList<Assign> list = new ArrayList<Assign>();
        AssignmentInfo[] assignInfoArray = null;
        IEnactmentService service = null;
        IAssignRead iAssignRead = null;
        try {
            service = EnactmentServiceFactory.createEnactService((Context)ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6EnactmentService\u63a5\u53e3\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
        }
        try {
            assignInfoArray = service.getAssignmentById(assignId, DataTypeEnum.RUNTIME);
        }
        catch (WfException e) {
            logger.error((Object)("\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
        }
        if (assignInfoArray != null && assignInfoArray.length > 0) {
            IUser iUser = null;
            try {
                iUser = UserFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                iAssignRead = AssignReadFactory.getLocalInstance(ctx);
            }
            catch (BOSException e1) {
                logger.error((Object)("\u83b7\u53d6AssignRead\u63a5\u53e3\u51fa\u9519\uff1a" + e1.getMessage()), (Throwable)e1);
            }
            AssignReadInfo assignReadInfo = new AssignReadInfo();
            for (int i = 0; i < assignInfoArray.length; ++i) {
                String assignmentId = assignInfoArray[i].getAssignmentId();
                Assign assign = new Assign();
                assign.setAssignID(assignmentId);
                assign.setSubject(assignInfoArray[i].getSubject(locale));
                assign.setBody(assignInfoArray[i].getBody(locale));
                assign.setActInstID(assignInfoArray[i].getActInstId());
                assign.setActdefName(assignInfoArray[i].getActDefName(locale));
                assign.setPersonUserID(assignInfoArray[i].getUserId());
                assign.setPersonUserName(assignInfoArray[i].getUserName(locale));
                String userId = assignInfoArray[i].getUserId();
                String userNumber = "";
                UserInfo userInfo = null;
                try {
                    userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(userId));
                    assignReadInfo = iAssignRead.getAssignReadInfo("where assignID = '" + assignmentId + "'");
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                userNumber = userInfo.getNumber();
                if (!StringUtils.isEmpty((String)userNumber)) {
                    assign.setUserNumber(userNumber);
                }
                if (assignReadInfo != null) {
                    assign.setWebSupport(assignReadInfo.isIsWebSupport());
                }
                list.add(assign);
            }
        }
        return list;
    }

    public static com.kingdee.bos.service.message.Message createDefaultUrgentMessage(String assignId, Context ctx) {
        com.kingdee.bos.service.message.Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        Locale[] local = ApplicationUtil.getContextLocales((Context)ctx);
        Locale _locale = null;
        int nSize = local.length;
        IAssignRead iAssignRead = null;
        IUser iUser = null;
        AssignReadInfo assignReadInfo = null;
        UserInfo userInfo = null;
        IEnactmentService service = null;
        AssignmentInfo assignInfo = null;
        try {
            iAssignRead = AssignReadFactory.getLocalInstance(ctx);
            iUser = UserFactory.getLocalInstance((Context)ctx);
            service = EnactmentServiceFactory.createEnactService((Context)ctx);
            assignInfo = service.getAssignmentById(assignId);
            assignReadInfo = iAssignRead.getAssignReadInfo("where assignID = '" + assignId + "'");
            userInfo = iUser.getUserInfo(ctx.getCaller());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (int i = 0; i < nSize; ++i) {
            _locale = local[i];
            message.setLocaleStringHeader("title", ResourceBase.getString((String)RESOURCE, (String)"urgency", (Locale)_locale) + ":" + assignInfo.getSubject(_locale), _locale);
            message.setLocaleStringHeader("body", ResourceBase.getString((String)RESOURCE, (String)"urgency", (Locale)_locale) + ":" + assignInfo.getBody(_locale), _locale);
            message.setLocaleStringHeader("sender", userInfo.getName(_locale), _locale);
        }
        message.setStringHeader("receiver", assignInfo.getUserId());
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 40);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("sourceID", assignId);
        if (assignReadInfo.isIsWebSupport()) {
            message.setStringHeader("webSupport", "true");
        } else {
            message.setStringHeader("webSupport", "false");
        }
        return message;
    }

    public static List<com.kingdee.bos.service.message.Message> createDefaultUrgentMessage(List assignId, Context ctx) {
        ArrayList<com.kingdee.bos.service.message.Message> list = new ArrayList<com.kingdee.bos.service.message.Message>();
        Locale[] local = ApplicationUtil.getContextLocales((Context)ctx);
        Locale _locale = null;
        int nSize = local.length;
        IAssignRead iAssignRead = null;
        IUser iUser = null;
        IEnactmentService service = null;
        AssignmentInfo assignInfo = null;
        try {
            iAssignRead = AssignReadFactory.getLocalInstance(ctx);
            iUser = UserFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (int i = 0; i < assignId.size(); ++i) {
            com.kingdee.bos.service.message.Message message = MessageFactory.newMessage((String)"kingdee.workflow");
            AssignReadInfo assignReadInfo = null;
            UserInfo userInfo = null;
            try {
                assignReadInfo = iAssignRead.getAssignReadInfo("where assignID = '" + assignId.get(i).toString() + "'");
                userInfo = iUser.getUserInfo(ctx.getCaller());
                service = EnactmentServiceFactory.createEnactService((Context)ctx);
                assignInfo = service.getAssignmentById(assignId.get(i).toString());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            for (int j = 0; j < nSize; ++j) {
                _locale = local[j];
                message.setLocaleStringHeader("title", ResourceBase.getString((String)RESOURCE, (String)"urgency", (Locale)_locale) + ":" + assignInfo.getSubject(_locale), _locale);
                message.setLocaleStringHeader("body", ResourceBase.getString((String)RESOURCE, (String)"urgency", (Locale)_locale) + ":" + assignInfo.getBody(_locale), _locale);
                message.setLocaleStringHeader("sender", userInfo.getName(_locale), _locale);
            }
            message.setStringHeader("receiver", assignInfo.getUserId());
            message.setStringHeader("databaseCenter", ctx.getAIS());
            message.setStringHeader("solution", ctx.getSolution());
            message.setIntHeader("type", 0);
            message.setIntHeader("bizType", 40);
            message.setIntHeader("sourceStatus", 0);
            message.setIntHeader("priority", 10);
            message.setStringHeader("sourceID", assignId.get(i).toString());
            if (assignReadInfo.isIsWebSupport()) {
                message.setStringHeader("webSupport", "true");
            } else {
                message.setStringHeader("webSupport", "false");
            }
            list.add(message);
        }
        return list;
    }

    public static com.kingdee.bos.service.message.Message setUrgentMessage(String assignId, String receiver, String title, String content, Context ctx) {
        com.kingdee.bos.service.message.Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        message = ProcessCenterUtil.createDefaultUrgentMessage(assignId, ctx);
        if (!StringUtils.isEmpty((String)receiver)) {
            message.setStringHeader("receiver", receiver);
        }
        if (!StringUtils.isEmpty((String)title)) {
            message.setLocaleStringHeader("title", title, locale);
        }
        if (!StringUtils.isEmpty((String)content)) {
            message.setLocaleStringHeader("body", content, locale);
        }
        return message;
    }

    public static List<com.kingdee.bos.service.message.Message> setUrgentMessage(List assignId, List receiver, String title, String content, Context ctx) {
        int i;
        ArrayList<com.kingdee.bos.service.message.Message> list = new ArrayList();
        list = ProcessCenterUtil.createDefaultUrgentMessage(assignId, ctx);
        if (receiver != null) {
            for (i = 0; i < receiver.size(); ++i) {
                ((com.kingdee.bos.service.message.Message)list.get(i)).setStringHeader("receiver", receiver.get(i).toString());
            }
        }
        if (!StringUtils.isEmpty((String)title)) {
            for (i = 0; i < receiver.size(); ++i) {
                ((com.kingdee.bos.service.message.Message)list.get(i)).setLocaleStringHeader("title", title, locale);
            }
        }
        if (!StringUtils.isEmpty((String)content)) {
            for (i = 0; i < receiver.size(); ++i) {
                ((com.kingdee.bos.service.message.Message)list.get(i)).setLocaleStringHeader("body", content, locale);
            }
        }
        return list;
    }

    public static boolean sendUrgentMessage(com.kingdee.bos.service.message.Message urgentMsg, Context ctx) {
        IEnactmentService iService = null;
        try {
            iService = EnactmentServiceFactory.createEnactService((Context)ctx);
            iService.sendMessage(urgentMsg);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean sendUrgentMessage(List<com.kingdee.bos.service.message.Message> urgentMsg, Context ctx) {
        IEnactmentService iService = null;
        try {
            iService = EnactmentServiceFactory.createEnactService((Context)ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        for (int i = 0; i < urgentMsg.size(); ++i) {
            iService.sendMessage(urgentMsg.get(i));
        }
        return true;
    }

    public static boolean sendUrgentMobile(String assignId, String content, String priority, Context ctx) {
        boolean success = false;
        String result = "";
        String receiver = "";
        result = ProcessCenterUtil.createDefaultUrgentMobileContent(assignId, content, ctx);
        try {
            IEnactmentService service = null;
            service = EnactmentServiceFactory.createEnactService((Context)ctx);
            AssignmentInfo assginInfo = null;
            assginInfo = service.getAssignmentById(assignId);
            receiver = assginInfo.getEmployeeId();
            success = MsgUtil.msgSend((Context)ctx, (String)result, (int)Integer.valueOf(priority), (boolean)true, (String)"", (String)receiver, (int)1, null, (String)assignId);
        }
        catch (Exception e) {
            logger.error((Object)("sendUrgentMobile send SMS error:" + e.getMessage()), (Throwable)e);
            return false;
        }
        return success;
    }

    public static Map sendUrgentMobile(List<String> assignIds, String content, String priority, Context ctx) {
        String sendSuccess = ResourceBase.getString((String)RESOURCE, (String)"sendSuccess", (Locale)ctx.getLocale());
        String sendFailed = ResourceBase.getString((String)RESOURCE, (String)"sendFailed", (Locale)ctx.getLocale());
        HashMap<String, String> resultMap = new HashMap<String, String>();
        HashMap<String, String> failMap = new HashMap<String, String>();
        failMap.put(SUCCESS, "0");
        failMap.put(FAILURE, "0");
        failMap.put(LOG, sendFailed);
        StringBuffer returnLog = new StringBuffer();
        int successCount = 0;
        int failureCount = 0;
        List<Object> result = new ArrayList();
        ArrayList<String> receivers = new ArrayList<String>();
        result = ProcessCenterUtil.createDefaultUrgentMobileContent(assignIds, content, ctx);
        try {
            IEnactmentService service = null;
            service = EnactmentServiceFactory.createEnactService((Context)ctx);
            AssignmentInfo[] assginInfo = null;
            String[] assignId = (String[])assignIds.toArray();
            assginInfo = service.getAssignmentById(assignId, DataTypeEnum.RUNTIME);
            for (int i = 0; i < assginInfo.length; ++i) {
                if (receivers.contains(assginInfo[i].getEmployeeId())) continue;
                receivers.add(assginInfo[i].getEmployeeId());
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return failMap;
        }
        for (int i = 0; i < receivers.size(); ++i) {
            try {
                boolean success = false;
                success = MsgUtil.msgSend((Context)ctx, (String)((String)result.get(i)), (int)Integer.valueOf(priority), (boolean)true, (String)"", (String)((String)receivers.get(i)), (int)1, null, (String)assignIds.get(i));
                if (success) {
                    ++successCount;
                    continue;
                }
                ++failureCount;
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("sendUrgentMobile send SMS <" + (i + 1) + "> error:" + e.getMessage()), (Throwable)e);
                ++failureCount;
            }
        }
        returnLog.append(sendSuccess).append(":").append(successCount).append(",").append(sendFailed).append(":").append(failureCount);
        logger.info((Object)("\u6279\u91cf\u53d1\u9001\u50ac\u529e\u77ed\u4fe1:" + returnLog));
        if (successCount == 0) {
            return failMap;
        }
        if (failureCount == 0) {
            resultMap.put(LOG, sendSuccess);
        } else {
            resultMap.put(LOG, returnLog.toString());
        }
        resultMap.put(SUCCESS, String.valueOf(successCount));
        resultMap.put(FAILURE, String.valueOf(failureCount));
        return resultMap;
    }

    private static boolean isDisableUrgentMoileDecision() {
        try {
            String mode = ParamManager.getParamValue(null, null, (String)"DisableUrgentMobileApprove");
            return Boolean.valueOf(mode);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return false;
        }
    }

    public static String createDefaultUrgentMobileContent(String assignId, String content, Context ctx) {
        StringBuffer result = new StringBuffer();
        IAssign assign = null;
        AssignInfo assignInfo = null;
        boolean isAudit = false;
        try {
            assign = AssignFactory.getLocalInstance((Context)ctx);
            assignInfo = assign.getValue((IObjectPK)new ObjectUuidPK(assignId));
            isAudit = ProcessCenterUtil.assignIsMultiApprove(assignId, ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)("get assignInfo throw EASBizException:" + e.getMessage()), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)content)) {
            result.append(ResourceBase.getString((String)RESOURCE, (String)"urgency", (Locale)locale)).append(assignInfo.getSubject(locale));
        } else {
            result.append(content);
        }
        if (isAudit) {
            String decision = "";
            if (!StringUtils.isEmpty((String)assignId)) {
                try {
                    EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
                    decision = service.getMultiApproveDecision(assignId);
                }
                catch (WfException e) {
                    logger.error((Object)"getMultiApproveDecision throws WfException!", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)("get IEnactmentService interface throw BOSException:" + e.getMessage()), (Throwable)e);
                }
            }
            if (!ProcessCenterUtil.isDisableUrgentMoileDecision()) {
                if (!StringUtils.isEmpty((String)decision)) {
                    String tips = AppMsgUtil.constructMessage((String)decision);
                    result.append(ResourceBase.getString((String)RESOURCE, (String)"replyApprove1", (Locale)locale)).append(tips);
                } else {
                    result.append(ResourceBase.getString((String)RESOURCE, (String)"replyApprove2", (Locale)locale));
                }
            }
        }
        return result.toString();
    }

    public static List<String> createDefaultUrgentMobileContent(List<String> assignIds, String content, Context ctx) {
        ArrayList<String> list = new ArrayList<String>();
        IAssign assign = null;
        EnactmentServiceProxy service = null;
        AssignInfo assignInfo = null;
        boolean isAudit = false;
        try {
            assign = AssignFactory.getLocalInstance((Context)ctx);
            service = new EnactmentServiceProxy(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (int i = 0; i < assignIds.size(); ++i) {
            StringBuffer result = new StringBuffer();
            String assignId = assignIds.get(i).toString();
            try {
                assignInfo = assign.getValue((IObjectPK)new ObjectUuidPK(assignId));
                isAudit = ProcessCenterUtil.assignIsMultiApprove(assignId, ctx);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (StringUtils.isEmpty((String)content)) {
                result.append(ResourceBase.getString((String)RESOURCE, (String)"urgency", (Locale)locale)).append(assignInfo.getSubject(locale));
            } else {
                result.append(content);
            }
            if (isAudit) {
                String decision = "";
                if (!StringUtils.isEmpty((String)assignId)) {
                    try {
                        decision = service.getMultiApproveDecision(assignId);
                    }
                    catch (WfException e) {
                        logger.error((Object)"getMultiApproveDecision throws WfException!", (Throwable)e);
                    }
                }
                if (!ProcessCenterUtil.isDisableUrgentMoileDecision()) {
                    if (!StringUtils.isEmpty((String)decision)) {
                        String tips = AppMsgUtil.constructMessage((String)decision);
                        result.append(ResourceBase.getString((String)RESOURCE, (String)"replyApprove1", (Locale)locale)).append(tips);
                    } else {
                        result.append(ResourceBase.getString((String)RESOURCE, (String)"replyApprove2", (Locale)locale));
                    }
                }
            }
            list.add(result.toString());
        }
        return list;
    }

    public static boolean assignIsMultiApprove(String assignId, Context ctx) throws BOSException, EASBizException {
        boolean success = false;
        IEnactmentService wFService = EnactmentServiceFactory.createEnactService((Context)ctx);
        logger.debug((Object)"\u5de5\u4f5c\u6d41\u6a21\u5757\u542f\u52a8");
        AssignmentInfo info = wFService.getAssignmentById(assignId);
        String packageName = info.getBizPackage();
        String funcName = info.getBizFunction();
        String operationName = info.getBizOperation();
        if (packageName != null && packageName.trim().length() > 0 && funcName != null && funcName.trim().length() > 0 && operationName != null && operationName.trim().length() > 0 && packageName.trim().equals("com.kingdee.eas.base.multiapprove.client") && funcName.trim().equals("MultiApproveUIFunction") && operationName.trim().equals("ActionSubmit")) {
            success = true;
        }
        return success;
    }

    public static Map checkMobileSendLimit(String content, Context ctx) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("sendSuccess", "false");
        returnMap.put("log", "");
        boolean noLimit = true;
        String msg = "";
        boolean isLimitSendCount = true;
        Locale locale = ProcessCenterUtil.getLocale(ctx);
        try {
            ObjectUuidPK pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            String paramValue = ParamManager.getParamValue(null, (IObjectPK)pk, (String)"MobileSendLimit");
            isLimitSendCount = Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u77ed\u4fe1\u6570\u91cf\u9650\u5236\u53c2\u6570(MobileSendLimit)\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            msg = ResourceBase.getString((String)RESOURCE, (String)"checkMobileSendLimit2", (Locale)locale);
            returnMap.put("log", msg);
            return returnMap;
        }
        if (isLimitSendCount) {
            int sendCount = (content.length() - 1) / 70 + 1;
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            IMobileMessageAssign iMobile = null;
            try {
                iMobile = MobileMessageAssignFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                msg = ResourceBase.getString((String)RESOURCE, (String)"checkMobileSendLimit1", (Locale)locale);
                returnMap.put("log", msg);
                return returnMap;
            }
            String orgID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            int sendedCount = 0;
            int cansendTotal = 0;
            try {
                sendedCount = iMobile.getSendedCountByUserId(userId, orgID);
                cansendTotal = iMobile.canSendCount(userId, orgID);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                msg = ResourceBase.getString((String)RESOURCE, (String)"checkMobileSendLimit1", (Locale)locale);
                returnMap.put("log", msg);
                return returnMap;
            }
            int remainingCount = cansendTotal - sendedCount > 0 ? cansendTotal - sendedCount : 0;
            msg = MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)"checkMobileSendLimit3", (Locale)locale), sendCount, remainingCount);
            if (sendCount + sendedCount > cansendTotal) {
                msg = msg + "," + ResourceBase.getString((String)RESOURCE, (String)"checkMobileSendLimit4", (Locale)locale);
                logger.info((Object)msg);
                noLimit = false;
            } else {
                logger.info((Object)msg);
                noLimit = true;
            }
        } else {
            noLimit = true;
        }
        returnMap.put("sendSuccess", String.valueOf(noLimit));
        returnMap.put("log", msg);
        return returnMap;
    }

    public static String[] createDefaultUrgentMailParam(String assignId, String title, String content, Context ctx) {
        StringBuffer mailContent = new StringBuffer();
        IAssign assign = null;
        AssignInfo assignInfo = null;
        boolean isAudit = false;
        boolean isRevertible = false;
        String receiver = "";
        try {
            assign = AssignFactory.getLocalInstance((Context)ctx);
            assignInfo = assign.getValue((IObjectPK)new ObjectUuidPK(assignId));
            isAudit = ProcessCenterUtil.assignIsMultiApprove(assignId, ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)("get assignInfo throw EASBizException:" + e.getMessage()), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)content)) {
            mailContent.append(ResourceBase.getString((String)RESOURCE, (String)"urgency", (Locale)locale)).append(assignInfo.getBody(locale));
        } else {
            mailContent.append(content);
        }
        if (StringUtils.isEmpty((String)title)) {
            title = ResourceBase.getString((String)RESOURCE, (String)"urgency", (Locale)locale) + assignInfo.getSubject(locale);
        }
        if (isAudit) {
            String postfix = ProcessCenterUtil.getLinkContentForApproval();
            if (StringUtils.isEmpty((String)postfix)) {
                isRevertible = false;
            } else {
                isRevertible = true;
                mailContent.append(postfix);
            }
        }
        receiver = assignInfo.getPersonEmpID().toString();
        int priority = 10;
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            ActivityInstInfo actinstInfo = svc.getActivityInstByActInstId(assignInfo.getActInstID().toString());
            WfEngine engine = WfEngine.getEngine((Context)ctx);
            WfActivity activity = new WfActivity(engine, actinstInfo);
            content = ProcessCenterUtil.parseEmailApproveMsgForUrgent(activity.container().getProcessContext(), assignInfo, content);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("\u50ac\u529e\u6d88\u606f\u5185\u5bb9\u8f6c\u6362\u51fa\u9519" + e.getMessage()), (Throwable)e);
        }
        String[] returnValue = new String[]{title, String.valueOf(priority), String.valueOf(isRevertible), content.toString(), receiver, assignId};
        return returnValue;
    }

    public static List<String[]> createDefaultUrgentMailParam(List<String> assignIds, String title, String content, Context ctx) {
        StringBuffer result = new StringBuffer();
        ArrayList<String[]> list = new ArrayList<String[]>();
        IAssign iAssign = null;
        AssignInfo assignInfo = null;
        boolean isAudit = false;
        boolean isRevertible = false;
        String receiver = "";
        try {
            iAssign = AssignFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (int i = 0; i < assignIds.size(); ++i) {
            try {
                isAudit = ProcessCenterUtil.assignIsMultiApprove(assignIds.get(i), ctx);
                assignInfo = iAssign.getValue((IObjectPK)new ObjectUuidPK(assignIds.get(i)));
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (StringUtils.isEmpty((String)content)) {
                result.append(ResourceBase.getString((String)RESOURCE, (String)"urgency", (Locale)locale)).append(assignInfo.getBody(locale));
            } else {
                result.append(content);
            }
            if (StringUtils.isEmpty((String)title)) {
                title = ResourceBase.getString((String)RESOURCE, (String)"urgency", (Locale)locale) + assignInfo.getSubject(locale);
            }
            if (isAudit) {
                String postfix = "";
                postfix = ProcessCenterUtil.getLinkContentForApproval();
                result.append(postfix);
            }
            receiver = assignInfo.getPersonEmpID().toString();
            int priority = 10;
            try {
                IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
                ActivityInstInfo actInstInfo = svc.getActivityInstByActInstId(assignInfo.getActInstID().toString());
                WfEngine engine = WfEngine.getEngine((Context)ctx);
                WfActivity activity = new WfActivity(engine, actInstInfo);
                content = ProcessCenterUtil.parseEmailApproveMsgForUrgent(activity.container().getProcessContext(), assignInfo, content);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("\u50ac\u529e\u6d88\u606f\u5185\u5bb9\u8f6c\u6362\u51fa\u9519" + e.getMessage()), (Throwable)e);
            }
            String[] returnValue = new String[]{title, String.valueOf(priority), String.valueOf(isRevertible), content.toString(), receiver, assignIds.get(i)};
            list.add(returnValue);
        }
        return list;
    }

    private static String getLinkContentForApproval() {
        String isAppend;
        Configuration config = Configuration.getInstance();
        ConfigurationItem sln = config.getConfigItem("PortalInfo");
        StringBuffer postfix = new StringBuffer();
        if (!(sln == null || (isAppend = sln.getProperty("isAppendOtherNotice")) != null && isAppend.trim().equalsIgnoreCase("false"))) {
            postfix.append("<br>");
            String url = sln.getProperty("host");
            String port = sln.getProperty("port");
            String context = sln.getProperty("contextroot");
            String isAllowEMailAudit = sln.getProperty("isAllowEMailAudit");
            String rederectTo = sln.getProperty("rederectTo");
            if (isAllowEMailAudit != null && isAllowEMailAudit.trim().equalsIgnoreCase("true")) {
                postfix.append(ResourceBase.getString((String)RESOURCE, (String)"urgentMessageMobileFirst", (Locale)locale) + "<br>");
                postfix.append(ResourceBase.getString((String)RESOURCE, (String)"urgentMessageMobileLast", (Locale)locale));
            } else {
                postfix.append(ResourceBase.getString((String)RESOURCE, (String)"clicklinktoapprove", (Locale)locale));
            }
            if (url != null && port != null && url.trim().length() > 0 && port.trim().length() > 0 && context != null && context.trim().length() > 0 && rederectTo != null && rederectTo.trim().length() > 0) {
                String contentURI = "http://" + url + ":" + port + context + rederectTo;
                postfix.append("<a href = '" + contentURI + "'><br>" + contentURI + "</a>");
            }
        }
        return postfix.toString();
    }

    private static String parseEmailApproveMsgForUrgent(ProcessContext context, AssignInfo assignment, String raw) {
        int i;
        if (!raw.contains("{#") || !raw.contains("#}")) {
            return raw;
        }
        String prefix = (String)context.getDataFieldValue("EMAIL_APPROVE_URL_PREFIX");
        if (StringUtils.isEmpty((String)prefix)) {
            return raw;
        }
        String transToApprove = "/easweb/webviews/workflow/transferApprove.jsp?AssignmentId=" + assignment.getAssignID().toString();
        String url = prefix + transToApprove;
        int j = 0;
        StringBuilder sb = new StringBuilder();
        while ((i = raw.indexOf("{#")) > -1 && (j = raw.indexOf("#}")) > -1) {
            sb.append(raw.substring(0, i));
            sb.append("<a href='");
            sb.append(url);
            sb.append("'>" + url);
            sb.append("</a>");
            raw = raw.substring(j + 2, raw.length());
        }
        sb.append(raw);
        return sb.toString();
    }

    public static boolean sendUrgentMail(String assignId, String title, String content, Context ctx) {
        boolean success = false;
        String[] param = new String[]{};
        param = ProcessCenterUtil.createDefaultUrgentMailParam(assignId, title, content, ctx);
        try {
            success = MsgUtil.msgSend((Context)ctx, (String)param[0], (int)Integer.valueOf(param[1]), (boolean)Boolean.valueOf(param[2]), (String)param[3], (String)param[4], (int)2, null, (String)param[5], (MimeTypeEnum)MimeTypeEnum.HTML);
        }
        catch (Exception e) {
            logger.error((Object)("sendUrgentMail send Mail error:" + e.getMessage()), (Throwable)e);
            return false;
        }
        return success;
    }

    public static Map sendUrgentMail(List<String> assignIdList, String title, String content, Context ctx) {
        String sendSuccess = ResourceBase.getString((String)RESOURCE, (String)"sendSuccess", (Locale)ctx.getLocale());
        String sendFailed = ResourceBase.getString((String)RESOURCE, (String)"sendFailed", (Locale)ctx.getLocale());
        HashMap<String, String> resultMap = new HashMap<String, String>();
        HashMap<String, String> failMap = new HashMap<String, String>();
        failMap.put(SUCCESS, "0");
        failMap.put(FAILURE, "0");
        failMap.put(LOG, sendFailed);
        int successCount = 0;
        int failureCount = 0;
        boolean success = false;
        StringBuffer returnLog = new StringBuffer();
        List<Object> list = new ArrayList();
        list = ProcessCenterUtil.createDefaultUrgentMailParam(assignIdList, title, content, ctx);
        for (int i = 0; i < list.size(); ++i) {
            String[] param = (String[])list.get(i);
            try {
                success = MsgUtil.msgSend((Context)ctx, (String)param[0], (int)Integer.valueOf(param[1]), (boolean)Boolean.valueOf(param[2]), (String)param[3], (String)param[4], (int)2, null, (String)param[5], (MimeTypeEnum)MimeTypeEnum.HTML);
                if (success) {
                    ++successCount;
                    continue;
                }
                ++failureCount;
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("sendUrgentMail send Mail <" + (i + 1) + "> error:" + e.getMessage()), (Throwable)e);
                ++failureCount;
            }
        }
        returnLog.append(sendSuccess).append(":").append(successCount).append(",").append(sendFailed).append(":").append(failureCount);
        logger.info((Object)("\u6279\u91cf\u53d1\u9001\u50ac\u529e\u90ae\u4ef6:" + returnLog));
        if (successCount == 0) {
            return failMap;
        }
        if (failureCount == 0) {
            resultMap.put(LOG, sendSuccess);
        } else {
            resultMap.put(LOG, returnLog.toString());
        }
        resultMap.put(SUCCESS, String.valueOf(successCount));
        resultMap.put(FAILURE, String.valueOf(failureCount));
        return resultMap;
    }

    public static Map sendInstantMsg(String personIds, String priorty, String title, String content, String msgBosID, Context ctx) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        HashMap<String, String> failMap = new HashMap<String, String>();
        locale = ProcessCenterUtil.getLocale(ctx);
        failMap.put(FAILURE, "");
        failMap.put(SUCCESS, "0");
        failMap.put(LOG, ResourceBase.getString((String)RESOURCE, (String)"sendFailedLog1", (Locale)locale));
        try {
            personIds = URLDecoder.decode(personIds, "UTF-8");
            priorty = URLDecoder.decode(priorty, "UTF-8");
            title = URLDecoder.decode(title, "UTF-8");
            content = URLDecoder.decode(content, "UTF-8");
            msgBosID = URLDecoder.decode(msgBosID, "UTF-8");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return failMap;
        }
        BMCMessageInfo msgInfo = new BMCMessageInfo();
        msgInfo.setId(BOSUuid.read((String)msgBosID));
        int pritotyValue = Integer.parseInt(priorty);
        msgInfo.setPriority(MsgPriority.getEnum(pritotyValue));
        if (!StringUtils.isEmpty((String)title)) {
            title = title.trim();
        }
        msgInfo.setTitle(title, EN);
        msgInfo.setTitle(title, ZH_CN);
        msgInfo.setTitle(title, ZH_HK);
        if (!StringUtils.isEmpty((String)content)) {
            content = content.trim();
        }
        msgInfo.setBody(content, EN);
        msgInfo.setBody(content, ZH_CN);
        msgInfo.setBody(content, ZH_HK);
        msgInfo.setType(MsgType.ONLINE);
        msgInfo.setStatus(MsgStatus.UNREADED);
        IUser iUser = null;
        IBMCMessage iBMCMessage = null;
        UserInfo userInfo = null;
        String receiverNames = "";
        BasReceiverCollection receivers = new BasReceiverCollection();
        int validCount = 0;
        int invalidCount = 0;
        StringBuffer validName = new StringBuffer();
        StringBuffer invalidName = new StringBuffer();
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            String[] persons = personIds.split(";");
            for (int i = 0; i < persons.length; ++i) {
                Person[] person;
                for (Person temp : person = svc.getPersonByPersonID(persons[i])) {
                    ClassificationStatCacheManager manager = ClassificationStatCacheManager.get((Context)ctx);
                    manager.expire(temp.getUserId());
                }
            }
            iUser = UserFactory.getLocalInstance((Context)ctx);
            iBMCMessage = BMCMessageFactory.getLocalInstance(ctx);
            userInfo = iUser.getUserInfo(ctx.getCaller());
            Map activeReceiverMap = ProcessCenterUtil.getUserByPerson(ctx, personIds);
            Iterator activeReceiverId = null;
            if (!activeReceiverMap.isEmpty()) {
                activeReceiverId = activeReceiverMap.keySet().iterator();
            } else {
                try {
                    UserInfo receiverUser = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)personIds)));
                    UserCollection userColl = new UserCollection();
                    userColl.add(receiverUser);
                    activeReceiverMap.put(personIds, userColl);
                    activeReceiverId = activeReceiverMap.keySet().iterator();
                }
                catch (Exception ex) {
                    failMap.put(LOG, ResourceBase.getString((String)RESOURCE, (String)"sendFailedLog2", (Locale)locale));
                    return failMap;
                }
            }
            Map receiverMap = ProcessCenterUtil.getReceiverMap(ctx, personIds);
            while (activeReceiverId.hasNext()) {
                String receiverId = activeReceiverId.next().toString();
                if (receiverMap.containsKey(receiverId)) {
                    ++validCount;
                    validName.append(receiverMap.get(receiverId)).append(",");
                    continue;
                }
                ++invalidCount;
                invalidName.append(receiverMap.get(receiverId)).append(",");
            }
            receiverNames = validName.substring(0, validName.length() - 1);
            receivers = ProcessCenterUtil.getBasReceiverCollection(activeReceiverMap);
            msgInfo.setSender(userInfo.getName());
            msgInfo.setNreceivers(receiverNames);
            iBMCMessage.addHandMsg(msgInfo, (IObjectCollection)receivers);
            resultMap.put(FAILURE, invalidCount + "");
            resultMap.put(SUCCESS, validCount + "");
            StringBuffer sf = new StringBuffer();
            if (invalidCount == 0) {
                sf.append(ResourceBase.getString((String)RESOURCE, (String)"sendSuccess", (Locale)locale));
            } else {
                sf.append(ResourceBase.getString((String)RESOURCE, (String)"sendSuccess", (Locale)locale)).append(":").append(validCount).append(ResourceBase.getString((String)RESOURCE, (String)"person", (Locale)locale)).append(",").append(ResourceBase.getString((String)RESOURCE, (String)"sendFailed", (Locale)locale)).append(":").append(invalidCount).append(ResourceBase.getString((String)RESOURCE, (String)"person", (Locale)locale)).append("(").append(invalidName).append(")");
            }
            resultMap.put(LOG, sf.toString());
            return resultMap;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return failMap;
        }
    }

    public static Map getReceiverMap(Context ctx, String receiver) throws EASBizException, BOSException, UuidException {
        HashMap<String, String> receiverMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)receiver)) {
            String[] args = receiver.split(";");
            int length = args.length;
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < length; ++i) {
                String name = "";
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)args[i]));
                try {
                    PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)pk);
                    name = personInfo.getName();
                    receiverMap.put(args[i], name);
                    continue;
                }
                catch (Exception e) {
                    logger.debug((Object)("receiverId is probably a userId:" + e.getMessage()), (Throwable)e);
                    try {
                        UserInfo userInfo = iUser.getUserInfo((IObjectPK)pk);
                        name = userInfo.getName();
                        receiverMap.put(args[i], name);
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        }
        return receiverMap;
    }

    public static BasReceiverCollection getBasReceiverCollection(Map receiverMap) throws EASBizException, BOSException, UuidException {
        ReceiverMessageUtils mu = new ReceiverMessageUtils();
        BasReceiverCollection receivers = new BasReceiverCollection();
        Object[] userCol = receiverMap.values().toArray();
        int length = userCol.length;
        for (int i = 0; i < length; ++i) {
            BasReceiverInfo info = null;
            UserCollection userInfoCol = (UserCollection)userCol[i];
            for (int j = 0; j < userInfoCol.size(); ++j) {
                UserInfo userInfo = userInfoCol.get(j);
                info = mu.getRptReceiverInfo((Object)userInfo);
                receivers.add(info);
            }
        }
        return receivers;
    }

    public static Map getUserByPerson(Context ctx, String personIds) throws BOSException {
        if (StringUtils.isEmpty((String)personIds)) {
            return null;
        }
        HashMap<String, UserCollection> receiver = new HashMap<String, UserCollection>();
        String[] personIdArray = personIds.split(";");
        IUser user = UserFactory.getLocalInstance((Context)ctx);
        int length = personIdArray.length;
        for (int i = 0; i < length; ++i) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person", (Object)personIdArray[i]));
            filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0));
            filter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)0));
            Date date = new Date();
            filter.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)date, CompareType.LESS));
            filter.getFilterItems().add(new FilterItemInfo("invalidationDate", (Object)date, CompareType.GREATER));
            entityViewInfo.setFilter(filter);
            SelectorItemCollection selector = entityViewInfo.getSelector();
            selector.add(new SelectorItemInfo("*"));
            UserCollection collection = user.getUserCollection(entityViewInfo);
            if (collection == null || collection.isEmpty()) continue;
            receiver.put(personIdArray[i], collection);
        }
        return receiver;
    }

    public static String getAssignStateByMsgId(String msgId, Context ctx) {
        String assignId = "";
        MsgSourceStatus msgState = null;
        WfAssignmentState assignState = null;
        BMCMessageInfo info = null;
        IBMCMessage iBmc = null;
        try {
            iBmc = BMCMessageFactory.getLocalInstance(ctx);
            info = iBmc.getBMCMessageInfo("where id = '" + msgId + "'");
        }
        catch (Exception e) {
            logger.error((Object)("\u53d6\u975e\u5386\u53f2\u6d88\u606fINFO\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            return "";
        }
        msgState = info.getSourceStatus();
        int msgStateVal = msgState.getValue();
        assignId = info.getSourceID();
        IEnactmentService iService = null;
        try {
            iService = EnactmentServiceFactory.createEnactService((Context)ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("\u53d6IEnactmentService\u63a5\u53e3\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            return "";
        }
        AssignmentInfo assignInfo = null;
        try {
            assignInfo = iService.getAssignmentById(assignId);
        }
        catch (WfException e) {
            logger.error((Object)("IEnactmentService.getAssignmentById\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            return "";
        }
        assignState = assignInfo.getState();
        int assignStateVal = assignState.getValue();
        if (assignStateVal != msgStateVal) {
            if (assignState.equals((Object)WfAssignmentState.ACCEPTED)) {
                info.setSourceStatus(MsgSourceStatus.ACCEPTED);
            } else if (assignState.equals((Object)WfAssignmentState.ASSIGNED)) {
                info.setSourceStatus(MsgSourceStatus.ASSIGNED);
            } else if (assignState.equals((Object)WfAssignmentState.CANCELED)) {
                info.setSourceStatus(MsgSourceStatus.CANCELED);
            } else if (assignState.equals((Object)WfAssignmentState.COMPLETED)) {
                info.setSourceStatus(MsgSourceStatus.COMPLETED);
            } else if (assignState.equals((Object)WfAssignmentState.REJECTED)) {
                info.setSourceStatus(MsgSourceStatus.REJECTED);
            } else {
                info.setSourceStatus(MsgSourceStatus.EMPTY);
            }
            try {
                iBmc.update((IObjectPK)new ObjectStringPK(msgId), info);
            }
            catch (Exception e) {
                logger.error((Object)("\u66f4\u65b0\u6d88\u606f\u7684\u4efb\u52a1\u72b6\u6001\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            }
            msgState = info.getSourceStatus();
        }
        return msgState.getName();
    }

    private static void appendParam(StringBuffer buffer, String key, String value, boolean encode) throws Exception {
        if (value == null) {
            return;
        }
        if (encode) {
            value = URLEncoder.encode(value, "utf-8");
        }
        buffer.append(buffer.indexOf("?") < 0 ? "?" : "&");
        buffer.append(key + "=" + value);
    }

    public static String getAssignIdByMsgId(String msgId, Context ctx) {
        String assignId = "";
        Object msgState = null;
        Object assignState = null;
        BMCMessageInfo info = null;
        IBMCMessage iBmc = null;
        try {
            iBmc = BMCMessageFactory.getLocalInstance(ctx);
            info = iBmc.getBMCMessageInfo("where id = '" + msgId + "'");
        }
        catch (Exception e) {
            logger.error((Object)("\u53d6\u975e\u5386\u53f2\u6d88\u606fINFO\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            return "";
        }
        assignId = info.getSourceID();
        return assignId;
    }

    public static int getMsgContentLengthLimit(Context ctx) {
        int contentLengthLimit = 500;
        try {
            IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
            String value = iParam.getParamValue(null, "MsgContentLengthLimit");
            contentLengthLimit = Integer.parseInt(value);
        }
        catch (Exception e1) {
            System.out.println("\u53d1\u9001\u5373\u65f6\u6d88\u606f\u53d6\u5f97\u6d88\u606f\u5185\u5bb9\u5b57\u7b26\u6570\u9650\u5236\u53c2\u6570MsgContentLengthLimit\u9519\u8bef\uff1a" + e1.getMessage());
        }
        return contentLengthLimit;
    }

    public static List<AttachmentInfo> getAttachInfoByBoID(Context ctx, String boID) {
        ArrayList<AttachmentInfo> attachInfos = new ArrayList<AttachmentInfo>();
        String[] attachIDs = null;
        IBoAttchAsso iBoAttach = null;
        IAttachment iAttach = null;
        try {
            iBoAttach = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            iAttach = AttachmentFactory.getLocalInstance((Context)ctx);
            attachIDs = iBoAttach.getAttchIDsByBoID(boID);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        for (int i = 0; i < attachIDs.length; ++i) {
            AttachmentInfo attachInfo = null;
            try {
                attachInfo = iAttach.getAttachmentInfo("where id='" + attachIDs[i] + "'");
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (attachInfo == null) continue;
            attachInfos.add(attachInfo);
        }
        return attachInfos;
    }

    public static int getLength(String str) {
        int totallength = 0;
        for (int i = 0; i < str.length(); ++i) {
            char intCode = str.charAt(i);
            if (intCode >= '\u0000' && intCode <= '\u0080') {
                ++totallength;
                continue;
            }
            totallength += 2;
        }
        return totallength;
    }

    public static String getSubString(String str, int start, int length, String ellipsis) {
        String _ellipsis = StringUtils.isEmpty((String)ellipsis) ? "..." : ellipsis;
        String subStr = "";
        int strLength = str.length();
        int realLength = 0;
        int cutLength = 0;
        for (int i = 0; i < strLength; ++i) {
            char intCode = str.charAt(i);
            realLength = intCode >= '\u0000' && intCode <= '\u0080' ? ++realLength : (realLength += 2);
            if (cutLength != 0 || realLength < length) continue;
            cutLength = i + 1;
        }
        subStr = realLength <= length ? str : str.substring(start, cutLength) + _ellipsis;
        return subStr;
    }

    public static Map<String, Integer> getUnreadMsgCount(Context ctx) {
        ClassificationStatCacheManager cache = ClassificationStatCacheManager.get((Context)ctx);
        return cache.getStat(ctx.getCaller().toString());
    }

    public static String getCurrentUserAssignIdByProcInstId(Context ctx, String procinstId) {
        String assignId = "";
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fassignid from t_wfr_assign a where a.fprocinstid = ? and a.fpersonuserid = ? ");
        sql.append(" union");
        sql.append(" select a.fassignid from t_wfr_assigndetail a where a.fprocinstid = ? and a.fpersonuserid = ? ");
        Object[] param = null;
        param = new String[]{procinstId, ctx.getCaller().toString(), procinstId, ctx.getCaller().toString()};
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (row != null) {
                while (row.next() && StringUtils.isEmpty((String)(assignId = row.getString("fassignid")))) {
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519", (Throwable)e);
        }
        return assignId;
    }

    public static Map<String, String> getExpectedApproveTime(Context ctx, List<String> procinstIds, Map<String, String> relations) throws BOSException {
        BigDecimal avgTimeTemp;
        String procinstId;
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (procinstIds == null || procinstIds.size() == 0) {
            return ret;
        }
        StringBuilder ids = new StringBuilder();
        for (int i = 0; i < procinstIds.size(); ++i) {
            String id = procinstIds.get(i);
            if (i > 0) {
                ids.append(", ");
            }
            ids.append("'").append(id).append("'");
        }
        if (relations == null) {
            String sqlProcinids = "select fprocinstid AS procinstId,FPARENTPROCINSTID as parentProcinstId from t_wfr_procinst where FPARENTPROCINSTID in(" + ids + ")";
            relations = new HashMap<String, String>();
            ArrayList subProcinstList = SQL.executeQuery((Context)ctx, (String)sqlProcinids);
            for (int i = 0; i < subProcinstList.size(); ++i) {
                Map item = (Map)subProcinstList.get(i);
                String subProcinstId = (String)item.get("procinstid");
                procinstId = (String)item.get("parentprocinstid");
                relations.put(subProcinstId, procinstId);
                ids.append(",'").append(subProcinstId).append("'");
            }
        } else {
            for (Map.Entry<String, String> entry : relations.entrySet()) {
                String subProcinstId = entry.getKey();
                ids.append(",'").append(subProcinstId).append("'");
            }
        }
        String sql = " select a.fprocinstid AS procinstId,avg(s.FEXECUTETIME) AS avgTime from t_wfr_assign a left join T_WFR_SAActInst s on a.FACTDEFID =s.FACTDEFID  where a.fprocinstid in(" + ids + ") group by a.FPROCINSTID  ";
        ArrayList temp = SQL.executeQuery((Context)ctx, (String)sql);
        HashMap avgTimeMap = new HashMap();
        for (int i = 0; i < temp.size(); ++i) {
            Object avgTime;
            ArrayList<BigDecimal> avgTimeList;
            Map item = (Map)temp.get(i);
            procinstId = (String)item.get("procinstid");
            String parentProcinstId = relations.get(procinstId);
            if (parentProcinstId == null) {
                parentProcinstId = procinstId;
            }
            if ((avgTimeList = (ArrayList<BigDecimal>)avgTimeMap.get(parentProcinstId)) == null) {
                avgTimeList = new ArrayList<BigDecimal>();
                avgTimeMap.put(parentProcinstId, avgTimeList);
            }
            if ((avgTime = item.get("avgtime")) == null || !(avgTime instanceof BigDecimal)) continue;
            avgTimeTemp = (BigDecimal)avgTime;
            avgTimeList.add(avgTimeTemp);
        }
        String allAvgHour = null;
        for (int i = 0; i < procinstIds.size(); ++i) {
            procinstId = procinstIds.get(i);
            List avgTimeList = (List)avgTimeMap.get(procinstId);
            if (avgTimeList == null || avgTimeList.size() == 0) {
                if (allAvgHour == null) {
                    ArrayList temp2 = SQL.executeQuery((Context)ctx, (String)"select avg(FEXECUTETIME) AS avgTime from  T_WFR_SAActInst");
                    if (temp2.size() > 0) {
                        Object avgTime = ((Map)temp2.get(0)).get("avgtime");
                        if (avgTime != null && avgTime instanceof BigDecimal) {
                            avgTimeTemp = (BigDecimal)avgTime;
                            allAvgHour = String.format("%.2f", avgTimeTemp.doubleValue() / 60.0);
                        } else {
                            allAvgHour = "";
                        }
                    } else {
                        allAvgHour = "";
                    }
                }
                ret.put(procinstId, allAvgHour);
                continue;
            }
            BigDecimal total = new BigDecimal("0");
            for (BigDecimal item : avgTimeList) {
                total = total.add(item);
            }
            double hour = total.doubleValue() / (double)(60 * avgTimeList.size());
            ret.put(procinstId, String.format("%.2f", hour));
        }
        return ret;
    }

    public static Map<String, String> getExpectedApproveTime(Context ctx, List<String> procinstIds) throws BOSException {
        return ProcessCenterUtil.getExpectedApproveTime(ctx, procinstIds, null);
    }
}

