/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.eas.base.message.util.sendmsg.pa.MessageModelEnum;
import com.kingdee.eas.base.message.util.sendmsg.pa.MessageTypeEnum;
import com.kingdee.eas.base.message.util.sendmsg.pa.api.IMessageAdapter;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WFNoticeAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFNoticeAdapter.class);
    private Message message = null;
    private Context ctx = null;

    @Override
    public boolean isNeedSendXT() {
        return true;
    }

    public WFNoticeAdapter(Message message) {
        logger.debug((Object)"WfNoticeAdapter init");
        this.message = message;
        this.ctx = WFNoticeAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
    }

    @Override
    public MessageTypeEnum getType() {
        return MessageTypeEnum.TEXT;
    }

    @Override
    public MessageModelEnum getModel() {
        return null;
    }

    @Override
    public Map<String, Object> getContent() {
        HashMap<String, Object> contents = new HashMap<String, Object>();
        String content = this.parseContent();
        contents.put("text", content);
        return contents;
    }

    private String parseContent() {
        String msgContent = null;
        msgContent = this.message.getLocaleStringHeader("body", new Locale("L2"));
        if (msgContent == null || msgContent.equals("")) {
            msgContent = this.message.getLocaleStringHeader("title", new Locale("L2"));
        }
        logger.debug((Object)("body=" + this.message.getLocaleStringHeader("body", new Locale("L2")) + ",title=" + this.message.getLocaleStringHeader("title", new Locale("L2"))));
        return msgContent;
    }

    @Override
    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IUser user = UserFactory.getLocalInstance((Context)this.ctx);
            String msgReceiver = this.message.getStringHeader("receiver");
            logger.info((Object)("XT Notices getUsers() msgReceiver: " + msgReceiver));
            UserInfo userInfo = (UserInfo)user.getValue((IObjectPK)new ObjectStringPK(msgReceiver));
            if (userInfo != null && userInfo.getPerson() != null) {
                list.add(userInfo.getPerson().getId().toString());
                logger.info((Object)("XT Notices getUsers() personID:" + userInfo.getPerson().getId().toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Notices getUsers() get personID error!", (Throwable)e);
        }
        return list;
    }

    @Override
    public Date getUpdateTime() {
        return new Date();
    }

    @Override
    public void clearTemporary() {
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    public static void main(String[] args) {
        Message newMessage = MessageFactory.newMessage();
        Locale locale = new Locale("L2");
        newMessage.setLocaleStringHeader("title", "aaa", locale);
        newMessage.setLocaleStringHeader("body", "bbb", locale);
        newMessage.setLocaleStringHeader("sender", "ccc", locale);
    }
}

