/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg.hrcloud;

import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class KDCloudServiceConfig {
    private static Logger logger = Logger.getLogger(KDCloudServiceConfig.class);
    private static final String CONFIGFILE = "eas_server_config.properties";
    protected static KDCloudServiceConfig instance = new KDCloudServiceConfig();
    private static XMLConfiguration configuration;
    private static Properties properties;
    private static Object lock;

    protected KDCloudServiceConfig() {
        try {
            this.load();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    public static KDCloudServiceConfig getInstance() {
        return instance;
    }

    public Properties getProperties() {
        return properties;
    }

    public String getPropertiesItem(String configKey) {
        return properties == null ? null : properties.getProperty(configKey);
    }

    private void load() {
        String propertiesPath = System.getProperty("eas.properties.dir");
        String fileName = propertiesPath + File.separator + "mobile" + File.separator + CONFIGFILE;
        File propertyFile = new File(fileName);
        if (propertyFile.exists()) {
            properties = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(fileName);
                properties.load(is);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        throw new RuntimeException("cann't find the config file!");
    }

    static {
        lock = new Object();
    }
}

