/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg.pa;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.message.util.JSONUtil;
import com.kingdee.eas.base.message.util.sendmsg.hrcloud.KDCloudServiceConfig;
import com.kingdee.eas.base.message.util.sendmsg.pa.api.AbstractMessage;
import com.kingdee.eas.base.message.util.sendmsg.pa.api.IMessageAdapter;
import com.kingdee.eas.base.message.util.sendmsg.pa.common.CommonMessage;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;

public class PushHRCloudMsgController {
    private static Logger logger = Logger.getLogger((String)PushHRCloudMsgController.class.getName());
    private static String refrenceInfo = new String();
    private static String token = "";

    private PushHRCloudMsgController() {
    }

    public static boolean push(Context ctx, List<IMessageAdapter> adapterList, String code, boolean toAllUser) {
        boolean bReturn = false;
        logger.info((Object)"PubAcctController==== push begin");
        if (adapterList == null) {
            return bReturn;
        }
        if (adapterList.size() > 0) {
            logger.info((Object)("has found " + adapterList.size() + " message" + new String(adapterList.size() > 1 ? "s" : "") + " submit to push"));
            try {
                if (StringUtils.isEmpty((String)token)) {
                    PushHRCloudMsgController.loginHRCloud();
                }
                String eid = KDCloudServiceConfig.getInstance().getPropertiesItem("cust3gNo");
                for (IMessageAdapter ia : adapterList) {
                    CommonMessage message = new CommonMessage(ctx, eid, ia, code, toAllUser);
                    if (message == null || message.getContent() == null) continue;
                    refrenceInfo = PushHRCloudMsgController.pushMsg(message);
                    if (refrenceInfo != null && refrenceInfo.contains("error") && refrenceInfo.contains("\"success\":false")) {
                        PushHRCloudMsgController.loginHRCloud();
                        refrenceInfo = PushHRCloudMsgController.pushMsg(message);
                    }
                    logger.info((Object)"PubAcctController === push succeed");
                    refrenceInfo = refrenceInfo + "\n" + message.toString(4);
                }
            }
            catch (Exception e) {
                refrenceInfo = "push failed:" + e.getMessage();
                logger.info((Object)("push failed:" + e.getMessage()));
            }
        } else {
            refrenceInfo = "has not found message submit to push";
        }
        logger.info((Object)("PubAcctController==== push refrenceInfo====" + refrenceInfo));
        logger.info((Object)"PubAcctController==== push end");
        return bReturn;
    }

    public static boolean push(Context ctx, IMessageAdapter adapter, String code, boolean toAllUser) {
        ArrayList<IMessageAdapter> list = new ArrayList<IMessageAdapter>();
        list.add(adapter);
        return PushHRCloudMsgController.push(ctx, list, code, toAllUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loginHRCloud() {
        HttpClient http = new HttpClient();
        http.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        http.getHttpConnectionManager().getParams().setSoTimeout(5000);
        GetMethod get = null;
        String url = KDCloudServiceConfig.getInstance().getPropertiesItem("hrCloudUrl");
        String eid = KDCloudServiceConfig.getInstance().getPropertiesItem("cust3gNo");
        String cloudKey = KDCloudServiceConfig.getInstance().getPropertiesItem("cloudKey");
        Date timestamp = new Date();
        String timeStr = "" + timestamp.getTime();
        Object[] data = new String[]{eid, timeStr, cloudKey};
        Arrays.sort(data);
        String opentoken = DigestUtils.shaHex((String)org.apache.commons.lang3.StringUtils.join((Object[])data));
        String getUrl = url + "/open/login?eid=" + eid + "&timestamp=" + timeStr + "&opentoken=" + opentoken + "&authPattern=eid_credential";
        logger.error((Object)getUrl);
        get = new GetMethod(getUrl);
        try {
            http.executeMethod((HttpMethod)get);
            if (get.getStatusCode() == 200) {
                String respose = get.getResponseBodyAsString();
                Map repData = JSONUtil.getMap4Json(respose);
                token = ((Map)repData.get("data")).get("token").toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)"login hrcloud error");
            logger.error((Object)e.getMessage());
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pushMsg(AbstractMessage message) {
        boolean status = false;
        String response = null;
        HttpClient http = new HttpClient();
        http.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        http.getHttpConnectionManager().getParams().setSoTimeout(5000);
        PostMethod post = null;
        try {
            String url = KDCloudServiceConfig.getInstance().getPropertiesItem("hrCloudUrl");
            String postUrl = url + "/openapi/pushMessage";
            post = new PostMethod(postUrl);
            post.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
            post.addParameter("token", token);
            post.addRequestHeader("token", token);
            logger.error((Object)("message=" + message.toString()));
            post.addParameter("msgdatas", message.toString());
            logger.info((Object)("starting push message to XT, push address is :" + url));
            logger.info((Object)("starting push message to XT, push message.toString() is :" + message.toString()));
            http.executeMethod((HttpMethod)post);
            if (post.getStatusCode() == 200) {
                status = true;
            }
            response = new String(post.getResponseBodyAsString().getBytes("UTF-8"));
            post.releaseConnection();
        }
        catch (Throwable e) {
            logger.error((Object)"error message", e);
            status = false;
            response = "send exception:" + e.getMessage();
        }
        finally {
            post.releaseConnection();
        }
        return response;
    }

    public static String getRefrenceInfo() {
        return refrenceInfo;
    }
}

