/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg.pa.common;

import com.kingdee.eas.base.message.util.sendmsg.pa.api.IMessageSection;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommonMessageHead
implements IMessageSection {
    private static Logger logger = Logger.getLogger((String)CommonMessageHead.class.getName());
    private static String PUSH_ALL_USERS = "PUSH_ALL_USERS";
    private Map<String, Object> from = null;
    private Map<String, Object> to = null;
    private String eid = null;

    public CommonMessageHead(String eid) {
        this.eid = eid;
    }

    @Override
    public void makeContent(Map<String, Object> fields) throws NullPointerException {
        if (fields != null && fields.containsKey("signtime") && fields.containsKey("users")) {
            this.makeMessage("no", this.eid, true);
            String signtime = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(System.currentTimeMillis());
            this.makeMessage("time", signtime, true);
            int nonce = new SecureRandom().nextInt();
            this.makeMessage("nonce", nonce, true);
            this.makeMessage("no", this.eid, false);
            String code = (String)fields.get("code");
            if (code == null || code.trim().equals("")) {
                code = "0";
            }
            this.makeMessage("code", code, false);
            List users = (List)fields.get("users");
            if (users == null) {
                throw new NullPointerException("user list is null or empty");
            }
            if (users.size() != 1 || !((String)users.get(0)).equals(PUSH_ALL_USERS)) {
                this.makeMessage("user", fields.get("users"), false);
            }
        }
    }

    @Override
    public Map<String, Object> getContent() {
        ArrayList<Map<String, Object>> to = new ArrayList<Map<String, Object>>();
        to.add(this.to);
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("from", this.from);
        content.put("to", to);
        return content;
    }

    @Override
    public boolean hasReady() {
        if (this.from == null || this.to == null) {
            logger.debug((Object)"message head field has not ready");
            return false;
        }
        return true;
    }

    protected void makeMessage(String key, Object value, boolean isFromInfo) {
        if (isFromInfo) {
            if (this.from == null) {
                this.from = new HashMap<String, Object>();
            }
            this.from.put(key, value);
        } else {
            if (this.to == null) {
                this.to = new HashMap<String, Object>();
            }
            this.to.put(key, value);
        }
    }

    protected Object getMessage(String key, boolean isFrom) {
        Map<String, Object> target = isFrom ? this.from : this.to;
        if (target == null) {
            return "";
        }
        return target.get(key);
    }

    @Override
    public boolean isSupportMultiEntries() {
        return false;
    }
}

