/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg.util;

import com.kingdee.eas.base.message.util.sendmsg.util.StringUtil;
import com.kingdee.eas.base.message.util.sendmsg.util.stream.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;

public class FileUtil {
    private static final Logger log = Logger.getLogger(FileUtil.class);
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final char FILE_SEPARATOR_CHAR = FILE_SEPARATOR.charAt(0);
    private static final int BUFFER_SIZE = 32768;

    private FileUtil() {
    }

    public static final boolean isExist(String filePath) {
        File f = new File(filePath);
        return f.exists();
    }

    public static final File createFolder(String filePath) {
        File f = new File(filePath);
        if (f.exists()) {
            return f;
        }
        return FileUtil.createFolder(filePath.split("\\" + FILE_SEPARATOR));
    }

    public static final File createFolder(String[] names) {
        String filePath = names[0];
        File f = null;
        for (int i = 1; i < names.length; ++i) {
            f = new File(filePath = filePath + FILE_SEPARATOR + names[i]);
            if (f.exists()) {
                if (!f.isFile()) continue;
                log.info((Object)(":( The diretory may contains files!!! " + filePath));
                return null;
            }
            if (f.mkdir()) continue;
            log.error((Object)(":( Create directory failed!!! " + filePath));
            return null;
        }
        return f;
    }

    public static final File createFile(String filePath) throws IOException {
        File f = new File(filePath);
        if (f.exists()) {
            return f;
        }
        int i = filePath.lastIndexOf(FILE_SEPARATOR);
        if (i == -1) {
            log.error((Object)(":( Invalid file path!!! " + filePath));
            return null;
        }
        if (null == FileUtil.createFolder(filePath.substring(0, i))) {
            return null;
        }
        f = new File(filePath);
        if (!f.createNewFile()) {
            log.error((Object)(":( Create file failed!!! " + filePath));
            return null;
        }
        return f;
    }

    public static File deleteFile(File file) {
        if (file.isDirectory()) {
            String[] files = file.list();
            for (int i = 0; i < files.length; ++i) {
                File f = FileUtil.deleteFile(new File(file.getPath() + FILE_SEPARATOR + files[i]));
                if (f == null) continue;
                return f;
            }
        }
        if (file.delete()) {
            return null;
        }
        return file;
    }

    public static File deleteFile(String filePath) {
        return FileUtil.deleteFile(new File(filePath));
    }

    public static boolean deleteContent(String dir) {
        return FileUtil.deleteContent(dir, null);
    }

    public static final boolean deleteContent(String dir, final String prefix) {
        try {
            File file = new File(dir);
            if (file.isDirectory()) {
                String[] files = null;
                files = StringUtil.isEmpty(prefix) ? file.list() : file.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(prefix);
                    }
                });
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.deleteFile(dir + FILE_SEPARATOR + files[i]);
                }
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static final void writeFileString(String filePath, String content) throws FileNotFoundException, IOException {
        try (RandomAccessFile rfile = null;){
            rfile = new RandomAccessFile(filePath, "rw");
            rfile.writeBytes(content);
        }
    }

    public static final void writeFile(String filePath, byte[] data) throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            fos.write(data);
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(fos);
            throw throwable;
        }
        StreamUtil.closeStream(fos);
    }

    public static void safeCopyFile(String from, String to) throws IOException {
        FileUtil.safeCopyFile(new File(from), new File(to));
    }

    public static void safeCopyFile(File from, File to) throws IOException {
        String path;
        if (from.isDirectory()) {
            throw new UnsupportedOperationException(":( Unsupport copy directory!!!");
        }
        if (to.isDirectory()) {
            throw new UnsupportedOperationException(":( Unsupport copy file to directory!!!");
        }
        if (!to.exists() && (to = FileUtil.createFile(path = to.getAbsolutePath())) == null) {
            throw new IOException(":( Couldn't create file!!!" + path);
        }
        FileUtil.copyFile(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(from);
            fos = new FileOutputStream(to);
            StreamUtil.copy(fis, fos, 32768);
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(fos);
            StreamUtil.closeStream(fis);
            throw throwable;
        }
        StreamUtil.closeStream(fos);
        StreamUtil.closeStream(fis);
    }

    public static String getExtension(File f) {
        if (f != null) {
            String filename = f.getName();
            return FileUtil.getExtension(filename);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String filePath) {
        RandomAccessFile rfile = null;
        try {
            rfile = new RandomAccessFile(filePath, "r");
            byte[] classBytes = new byte[(int)rfile.length()];
            rfile.read(classBytes);
            rfile.close();
            byte[] byArray = classBytes;
            return byArray;
        }
        catch (IOException ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (rfile != null) {
                StreamUtil.closeStream(rfile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws FileNotFoundException, IOException {
        FileInputStream in = null;
        byte[] bytes = null;
        try {
            in = new FileInputStream(file);
            bytes = StreamUtil.readInputStream(in);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return bytes;
    }

    public static String getExtension(String filename) {
        int i;
        if (StringUtil.isNotEmpty(filename) && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public static File createTemporaryFile(boolean folder, String baseFolder) throws IOException {
        String name = "xx" + System.currentTimeMillis();
        if (baseFolder == null) {
            baseFolder = System.getProperty("user.home");
        }
        if (baseFolder == null) {
            baseFolder = System.getProperty("user.dir");
        }
        String fullName = baseFolder + File.separator + name;
        File file = new File(fullName);
        if (folder) {
            FileUtil.createFolder(fullName);
        } else {
            FileUtil.createFile(fullName);
        }
        file.deleteOnExit();
        return file;
    }

    public static File compress(String packageFolderPath, String zipFileName) throws IOException {
        File zipFile = new File(zipFileName);
        return FileUtil.compress(packageFolderPath, zipFile);
    }

    public static File compress(String packageFolderPath, File zipFile) throws IOException {
        File packageFolder = new File(packageFolderPath);
        if (!packageFolder.exists()) {
            throw new IOException(packageFolderPath + " not exist!");
        }
        Project prj = new Project();
        Zip zip = new Zip();
        zip.setProject(prj);
        zip.setDestFile(zipFile);
        FileSet fileSet = new FileSet();
        fileSet.setProject(prj);
        fileSet.setDir(packageFolder);
        zip.addFileset(fileSet);
        zip.execute();
        return zipFile;
    }

    public static String getParentFolder(String filePath) {
        File file = new File(filePath);
        if (file.isFile()) {
            file = new File(file.getParent());
        }
        return file.getParent();
    }
}

