/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg.util.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;

public class StreamUtil {
    public static final Logger log = Logger.getLogger(StreamUtil.class);

    public static int copy(InputStream in, OutputStream out, int blockSize) throws IOException {
        int size = 0;
        byte[] block = new byte[blockSize];
        while (true) {
            int i;
            if ((i = in.read(block, 0, blockSize)) > 0) {
                out.write(block, 0, i);
                size += i;
                continue;
            }
            if (i == -1) break;
        }
        return size;
    }

    public static byte[] readInputStream(InputStream in) throws IOException {
        int read;
        byte[] buffer = new byte[]{};
        byte[] perReadBuffer = new byte[32768];
        while ((read = in.read(perReadBuffer)) != -1) {
            byte[] temp = new byte[buffer.length + read];
            System.arraycopy(buffer, 0, temp, 0, buffer.length);
            System.arraycopy(perReadBuffer, 0, temp, buffer.length, read);
            buffer = temp;
        }
        return buffer;
    }

    public static final void closeStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
    }

    public static final void closeStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
    }

    public static final void closeStream(RandomAccessFile raf) {
        if (raf != null) {
            try {
                raf.close();
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
    }

    public static final void forwardStream(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buf = new byte[32768];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }

    public static final InputStream loadResource(Class relativeClass, String resourceName) {
        StringBuffer full_resource = new StringBuffer();
        full_resource.append("/");
        full_resource.append(StreamUtil.getPackageName(relativeClass).replace('.', '/'));
        full_resource.append("/");
        full_resource.append(resourceName);
        return relativeClass.getResourceAsStream(full_resource.toString());
    }

    public static String getPackageName(Class cls) {
        Package pkg = cls.getPackage();
        if (pkg == null) {
            String clsname = cls.getName();
            int pos = clsname.lastIndexOf(".");
            String pckName = clsname.substring(0, pos);
            return pckName;
        }
        return pkg.getName();
    }

    public static byte[] getByteFromInputStream(InputStream is) {
        byte[] data = new byte[100];
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int ch = 0;
            while ((ch = is.read(data, 0, 100)) > 0) {
                bos.write(data, 0, ch);
            }
            data = bos.toByteArray();
            is.close();
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    public static InputStream getInputStreamFromByte(byte[] data) {
        return new ByteArrayInputStream(data);
    }
}

