/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.metas.AssignDetailFactory;
import com.kingdee.bos.workflow.metas.AssignDetailInfo;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignHstFactory;
import com.kingdee.bos.workflow.metas.AssignHstInfo;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.IAssignDetail;
import com.kingdee.bos.workflow.metas.IAssignHst;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.message.AbstractBMCMessageHistoryInfo;
import com.kingdee.eas.base.message.AbstractBMCMessageInfo;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryFactory;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.IBMCMessageHistory;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.cp.common.StringUtil;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class WebMessageUtils {
    private static Logger logger = Logger.getLogger((String)WebMessageUtils.class.getName());
    public static int COMMON_NOTICE = 1;
    public static int PASS_NOTICE = 2;
    public static int ONLINE_NOTICE = 3;
    public static final String UNDISPOSETASK = "1";
    public static final String DISPOSEDTASKNODE = "2";
    public static final String NOTICE = "3";
    public static final String MESSAGETYPE_KEY = "messageType";
    public static final String ENABLEHISTORY = "enableHistory";

    public static int getNoticeType(Context ctx, String messageId, boolean ifHistory) {
        AbstractBMCMessageInfo msg = null;
        AbstractBMCMessageHistoryInfo hMsg = null;
        try {
            ObjectUuidPK iObjectPK = new ObjectUuidPK(BOSUuid.read((String)messageId));
            if (!ifHistory) {
                IBMCMessage iBMCMessage = BMCMessageFactory.getRemoteInstance();
                if (iBMCMessage.exists((IObjectPK)iObjectPK)) {
                    msg = iBMCMessage.getBMCMessageInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)messageId)));
                }
                if (msg.getBizType().equals((Object)MsgBizType.WORKFLOW) && !StringUtils.isEmpty((String)msg.getSourceIDs()) && !msg.getSourceIDs().startsWith("|")) {
                    return PASS_NOTICE;
                }
                if (msg.getType().equals((Object)MsgType.ONLINE)) {
                    return ONLINE_NOTICE;
                }
            } else {
                IBMCMessageHistory iBMCMessageHst = BMCMessageHistoryFactory.getRemoteInstance();
                if (iBMCMessageHst.exists((IObjectPK)iObjectPK)) {
                    hMsg = iBMCMessageHst.getBMCMessageHistoryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)messageId)));
                }
                if (hMsg.getBizType().equals((Object)MsgBizType.WORKFLOW) && !StringUtils.isEmpty((String)hMsg.getSourceIDs())) {
                    return PASS_NOTICE;
                }
                if (hMsg.getType().equals((Object)MsgType.ONLINE)) {
                    return ONLINE_NOTICE;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getNoticeType failed", (Throwable)e);
        }
        return COMMON_NOTICE;
    }

    public static AssignDetailInfo getAssignDetailInfo(IObjectPK iObjectPK, Context ctx) throws Exception {
        IAssignDetail iAssignDetail = AssignDetailFactory.getRemoteInstance();
        if (iAssignDetail.exists(iObjectPK)) {
            return iAssignDetail.getValue(iObjectPK);
        }
        return null;
    }

    public static AssignHstInfo getAssignHstInfo(IObjectPK iObjectPK, Context ctx) throws Exception {
        IAssignHst iAssignHst = AssignHstFactory.getRemoteInstance();
        if (iAssignHst.exists(iObjectPK)) {
            return iAssignHst.getValue(iObjectPK);
        }
        return null;
    }

    public static String recoverRequestParam(String param) {
        if (null != param && param.trim().length() > 0) {
            return param.replaceAll(" ", "+");
        }
        return param;
    }

    public static boolean canHandleAssignment(Context ctx, String assigmentId) {
        boolean tag = false;
        AssignmentInfo assignmentInfo = null;
        try {
            IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
            assignmentInfo = service.getAssignmentById(assigmentId);
            if (null != assignmentInfo && (assignmentInfo.getState().equals((Object)WfAssignmentState.ASSIGNED) || assignmentInfo.getState().equals((Object)WfAssignmentState.ACCEPTED))) {
                tag = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tag;
    }

    public static boolean canForwardAssignment(Context ctx, String assignmentId) {
        AssignmentInfo assignmentInfo = null;
        try {
            IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
            boolean allowForward = MultiApproveUtil.allowForward((IEnactmentService)service, (String)assignmentId);
            if (!allowForward) {
                return false;
            }
            assignmentInfo = service.getAssignmentById(assignmentId);
        }
        catch (Exception e) {
            return false;
        }
        return assignmentInfo.getState().equals((Object)WfAssignmentState.ASSIGNED) || assignmentInfo.getState().equals((Object)WfAssignmentState.ACCEPTED);
    }

    public static AssignmentInfo getAssignmentInfoById(Context ctx, String assignmentId) {
        AssignmentInfo assignmentInfo = null;
        try {
            IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
            assignmentInfo = service.getAssignmentById(assignmentId);
        }
        catch (Exception ex) {
            logger.error((Object)"getAssignmentInfoById failed", (Throwable)ex);
        }
        return assignmentInfo;
    }

    public static AssignInfo getAssignInfoById(Context ctx, String assignmentId) {
        AssignInfo info = null;
        try {
            info = AssignFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(assignmentId));
        }
        catch (Exception ex) {
            logger.error((Object)"getAssignInfoById failed", (Throwable)ex);
        }
        return info;
    }

    public static AssignmentInfo forwardAssignmentWithOpinion(Context ctx, String assignmentId, String destUserId, HashMap opinonMap) {
        try {
            return EnactmentServiceProxy.getEnacementService((Context)ctx).forwardAssignment(assignmentId, destUserId, (Map)opinonMap);
        }
        catch (BOSException e) {
            logger.error((Object)"forwardAssignmentWithOpinion failed", (Throwable)e);
            return null;
        }
    }

    public static String getAttachementFile(String attachID, Context ctx, ServletContext app) throws Exception {
        AttachmentInfo attInfo = (AttachmentInfo)AttachmentFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(attachID));
        if (attInfo == null) {
            return "";
        }
        String fileName = StringUtil.encoder((String)attInfo.getId().toString());
        if (fileName.indexOf("%") > -1) {
            fileName = fileName.replaceAll("%", "9");
        }
        String suffix = attInfo.getSimpleName();
        File file = null;
        file = WebMessageUtils.createFileOnServer(fileName + "." + suffix, app, attInfo);
        return "/resource/" + file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createFileOnServer(String fileName, ServletContext app, AttachmentInfo info) {
        File file;
        File fileDir = new File(app.getRealPath("") + "//resource//");
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }
        if ((file = new File(app.getRealPath("") + "/resource/" + fileName)).exists()) {
            long saveOrUpdateToDBTime;
            long uploadTime = file.lastModified();
            if (uploadTime != (saveOrUpdateToDBTime = info.getLastUpdateTime().getTime())) {
                file.delete();
            } else if (uploadTime == saveOrUpdateToDBTime) {
                return file;
            }
        }
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new ByteArrayInputStream(info.getFile()));
            out = new BufferedOutputStream(new FileOutputStream(file));
            file.setLastModified(info.getLastUpdateTime().getTime());
            byte[] array = new byte[4096];
            int len = 0;
            while ((len = in.read(array)) != -1) {
                ((BufferedOutputStream)out).write(array, 0, len);
            }
            ((BufferedOutputStream)out).flush();
        }
        catch (IOException e) {
            logger.error((Object)"createFileOnServer failed", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"createFileOnServer (close) failed", (Throwable)e);
            }
        }
        return file;
    }
}

