/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.IOtherSysMSG;
import com.kingdee.bos.workflow.metas.OtherSysMSGFactory;
import com.kingdee.bos.workflow.metas.OtherSysMSGInfo;
import com.kingdee.bos.workflow.metas.OtherSysMSGStatus;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.eas.base.message.webservice.WSMessage;
import com.kingdee.eas.base.message.webservice.WfMsgRecordCleaner;
import com.kingdee.eas.base.message.webservice.WfrAssignMessage;
import com.kingdee.eas.base.message.webservice.WfrProcMessage;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class MessageWebServiceDaoProxy
implements InvocationHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.message.webservice.MessageWebServiceDaoProxy");
    private Object object;
    private String easServer;
    private String dc;

    public MessageWebServiceDaoProxy(Object object, String dc) {
        this.object = object;
        this.easServer = MessageWebServiceDaoProxy.getLocalServer();
        this.dc = dc;
    }

    public void init() {
        Thread t = new Thread(new WfMsgRecordCleaner(this.dc));
        t.setName("WfMsgRecordCleaner_" + this.dc);
        t.start();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String id = this.before(method, args);
        Object obj = Boolean.FALSE;
        try {
            obj = method.invoke(this.object, args);
            this.after(id, "");
        }
        catch (Exception e) {
            this.after(id, this.getStackStr(e));
        }
        return obj;
    }

    private String getStackStr(Exception e) {
        Throwable throwable = e.getCause();
        if (throwable == null) {
            return "";
        }
        StackTraceElement[] stacks = throwable.getStackTrace();
        String className = throwable.getClass().getName();
        String msg = throwable.getLocalizedMessage();
        StringBuffer sb = new StringBuffer();
        sb.append(className).append(":").append(msg).append("</br>");
        for (StackTraceElement stack : stacks) {
            sb.append(stack.toString()).append("</br>");
        }
        return sb.toString();
    }

    private void after(String id, String errorLog) {
        String callStatue = "0";
        if (StringUtils.isEmpty((String)errorLog)) {
            callStatue = "1";
        }
        String sql = "update t_wfr_othersysmsg set FCallState=?,FErrorLog=?  where fid =?";
        try {
            SQL.executeUpdate((String)this.dc, (String)sql, (int[])new int[]{12, 12, 12}, (Object[])new Object[]{callStatue, errorLog, id});
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
    }

    private Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    private String before(Method method, Object[] args) {
        OtherSysMSGInfo otherSysMSGInfo = new OtherSysMSGInfo();
        otherSysMSGInfo.setServer(this.easServer);
        otherSysMSGInfo.setCallTime(this.now());
        otherSysMSGInfo.setCallState(OtherSysMSGStatus.executing);
        otherSysMSGInfo.setErrorLog(Thread.currentThread().getName());
        otherSysMSGInfo.setMethodName(this.object.getClass().getSimpleName() + "_" + method.getName());
        if (args.length > 0 && args[0] != null) {
            try {
                Object obj = args[0];
                if (obj instanceof WSMessage) {
                    this.forWSMessage(otherSysMSGInfo, (WSMessage)obj);
                } else if (obj instanceof String) {
                    if (args.length > 1 && "removeMessage".equals(method.getName())) {
                        this.forString(otherSysMSGInfo, (String)obj, (Context)args[1]);
                    } else if (args.length > 2 && "updateMessages".equals(method.getName())) {
                        this.forString(otherSysMSGInfo, (String)obj, (Context)args[2]);
                    } else {
                        this.forString(otherSysMSGInfo, (String)obj);
                    }
                } else if (obj instanceof WfrProcMessage) {
                    this.forWfrProcMessage(otherSysMSGInfo, (WfrProcMessage)obj);
                } else if (obj instanceof WfrAssignMessage) {
                    this.forWfrAssignMessage(otherSysMSGInfo, (WfrAssignMessage)obj);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return otherSysMSGInfo.getId().toString();
    }

    private void forString(OtherSysMSGInfo otherSysMSGInfo, String id, Context ctx) throws Exception {
        if (id.indexOf("'") > -1) {
            id = id.substring(1, id.length() - 1);
        }
        otherSysMSGInfo.setMsgId(id);
        otherSysMSGInfo.setId(BOSUuid.create((String)"9D431C6B"));
        String bosType = BOSUuid.read((String)id).getType().toString();
        if (id.endsWith("WFWKITEM")) {
            this.forStringAssign(otherSysMSGInfo, id, ctx);
        } else if ("9623EB51".equals(bosType)) {
            String sql = "select fassignid as assignid from t_bas_assignread where fid=?";
            ArrayList list = SQL.executeQuery((String)this.dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{id});
            if (list.size() > 0) {
                Map m = (Map)list.get(0);
                String assignid = (String)m.get("assignid");
                this.forStringAssign(otherSysMSGInfo, assignid, ctx);
            }
        } else {
            this.forStringMessage(otherSysMSGInfo, id);
        }
        this.insertOtherSysMSGInfo(otherSysMSGInfo);
    }

    private void forString(OtherSysMSGInfo otherSysMSGInfo, String id) throws Exception {
        this.forString(otherSysMSGInfo, id, null);
    }

    private void forStringMessage(OtherSysMSGInfo otherSysMSGInfo, String id) {
        String sql = "select FRECEIVER as receiverid from t_bas_message where fid=?";
        try {
            ArrayList list = SQL.executeQuery((String)this.dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{id});
            if (list.size() > 0) {
                Map m = (Map)list.get(0);
                String receiverid = (String)m.get("receiverid");
                otherSysMSGInfo.setMsgReceiverId(receiverid);
                sql = "SELECT FNAME_L2 as receiver FROM t_pm_user where FID=? ";
                list = SQL.executeQuery((String)this.dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{receiverid});
                if (list.size() > 0) {
                    m = (Map)list.get(0);
                    String receiver = (String)m.get("receiver");
                    otherSysMSGInfo.setMsgReceiver(receiver);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
    }

    private void forStringAssign(OtherSysMSGInfo otherSysMSGInfo, String id, Context ctx) throws BOSException {
        String sql = "select FPERSONUSERID as receiverid,FPERSONUSERNAME_L2 as receiver,FACTDEFNAME_L2 as actname,FPROCINSTID as procinstid,FBIZOBJID as billid from t_wfr_assign where fassignid=?";
        ArrayList list = SQL.executeQuery((String)this.dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{id});
        if (list.size() > 0) {
            this.intoOtherSysMSGInfo(otherSysMSGInfo, list);
        } else {
            sql = "select FPERSONUSERID as receiverid,FPERSONUSERNAME_L2 as receiver,FACTDEFNAME_L2 as actname,FPROCINSTID as procinstid,FBIZOBJID as billid from t_wfr_assigndetail where fassignid=?";
            list = SQL.executeQuery((String)this.dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{id});
            if (list.size() > 0) {
                this.intoOtherSysMSGInfo(otherSysMSGInfo, list);
            }
        }
        if (ctx != null) {
            String billNumber = this.getBillNumber(ctx, otherSysMSGInfo.getBillId());
            otherSysMSGInfo.setBillCode(billNumber);
        }
    }

    private String getBillNumber(Context ctx, String billId) {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("number"));
        IObjectValue o = null;
        try {
            o = ScriptUtil.getBizObject((Context)ctx, (String)billId, (SelectorItemCollection)selectors, (boolean)false);
        }
        catch (WfException e) {
            logger.error((Object)"\u83b7\u53d6\u5355\u636e\u5bf9\u8c61\u5931\u8d25\u3002");
        }
        return (String)o.get("number");
    }

    private void insertOtherSysMSGInfo(OtherSysMSGInfo otherSysMSGInfo) throws BOSException {
        String sql = "insert into t_wfr_othersysmsg(fid,FMsgReceiver,FMsgReceiverId,FBILLID,FBILLCODE,FProcinstId,FActName,FMsgId,FMethodName,FServer,FCallTime,FCALLSTATE,FERRORLOG) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        SQL.executeUpdate((String)this.dc, (String)sql, (int[])new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 93, 12, 12}, (Object[])new Object[]{otherSysMSGInfo.getId().toString(), otherSysMSGInfo.getMsgReceiver(), otherSysMSGInfo.getMsgReceiverId(), otherSysMSGInfo.getBillId(), otherSysMSGInfo.getBillCode(), otherSysMSGInfo.getProcinstId(), otherSysMSGInfo.getActName(), otherSysMSGInfo.getMsgId(), otherSysMSGInfo.getMethodName(), otherSysMSGInfo.getServer(), otherSysMSGInfo.getCallTime(), otherSysMSGInfo.getCallState().getValue(), otherSysMSGInfo.getErrorLog()});
    }

    private void intoOtherSysMSGInfo(OtherSysMSGInfo otherSysMSGInfo, ArrayList<?> list) {
        Map m = (Map)list.get(0);
        otherSysMSGInfo.setMsgReceiverId((String)m.get("receiverid"));
        otherSysMSGInfo.setMsgReceiver((String)m.get("receiver"));
        otherSysMSGInfo.setActName((String)m.get("actname"));
        otherSysMSGInfo.setProcinstId((String)m.get("procinstid"));
        otherSysMSGInfo.setBillId((String)m.get("billid"));
    }

    private void forWfrAssignMessage(OtherSysMSGInfo otherSysMSGInfo, WfrAssignMessage wfrAssignMsg) throws Exception {
        Context ctx = wfrAssignMsg.getCtx();
        this.addnew(otherSysMSGInfo, wfrAssignMsg.getBillID(), wfrAssignMsg.getProcInstId(), wfrAssignMsg.getBillNumber(), wfrAssignMsg.getHandler(), wfrAssignMsg.getHandlerId(), wfrAssignMsg.getAssignId(), wfrAssignMsg.getActName(), ctx);
    }

    private void forWfrProcMessage(OtherSysMSGInfo otherSysMSGInfo, WfrProcMessage wfrProcMsg) throws Exception {
        Context ctx = wfrProcMsg.getCtx();
        this.addnew(otherSysMSGInfo, wfrProcMsg.getBillID(), wfrProcMsg.getProcInstId(), wfrProcMsg.getBillNumber(), wfrProcMsg.getInitiator(), wfrProcMsg.getInitiatorId(), wfrProcMsg.getProcInstId(), null, ctx);
    }

    private void forWSMessage(OtherSysMSGInfo otherSysMSGInfo, WSMessage wsMessage) throws Exception {
        Context ctx = wsMessage.getContext();
        String sourceId = wsMessage.getSourceID();
        String msgId = wsMessage.getMsgID();
        String bosType = BOSUuid.read((String)msgId).getType().toString();
        if ("9623EB51".equals(bosType)) {
            msgId = sourceId;
        }
        this.addnew(otherSysMSGInfo, wsMessage.getBillId(), wsMessage.getProcInstId(), wsMessage.getBillNumber(), wsMessage.getReceivers(), wsMessage.getRecieverID(), msgId, wsMessage.getActName(), ctx);
    }

    private void addnew(OtherSysMSGInfo otherSysMSGInfo, String billID, String procInstId, String billNumber, String receiver, String receiverID, String msgID, String actName, Context ctx) throws Exception {
        IOtherSysMSG otherSysMSG = OtherSysMSGFactory.getLocalInstance((Context)ctx);
        otherSysMSGInfo.setBillId(billID);
        otherSysMSGInfo.setProcinstId(procInstId);
        otherSysMSGInfo.setBillCode(billNumber);
        otherSysMSGInfo.setMsgReceiver(receiver);
        otherSysMSGInfo.setMsgReceiverId(receiverID);
        otherSysMSGInfo.setMsgId(msgID);
        otherSysMSGInfo.setActName(actName);
        otherSysMSG.addnew(otherSysMSGInfo);
    }

    public static String getLocalServer() {
        String ip = "";
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String path = System.getProperty("EAS_INSTANCE_HOME");
        if (path != null && path.contains("/")) {
            String[] temp = path.split("/");
            return ip + "/" + temp[temp.length - 1];
        }
        return "";
    }
}

