/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.receiver.util.receiver;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.forewarn.OrgUserInfo;
import com.kingdee.eas.base.message.MAGroupResolventInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.receiver.util.DKTreeNodeUtils;
import com.kingdee.eas.base.receiver.util.PersonItem;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ReceiverDKTreeNodeUtils {
    private String inputText = null;
    private ArrayList treePaths = new ArrayList();

    public OrgUserInfo putOrgUserInfo(DefaultKingdeeTreeNode node, boolean isCU) {
        Object ob = node.getUserObject();
        return this.putOrgUserInfo(ob, node, isCU);
    }

    public String getPersonNodeID(DefaultKingdeeTreeNode node) {
        String id = "";
        Object ob = node.getUserObject();
        if (ob instanceof PersonItem) {
            id = ((PersonItem)ob).getId();
        } else if (ob instanceof OrgStructureInfo) {
            id = ((OrgStructureInfo)ob).getUnit().getId().toString();
        } else if (ob instanceof OrgUserInfo) {
            id = ((OrgUserInfo)ob).getOrgUserID();
        } else if (ob instanceof UserInfo) {
            id = ((UserInfo)ob).getId().toString();
        }
        return id;
    }

    public String getPersonNodeNameNumber(DefaultKingdeeTreeNode node) {
        String id = "";
        Object ob = node.getUserObject();
        if (ob instanceof PersonItem) {
            id = LocaleUtils.getDefaultLocale().toString().toLowerCase().equals("l3") ? ((PersonItem)ob).getName_l3() + "." + ((PersonItem)ob).getNumber() : ((PersonItem)ob).getName_l2() + "." + ((PersonItem)ob).getNumber();
        } else if (ob instanceof OrgStructureInfo) {
            id = ((OrgStructureInfo)ob).getUnit().getName() + "." + ((OrgStructureInfo)ob).getUnit().getNumber();
        } else if (ob instanceof OrgUserInfo) {
            id = ((OrgUserInfo)ob).getOrgUserName() + "." + ((OrgUserInfo)ob).getNumber();
        } else if (ob instanceof UserInfo) {
            id = ((UserInfo)ob).getName() + "." + ((UserInfo)ob).getNumber();
        }
        return "[" + id + "]";
    }

    public OrgUserInfo putOrgUserInfo(Object ob, DefaultKingdeeTreeNode node, boolean isCU) {
        OrgUserInfo oui = new OrgUserInfo();
        String orgUserID = "";
        String orgUserName = "";
        String parentID = "";
        String isLeaf = "";
        String userOrOrg = "";
        String orgUserLevel = "";
        String number = "";
        if (ob instanceof PersonItem) {
            PersonItem pi = (PersonItem)ob;
            orgUserID = pi.getId();
            orgUserName = SysContext.getSysContext().getLocale().toString().toLowerCase().equals("l2") ? pi.getName_l2() : pi.getName_l3();
            parentID = "";
            if (node.getParent() != null) {
                parentID = this.getPersonNodeID((DefaultKingdeeTreeNode)node.getParent());
            }
            isLeaf = "1";
            userOrOrg = "1";
            orgUserLevel = "10000";
            number = pi.getNumber();
        } else if (ob instanceof OrgStructureInfo) {
            OrgStructureInfo osi = (OrgStructureInfo)ob;
            orgUserID = osi.getUnit().getId().toString();
            number = osi.getUnit().getNumber();
            orgUserName = osi.getUnit().getName();
            parentID = "";
            if (osi.getParent() != null) {
                parentID = osi.getParent().getId().toString();
            }
            isLeaf = osi.isIsLeaf() ? "1" : "0";
            userOrOrg = "0";
            if (isCU) {
                userOrOrg = "2";
            }
            orgUserLevel = String.valueOf(osi.getLevel());
        }
        oui.setIsLeaf(isLeaf);
        oui.setNumber(number);
        oui.setOrgUserID(orgUserID);
        oui.setOrgUserLevel(orgUserLevel);
        oui.setOrgUserName(orgUserName);
        oui.setParentID(parentID);
        oui.setUserOrOrg(userOrOrg);
        return oui;
    }

    public String getParentNodeName(KDTree treeStaticReceivers, DefaultKingdeeTreeNode node) {
        String str = node.getText();
        DefaultKingdeeTreeNode tmpNode = null;
        tmpNode = node;
        int i = 0;
        while ((tmpNode = (DefaultKingdeeTreeNode)tmpNode.getParent()) != null) {
            if (tmpNode == (DefaultKingdeeTreeNode)treeStaticReceivers.getModel().getRoot()) {
                str = tmpNode.getText() + "." + str;
                break;
            }
            str = tmpNode.getText() + "." + str;
            ++i;
        }
        return str;
    }

    public void initPUTree(List list, FullOrgUnitInfo fo, DefaultKingdeeTreeNode rootNode, boolean isHaveUser, boolean isUser) {
        if (list != null && list.size() != 0) {
            Iterator it = list.iterator();
            DefaultKingdeeTreeNode childerNode1 = null;
            int i = 0;
            int maxLength = 10;
            while (it.hasNext() & i < maxLength) {
                childerNode1 = this.initAddNode(it.next(), isHaveUser);
                if (childerNode1 == null) continue;
                rootNode.add((MutableTreeNode)childerNode1);
                if (i == maxLength - 1) {
                    childerNode1 = new DefaultKingdeeTreeNode();
                    childerNode1.setCustomIcon(EASResource.getIcon((String)"imgTbtn_check"));
                    if (isUser) {
                        childerNode1.setText(EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"moreuser"));
                    } else {
                        childerNode1.setText(EASResource.getString((String)"com.kingdee.eas.base.message.MessageCenter", (String)"duozhiyuan"));
                    }
                    childerNode1.setUserObject((Object)fo.getId());
                    rootNode.add((MutableTreeNode)childerNode1);
                }
                ++i;
            }
        }
    }

    public DefaultKingdeeTreeNode initAddNode(Object ob, boolean isHaveUser) {
        DefaultKingdeeTreeNode pNode = new DefaultKingdeeTreeNode();
        if (ob instanceof UserInfo) {
            UserInfo ui = (UserInfo)ob;
            pNode = new DefaultKingdeeTreeNode();
            pNode.setUserObject((Object)ui);
            pNode.setText(ui.getName() + "(" + ui.getNumber() + ")");
        } else {
            PersonItem pi = (PersonItem)ob;
            if (!StringUtils.isEmpty((String)pi.getName_l2())) {
                pNode = new DefaultKingdeeTreeNode();
                pNode.setUserObject((Object)pi);
                if (SysContext.getSysContext().getLocale().toString().toLowerCase().equals("l2")) {
                    pNode.setText(pi.getName_l2());
                } else {
                    pNode.setText(pi.getName_l3());
                }
            }
            if (isHaveUser && !pi.isHaveUser()) {
                return null;
            }
        }
        pNode.setCustomIcon(EASResource.getIcon((String)"imgTree_user"));
        return pNode;
    }

    public boolean isHNode(DefaultKingdeeTreeNode node, HashMap map) {
        return map.containsKey(DKTreeNodeUtils.init().getPersonNodeID(node));
    }

    public void putPersonMap(DefaultKingdeeTreeNode node, HashMap map) {
        Object ob = node.getUserObject();
        if (ob instanceof PersonItem) {
            map.put(((PersonItem)ob).getId(), "");
        } else if (ob instanceof OrgStructureInfo) {
            map.put(((OrgStructureInfo)ob).getUnit().getId().toString(), "");
        } else if (ob instanceof UserInfo) {
            map.put(((UserInfo)ob).getId().toString(), "");
        }
    }

    public boolean isAddChilderNode(String id, HashMap map) {
        return this.isAddChilderNode_inner(id, map);
    }

    private boolean isAddChilderNode_inner(String id, HashMap map) {
        boolean isRe = false;
        if (!map.containsKey(id)) {
            isRe = true;
            map.put(id, null);
        }
        return isRe;
    }

    private void checkNodeID(DefaultKingdeeTreeNode root, HashMap nodeMap) {
        OrgStructureInfo osi = (OrgStructureInfo)root.getUserObject();
        nodeMap.put(osi.getUnit().getId().toString(), root);
    }

    public void checkNode(DefaultKingdeeTreeNode root, HashMap nodeMap) {
        root.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
        this.checkNodeID(root, nodeMap);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.checkNode((DefaultKingdeeTreeNode)root.getChildAt(i), nodeMap);
        }
    }

    public void search(String field, KDTree kdTree, KDCheckBox cb) {
        if (!StringUtils.isEmpty((String)field)) {
            this.inputText = field.trim();
            this.treePaths.clear();
            this.searchNode((DefaultKingdeeTreeNode)kdTree.getModel().getRoot(), kdTree, cb);
            TreePath[] paths = this.treePaths.toArray(new TreePath[0]);
            kdTree.getSelectionModel().clearSelection();
            kdTree.setSelectionPaths(paths);
            if (paths != null && paths.length > 0) {
                kdTree.scrollPathToVisible(paths[0]);
            }
        }
    }

    private void searchNode(DefaultKingdeeTreeNode node, KDTree kdTree, KDCheckBox cb) {
        if (node == null) {
            return;
        }
        if (this.checkEquals(node.getText(), cb)) {
            kdTree.setSelectionNode(node);
            this.treePaths.add(kdTree.getSelectionPath());
        }
        int childCount = node.getChildCount();
        DefaultKingdeeTreeNode tmpNode = null;
        for (int i = 0; i < childCount; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (tmpNode.getChildCount() != 0) {
                this.searchNode(tmpNode, kdTree, cb);
                continue;
            }
            if (!this.checkEquals(tmpNode.getText(), cb)) continue;
            kdTree.setSelectionNode(tmpNode);
            this.treePaths.add(kdTree.getSelectionPath());
        }
    }

    private boolean checkEquals(String str, KDCheckBox cb) {
        if (str == null || this.inputText == null || str.trim() == null || str.trim().equals("") || this.inputText.equals("")) {
            return false;
        }
        str = str.trim();
        return cb.isSelected() ? str.equalsIgnoreCase(this.inputText) || str.indexOf(this.inputText) != -1 : str.equals(this.inputText);
    }

    public String getNodeOrgID(DefaultKingdeeTreeNode dkt) {
        FullOrgUnitInfo osi;
        Object ob;
        String id = "";
        if (dkt != null && (ob = dkt.getUserObject()) != null && ob instanceof OrgStructureInfo && (osi = ((OrgStructureInfo)ob).getUnit()) != null) {
            id = osi.getId().toString();
        }
        return id;
    }

    public PersonItem initPersonItem(Object ob) {
        PersonItem pi = new PersonItem();
        pi.setHaveUser(false);
        if (ob instanceof OrgUserInfo) {
            OrgUserInfo oui = (OrgUserInfo)ob;
            pi.setId(oui.getOrgUserID());
            pi.setName_l3(oui.getOrgUserName());
            pi.setName_l2(oui.getOrgUserName());
            pi.setNumber(oui.getNumber());
        } else if (ob instanceof PersonInfo) {
            PersonInfo pInfo = (PersonInfo)ob;
            pi.setId(pInfo.getId().toString());
            pi.setName_l3(pInfo.getName());
            pi.setName_l2(pInfo.getName());
            pi.setNumber(pInfo.getNumber());
        }
        return pi;
    }

    public MAGroupResolventInfo setMAGroup(IRow row) {
        MAGroupResolventInfo info = new MAGroupResolventInfo();
        info.setName(row.getCell("name").getValue().toString());
        info.setNumber(row.getCell("number").getValue().toString());
        if (row.getCell("description").getValue() == null) {
            info.setDescription("");
        } else {
            info.setDescription(row.getCell("description").getValue().toString());
        }
        info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        return info;
    }
}

