/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.sm.util;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    public static Date getDateByDateAndTime(Date date, Time time) {
        Calendar cDate = Calendar.getInstance();
        cDate.setTime(date);
        Calendar cTime = Calendar.getInstance();
        cTime.setTime(new Date(time.getTime()));
        Calendar c = Calendar.getInstance();
        c.set(1, cDate.get(1));
        c.set(2, cDate.get(2));
        c.set(5, cDate.get(5));
        c.set(11, cTime.get(11));
        c.set(12, cTime.get(12));
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date addMinute(Date date, int num) {
        Calendar cDate = Calendar.getInstance();
        cDate.setTime(date);
        cDate.add(12, num);
        return cDate.getTime();
    }

    public static Date getNextHour(Date date) {
        Calendar cDate = Calendar.getInstance();
        cDate.setTime(date);
        cDate.set(12, 0);
        cDate.set(13, 0);
        cDate.set(14, 0);
        cDate.add(10, 1);
        return cDate.getTime();
    }

    public static String toString(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat fo = new SimpleDateFormat(pattern);
        return fo.format(date);
    }

    public static Date getDateFormat(String str, String formate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(formate);
        Date date = format.parse(str);
        return date;
    }

    private static int getMondayPlus() {
        Calendar cd = Calendar.getInstance();
        int dayOfWeek = cd.get(7);
        if (dayOfWeek == 1) {
            return -6;
        }
        return 2 - dayOfWeek;
    }

    public static Date getCurrentMonday(int weeks) {
        int mondayPlus = DateUtil.getMondayPlus();
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, mondayPlus);
        Date monday = currentDate.getTime();
        return monday;
    }

    public static Date getFirstDayOfMonth(int month) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(5, 1);
        ((Calendar)calendar).add(2, month);
        Date firstDayOfMonth = calendar.getTime();
        return firstDayOfMonth;
    }

    public static Date getLastDayOfMonth(int month) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(5, 1);
        ((Calendar)calendar).add(2, month + 1);
        ((Calendar)calendar).add(5, -1);
        Date lastDayOfMonth = calendar.getTime();
        return lastDayOfMonth;
    }

    public static Date getMonday(int weeks) {
        int mondayPlus = DateUtil.getMondayPlus();
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, mondayPlus + 7 * weeks);
        Date monday = currentDate.getTime();
        return monday;
    }

    public static Date getSunday(int weeks) {
        int mondayPlus = DateUtil.getMondayPlus();
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, mondayPlus + 7 * weeks + 6);
        Date monday = currentDate.getTime();
        return monday;
    }

    public static String getWeekIndexOfMonth(Date d) {
        String result = "";
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(d);
        gc.setFirstDayOfWeek(2);
        int wk = gc.get(4);
        switch (wk) {
            case 1: {
                result = "1";
                break;
            }
            case 2: {
                result = "2";
                break;
            }
            case 3: {
                result = "3";
                break;
            }
            case 4: {
                result = "4";
                break;
            }
            case 5: {
                result = "5";
                break;
            }
            case 6: {
                result = "6";
                break;
            }
            default: {
                result = "0";
            }
        }
        return "\u7ed7\ufffd" + result + "\u935b\ufffd";
    }

    public static String getDayOfWeek(Date d) {
        String result = "";
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(d);
        int wkIndex = gc.get(7);
        switch (wkIndex) {
            case 1: {
                result = "\u935b\u3126\u68e9";
                break;
            }
            case 2: {
                result = "\u935b\u3124\u7af4";
                break;
            }
            case 3: {
                result = "\u935b\u3124\u7c29";
                break;
            }
            case 4: {
                result = "\u935b\u3124\u7b01";
                break;
            }
            case 5: {
                result = "\u935b\u3125\u6d13";
                break;
            }
            case 6: {
                result = "\u935b\u3124\u7c32";
                break;
            }
            default: {
                result = "\u935b\u3125\u53da";
            }
        }
        return result;
    }

    public static boolean isInTime(Date eventEndDate, int dayNum) {
        boolean retFlag = true;
        Calendar currentCal = Calendar.getInstance();
        currentCal.set(11, 0);
        currentCal.set(12, 0);
        currentCal.set(13, 0);
        currentCal.set(14, 0);
        Calendar cEventEndDate = Calendar.getInstance();
        cEventEndDate.setTime(eventEndDate);
        cEventEndDate.set(11, 0);
        cEventEndDate.set(12, 0);
        cEventEndDate.set(13, 0);
        cEventEndDate.set(14, 0);
        cEventEndDate.add(6, dayNum);
        return cEventEndDate.after(currentCal);
    }

    public static Date getCurrentDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getNotifyFinishDate(Date eventEndDate, int configDays, int configHours) {
        Calendar cEventEndDate = Calendar.getInstance();
        cEventEndDate.setTime(eventEndDate);
        cEventEndDate.set(11, 0);
        cEventEndDate.set(12, 0);
        cEventEndDate.set(13, 0);
        cEventEndDate.set(14, 0);
        cEventEndDate.add(6, configDays + 1);
        cEventEndDate.add(10, -1 * configHours);
        return cEventEndDate.getTime();
    }

    public static boolean isSameDateOfMinute(Date date1, Date date2) {
        Calendar cDate1 = Calendar.getInstance();
        cDate1.setTime(date1);
        cDate1.set(13, 0);
        cDate1.set(14, 0);
        Calendar cDate2 = Calendar.getInstance();
        cDate2.setTime(date2);
        cDate2.set(13, 0);
        cDate2.set(14, 0);
        return cDate1.equals(cDate2);
    }

    public static boolean isSameDay(Date d1, Date d2) {
        Calendar cDate1 = Calendar.getInstance();
        cDate1.setTime(d1);
        cDate1.set(11, 0);
        cDate1.set(12, 0);
        cDate1.set(13, 0);
        cDate1.set(14, 0);
        Calendar cDate2 = Calendar.getInstance();
        cDate2.setTime(d2);
        cDate2.set(11, 0);
        cDate2.set(12, 0);
        cDate2.set(13, 0);
        cDate2.set(14, 0);
        return cDate1.equals(cDate2);
    }

    public static int marginDate(Date d1, Date d2) {
        Calendar cDate1 = Calendar.getInstance();
        cDate1.setTime(d1);
        cDate1.set(11, 0);
        cDate1.set(12, 0);
        cDate1.set(13, 0);
        cDate1.set(14, 0);
        Calendar cDate2 = Calendar.getInstance();
        cDate2.setTime(d2);
        cDate2.set(11, 0);
        cDate2.set(12, 0);
        cDate2.set(13, 0);
        cDate2.set(14, 0);
        long fDate = cDate1.getTimeInMillis();
        long lDate = cDate2.getTimeInMillis();
        long value = lDate - fDate;
        long day = value / 86400000L;
        return Integer.parseInt(day + "");
    }
}

