/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.formularengine.expr;

import com.kingdee.bos.bi.model.common.formularengine.IFuncExecutor;
import com.kingdee.bos.bi.model.common.formularengine.IVarValueProvider;
import com.kingdee.bos.bi.model.common.formularengine.exception.FormulaComputingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.ConstantExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.StringExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.VarExpr;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.util.ArrayList;
import java.util.List;

public class FuncExpr
extends AbstractExpr {
    public static final AbstractExpr PARAM_TYPE_STRING = new StringExpr(null);
    public static final AbstractExpr PARAM_TYPE_NUMBER = new ConstantExpr();
    public static final AbstractExpr PARAM_VALUE_DEFAULT = new VarExpr("");
    private String _funcName;
    private List _paramsTypes;
    private List _paramsValues = new ArrayList();

    public FuncExpr(String funcName) {
        this._funcName = funcName;
    }

    public void addParamType(AbstractExpr param) {
        if (param instanceof StringExpr || param instanceof ConstantExpr) {
            if (this._paramsTypes == null) {
                this._paramsTypes = new ArrayList();
            }
        } else {
            throw new IllegalArgumentException("It must be String or Number.");
        }
        this._paramsTypes.add(param.getClass());
    }

    public void addParam(AbstractExpr param) {
        this._paramsValues.add(param);
    }

    @Override
    protected void doComputing(IVarValueProvider valueProvider) throws FormulaComputingException {
        int count = this._paramsValues.size();
        Variant[] paramValues = new Variant[count];
        for (int i = 0; i < count; ++i) {
            AbstractExpr p = (AbstractExpr)this._paramsValues.get(i);
            if (p == PARAM_VALUE_DEFAULT) {
                paramValues[i] = null;
                continue;
            }
            if (p.isReturnValueUnsure()) {
                p.computing(valueProvider);
            }
            paramValues[i] = p.getReturnValue();
        }
        this._returnValue = ((IFuncExecutor)((Object)valueProvider)).exec(this._funcName, paramValues);
    }

    @Override
    public String getExprString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._funcName);
        sb.append("(");
        for (int i = 0; i < this._paramsValues.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(((AbstractExpr)this._paramsValues.get(i)).getExprString());
        }
        sb.append(")");
        return sb.toString();
    }
}

