/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.adv.chain.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.dynbusiness.ConfigItemStateEnum;
import com.kingdee.eas.dynbusiness.ConfigItemTypeEnum;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessorInfo;
import com.kingdee.eas.dynbusiness.adv.chain.ChainCommonFacadeFactory;
import com.kingdee.eas.dynbusiness.adv.chain.client.AbstractBusinessProcessorEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BusinessProcessorEditUI
extends AbstractBusinessProcessorEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BusinessProcessorEditUI.class);
    private String bosType = null;
    private String subSystem = null;
    private String chainVerison = "0.0.0";
    private String classParam = null;
    private String billName = null;
    private static String str = "com.kingdee.eas.dynbusiness.adv.chain.BusinessChainResource";

    protected IObjectValue createNewData() {
        BusinessProcessorInfo bizProc = new BusinessProcessorInfo();
        bizProc.setType(ConfigItemTypeEnum.STANDARD);
        bizProc.setState(ConfigItemStateEnum.OPEN);
        return bizProc;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BusinessProcessorFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
    }

    private void initData() {
        if (this.editData.getSubSystem() == null) {
            String fullName;
            this.billName = (String)this.getUIContext().get("billName");
            if (this.getUIContext().get("bosType") != null) {
                this.bosType = (String)this.getUIContext().get("bosType");
            }
            this.subSystem = fullName = (String)this.getUIContext().get("fullName");
            this.editData.setSubSystem(this.subSystem);
            this.editData.setSystemName(this.billName);
            this.btnBosType.setText(this.billName);
        }
        if (this.editData.getSystemName() != null) {
            this.billName = this.editData.getSystemName();
            this.btnBosType.setText(this.billName);
        }
        if (this.editData.getSubSystem() != null) {
            this.subSystem = this.editData.getSubSystem();
        }
        if (this.editData.getBosType() != null) {
            this.bosType = this.editData.getBosType();
        }
        if (this.editData.getVersion() != null) {
            this.chainVerison = this.editData.getVersion();
        }
        this.classParam = (String)this.getUIContext().get("UIClassParam");
        if (this.classParam != null) {
            if (this.classParam.equals("1")) {
                this.comboType.setSelectedIndex(0);
            } else if (this.classParam.equals("2")) {
                this.comboType.setSelectedIndex(1);
            } else if (this.classParam.equals("3")) {
                this.comboType.setSelectedIndex(2);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setBillType();
        this.initOldData((IObjectValue)this.editData);
        if (this.editData.getSystemName() != null) {
            this.btnBosType.setText(this.editData.getSystemName());
        }
    }

    private void setBillType() {
        if (this.editData.getSubSystem() != null) {
            this.subSystem = this.editData.getSubSystem();
            this.btnBosType.setText(this.editData.getSystemName());
        }
        if (this.editData.getBosType() != null) {
            this.bosType = this.editData.getBosType();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setSyncOldValue(true);
        this.editData.setBosType(this.bosType);
        this.editData.setSystemName(this.billName);
        this.editData.setSubSystem(this.subSystem);
        this.editData.setVersion(this.chainVerison);
        this.editData.setSyncOldValue(false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.setVersion();
        this.verify();
        super.actionSubmit_actionPerformed(e);
    }

    private void verify() throws Exception {
        if (this.txtNumber.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"NUM_NOT_NULL"));
            this.abort();
        } else if (this.txtName.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"NAME_NOT_NULL"));
            this.abort();
        } else if (this.txtFunction.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"FUNCTION_NOT_NULL"));
            this.abort();
        } else if (this.txtImplementClass.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)str, (String)"IMPCLASS_NOT_NULL"));
            this.abort();
        } else if (this.editData.getId() == null) {
            String number = this.txtNumber.getText().trim();
            boolean flag = ChainCommonFacadeFactory.getRemoteInstance().checkNumberExists(false, number);
            if (flag) {
                MsgBox.showInfo((String)EASResource.getString((String)str, (String)"NUMBER_IS_EXISTS"));
                this.abort();
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("bosType"));
        sic.add(new SelectorItemInfo("version"));
        sic.add(new SelectorItemInfo("systemName"));
        return sic;
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            if (this.editData != null && this.editData.getNumber() == null) {
                this.txtNumber.setAccessAuthority(0);
            } else {
                this.txtNumber.setAccessAuthority(1);
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.editData.getNumber() == null) {
            this.txtNumber.setAccessAuthority(0);
        } else {
            this.txtNumber.setAccessAuthority(1);
        }
    }

    public boolean checkBeforeWindowClosing() {
        this.getUIContext().remove("bosType");
        this.getUIContext().remove("fullName");
        this.getUIContext().remove("billName");
        return super.checkBeforeWindowClosing();
    }

    private void setVersion() {
        String[] ver = this.chainVerison.split("\\.");
        if (this.classParam.equals("1")) {
            ver[0] = this.addOne(ver[0]);
        }
        if (this.classParam.equals("2")) {
            ver[1] = this.addOne(ver[1]);
        }
        if (this.classParam.equals("3")) {
            ver[2] = this.addOne(ver[2]);
        }
        this.chainVerison = ver[0] + "." + ver[1] + "." + ver[2];
    }

    private String addOne(String str) {
        Integer ver = new Integer(str);
        return ver + 1 + "";
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            String fid = this.editData.getId().toString();
            ArrayList<String> id = new ArrayList<String>();
            id.add(fid);
            boolean flag = ChainCommonFacadeFactory.getRemoteInstance().isExcerpt(id);
            if (flag) {
                MsgBox.showInfo((String)EASResource.getString((String)str, (String)"CAN_NOT_DEL"));
                return;
            }
            super.actionRemove_actionPerformed(e);
        }
    }
}

