/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.condition;

import com.kingdee.eas.dynbusiness.ColumnDataType;
import com.kingdee.eas.dynbusiness.TableTypeEnum;
import com.kingdee.eas.dynbusiness.condition.ColumnExpressionParser;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.ITableSQLBuild;
import com.kingdee.eas.dynbusiness.condition.TableColumnHelper;
import com.kingdee.eas.dynbusiness.expression.IllegalExpressionException;
import com.kingdee.eas.dynbusiness.util.ArrayUtils;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import com.kingdee.eas.dynbusiness.util.SqlBuilderHelper;
import org.apache.log4j.Logger;

public class ColumnItem
extends ConditionItem
implements ITableSQLBuild {
    private static final Logger logger = Logger.getLogger((String)ColumnItem.class.getName());
    private ColumnDataType dataType;
    private String convertTo;
    private String relationField;
    private String relationTable;
    private String relationTableField;
    String TRANSFUNC_PREFIX;
    String TRANSFUNC_POSTFIX;
    private TableColumnHelper helper = new TableColumnHelper();

    public void setRelationField(String relationField) {
        this.relationField = relationField;
    }

    public void setRelationTable(String relationTable) {
        String[] splits = relationTable.split("\\.");
        if (splits.length > 1) {
            this.relationTable = splits[0];
            this.relationTableField = splits[1];
        } else {
            this.relationTable = relationTable;
        }
    }

    @Override
    public String[] getSplits() {
        if (this.splits == null) {
            ExpressionParser exprParser = ExpressionParser.getInstance();
            this.splits = exprParser.splitVariables(this.getName());
        }
        return super.getSplits();
    }

    public ColumnItem(String name) {
        super(name);
    }

    public String getAlias() {
        if (this.relationField != null && this.relationTable != null) {
            return this.relationTable;
        }
        return this.helper.getAliasByLevel();
    }

    @Override
    public boolean hasLevelGreaterZero(String alias) {
        return this.helper.hasLevelGreaterZero(alias);
    }

    @Override
    public boolean hasLevelZero(String alias) {
        return this.helper.hasLevelZero(alias);
    }

    @Override
    public String getExpression() {
        return this.getExpression(false);
    }

    boolean isConvertToBase() {
        return this.convertTo != null && this.convertTo.equalsIgnoreCase("base");
    }

    private String getExpression(boolean isToSum) {
        try {
            ColumnExpressionParser parser = new ColumnExpressionParser(this);
            parser.setToSum(isToSum);
            return parser.parseColumnPression();
        }
        catch (IllegalExpressionException e) {
            logger.error((Object)("\u89e3\u6790ColumnItem(" + this.getName() + ")\u51fa\u9519\uff01"), (Throwable)e);
            return null;
        }
    }

    String getRealExpression(String expr, boolean isToSum, boolean convertToBase) {
        StringBuffer sb = new StringBuffer();
        if (this.relationField != null && this.relationTable != null) {
            sb.append(this.relationTable).append(".").append(this.getName());
            return sb.toString();
        }
        if (convertToBase) {
            sb.append("Round(Decimal(");
        }
        if (isToSum && this.helper.getLevelFrom() == 0 && this.isNeedToAggregate()) {
            sb.append("SUM(");
            sb.append(this.getAlias()).append(".").append(expr);
            sb.append(")");
        } else {
            sb.append(this.getAlias()).append(".").append(expr);
        }
        if (convertToBase) {
            sb.append("*mmu.FBaseConvsRate,21,8),8)");
        }
        return sb.toString();
    }

    public int getLevelFrom() {
        return this.helper.getLevelFrom();
    }

    public void setLevelFrom(int levelFrom) {
        this.helper.setLevelFrom(levelFrom);
    }

    public TableTypeEnum getTable() {
        return this.helper.getTable();
    }

    public void setTable(TableTypeEnum table) {
        this.helper.setTable(table);
    }

    public ColumnDataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(ColumnDataType dataType) {
        this.dataType = dataType;
        if (this.dataType != null) {
            if (dataType.equals(ColumnDataType.QTY)) {
                this.TRANSFUNC_POSTFIX = ",21,8),mmu.FQtyPrecision)";
                this.TRANSFUNC_PREFIX = "Round(Decimal(";
            } else if (dataType.equals(ColumnDataType.AMOUNT)) {
                this.TRANSFUNC_POSTFIX = ",19,4),cur.FPrecision)";
                this.TRANSFUNC_PREFIX = "Round(Decimal(";
            }
        }
    }

    @Override
    public String buildConditon(boolean isToSum, String[] columns) {
        if (columns != null && columns.length == 2 && this.dataType.equals(ColumnDataType.QTY)) {
            StringBuffer sb = new StringBuffer();
            sb.append("SUM(CASE WHEN ").append("entry").append(".").append(columns[1]).append(" = ").append("srce").append(".FUnitID").append(" THEN ").append(this.getExpression(false)).append("\r\n").append("ELSE Round(Decimal(").append("entry").append(".").append(columns[0]).append("/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END)");
            return sb.toString();
        }
        return this.getExpression(isToSum);
    }

    @Override
    public boolean hasMulOrDivOperation(int levelFrom) {
        boolean isAmount;
        boolean isQty;
        boolean bl = isQty = this.dataType != null && this.dataType.equals(ColumnDataType.QTY);
        if (!isQty && levelFrom < 10) {
            return false;
        }
        if (isQty && this.convertTo != null && this.convertTo.equalsIgnoreCase("base")) {
            return true;
        }
        boolean bl2 = isAmount = this.dataType != null && this.dataType.equals(ColumnDataType.AMOUNT);
        if (!isAmount && levelFrom >= 10) {
            return false;
        }
        try {
            ColumnExpressionParser parser = new ColumnExpressionParser(this);
            return parser.hasMulOrDivOperationForColumn();
        }
        catch (IllegalExpressionException e) {
            logger.error((Object)("\u89e3\u6790ColumnItem(" + this.getName() + ")\u51fa\u9519\uff01"), (Throwable)e);
            return false;
        }
    }

    @Override
    public String buildJoin() {
        if (this.relationField != null && this.relationTable != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("LEFT OUTER JOIN ");
            sb.append(this.relationTable);
            sb.append(" ON ");
            sb.append(this.helper.getAliasByLevel());
            sb.append(".");
            sb.append(this.relationField);
            sb.append("=");
            sb.append(this.relationTable);
            sb.append(".");
            sb.append(this.relationTableField == null ? "FID" : this.relationTableField);
            return sb.toString();
        }
        return "";
    }

    @Override
    public String[] getGroupByFields(int levelFrom) {
        if (this.helper.getLevelFrom() != levelFrom && (this.isNeedToAggregate() || levelFrom == 0)) {
            return new String[0];
        }
        ExpressionParser exprParser = ExpressionParser.getInstance();
        String[] fields = exprParser.splitVariables(this.getName());
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = new StringBuffer().append(this.getAlias()).append(".").append(fields[i]).toString();
        }
        if (this.isConvertToBase()) {
            String[] convertFields = new String[]{"mmu.FBaseConvsRate", "mmu.FQtyPrecision"};
            fields = ArrayUtils.mergeArray(fields, convertFields);
        }
        return fields;
    }

    @Override
    public String[] getColumnNames(int levelFrom, boolean withAlias) {
        if (this.helper.getLevelFrom() == levelFrom) {
            boolean isToSum;
            ExpressionParser exprParser = ExpressionParser.getInstance();
            String[] vars = exprParser.splitVariables(this.getName());
            if (!withAlias) {
                return SqlBuilderHelper.addColumnNamesWithType(vars, this.dataType);
            }
            boolean bl = isToSum = levelFrom == 0 && this.isNeedToAggregate();
            if (vars.length == 1) {
                return new String[]{this.getRealExpression(this.name, isToSum, false)};
            }
            String[] cols = new String[vars.length];
            for (int i = 0; i < vars.length; ++i) {
                cols[i] = this.getRealExpression(vars[i], isToSum, false);
            }
            return cols;
        }
        return new String[0];
    }

    private boolean isNeedToAggregate() {
        return this.dataType != null && (this.dataType.equals(ColumnDataType.QTY) || this.dataType.equals(ColumnDataType.AMOUNT));
    }

    public String getConvertTo() {
        return this.convertTo;
    }

    public void setConvertTo(String convertTo) {
        this.convertTo = convertTo;
    }
}

