/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.app.LotFrameManu;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.emm.mo.EMMManufactureOrderChangeEntryCollection;
import com.kingdee.eas.emm.mo.EMMManufactureOrderChangeEntryFactory;
import com.kingdee.eas.emm.mo.EMMManufactureOrderEXCTL;
import com.kingdee.eas.emm.mo.EMMManufactureOrderFacadeFactory;
import com.kingdee.eas.emm.mo.EMMManufactureOrderFlowCTL;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.industry.emm.mo.EMMManufactureOrderEntrysGenFacadeFactory;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.IProductTransactionType;
import com.kingdee.eas.mm.basedata.IStandardRooting;
import com.kingdee.eas.mm.basedata.OperationFactory;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeCollection;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.common.util.MMCommonUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class EMMManufactureOrderCTL {
    private static String HQXMSCDDBT_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HQXMSCDDBT_INFO");
    private static String CXSFCZXYDBJH_FAIL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"CXSFCZXYDBJH_FAIL");

    public static SelectorItemCollection getSelectors4Routing() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        return sic;
    }

    public static boolean isNullOrIdIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)((String)obj));
        }
        if (obj instanceof CoreBaseInfo) {
            return ((CoreBaseInfo)obj).getId() == null;
        }
        return false;
    }

    public IRowSet getPrintDataSet(Context ctx, String moid, boolean subRoutingExpand) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("material.id"));
        selectorItemCollection.add(new SelectorItemInfo("material.number"));
        selectorItemCollection.add(new SelectorItemInfo("material.name"));
        selectorItemCollection.add(new SelectorItemInfo("material.model"));
        selectorItemCollection.add(new SelectorItemInfo("blkSize"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)moid, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        CoreBaseCollection stocks = ManufactureOrderStockFactory.getLocalInstance((Context)ctx).getCollection(entityViewInfo);
        Object[] args = null;
        if (stocks != null && stocks.size() > 0) {
            MMCommonUtils.objectValueSort((IObjectCollection)stocks, (boolean)true, (String)"material");
            int count = stocks.size();
            for (int i = 0; i < count; ++i) {
                ManufactureOrderStockInfo info = (ManufactureOrderStockInfo)stocks.get(i);
                if (StringUtils.isEmpty((String)info.getBlkSize())) continue;
                String name = info.getMaterial().getName();
                String number = info.getMaterial().getNumber();
                String model = info.getMaterial().getModel();
                String blankingSize = info.getBlkSize();
                args = new String[]{number, name, model == null ? " " : model, blankingSize == null ? " " : blankingSize};
                break;
            }
            if (args == null) {
                ManufactureOrderStockInfo info = (ManufactureOrderStockInfo)stocks.get(0);
                String name = info.getMaterial().getName();
                String number = info.getMaterial().getNumber();
                String model = info.getMaterial().getModel();
                args = new String[]{number, name, model == null ? " " : model, " "};
            }
        } else {
            args = new String[]{" ", " ", " ", " "};
        }
        Locale locale = ctx.getLocale();
        StringBuffer sql = new StringBuffer();
        sql.append("create table Technics (");
        sql.append("fid varchar(44),");
        sql.append("fparentid varchar(44),");
        sql.append("foprtseq nvarchar(180),");
        sql.append("foprtnumber nvarchar(80),");
        sql.append("foprtname nvarchar(80),");
        sql.append("fworkcenter nvarchar(80),");
        sql.append("forganization nvarchar(80),");
        sql.append("fdepartment nvarchar(80),");
        sql.append("fiskeyoprt int,");
        sql.append("fentrusttype int,");
        sql.append("fpreparetime numeric(21,8),");
        sql.append("fworktime numeric(21,8),");
        sql.append("fissubrouting int)");
        String table = null;
        try {
            CoreBaseCollection technics;
            table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            sql.setLength(0);
            sql.append("insert into ").append(table).append(" ( ");
            sql.append("fid, fparentid, foprtseq, foprtnumber, foprtname, fworkcenter, forganization, fdepartment, fiskeyoprt, fentrusttype, fpreparetime, fworktime, fissubrouting");
            sql.append(" ) ");
            sql.append(" select distinct ");
            sql.append(" technics.fid, ");
            sql.append(" technics.fparentid, ");
            sql.append(" to_char(technics.foperationno), ");
            sql.append(" operation.fnumber, ");
            sql.append(" operation.fname_").append(locale).append(", ");
            sql.append(" workcenter.fname_").append(locale).append(", ");
            sql.append(" storageorgunit.fname_").append(locale).append(", ");
            sql.append(" adminorgunit.fname_").append(locale).append(", ");
            sql.append(" technics.fiskeyop, ");
            sql.append(" technics.fentrusttype, ");
            sql.append(" technics.fpreparetime, ");
            sql.append(" technics.fworktime, ");
            sql.append(" 1 ");
            sql.append(" from t_mm_mftordertechnics as technics ");
            sql.append(" left outer join t_mm_operation as operation on technics.foperationid = operation.fid ");
            sql.append(" left outer join t_mm_workcenter as workcenter on technics.fworkcenterid = workcenter.fid ");
            sql.append(" left outer join t_org_storage as storageorgunit on technics.fstorageorgunitid = storageorgunit.fid ");
            sql.append(" left outer join t_org_admin as adminorgunit on technics.fadminorgunitid = adminorgunit.fid ");
            sql.append(" where technics.fparentid = '" + moid + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            if (subRoutingExpand) {
                entityViewInfo = new EntityViewInfo();
                selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add(new SelectorItemInfo("operationNo"));
                selectorItemCollection.add(new SelectorItemInfo("operation.id"));
                selectorItemCollection.add(new SelectorItemInfo("operation.name"));
                selectorItemCollection.add(new SelectorItemInfo("operation.number"));
                selectorItemCollection.add(new SelectorItemInfo("subRouting.id"));
                selectorItemCollection.add(new SelectorItemInfo("subRouting.name"));
                selectorItemCollection.add(new SelectorItemInfo("subRouting.number"));
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)moid, CompareType.EQUALS));
                entityViewInfo.setFilter(filterInfo);
                entityViewInfo.setSelector(selectorItemCollection);
                technics = ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx).getCollection(entityViewInfo);
                if (technics != null && technics.size() > 0) {
                    ArrayList<ManufactureOrderTechnicsInfo> technicsList = new ArrayList<ManufactureOrderTechnicsInfo>();
                    ArrayList<StandardRootingInfo> subRoutingList = new ArrayList<StandardRootingInfo>();
                    int count = technics.size();
                    for (int i = 0; i < count; ++i) {
                        ManufactureOrderTechnicsInfo info = (ManufactureOrderTechnicsInfo)technics.get(i);
                        if (info.getSubRouting() == null) continue;
                        technicsList.add(info);
                        subRoutingList.add(info.getSubRouting());
                    }
                    this.insertSubRouting(ctx, table, moid, technicsList, subRoutingList);
                }
            }
            sql.setLength(0);
            sql.append(" select distinct ");
            sql.append(" manufactureorder.fid as id, ");
            sql.append(" storageorgunit.fname_").append(locale).append(" as storageorgunit, ");
            sql.append(" manufactureorder.fnumber as billnumber, ");
            sql.append(" biztype.fname_").append(locale).append(" as biztype, ");
            sql.append(" material.fnumber as productnumber, ");
            sql.append(" material.fname_").append(locale).append(" as productname, ");
            sql.append(" material.fmodel as productmodel, ");
            sql.append(" material.fpicturenumber as picturenumber, ");
            sql.append(" trade.fname_").append(locale).append(" as brandnumber, ");
            sql.append(" isnull(manufactureorder.fqty, 0) - isnull(manufactureorder.ftotalsplitqty, 0) as qty, ");
            sql.append(" unit.fname_").append(locale).append(" as unit, ");
            sql.append(" multiunit.fqtyprecision").append(" as scale, ");
            sql.append(" manufactureorder.fplanbegindate as planbegindate, ");
            sql.append(" manufactureorder.fplanenddate as planenddate, ");
            sql.append(" ? as materialnumber, ");
            sql.append(" ? as materialname, ");
            sql.append(" ? as materialmodel, ");
            sql.append(" ? as blankingsize, ");
            sql.append(" technics.fid as technicsid, ");
            sql.append(" technics.foprtseq as oprtseq, ");
            sql.append(" technics.foprtnumber as oprtnumber, ");
            sql.append(" technics.foprtname as oprtname, ");
            sql.append(" technics.fworkcenter as workcenter, ");
            sql.append(" technics.forganization as organization, ");
            sql.append(" technics.fdepartment as department, ");
            sql.append(" technics.fiskeyoprt as iskeyoprt, ");
            sql.append(" technics.fentrusttype as entrusttype, ");
            sql.append(" technics.fpreparetime as preparetime, ");
            sql.append(" technics.fworktime as worktime, ");
            sql.append(" technics.fissubrouting as issubrouting ");
            sql.append(" from t_mm_manufactureorder as manufactureorder ");
            sql.append(" left outer join t_bd_material as material on manufactureorder.fmaterialid = material.fid ");
            sql.append(" left outer join t_scm_biztype as biztype on manufactureorder.fbiztypeid = biztype.fid ");
            sql.append(" left outer join t_scm_billtype as billtype on manufactureorder.fbilltypeid = billtype.fid ");
            sql.append(" left outer join t_org_storage as storageorgunit on manufactureorder.fstorageorgunitid = storageorgunit.fid ");
            sql.append(" left outer join t_bd_measureunit as unit on manufactureorder.funitid = unit.fid ");
            sql.append(" left outer join t_bd_multimeasureunit as multiunit on manufactureorder.funitid = multiunit.fmeasureunitid and multiunit.fmaterialid = manufactureorder.fmaterialid");
            sql.append(" left outer join t_mm_materialtrademark as trade on material.fmaterialtrademark = trade.fid ");
            sql.append(" left outer join " + table + " as technics on manufactureorder.fid = technics.fparentid ");
            sql.append(" where manufactureorder.fid = '" + moid + "'");
            sql.append(" order by technics.foprtseq");
            technics = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])args);
            return technics;
        }
        catch (Exception exc) {
            throw new BOSException((Throwable)exc);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(table);
        }
    }

    public static boolean checkEntryHasDestObject(Context ctx, String srcEntryId, Set destTypes) throws BOSException {
        boolean hasDestObject = false;
        StringBuffer sql_botEntryRelation = new StringBuffer();
        sql_botEntryRelation.append("SELECT count(1) as COUNTNO FROM T_BOT_RELATIONENTRY AS botEntry ");
        sql_botEntryRelation.append("INNER JOIN T_BOT_RELATION AS bot on bot.FID = botEntry.FKeyID ");
        sql_botEntryRelation.append("WHERE botEntry.FSrcEntryID = '" + srcEntryId + "'");
        if (destTypes != null && destTypes.size() > 0) {
            String destEntityType = StringUtils.arrayToString((Object[])destTypes.toArray(), (String)"','");
            sql_botEntryRelation.append(" and bot.FDestEntityID in ('" + destEntityType + "')");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql_botEntryRelation.toString());
        try {
            if (rs.next() && rs.getInt("COUNTNO") > 0) {
                hasDestObject = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hasDestObject;
    }

    public Set getMOEntryWithDestObject(Context ctx, String id, Set destTypes) throws BOSException {
        HashSet<String> returnSet = new HashSet<String>();
        StringBuffer sql_botEntryRelation = new StringBuffer();
        sql_botEntryRelation.append(" SELECT distinct FSrcEntryID FROM T_BOT_RELATIONENTRY AS botEntry ");
        sql_botEntryRelation.append(" INNER JOIN T_BOT_RELATION AS bot on bot.FID = botEntry.FKeyID ");
        sql_botEntryRelation.append(" WHERE bot.FSrcEntityID = '1D0D80DD'");
        sql_botEntryRelation.append(" AND bot.FSRCOBJECTID = '" + id + "'");
        if (destTypes != null) {
            String destEntityType = StringUtils.arrayToString((Object[])destTypes.toArray(), (String)"','");
            if (destTypes.size() > 1) {
                sql_botEntryRelation.append(" and bot.FDestEntityID in ('" + destEntityType + "')");
            } else {
                sql_botEntryRelation.append(" and bot.FDestEntityID ='" + destTypes.toArray()[0] + "'");
            }
        }
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)sql_botEntryRelation.toString());
        try {
            if (rs.next()) {
                returnSet.add(rs.getString("FSrcEntryID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnSet;
    }

    private void insertSubRouting(Context ctx, String table, String moid, List technicsList, List subRoutingList) throws EASBizException, BOSException {
        StringBuffer insert = new StringBuffer();
        insert.append(" insert into ").append(table).append(" ( ");
        insert.append(" fid, fparentid, foprtseq, foprtnumber, foprtname, fworkcenter, forganization, fdepartment, fiskeyoprt, fentrusttype, fpreparetime, fworktime, fissubrouting ) ");
        insert.append(" values (?,?,?,?,?,?,?,?,?,?,?,?,?)");
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.prepareStatement(insert.toString());
            if (subRoutingList != null) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                int count = subRoutingList.size();
                for (int i = 0; i < count; ++i) {
                    ManufactureOrderTechnicsInfo info = (ManufactureOrderTechnicsInfo)technicsList.get(i);
                    StandardRootingInfo routing = (StandardRootingInfo)subRoutingList.get(i);
                    params.clear();
                    int oprtSeq = info.getOperationNo();
                    String oprtNumber = info.getOperation().getNumber();
                    params.put("ROUTINGID", routing.getId().toString());
                    params.put("STORAGEORG", info.getStorageOrgUnit());
                    params.put("BEGINTIME", info.getEarlistWoktime());
                    params.put("ENDTIME", info.getEarlistCmpTime());
                    params.put("BASEUNIT", info.getBaseUnit());
                    params.put("BILL_UNIT", info.getUnit());
                    params.put("BILL_QTY", info.getQty());
                    ManufactureOrderTechnicsCollection technics = ManufactureOrderFactory.getLocalInstance((Context)ctx).routingExpand(params);
                    if (technics == null || technics.size() <= 0) continue;
                    int size = technics.size();
                    for (int j = 0; j < size; ++j) {
                        info = technics.get(j);
                        statement.setString(1, BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
                        statement.setString(2, moid);
                        statement.setString(3, oprtSeq + "." + info.getOperationNo());
                        if (info.getOperation() != null) {
                            statement.setString(4, oprtNumber + "-" + info.getOperation().getNumber());
                            statement.setString(5, info.getOperation().getName());
                        } else {
                            statement.setString(4, oprtNumber + ".#");
                            statement.setString(5, "");
                        }
                        if (info.getWorkcenter() != null) {
                            statement.setString(6, info.getWorkcenter().getName());
                        } else {
                            statement.setString(6, "");
                        }
                        if (info.getStorageOrgUnit() != null) {
                            statement.setString(7, info.getStorageOrgUnit().getName());
                        } else {
                            statement.setString(7, "");
                        }
                        if (info.getAdminOrgUnit() != null) {
                            statement.setString(8, info.getAdminOrgUnit().getName());
                        } else {
                            statement.setString(8, "");
                        }
                        statement.setInt(9, info.isIsKeyOP() ? 1 : 0);
                        statement.setInt(10, info.getEntrustType().getValue());
                        statement.setBigDecimal(11, info.getPrepareTime());
                        statement.setBigDecimal(12, info.getWorkTime());
                        statement.setInt(13, 0);
                        statement.addBatch();
                    }
                }
                statement.executeBatch();
            }
        }
        catch (Exception exc) {
            try {
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)connection);
    }

    public static String getRecKeyString(IObjectValue model) {
        String recKey = "";
        MaterialInfo materialInfo = (MaterialInfo)model.get("material");
        int operationNo = model.getInt("operationNo");
        recKey = materialInfo != null ? materialInfo.getId().toString() : "MATERIAL_NULL";
        recKey = recKey + "!";
        recKey = recKey + operationNo;
        return recKey;
    }

    public Set getTechsWithDestObject(Context ctx, String id) throws BOSException {
        Set<String> returnSet = new HashSet();
        HashSet<String> destTypes = new HashSet<String>();
        destTypes.add("6F0D8519");
        destTypes.add("200BB61F");
        returnSet = this.getMOEntryWithDestObject(ctx, id, destTypes);
        StringBuffer sql_getReport = new StringBuffer();
        sql_getReport.append(" SELECT distinct rpt.FProcessID FROM T_MM_CompletionReport as rpt");
        sql_getReport.append(" INNER JOIN T_BOT_RELATION as bot on rpt.FID = bot.FDESTOBJECTID");
        sql_getReport.append(" WHERE bot.FSrcEntityID = '1D0D80DD'");
        sql_getReport.append(" AND bot.FSRCOBJECTID = '" + id + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql_getReport.toString());
        try {
            while (rs.next()) {
                returnSet.add(rs.getString("FProcessID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql_queryDispatch = new StringBuffer();
        sql_queryDispatch.append(" SELECT distinct disEntry.FSourceBillEntryID FROM T_MM_DisTaskDispatchEntry as disEntry ");
        sql_queryDispatch.append(" WHERE disEntry.FSourceBillID = '" + id + "'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql_queryDispatch.toString());
        try {
            while (rs.next()) {
                returnSet.add(rs.getString("FSourceBillEntryID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnSet;
    }

    public static String idSubString(Context ctx, String idStr) throws BOSException {
        String idSubStr = null;
        HashSet<String> idSubToZeroSet = new HashSet<String>();
        StringBuffer subIdSql = new StringBuffer();
        subIdSql.append("select mo.FId as ID,transType.FIsSetWIPQtyToZero as IsZero ").append("from t_mm_manufactureOrder mo ").append(" inner join t_mm_ProductTransactionType transType on mo.fTransactionTypeId = transType.FId ").append(" where mo.Fid in (").append(idStr).append(") ").append("and transType.FIsSetWIPQtyToZero = 1 ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)subIdSql.toString());
            while (rs.next()) {
                String moId = rs.getString("ID");
                idSubToZeroSet.add(moId);
            }
            if (idSubToZeroSet != null) {
                idSubStr = StringUtils.arrayToString((Object[])idSubToZeroSet.toArray(), (String)"','");
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        return idSubStr;
    }

    public static void afterSubmit(Context ctx, String idStrs) throws BOSException, EASBizException {
        Object[] idStrArray = new String[]{idStrs};
        String idStr = SQLUtil.arrayToString((Object[])idStrArray);
        String[] sqls = new String[8];
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_ManufactureOrder as t0  ").append("set (FFirstOperNo,FLastOperNo) = ").append("(select firstOp,lastOp from ").append("(select t1.FParentID,min(FOperationNo) firstOp,max(FOperationNo) lastOp ").append("from T_MM_MFTOrderTechnics t1 ").append("where t1.FParentID in (").append(idStr).append(") ").append("group by t1.FParentID) t2 ").append("where t0.FID = t2.FParentID ").append("and t0.FID in (").append(idStr).append(")").append(" and isnull(t0.fbirthtype, 0) = ").append(0).append(")\r\n");
        updateSql.append("Where\r\n");
        updateSql.append("1=1\r\n");
        updateSql.append("And t0.FID In (\r\n");
        updateSql.append(idStr);
        updateSql.append(")\r\n");
        updateSql.append("And isnull(t0.FBirthType, 0) = ").append(0).append("\r\n");
        sqls[0] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_ManufactureOrder as t0  ").append("set (FLackLowerLimitBase,FExtraUpperLimitBase,FDeliveryBaseQty ,FunRepairBaseQty) = ").append("(select round(decimal(t0.FLackLowerLimit * t1.FBaseConvsRate,21,8),t2.FQtyPrecision),").append("round(decimal(t0.FExtraUpperLimit * t1.FBaseConvsRate,21,8),t2.FQtyPrecision), ").append("round(decimal(t0.FDeliveryQty * t1.FBaseConvsRate,21,8),t2.FQtyPrecision), ").append("round(decimal(t0.FunRepairQty * t1.FBaseConvsRate,21,8),t2.FQtyPrecision)").append("from t_bd_multimeasureunit t1,t_bd_multimeasureunit t2 ").append("where t0.FMaterialID = t1.FMaterialID and t0.FUnitID = t1.fmeasureunitid ").append("and t0.FMaterialID = t2.FMaterialID and t0.FBaseUnitID = t2.fmeasureunitid ").append("and t0.FID in (").append(idStr).append(") ").append(")");
        updateSql.append("Where\r\n");
        updateSql.append("1=1\r\n");
        updateSql.append("And t0.FID In (\r\n");
        updateSql.append(idStr);
        updateSql.append(")\r\n");
        sqls[1] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_MFTOrderTechnics as t0  ").append("set (FBaseQty) = ").append("(select t1.FBaseQty ").append("from T_MM_ManufactureOrder t1 ").append("where t0.FParentID = t1.FID ").append("and t1.FID in (").append(idStr).append(") ").append(")");
        sqls[2] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_MFTOrderStock as t0  ").append("set (FBaseQty,FUnitbaseQty,FLossBaseQty,FPlannedBaseQty,FOriginalPlanBaseQty,FUnReceiptBaseQty,FTotalReceiptBaseQty) = ").append("(select round(decimal(t0.FQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision),").append("round(decimal(t0.FUnitQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("round(decimal(t0.FLossQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("round(decimal(t0.FPlannedQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("round(decimal(t0.FOriginalPlanQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("round(decimal(t0.FUnReceiptQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision), ").append("round(decimal(t0.FTotalReceiptQty * t2.FBaseConvsRate,21,8),t3.FQtyPrecision) ").append("from t_bd_multimeasureunit t2 , T_MM_ManufactureOrder t1 ,t_bd_multimeasureunit t3 ").append("where t0.FParentID = t1.FID ").append("and t0.FMaterialID = t2.FMaterialID and t0.FUnitID = t2.fmeasureunitid ").append(" and t0.FMaterialID = t3.FMaterialID and t0.FBaseUnitID = t3.fmeasureunitid ").append("and t1.FID in (").append(idStr).append(") ").append(")\r\n");
        updateSql.append("Where\r\n");
        updateSql.append("1=1\r\n");
        updateSql.append("And t0.FParentID In (\r\n");
        updateSql.append(idStr);
        updateSql.append(")\r\n");
        sqls[3] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_MFTOrderStock as t0  ").append("set (FWorkcenterID,FOperationID) = ").append("(select FWorkcenterID,FOperationID ").append("from T_MM_MFTOrderTechnics t1 ").append(" where t0.FOperationNo = t1.FOperationNo and t1.fparentid=t0.fparentid").append(")").append("where t0.FParentID in (").append(idStr).append(") ");
        sqls[4] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append(" update t_mm_mftordertechnics  ");
        updateSql.append(" set fbasestatus =  ").append(4);
        updateSql.append(" Where FParentID In (\r\n");
        updateSql.append(idStr);
        updateSql.append(")\r\n");
        updateSql.append("and fbasestatus = ");
        updateSql.append(0);
        updateSql.append("or fbasestatus = ");
        updateSql.append(1);
        sqls[5] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_MFTOrderTechnics as t0  ").append("set (FUnDispatchQty,FUnDispatchBaseQty) = ").append("(select t0.FQTY - t0.FTotalSplitQty - t0.FTotalDispatchQty,").append("round(decimal((t0.FQTY - t0.FTotalSplitQty - t0.FTotalDispatchQty) * t2.FBaseConvsRate,21,8),t3.FQtyPrecision)").append(" from t_bd_multimeasureunit t2 , T_MM_ManufactureOrder t1 ,t_bd_multimeasureunit t3 ").append("where t0.FParentID = t1.FID ").append(" and t1.FMaterialID = t2.FMaterialID and t1.FUnitID = t2.fmeasureunitid ").append(" and t1.FMaterialID = t3.FMaterialID and t1.FBaseUnitID = t3.fmeasureunitid ").append("and t1.FID in (").append(idStr).append(") ").append(")");
        sqls[6] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_MFTOrderStock as t0 ").append("set (FUnReceiptQty,FUnReceiptBaseQty,FUnIssueQty,FUnIssueBaseQty,FAssociateQty) = ").append("(select t0.FPlannedQty-t0.FTotalReceiptQty,t0.FPlannedBaseQty-t0.FTotalReceiptBaseQty,t0.FPlannedQty-t0.FActIssueQty+t0.FRejectedQty,t0.FPlannedBaseQty-t0.FActIssueBaseQty+t0.FRejectedBaseQty,").append(" case when t0.FIsQtyLimit=1 then ").append("round(to_decimal(t0.FPickExtraBaseQty,21,8),b1.FQtyPrecision)-t0.FActIssueBaseQty+t0.FRejectedBaseQty ").append(" else t0.FPlannedBaseQty-t0.FActIssueBaseQty+t0.FRejectedBaseQty ").append(" end ").append("from t_bd_multimeasureunit  b1 ").append("where t0.FMaterialID = b1.FMaterialID and t0.FBaseUnitID = b1.fmeasureunitid) ").append(" where t0.FParentID in (").append(idStr).append(") ");
        sqls[7] = updateSql.toString();
        try {
            SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        }
        catch (BOSException bosException) {
            Throwable throwable = bosException.getCause();
            if (throwable instanceof SQLException) {
                String sqlState = ((SQLException)throwable).getSQLState();
                String message = ((SQLException)throwable).getMessage();
                if (sqlState != null && sqlState.equalsIgnoreCase("22003")) {
                    throw new ManufactureOrderException(ManufactureOrderException.NUMERIC_VALUE_OUT_OF_RANGE);
                }
                if (message != null && message.toLowerCase().indexOf("numeric") > -1) {
                    throw new ManufactureOrderException(ManufactureOrderException.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
            throw bosException;
        }
    }

    private void afterThawing(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String[] sqls = new String[1];
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        viewInfo.setFilter(filterInfo);
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_ManufactureOrder   ").append(" set FBaseStatus = FOldBaseStatus ").append(" where fid in (").append(idStr).append(")  ");
        sqls[0] = updateSql.toString();
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    public static boolean checkUnAuditInParam(Context ctx, ManufactureOrderInfo mo) throws BOSException, EASBizException {
        if (mo != null && mo.getBillType() != null) {
            String billTypeId = mo.getBillType().getId().toString();
            String orgUnitID = mo.getStorageOrgUnit().getId().toString();
            boolean isCanUnAudit = false;
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strCanUnAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, orgUnitID, billTypeId);
            if (strCanUnAudit != null && strCanUnAudit.trim().length() != 0 && strCanUnAudit.trim().toLowerCase().equals("1")) {
                isCanUnAudit = true;
            }
            if (!isCanUnAudit) {
                throw new SCMBillException(SCMBillException.CHECK_UNAUDIT_PARAM);
            }
        }
        return true;
    }

    public static String createTempTable2(Context ctx) throws BOSException, EASBizException {
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("create table tttttt (").append("FID varchar(44) not null,").append("FMaterialID varchar(44) null,").append("FTrackNumberID varchar(44) null,").append("FProjectID varchar(44) null,").append("FStorageOrgUnitID varchar(44) null,").append("FBOMID varchar(44) null, ").append("FLocationID varchar(44) null ").append(")");
            expandTablName = pool.createTempTable(sqlBuf.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return expandTablName;
    }

    private static void dealLotRule(Context ctx, ManufactureOrderInfo manuorderInfo) throws EASBizException, BOSException {
        LotFrame lotFrame = LotRuleFactory.getLocalInstance((Context)ctx).getLotFrame(manuorderInfo.getMaterial().getId().toString(), manuorderInfo.getStorageOrgUnit().getId().toString());
        if (lotFrame != null && lotFrame.getLotRule() != null) {
            LotFrameManu lot = new LotFrameManu();
            lot.setSeq(lotFrame.getSeq());
            lot.setSysDate(lotFrame.getSysDate());
            lot.setCurrentSerial(lotFrame.getCurrentSerial());
            lot.setLotRule(lotFrame.getLotRule());
            lot.setBillNumber(manuorderInfo.getNumber());
            lot.setMainBizOrg(manuorderInfo.getStorageOrgUnit().getNumber());
            lot.setMaterial(manuorderInfo.getMaterial().getNumber());
            String lotNo = lot.getLotNumber();
            manuorderInfo.setLot(lotNo);
        } else {
            manuorderInfo.setLot(null);
        }
    }

    private static BigDecimal getAssistUnitQty(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo eoUnitInfo, BigDecimal qty, MeasureUnitInfo assistUnitInfo) throws EASBizException, BOSException {
        if (EMMManufactureOrderCTL.isNullOrIdIsNull(materialInfo) || EMMManufactureOrderCTL.isNullOrIdIsNull(assistUnitInfo) || qty == null || qty.doubleValue() == 0.0) {
            return SysConstant.BIGZERO;
        }
        return SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (MeasureUnitInfo)eoUnitInfo, (MeasureUnitInfo)assistUnitInfo, (BigDecimal)qty);
    }

    private static CostObjectInfo getCostObject(Context ctx, MaterialInfo materialInfo, StorageOrgUnitInfo storageOrgUnit, String lot, String moid) throws EASBizException, BOSException {
        if (storageOrgUnit == null) {
            return null;
        }
        OrgUnitCollection companys = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(storageOrgUnit.getId().toString(), 4, 1);
        CompanyOrgUnitInfo company = null;
        if (companys != null && companys.size() > 0) {
            company = (CompanyOrgUnitInfo)companys.get(0);
        }
        if (company == null) {
            return null;
        }
        String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)storageOrgUnit.getId().toString())), (String)"AutoGenLotCost");
        ICostObject icostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
        IMaterialCompanyInfo iMaterialCompanyInfo = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        CostObjectInfo costObjectInfo = icostObject.getCostObjectByMaterialLotAndOrder(company.getId().toString(), materialInfo.getId().toString(), lot, moid);
        if (costObjectInfo != null) {
            return costObjectInfo;
        }
        if (paramValue.equals("false")) {
            return null;
        }
        MaterialInventoryInfo materialInventoryInfo = iMaterialInventory.getInventoryInfo(materialInfo.getId().toString(), storageOrgUnit.getId().toString());
        if (!materialInventoryInfo.isIsLotNumber() || materialInventoryInfo.getStatus().getValue() != 1) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT mateial.Id, mateial.number, mateial.name, mateial.status, status, accountType,calculateType,createCOByOrder ").append(" WHERE mateial.Id = '").append(materialInfo.getId().toString()).append("' ").append(" AND mateial.status = '1' AND status = '1' ").append(" AND company.Id = '").append(company.getId().toString()).append("'");
        MaterialCompanyInfoCollection mciColl = iMaterialCompanyInfo.getMaterialCompanyInfoCollection(sql.toString());
        if (mciColl.size() == 0) {
            return null;
        }
        MaterialCompanyInfoInfo companyInfo = mciColl.get(0);
        if (companyInfo.getCalculateType().getValue() == 2 && companyInfo.getAccountType().getValue() == 5 || companyInfo.isCreateCOByOrder()) {
            CostObjectCollection cols = new CostObjectCollection();
            CostObjectInfo item = new CostObjectInfo();
            item.setCompany(company);
            item.setRelatedId(materialInfo.getId());
            item.setBatchNumber(lot);
            item.setStdProductID(materialInfo);
            item.setOrderID(moid);
            cols.add(item);
            icostObject.addnewBybatch((IObjectCollection)cols);
            costObjectInfo = icostObject.getCostObjectByMaterialLotAndOrder(company.getId().toString(), materialInfo.getId().toString(), lot, moid);
        }
        return costObjectInfo;
    }

    private CostObjectInfo getCostObjectByMaterialLot(Context ctx, String materialID, String companyID, String lot) throws BOSException, EASBizException {
        throw new UnsupportedOperationException("USE ICostObject.getCostObjectByMaterialLotAndOrder instead.");
    }

    private void getDefaultRouting(Context ctx, String materialID, String storageOrgUnitID, ProductTransactionTypeInfo transInfo, Map inParam, Map outParam) throws BOSException, EASBizException {
        StandardRootingInfo customizedRouting = (StandardRootingInfo)inParam.get("CUSTOMIZED_ROUTING");
        if (customizedRouting == null) {
            CoreBaseCollection col = null;
            if (transInfo != null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID));
                filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(60)));
                filterInfo.getFilterItems().add(new FilterItemInfo("isMainRooting", (Object)Boolean.TRUE));
                viewInfo.setFilter(filterInfo);
                viewInfo.setSelector(EMMManufactureOrderCTL.getSelectors4Routing());
                IStandardRooting routing = StandardRootingFactory.getLocalInstance((Context)ctx);
                col = routing.getCollection(viewInfo);
                if (!(transInfo.isIsWPManagement() || col != null && col.size() != 0)) {
                    viewInfo = new EntityViewInfo();
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID));
                    filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"-"));
                    viewInfo.setFilter(filterInfo);
                    viewInfo.setSelector(EMMManufactureOrderCTL.getSelectors4Routing());
                    col = routing.getCollection(viewInfo);
                }
                if (col != null && col.size() > 0) {
                    outParam.put("ROUTING", col.get(0));
                    inParam.put("ROUTINGID", col.get(0).getId().toString());
                    ManufactureOrderTechnicsCollection techCol = EMMManufactureOrderFacadeFactory.getLocalInstance(ctx).routingExpand(inParam);
                    outParam.put("TECHNICS", techCol);
                }
            }
        } else {
            outParam.put("ROUTING", customizedRouting);
            inParam.put("ROUTINGID", customizedRouting.getId().toString());
            ManufactureOrderTechnicsCollection techCol = EMMManufactureOrderFacadeFactory.getLocalInstance(ctx).routingExpand(inParam);
            outParam.put("TECHNICS", techCol);
        }
    }

    public static ProductTransactionTypeInfo getDefaultTransType(Context ctx, String orgID, String bizTypeID) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgID));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)bizTypeID));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20)));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bizType.*"));
        sic.add(new SelectorItemInfo("defaultBFWarehouse.*"));
        sic.add(new SelectorItemInfo("defaultBFLocation.*"));
        viewInfo.setSelector(sic);
        IProductTransactionType ptType = ProductTransactionTypeFactory.getLocalInstance((Context)ctx);
        ProductTransactionTypeCollection prodCol = ptType.getProductTransactionTypeCollection(viewInfo);
        ProductTransactionTypeInfo type = null;
        if (prodCol.size() > 0) {
            type = prodCol.get(0);
        }
        return type;
    }

    private static BigDecimal getExpectOutputQty(Context ctx, BigDecimal orderBaseQty, MaterialScrapRateExpressionEnum scrapRateExpression, BigDecimal productBaseQty, ConsumeTypeEnum consumeType, BigDecimal consumeFixBaseQty, BigDecimal baseProportion, BigDecimal scrapRatio) throws EASBizException, BOSException {
        BigDecimal outputBaseQty = SysConstant.BIGZERO;
        BigDecimal ONE = new BigDecimal("1.0");
        BigDecimal PERCENT = new BigDecimal("100.0");
        int PREC = 8;
        BigDecimal byDivide = ONE.subtract(scrapRatio.divide(PERCENT, 8, 4));
        BigDecimal byMutiple = ONE.add(scrapRatio.divide(PERCENT, 8, 4));
        baseProportion = baseProportion.divide(PERCENT, 8, 4);
        if (consumeType.equals((Object)ConsumeTypeEnum.VariableAmount)) {
            if (scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                if (!productBaseQty.equals(SysConstant.BIGZERO) && !byDivide.equals(SysConstant.BIGZERO)) {
                    outputBaseQty = orderBaseQty.divide(productBaseQty, 8, 4).multiply(consumeFixBaseQty).divide(byDivide, 8, 4);
                }
            } else if (scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE) && !productBaseQty.equals(SysConstant.BIGZERO)) {
                outputBaseQty = orderBaseQty.divide(productBaseQty, 8, 4).multiply(consumeFixBaseQty).multiply(byMutiple);
            }
        } else if (consumeType.equals((Object)ConsumeTypeEnum.Proportion)) {
            if (scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                if (!byDivide.equals(SysConstant.BIGZERO)) {
                    outputBaseQty = orderBaseQty.multiply(baseProportion).divide(byDivide, 8, 4);
                }
            } else if (scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                outputBaseQty = orderBaseQty.multiply(baseProportion).multiply(byMutiple);
            }
        }
        return outputBaseQty;
    }

    public static boolean hasProjectCalendar(Context ctx, String storageOrgID) throws BOSException, EASBizException {
        String sql = "select FID from T_MM_FactoryCalendar where FStorageOrgUnitID = '" + storageOrgID + "'";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (set.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSupplyClassTerm(Context ctx, ManufactureOrderInfo mo) throws BOSException, EASBizException {
        HashMap<String, String> classTermMap = new HashMap<String, String>();
        ManufactureOrderTechnicsCollection technicsCol = mo.getTechnics();
        ManufactureOrderTechnicsInfo info = null;
        HashSet<String> workCenterIds = new HashSet<String>();
        int n = technicsCol.size();
        for (int i = 0; i < n; ++i) {
            info = technicsCol.get(i);
            if (info.getWorkcenter() == null) return false;
            if (info.getWorkcenter().getId() == null) {
                return false;
            }
            workCenterIds.add(info.getWorkcenter().getId().toString());
        }
        StringBuffer sqlSB = new StringBuffer("");
        sqlSB.setLength(0);
        sqlSB.append(" select t1.fid,t1.FClassTeamID from T_MM_WorkCenter t1 ").append(" where t1.fid in ( ").append(SQLUtil.arrayToString((Object[])workCenterIds.toArray())).append(")");
        ArrayList paramLst = new ArrayList();
        paramLst.clear();
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])paramLst.toArray());
        try {
            while (rs.next()) {
                if (rs.getString("FClassTeamID") == null) return false;
                if (rs.getString("FClassTeamID").length() == 0) {
                    return false;
                }
                classTermMap.put(rs.getString("fid"), rs.getString("FClassTeamID"));
            }
        }
        catch (SQLException sqlExp) {
            throw new SQLDataException(sqlExp);
        }
        int i = 0;
        int n2 = technicsCol.size();
        while (i < n2) {
            info = technicsCol.get(i);
            if (!classTermMap.containsKey(info.getWorkcenter().getId().toString())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void lotNumberCheck(Context ctx, ManufactureOrderInfo mo) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnit = null;
        MaterialInfo materialInfo = null;
        materialInfo = mo.getMaterial();
        storageOrgUnit = mo.getStorageOrgUnit();
        if (storageOrgUnit == null) {
            return;
        }
        if (materialInfo == null) {
            return;
        }
        boolean isIsLotNumber = EMMManufactureOrderCTL.getIsIsLotNumber(ctx, materialInfo, storageOrgUnit);
        LotFrame lotFrame = new LotFrame();
        lotFrame.setMainBizOrg(storageOrgUnit.getId().toString());
        lotFrame.setMaterial(materialInfo.getId().toString());
        List lotList = new ArrayList<LotFrame>();
        lotList.add(lotFrame);
        lotList = LotRuleFactory.getLocalInstance((Context)ctx).fillLotFramesNoSerial(lotList);
        lotFrame = (LotFrame)lotList.get(0);
        boolean isLotRule = false;
        if (lotFrame != null && lotFrame.getLotRule() != null) {
            isLotRule = true;
        }
        LotParamValueInfo lotParamInfo = LotFacadeFactory.getLocalInstance((Context)ctx).getLotParamValueByOrg(storageOrgUnit.getId().toString());
        boolean isManufacturePlan = lotParamInfo.isManufacturePlan();
        boolean isManufactureOrder = lotParamInfo.isManufactureOrder();
        boolean isManufactureProseee = lotParamInfo.isManufactureProseee();
        PlannedOrderInfo planorderinfo = null;
        if (mo.getSourceBillId() != null) {
            planorderinfo = (PlannedOrderInfo)PlannedOrderFactory.getLocalInstance((Context)ctx).getCoreBillBaseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)mo.getSourceBillId())));
        }
        if (isIsLotNumber) {
            if (isManufacturePlan) {
                if (isManufactureOrder) {
                    if (isManufactureProseee) {
                        if (planorderinfo != null && planorderinfo.getLot() != null) {
                            mo.setLot(planorderinfo.getLot().trim());
                        } else {
                            mo.setLot(null);
                        }
                    } else if (isLotRule) {
                        EMMManufactureOrderCTL.dealLotRule(ctx, mo);
                    } else {
                        mo.setLot(null);
                    }
                } else if (planorderinfo != null && planorderinfo.getLot() != null) {
                    mo.setLot(planorderinfo.getLot().trim());
                } else if (isLotRule) {
                    EMMManufactureOrderCTL.dealLotRule(ctx, mo);
                } else {
                    mo.setLot(null);
                }
            } else if (isManufactureOrder) {
                if (isLotRule) {
                    EMMManufactureOrderCTL.dealLotRule(ctx, mo);
                } else {
                    mo.setLot(null);
                }
            }
        }
    }

    public static void releaseTempTable(Context ctx, String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    public static void getExpectOutput(Context ctx, Map inParam, Map retData) throws EASBizException, BOSException {
        ManufactureOrderExpectOutputCollection expectOutputs = new ManufactureOrderExpectOutputCollection();
        retData.put("EXPECTOUTPUTS", expectOutputs);
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)inParam.get("STORAGEORG");
        MaterialInfo moMaterialInfo = (MaterialInfo)inParam.get("MATERIAL");
        BomInfo bomInfo = (BomInfo)inParam.get("BOM");
        if (bomInfo == null) {
            return;
        }
        String bomID = bomInfo.getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("unit.*"));
        sic.add(new SelectorItemInfo("baseUnit.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("materialPlan.*"));
        sic.add(new SelectorItemInfo("entrys.material.*"));
        sic.add(new SelectorItemInfo("entrys.baseUnit.*"));
        sic.add(new SelectorItemInfo("entrys.unit.*"));
        sic.add(new SelectorItemInfo("entrys.materialInventory.*"));
        sic.add(new SelectorItemInfo("entrys.defaultWarehouse.*"));
        bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectStringPK(bomID), sic);
        Timestamp moBeginDate = (Timestamp)inParam.get("BEGINTIME");
        Timestamp moEndDate = (Timestamp)inParam.get("ENDTIME");
        MeasureUnitInfo moBaseUnit = (MeasureUnitInfo)inParam.get("BASEUNIT");
        MeasureUnitInfo moUnit = (MeasureUnitInfo)inParam.get("BILL_UNIT");
        BigDecimal moQty = (BigDecimal)inParam.get("BILL_QTY");
        BigDecimal moSplitQty = (BigDecimal)inParam.get("SPLIT_QTY");
        if (moSplitQty == null) {
            moSplitQty = SysConstant.BIGZERO;
        }
        ManufactureOrderTechnicsCollection technicsCol = (ManufactureOrderTechnicsCollection)retData.get("TECHNICS");
        int lastOperNo = 0;
        OperationInfo lastOperationInfo = null;
        if (technicsCol != null && technicsCol.size() > 0) {
            MMCommonUtils.objectValueSort((IObjectCollection)technicsCol, (boolean)true, (String)"operationNo");
            ManufactureOrderTechnicsInfo maxTechnicInfo = technicsCol.get(technicsCol.size() - 1);
            lastOperationInfo = maxTechnicInfo.getOperation();
            lastOperNo = maxTechnicInfo.getOperationNo();
        }
        IRowSet rowSet = EMMManufactureOrderCTL._getWpSeq(ctx, inParam);
        HashMap<String, Object[]> pBomMap = new HashMap<String, Object[]>();
        try {
            while (rowSet != null && rowSet.next()) {
                String bomItemID = rowSet.getString("FBomItemID");
                Integer wpSeq = new Integer(rowSet.getInt("FWpSeq"));
                String operationID = rowSet.getString("FOperationID");
                OperationInfo operationInfo = OperationFactory.getLocalInstance((Context)ctx).getOperationInfo((IObjectPK)new ObjectStringPK(operationID));
                pBomMap.put(bomItemID, new Object[]{wpSeq, operationInfo});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        BigDecimal orderBaseQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)moMaterialInfo.getId().toString(), (MeasureUnitInfo)moUnit, (MeasureUnitInfo)moBaseUnit, (BigDecimal)moQty.subtract(moSplitQty));
        BigDecimal productBaseQty = bomInfo.getProductBaseQty();
        BomEntryCollection bomEntrys = bomInfo.getEntrys();
        for (BomEntryInfo bomEntryInfo : bomEntrys) {
            MaterialPlanInfo materialInventory;
            String bomEntryId = bomEntryInfo.getId().toString();
            Integer operationNo = null;
            OperationInfo opInfo = null;
            if (pBomMap.get(bomEntryId) != null) {
                Object[] opo = (Object[])pBomMap.get(bomEntryId);
                operationNo = (Integer)opo[0];
                opInfo = (OperationInfo)opo[1];
            }
            MaterialScrapRateExpressionEnum scrapRateExpression = (materialInventory = bomEntryInfo.getMaterialInventory()) == null ? null : materialInventory.getScrapRateExpression();
            ConsumeTypeEnum consumeType = bomEntryInfo.getConsumeType();
            BigDecimal consumeFixBaseQty = bomEntryInfo.getConsumeFixBaseQty();
            BigDecimal baseProportion = bomEntryInfo.getBaseProportion();
            BigDecimal scrapRatio = bomEntryInfo.getScrapRatio();
            Date effectiveDate = bomEntryInfo.getEffectiveDate();
            Date disableDate = bomEntryInfo.getDisableDate();
            BigDecimal bomCoefficient = bomInfo.getBaseUnit().getCoefficient();
            BigDecimal bomEntryCoefficient = bomEntryInfo.getBaseUnit().getCoefficient();
            BigDecimal baseExchangeRate = bomCoefficient.divide(bomEntryCoefficient, 8, 4);
            if (moEndDate == null || effectiveDate == null || moBeginDate == null || disableDate == null || moEndDate == null || moEndDate.before(effectiveDate) || moBeginDate.after(disableDate) || DateTimeUtils.dayEquals((Date)moBeginDate, (Date)disableDate) || !MaterialProductEnum.RELATEDPRODUCT.equals((Object)bomEntryInfo.getOutputType()) && !MaterialProductEnum.BYPRODUCT.equals((Object)bomEntryInfo.getOutputType())) continue;
            MaterialInfo expMaterial = bomEntryInfo.getMaterial();
            ManufactureOrderExpectOutputInfo outputInfo = new ManufactureOrderExpectOutputInfo();
            outputInfo.setMaterial(expMaterial);
            outputInfo.setOutputType(bomEntryInfo.getOutputType());
            outputInfo.setOperationNo(operationNo == null ? lastOperNo : operationNo);
            outputInfo.setOperation(opInfo == null ? lastOperationInfo : opInfo);
            outputInfo.setUnit(bomEntryInfo.getUnit());
            outputInfo.setBaseUnit(bomEntryInfo.getBaseUnit());
            BigDecimal tempQty = EMMManufactureOrderCTL.getExpectOutputQty(ctx, orderBaseQty, scrapRateExpression, productBaseQty, consumeType, consumeFixBaseQty, baseProportion, scrapRatio);
            outputInfo.setBaseQty(tempQty.divide(baseExchangeRate, 8, 4).multiply(baseExchangeRate));
            outputInfo.setQty(SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)outputInfo.getMaterial().getId().toString(), (MeasureUnitInfo)outputInfo.getBaseUnit(), (MeasureUnitInfo)outputInfo.getUnit(), (BigDecimal)outputInfo.getBaseQty()));
            outputInfo.setAssistUnit(expMaterial.getAssistUnit());
            outputInfo.setAssistQty(EMMManufactureOrderCTL.getAssistUnitQty(ctx, outputInfo.getMaterial(), outputInfo.getUnit(), outputInfo.getQty(), outputInfo.getAssistUnit()));
            outputInfo.setFinishedQty(SysConstant.BIGZERO);
            outputInfo.setPassQty(SysConstant.BIGZERO);
            outputInfo.setScrapQty(SysConstant.BIGZERO);
            outputInfo.setToStoreQty(SysConstant.BIGZERO);
            outputInfo.setDefaultWarehous(bomEntryInfo.getDefaultWarehouse());
            outputInfo.setCostObect(EMMManufactureOrderCTL.getCostObject(ctx, outputInfo.getMaterial(), storageOrgUnitInfo, null, null));
            outputInfo.setRemark(outputInfo.getRemark());
            expectOutputs.add(outputInfo);
        }
        retData.put("EXPECTOUTPUTS", expectOutputs);
    }

    protected static IRowSet _getWpSeq(Context ctx, Map paraMap) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)paraMap.get("STORAGEORG");
        String routingID = (String)paraMap.get("ROUTINGID");
        BomInfo bom = (BomInfo)paraMap.get("BOM");
        StringBuffer querySB = new StringBuffer();
        querySB.append("SELECT T1.FBomItemID FBomItemID, T1.FUnitQty FUnitQty, T2.FWpSeq FWpSeq ,T2.FOperationID FOperationID ").append(" FROM T_MM_PBOM T0 ").append(" INNER JOIN T_MM_PBOMEntry T1 ").append(" ON T0.FID = T1.FParentID ").append(" INNER JOIN T_MM_MaterialRWP T2 ").append(" ON T1.FRoutingItemID = T2.FID ").append("WHERE T0.FStorageOrgUnitID = '").append(storageOrgUnit.getId().toString()).append("' AND t0.FBomID = '").append(bom.getId().toString()).append("' AND t0.FRoutingID = '").append(routingID).append("' ");
        return DbUtil.executeQuery((Context)ctx, (String)querySB.toString());
    }

    public static boolean getIsIsLotNumber(Context ctx, MaterialInfo materialInfo, StorageOrgUnitInfo storageOrgUnit) throws EASBizException, BOSException {
        MaterialInventoryInfo materialInv;
        SCMEntryDataVO vo = new SCMEntryDataVO();
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        vo.setMaterialInfos(new MaterialInfo[]{materialInfo});
        vo.setStorageOrgUnitInfos(new StorageOrgUnitInfo[]{storageOrgUnit});
        vo.setIsLoadingMaterialPlan(true);
        vo.setIsLoadingMaterialInventory(true);
        vo.setIsLoadingMaterialInfo(false);
        voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(vo);
        String key = materialInfo.getId().toString() + storageOrgUnit.getId().toString();
        Map miInfoMap = voResult.getMaterialInventoryInfos();
        return miInfoMap != null && miInfoMap.get(key) != null && (materialInv = (MaterialInventoryInfo)voResult.getMaterialInventoryInfos().get(key)).isIsLotNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandBOMFromPLannedOrder(Context ctx, Map inParam, Map outParam, ManufactureOrderInfo mo) throws EASBizException, BOSException {
        String expandTablName = EMMManufactureOrderFlowCTL.createTempTable(ctx);
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("yield"));
            BomInfo bom = (BomInfo)BomFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(mo.getBomID()), sic);
            if (bom != null) {
                outParam.put("BOM", bom);
            }
            StorageOrgUnitInfo[] storages = new StorageOrgUnitInfo[mo.getStocks().size()];
            MaterialInfo[] materials = new MaterialInfo[mo.getStocks().size()];
            MeasureUnitInfo[] units = new MeasureUnitInfo[mo.getStocks().size()];
            for (int i = 0; i < mo.getStocks().size(); ++i) {
                storages[i] = mo.getStorageOrgUnit();
                materials[i] = mo.getStocks().get(i).getMaterial();
                units[i] = mo.getStocks().get(i).getUnit();
            }
            SCMEntryDataVO vo = new SCMEntryDataVO();
            vo.setIsLoadingMmuPrecision(true);
            vo.setMaterialInfos(materials);
            vo.setMeasureUnitInfos(units);
            vo.setStorageOrgUnitInfos(storages);
            vo.setIsLoadingMaterialPlan(true);
            vo.setIsLoadingMaterialInventory(false);
            vo.setIsLoadingMaterialInfo(false);
            SCMEntryDataVO voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(vo);
            StringBuffer sqlBuf = new StringBuffer();
            String[] sqls = new String[mo.getStocks().size()];
            String key = null;
            String storageOrgId = mo.getStorageOrgUnit().getId().toString();
            MaterialPlanInfo mpInfo = null;
            if (bom != null) {
                inParam.put("BOM", bom);
                IRowSet rowSet = EMMManufactureOrderCTL._getWpSeq(ctx, inParam);
                try {
                    while (rowSet != null && rowSet.next()) {
                        String bomItemID = rowSet.getString("FBomItemID");
                        Integer wpSeq = new Integer(rowSet.getInt("FWpSeq"));
                        String operationID = rowSet.getString("FOperationID");
                        OperationInfo operationInfo = OperationFactory.getLocalInstance((Context)ctx).getOperationInfo((IObjectPK)new ObjectStringPK(operationID));
                        inParam.put(bomItemID, new Object[]{wpSeq, operationInfo});
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            HashMap<String, Object[]> bomMap = new HashMap<String, Object[]>();
            if (bom != null) {
                String locStr = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                sqlBuf.setLength(0);
                sqlBuf.append("select FSeq, FMaterialID, FBlueprint_").append(locStr).append(", FLocationID, FIsBackFlush ").append(" from t_mm_bomentry where FParentid = '").append(mo.getBomID()).append("'");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
                try {
                    while (rowSet != null && rowSet.next()) {
                        Integer seq = new Integer(rowSet.getInt("FSeq"));
                        String materialID = rowSet.getString("FMaterialID");
                        String blueprint = rowSet.getString("FBlueprint_" + locStr);
                        String locationID = rowSet.getString("FLocationID");
                        Boolean isBackFlush = new Boolean(rowSet.getBoolean("FIsBackFlush"));
                        bomMap.put(seq.toString() + "-" + materialID, new Object[]{blueprint, locationID, isBackFlush});
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            for (int i = 0; i < mo.getStocks().size(); ++i) {
                BigDecimal newNetWeight;
                BigDecimal lackRatio;
                BigDecimal extraRatio;
                ManufactureOrderStockInfo entry = mo.getStocks().get(i);
                String materialId = entry.getMaterial().getId().toString();
                key = materialId + storageOrgId;
                mpInfo = (MaterialPlanInfo)voResult.getMaterialPlanInfos().get(key);
                key = materialId + entry.getUnit().getId().toString();
                int prec = 4;
                if (voResult.getMmuPrecisions().get(key) != null) {
                    prec = (Integer)voResult.getMmuPrecisions().get(key);
                }
                if ((extraRatio = mpInfo.getIssInHightLimit()) == null || extraRatio.compareTo(new BigDecimal("0.00")) == 0) {
                    extraRatio = new BigDecimal("0.00");
                }
                if ((lackRatio = mpInfo.getIssInLowLimit()) == null || lackRatio.compareTo(new BigDecimal("0.00")) == 0) {
                    lackRatio = new BigDecimal("0.00");
                }
                newNetWeight = null != (newNetWeight = entry.getNewnetWeight()) && newNetWeight.compareTo(new BigDecimal("0.00")) != 0 ? newNetWeight.setScale(8, 4) : new BigDecimal("0.00");
                BigDecimal unitQty = entry.getUnitQty();
                unitQty = null != unitQty && unitQty.compareTo(new BigDecimal("0.00")) != 0 ? unitQty.setScale(8, 4) : new BigDecimal("1");
                BigDecimal planQty = entry.getPlannedQty();
                planQty = planQty == null || planQty.compareTo(new BigDecimal("0.00")) == 0 ? new BigDecimal("0.00") : planQty.setScale(8, 4);
                BigDecimal LossRatio = entry.getLossRatio();
                LossRatio = null != LossRatio && LossRatio.compareTo(new BigDecimal("0.00")) != 0 ? LossRatio.setScale(8, 4) : new BigDecimal("0");
                BigDecimal LossQty = entry.getLossQty();
                LossQty = null != LossQty && LossQty.compareTo(new BigDecimal("0.00")) != 0 ? LossQty.setScale(8, 4) : new BigDecimal("0");
                String blueprint = null;
                String locationID = null;
                Boolean isBackFlush = null;
                if (bomMap != null && bomMap.size() > 0) {
                    Set bomSet = bomMap.keySet();
                    Iterator bomIt = bomSet.iterator();
                    String pk = null;
                    Object[] values = null;
                    while (bomIt.hasNext()) {
                        pk = (String)bomIt.next();
                        if (pk.indexOf("-" + materialId) <= 0) continue;
                        values = (Object[])bomMap.get(pk);
                        blueprint = (String)values[0];
                        locationID = (String)values[1];
                        isBackFlush = (Boolean)values[2];
                        break;
                    }
                }
                sqlBuf.setLength(0);
                sqlBuf.append("insert into ").append(expandTablName).append(" ").append("\r\n").append("(fid,fmaterialid,funitid,fbaseunitid,fPrec,FReplaceMode,").append("FIssMode,FIsQuotaControl,FIssInHightLimit,FIssInLowLimit,FBOMDefWarehouseID,").append("FRoutingItemID,FMaterialAttr,flevel,").append("funitQty,fQty,fPlannedQty,fscrapQty,fscrapRate,FScrapRateExpression,FDemandTime,FNetWeight,FBlkSize,FSpecifiedLength, ").append(" FBomEntryId, FProvideType, FSupplyStorageId ");
                if (bom != null) {
                    sqlBuf.append(", FBlueprint, FLocationID, FIsBackFlush )");
                } else {
                    sqlBuf.append(" )");
                }
                sqlBuf.append("\r\n").append("VALUES(").append("newbosid('12345678'),").append("'").append(entry.getMaterial().getId().toString()).append("',").append("'").append(entry.getUnit().getId().toString()).append("',").append("'").append(entry.getBaseUnit().getId().toString()).append("',").append(prec).append(",0,").append(mpInfo.getIssMode().getValue()).append(",").append(mpInfo.isIsQuotaControl() ? 1 : 0).append(",to_decimal(").append(extraRatio).append(",21,8),to_decimal(").append(lackRatio).append(",21,8),NULL,NULL,").append(mpInfo.getMaterialAttr().getValue()).append(",0,").append("to_decimal(").append(unitQty).append(",21,8)").append(",to_decimal(").append(planQty).append(",21,8),to_decimal(").append(planQty).append(",21,8),").append("to_decimal(").append(LossQty).append(",21,8),to_decimal(").append(LossRatio).append(",21,8),").append(mpInfo.getScrapRateExpression().getValue()).append(",").append("to_date('").append(MRPUtil.dateToString((Date)entry.getDemandTime())).append("'),").append("to_decimal(").append(newNetWeight).append(",21,8),'");
                if (entry.getBlkSize() == null) {
                    sqlBuf.append("','");
                } else {
                    sqlBuf.append(entry.getBlkSize()).append("','");
                }
                if (entry.getSpecifiedLength() == null) {
                    sqlBuf.append("', ");
                } else {
                    sqlBuf.append(entry.getSpecifiedLength()).append("', ");
                }
                if (entry.getBomEntryID() != null) {
                    sqlBuf.append("'").append(entry.getBomEntryID()).append("', ");
                } else {
                    sqlBuf.append(" NULL, ");
                }
                if (entry.getProvideType() != null) {
                    sqlBuf.append(entry.getProvideType().getValue()).append(", ");
                } else {
                    sqlBuf.append(" NULL, ");
                }
                if (entry.getStorageOrgUnit() != null) {
                    sqlBuf.append("'").append(entry.getStorageOrgUnit().getId().toString()).append("' ");
                } else {
                    sqlBuf.append(" NULL ");
                }
                if (bom != null) {
                    if (blueprint != null) {
                        sqlBuf.append(", '").append(blueprint).append("'");
                    } else {
                        sqlBuf.append(", NULL ");
                    }
                    if (locationID != null) {
                        sqlBuf.append(", '").append(locationID).append("'");
                    } else {
                        sqlBuf.append(", NULL ");
                    }
                    if (isBackFlush != null) {
                        sqlBuf.append(", ").append(isBackFlush != false ? 1 : 0);
                    } else {
                        sqlBuf.append(", ").append(mpInfo.isIsBackFlush() ? 1 : 0);
                    }
                }
                sqlBuf.append(")");
                sqls[i] = sqlBuf.toString();
            }
            SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
            inParam.put("RECALC", Boolean.FALSE);
            inParam.put("TABLENAME", expandTablName);
            ManufactureOrderStockCollection stocks = EMMManufactureOrderEXCTL.buildStock(ctx, inParam);
            outParam.put("STOCKS", stocks);
        }
        finally {
            if (expandTablName != null) {
                TempTablePool pool = TempTablePool.getInstance((Context)ctx);
                pool.releaseTable(expandTablName);
            }
        }
    }

    public static void updateRowStatus(Context ctx, EntryBaseStatusEnum baseStatus, String fids) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_MM_MFTOrderTechnics technics set fbasestatus = ").append(baseStatus.getValue());
        sb.append(" where technics.fparentid in (").append(fids).append(")");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb.setLength(0);
    }

    public static Map getEMMManufactureDataByInfo(Map inParam) throws BOSException, EASBizException {
        HashMap<String, Object> retData = new HashMap<String, Object>();
        Map stocks = EMMManufactureOrderEntrysGenFacadeFactory.getRemoteInstance().genStocksEntrys(inParam);
        Map technics = EMMManufactureOrderEntrysGenFacadeFactory.getRemoteInstance().genTechnicsEntrys(inParam);
        ManufactureOrderInfo stocksInfo = (ManufactureOrderInfo)stocks.get("ManufactureOrderInfo");
        ManufactureOrderInfo technicsInfo = (ManufactureOrderInfo)technics.get("ManufactureOrderInfo");
        StorageOrgUnitInfo storageOrg = stocksInfo.getStorageOrgUnit();
        MaterialInfo material = stocksInfo.getMaterial();
        MeasureUnitInfo unit = stocksInfo.getUnit();
        MeasureUnitInfo baseUnit = stocksInfo.getBaseUnit();
        StandardRootingInfo routing = stocksInfo.getRouting();
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        if (storageOrg != null && material != null && unit != null && baseUnit != null) {
            SCMEntryDataVO vo = new SCMEntryDataVO();
            vo.setMaterialInfos(new MaterialInfo[]{material});
            vo.setStorageOrgUnitInfos(new StorageOrgUnitInfo[]{storageOrg});
            vo.setIsLoadingMou(true);
            vo.setIsLoadingMmuPrecision(true);
            vo.setIsLoadingMaterialPlan(false);
            vo.setIsLoadingMaterialInventory(false);
            vo.setMeasureUnitInfos(new MeasureUnitInfo[]{unit});
            vo.setBaseMeasureUnitInfos(new MeasureUnitInfo[]{baseUnit});
            vo.setAssistMeasureUnitInfos(new MeasureUnitInfo[]{null});
            try {
                voResult = SCMGroupFacadeFactory.getRemoteInstance().loadComplexData(vo);
            }
            catch (Exception e) {
                throw new BOSException(HQXMSCDDBT_INFO);
            }
        }
        retData.put("VO_ENTRY", voResult);
        retData.put("ROUTING", routing);
        retData.put("STOCKS", stocksInfo.getStocks());
        retData.put("TECHNICS", technicsInfo.getTechnics());
        retData.put("EXPECTOUTPUTS", null);
        retData.put("TECHNICSEX", null);
        return retData;
    }

    public static boolean checkManufactureOrderChangeBill(Context ctx, HashSet ids) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("parent.billBaseStatus", (Object)4, CompareType.EQUALS));
        filterinfo.getFilterItems().add(new FilterItemInfo("manuOrder", (Object)ids, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        view.setSelector(sic);
        view.setFilter(filterinfo);
        EMMManufactureOrderChangeEntryCollection colls = null;
        colls = ctx == null ? EMMManufactureOrderChangeEntryFactory.getRemoteInstance().getEMMManufactureOrderChangeEntryCollection(view) : EMMManufactureOrderChangeEntryFactory.getLocalInstance(ctx).getEMMManufactureOrderChangeEntryCollection(view);
        if (colls != null && colls.size() > 0) {
            ctx.put((Object)"EMMMOCE_COLLS", (Object)colls);
            return true;
        }
        return false;
    }

    public static boolean checkManufactureStockTransferPlanBill(Context ctx, HashSet ids) throws EASBizException, BOSException {
        StringBuffer sbStr = new StringBuffer();
        String manufactureOrderids = SQLUtil.arrayToString((Object[])ids.toArray());
        sbStr.append("select * from ct_mo_stocktransferplandetial b where b.fentrysourcebillid in").append("(select fid from t_mm_mftorderstock a where a.fparentid in (").append(manufactureOrderids).append(")) and b.cftransferstatus in (1, 2)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbStr.toString());
        try {
            return rs.next();
        }
        catch (SQLException ex) {
            throw new EASBizException(new NumericExceptionSubItem(CXSFCZXYDBJH_FAIL, ex.getMessage()));
        }
    }
}

