/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.base.DbExecuteUtilFacadeFactory;
import com.kingdee.eas.emm.mo.EMMManufactureOrderChangeEntryCollection;
import com.kingdee.eas.emm.mo.EMMManufactureOrderChangeFactory;
import com.kingdee.eas.emm.mo.EMMManufactureOrderChangeInfo;
import com.kingdee.eas.emm.mo.client.AbstractEMMManufactureOrderChangeEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.multiDetail.DetailPanelEvent;
import com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener;
import com.kingdee.eas.industry.emm.common.BillBaseStatusEnum;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class EMMManufactureOrderChangeEditUI
extends AbstractEMMManufactureOrderChangeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EMMManufactureOrderChangeEditUI.class);
    private String NUMBER_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"NUMBER_ISNOTNULL");
    private String STORAGE_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"STORAGE_ISNOTNULL");
    private String BGYY_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"BGYY_ISNOTNULL");
    private String YWRQ_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"YWRQ_ISNOTNULL");
    private String ENTRY_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"ENTRY_ISNOTNULL");
    private String ENTRY_HEADER = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"ENTRY_ISNOTNULL");
    private String MFT_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"MFT_ISNOTNULL");
    private String MATERIAL_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"MATERIAL_ISNOTNULL");
    private String MFTSTATUS_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"MFTSTATUS_ISNOTNULL");
    private String HYSL_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HYSL_ISNOTNULL");
    private String HXSL_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HXSL_ISNOTNULL");
    private String HYJHKGRQ_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HYJHKGRQ_ISNOTNULL");
    private String HXJHKGRQ_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HXJHKGRQ_ISNOTNULL");
    private String HYJHWGRQ_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HYJHWGRQ_ISNOTNULL");
    private String HXJHWGRQ_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HXJHWGRQ_ISNOTNULL");
    private String HSCDDZTBSSH_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HSCDDZTBSSH_INFO");
    private String HSJMZGB_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HSJMZGB_INFO");
    private String HXJHKGDYWG_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HXJHKGDYWG_INFO");
    private String DJYSH_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"DJYSH_INFO");
    private String DJWTJ_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"DJWTJ_INFO");
    private String SUCCESS_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"SUCCESS_INFO");
    private String TJZTDDJBXBC_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"TJZTDDJBXBC_INFO");
    private String DJYSH_NOTMODIFY = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"DJYSH_NOTMODIFY");
    private String DJYSH_NODELETE = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"DJYSH_NODELETE");
    private String HYD_FLAG = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HYD_FLAG");
    private String HSCDDCF_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HSCDDCF_INFO");
    private String HCF_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"HCF_INFO");
    private Map mapManuOrder = new HashMap();

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtstorageOrgUnit.setFilterInfoProducer(null);
        this.prmtstorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                StorageOrgUnitInfo oldOrg = null;
                StorageOrgUnitInfo newOrg = null;
                try {
                    if (eventObj.getOldValue() != null) {
                        oldOrg = (StorageOrgUnitInfo)eventObj.getOldValue();
                    }
                    if (eventObj.getNewValue() != null) {
                        newOrg = (StorageOrgUnitInfo)eventObj.getNewValue();
                    }
                    if (newOrg == null) {
                        EMMManufactureOrderChangeEditUI.this.txtNumber.setText(null);
                    } else if (oldOrg != null) {
                        if (!oldOrg.getId().toString().equals(newOrg.getId().toString())) {
                            EMMManufactureOrderChangeEditUI.this.txtNumber.setText(EMMManufactureOrderChangeEditUI.this.getBillNumber((IObjectValue)EMMManufactureOrderChangeEditUI.this.editData, newOrg.getId().toString()));
                        }
                    } else if (EMMManufactureOrderChangeEditUI.this.prmtstorageOrgUnit.getValue() != null) {
                        EMMManufactureOrderChangeEditUI.this.txtNumber.setText(EMMManufactureOrderChangeEditUI.this.getBillNumber((IObjectValue)EMMManufactureOrderChangeEditUI.this.editData, newOrg.getId().toString()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                EMMManufactureOrderChangeEditUI.this.setEntry(true);
            }
        });
        this.setEntry(false);
        this.kdtEntrys_detailPanel.addAddListener(new IDetailPanelListener(){

            public void afterEvent(DetailPanelEvent event) throws Exception {
                IObjectValue vo = event.getObjectValue();
                vo.put("orderStatus", (Object)0);
                EMMManufactureOrderChangeEditUI.this.setManuOrder();
            }

            public void beforeEvent(DetailPanelEvent event) throws Exception {
                IObjectValue vo = event.getObjectValue();
                vo.put("orderStatus", (Object)0);
            }
        });
        this.kdtEntrys_detailPanel.addInsertListener(new IDetailPanelListener(){

            public void afterEvent(DetailPanelEvent arg0) throws Exception {
                EMMManufactureOrderChangeEditUI.this.setManuOrder();
            }

            public void beforeEvent(DetailPanelEvent arg0) throws Exception {
                IObjectValue vo = arg0.getObjectValue();
                vo.put("orderStatus", (Object)0);
            }
        });
        this.kdtEntrys_detailPanel.addRemoveListener(new IDetailPanelListener(){

            public void afterEvent(DetailPanelEvent arg0) throws Exception {
                EMMManufactureOrderChangeEditUI.this.setManuOrder();
            }

            public void beforeEvent(DetailPanelEvent arg0) throws Exception {
            }
        });
        FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (String)"emmmocadd");
        StorageOrgUnitInfo info = null;
        StorageOrgUnitInfo storageOrgInfo = SysContext.getSysContext().getCurrentStorageUnit();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        ArrayList<String> numberLs = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            info = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(collection.get(i).getId().toString()));
            keys.add(collection.get(i).getId().toString());
            if (!info.isIsBizUnit()) continue;
            String number = info.getNumber();
            numberLs.add(number);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtstorageOrgUnit.setEntityViewInfo(view);
        if (this.getOprtState().equals("ADDNEW")) {
            if (!storageOrgInfo.isIsBizUnit() || !keys.contains(storageOrgInfo.getId().toString())) {
                Collections.sort(numberLs);
                EntityViewInfo views = new EntityViewInfo();
                FilterInfo filters = new FilterInfo();
                if (numberLs.size() > 0) {
                    filters.getFilterItems().add(new FilterItemInfo("number", numberLs.get(0), CompareType.EQUALS));
                } else {
                    filters.getFilterItems().add(new FilterItemInfo("number", (Object)"", CompareType.EQUALS));
                }
                views.setFilter(filters);
                this.prmtstorageOrgUnit.setValue((Object)StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(views).get(0));
            } else {
                this.prmtstorageOrgUnit.setValue((Object)storageOrgInfo);
            }
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (this.editData != null && this.editData.getBillBaseStatus() != null && this.editData.getBillBaseStatus().getValue() == 4) {
            this.actionSubmit.setEnabled(false);
            this.btnSubmit.setEnabled(false);
        }
    }

    protected void setManuOrder() {
        if (this.kdtEntrys.getRowCount() > 0) {
            this.mapManuOrder.clear();
            for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
                IRow row = this.kdtEntrys.getRow(i);
                this.mapManuOrder.put(i, row.getCell("manuOrder").getValue());
            }
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)this.getUITitle());
        this.setManuOrder();
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
        super.applyDefaultValue(vo);
        if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
            vo.put("billBaseStatus", (Object)0);
        }
    }

    private void setEntry(boolean isRemove) {
        if (isRemove) {
            this.kdtEntrys.removeRows();
            this.kdtEntrys.addRow();
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
            this.kdtEntrys.addRow();
        }
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        KDBizPromptBox prmtManuOrder = new KDBizPromptBox();
        prmtManuOrder.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7ManufactureOrderQuery");
        prmtManuOrder.setDisplayFormat("$number$");
        prmtManuOrder.setEditFormat("$number$");
        prmtManuOrder.setCommitFormat("$number$");
        prmtManuOrder.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent paramSelectorEvent) {
                KDBizPromptBox promptbox = (KDBizPromptBox)paramSelectorEvent.getSource();
                EntityViewInfo view = new EntityViewInfo();
                HashSet<String> set = new HashSet<String>();
                StringBuffer sql = new StringBuffer();
                sql.append(" select fid from t_mm_manufactureOrder where fid not in ( select fparentid FID from T_MM_MOSplitRecord union select FCHILDID FID from T_MM_MOSplitRecord)");
                try {
                    IRowSet row = DbExecuteUtilFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
                    while (row.next()) {
                        set.add(row.getString("fid"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                if (EMMManufactureOrderChangeEditUI.this.prmtstorageOrgUnit.getValue() != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)EMMManufactureOrderChangeEditUI.this.prmtstorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)5, CompareType.EQUALS));
                if (EMMManufactureOrderChangeEditUI.this.prmtstorageOrgUnit.getValue() == null) {
                    filterInfo.setMaskString("(#0 and #1 or #2) ");
                } else {
                    filterInfo.setMaskString("#0 and #1 and (#2 or #3)");
                }
                view.setFilter(filterInfo);
                promptbox.setEntityViewInfo(view);
                promptbox.getQueryAgent().resetRuntimeEntityView();
            }
        });
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.*"));
        prmtManuOrder.setSelectorCollection(sic);
        FilterInfo filter = new FilterInfo();
        if (this.prmtstorageOrgUnit.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)5, CompareType.EQUALS));
        if (this.prmtstorageOrgUnit.getValue() == null) {
            filter.setMaskString("(#0 or #1) ");
        } else {
            filter.setMaskString("#0 and (#1 or #2)");
        }
        HashSet<String> set = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from t_mm_manufactureOrder where fid not in ( select fparentid FID from T_MM_MOSplitRecord union select FCHILDID FID from T_MM_MOSplitRecord)");
        try {
            IRowSet row = DbExecuteUtilFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
            while (row.next()) {
                set.add(row.getString("fid"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        evi.setFilter(filter);
        prmtManuOrder.setEntityViewInfo(evi);
        prmtManuOrder.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                EMMManufactureOrderChangeEditUI.this.changeManuOrder(eventObj);
            }
        });
        this.kdtEntrys.getColumn("manuOrder").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtManuOrder));
        this.kdtEntrys.getColumn("manuOrder").setRenderer((IBasicRender)avr);
        final KDDatePicker pkNewPlanBeginDate = new KDDatePicker();
        pkNewPlanBeginDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                KDTSelectBlock selected = EMMManufactureOrderChangeEditUI.this.getDetailTable().getSelectManager().get();
                if (selected == null) {
                    return;
                }
                int selectedRow = selected.getBeginRow();
                Date newPlanBeginDate = null;
                Date newPlanEndDate = null;
                newPlanBeginDate = (Date)pkNewPlanBeginDate.getValue();
                newPlanEndDate = (Date)EMMManufactureOrderChangeEditUI.this.kdtEntrys.getCell(selectedRow, "newPlanEndDate").getValue();
                if (newPlanEndDate != null && newPlanBeginDate.compareTo(newPlanEndDate) == 1) {
                    EMMManufactureOrderChangeEditUI.this.kdtEntrys.getCell(selectedRow, "newPlanEndDate").setValue((Object)newPlanBeginDate);
                } else {
                    EMMManufactureOrderChangeEditUI.this.kdtEntrys.getCell(selectedRow, "newPlanBeginDate").setValue((Object)newPlanBeginDate);
                }
            }
        });
        this.kdtEntrys.getColumn("newPlanBeginDate").setEditor((ICellEditor)new KDTDefaultCellEditor(pkNewPlanBeginDate));
        this.kdtEntrys.getColumn("newPlanBeginDate").setRenderer((IBasicRender)avr);
        final KDDatePicker pkNewPlanEndDate = new KDDatePicker();
        pkNewPlanEndDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                KDTSelectBlock selected = EMMManufactureOrderChangeEditUI.this.getDetailTable().getSelectManager().get();
                if (selected == null) {
                    return;
                }
                int selectedRow = selected.getBeginRow();
                Date newPlanEndDate = null;
                Date oldPlanBeginDate = null;
                Date oldPlanEndDate = null;
                newPlanEndDate = (Date)pkNewPlanEndDate.getValue();
                oldPlanBeginDate = (Date)EMMManufactureOrderChangeEditUI.this.kdtEntrys.getCell(selectedRow, "oldPlanBeginDate").getValue();
                oldPlanEndDate = (Date)EMMManufactureOrderChangeEditUI.this.kdtEntrys.getCell(selectedRow, "oldPlanEndDate").getValue();
                long betweenDays = EMMManufactureOrderChangeEditUI.getDaySub(oldPlanBeginDate, oldPlanEndDate);
                Calendar c = Calendar.getInstance();
                c.setTime(newPlanEndDate);
                c.add(5, (int)(0L - betweenDays));
                EMMManufactureOrderChangeEditUI.this.kdtEntrys.getCell(selectedRow, "newPlanBeginDate").setValue((Object)c.getTime());
            }
        });
        this.kdtEntrys.getColumn("newPlanEndDate").setEditor((ICellEditor)new KDTDefaultCellEditor(pkNewPlanEndDate));
        this.kdtEntrys.getColumn("newPlanEndDate").setRenderer((IBasicRender)avr);
        KDFormattedTextField kdtEntrys_newQty_TextField = new KDFormattedTextField();
        kdtEntrys_newQty_TextField.setName("kdtEntrys_newQty_TextField");
        kdtEntrys_newQty_TextField.setVisible(true);
        kdtEntrys_newQty_TextField.setEditable(true);
        kdtEntrys_newQty_TextField.setHorizontalAlignment(2);
        kdtEntrys_newQty_TextField.setDataType(1);
        kdtEntrys_newQty_TextField.setMinimumValue((Comparable)new BigDecimal("0"));
        kdtEntrys_newQty_TextField.setMaximumValue((Comparable)new BigDecimal("1.0E18"));
        kdtEntrys_newQty_TextField.setPrecision(10);
        KDTDefaultCellEditor kdtEntrys_newQty_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_newQty_TextField);
        this.kdtEntrys.getColumn("newQty").setEditor((ICellEditor)kdtEntrys_newQty_CellEditor);
    }

    public static long getDaySub(Date beginDate, Date endDate) {
        Calendar calst = Calendar.getInstance();
        Calendar caled = Calendar.getInstance();
        calst.setTime(beginDate);
        caled.setTime(endDate);
        calst.set(11, 0);
        calst.set(12, 0);
        calst.set(13, 0);
        caled.set(11, 0);
        caled.set(12, 0);
        caled.set(13, 0);
        int days = ((int)(caled.getTime().getTime() / 1000L) - (int)(calst.getTime().getTime() / 1000L)) / 3600 / 24;
        return days;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (IndustryUtils.isEmptyString((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocusInWindow();
            MsgBox.showWarning((String)this.NUMBER_ISNOTNULL);
            SysUtil.abort();
        }
        if (this.prmtstorageOrgUnit.getValue() == null) {
            this.prmtstorageOrgUnit.requestFocusInWindow();
            MsgBox.showWarning((String)this.STORAGE_ISNOTNULL);
            SysUtil.abort();
        }
        if (IndustryUtils.isEmptyString((String)this.txtchangeReason.getText())) {
            this.txtchangeReason.requestFocusInWindow();
            MsgBox.showWarning((String)this.BGYY_ISNOTNULL);
            SysUtil.abort();
        }
        if (this.pkBizDate.getValue() == null) {
            this.pkBizDate.requestFocusInWindow();
            MsgBox.showWarning((String)this.YWRQ_ISNOTNULL);
            SysUtil.abort();
        }
        if (this.kdtEntrys.getRowCount() > 0) {
            for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
                IRow row = this.kdtEntrys.getRow(i);
                this.verifyRow(row, i);
            }
        } else {
            MsgBox.showWarning((String)this.ENTRY_ISNOTNULL);
            SysUtil.abort();
        }
    }

    protected void verifyRow(IRow row, int i) {
        ++i;
        ICell cell = row.getCell("manuOrder");
        if (cell.getValue() == null) {
            MsgBox.showWarning((String)(this.ENTRY_HEADER + i + this.MFT_ISNOTNULL));
            SysUtil.abort();
        }
        if ((cell = row.getCell("material")).getValue() == null) {
            MsgBox.showWarning((String)(this.ENTRY_HEADER + i + this.MATERIAL_ISNOTNULL));
            SysUtil.abort();
        }
        if ((cell = row.getCell("orderStatus")).getValue() == null) {
            MsgBox.showWarning((String)(this.ENTRY_HEADER + i + this.MFTSTATUS_ISNOTNULL));
            SysUtil.abort();
        }
        if ((cell = row.getCell("oldQty")).getValue() == null) {
            MsgBox.showWarning((String)(this.ENTRY_HEADER + i + this.HYSL_ISNOTNULL));
            SysUtil.abort();
        }
        if ((cell = row.getCell("newQty")).getValue() == null) {
            MsgBox.showWarning((String)(this.ENTRY_HEADER + i + this.HXSL_ISNOTNULL));
            SysUtil.abort();
        }
        if ((cell = row.getCell("oldPlanBeginDate")).getValue() == null) {
            MsgBox.showWarning((String)(this.ENTRY_HEADER + i + this.HYJHKGRQ_ISNOTNULL));
            SysUtil.abort();
        }
        if ((cell = row.getCell("newPlanBeginDate")).getValue() == null) {
            MsgBox.showWarning((String)(this.ENTRY_HEADER + i + this.HXJHKGRQ_ISNOTNULL));
            SysUtil.abort();
        }
        if ((cell = row.getCell("oldPlanEndDate")).getValue() == null) {
            MsgBox.showWarning((String)(this.ENTRY_HEADER + i + this.HYJHWGRQ_ISNOTNULL));
            SysUtil.abort();
        }
        if ((cell = row.getCell("newPlanEndDate")).getValue() == null) {
            MsgBox.showWarning((String)(this.ENTRY_HEADER + i + this.HXJHWGRQ_ISNOTNULL));
            SysUtil.abort();
        }
    }

    protected void changeManuOrder(DataChangeEvent e) {
        KDBizPromptBox bizBox = (KDBizPromptBox)e.getSource();
        KDTSelectBlock selected = this.getDetailTable().getSelectManager().get();
        if (selected == null) {
            return;
        }
        ManufactureOrderInfo Info = null;
        int selectedRow = selected.getBeginRow();
        if (bizBox.getValue() instanceof Object) {
            Info = (ManufactureOrderInfo)bizBox.getValue();
        }
        if (Info == null) {
            return;
        }
        if (Info.equals(this.mapManuOrder.get(selectedRow))) {
            return;
        }
        int qtyPrecision = 0;
        if (Info.getMaterial() != null) {
            try {
                IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
                MultiMeasureUnitInfo multiUnitInfo = imultiUnit.getMultiUnit(Info.getMaterial().getId().toString(), Info.getMaterial().getBaseUnit().getId().toString());
                if (multiUnitInfo != null) {
                    qtyPrecision = multiUnitInfo.getQtyPrecision();
                }
            }
            catch (Exception e2) {
                logger.error((Object)e2);
            }
        }
        KDTDefaultCellEditor editor = FormattedEditorFactory.getBigDecimalCellEditor((int)qtyPrecision, (boolean)true);
        String sFormat = PrecisionUtil.getFormatString((int)qtyPrecision);
        this.kdtEntrys.getCell(selectedRow, "oldQty").setEditor((ICellEditor)editor);
        this.kdtEntrys.getCell(selectedRow, "newQty").setEditor((ICellEditor)editor);
        this.kdtEntrys.getCell(selectedRow, "oldQty").getStyleAttributes().setNumberFormat(sFormat);
        this.kdtEntrys.getCell(selectedRow, "newQty").getStyleAttributes().setNumberFormat(sFormat);
        this.kdtEntrys.getCell(selectedRow, "material").setValue((Object)Info.getMaterial());
        this.kdtEntrys.getCell(selectedRow, "materialNum").setValue((Object)Info.getMaterial().getNumber());
        this.kdtEntrys.getCell(selectedRow, "materialModel").setValue((Object)Info.getMaterial().getModel());
        this.kdtEntrys.getCell(selectedRow, "orderStatus").setValue((Object)Info.getBaseStatus());
        this.kdtEntrys.getCell(selectedRow, "oldQty").setValue((Object)Info.getQty());
        this.kdtEntrys.getCell(selectedRow, "newQty").setValue((Object)Info.getQty());
        this.kdtEntrys.getCell(selectedRow, "oldPlanBeginDate").setValue((Object)Info.getPlanBeginDate());
        this.kdtEntrys.getCell(selectedRow, "newPlanBeginDate").setValue((Object)Info.getPlanBeginDate());
        this.kdtEntrys.getCell(selectedRow, "oldPlanEndDate").setValue((Object)Info.getPlanEndDate());
        this.kdtEntrys.getCell(selectedRow, "newPlanEndDate").setValue((Object)Info.getPlanEndDate());
        this.mapManuOrder.put(selectedRow, Info);
    }

    private void verifySubmit() throws Exception {
        IRow row;
        int i;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        HashMap<Object, Integer> mapManuOrder = new HashMap<Object, Integer>();
        if (this.kdtEntrys.getRowCount() > 0) {
            for (i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
                row = this.kdtEntrys.getRow(i);
                if (mapManuOrder.get(row.getCell("manuOrder").getValue()) != null) {
                    MsgBox.showWarning((String)(this.ENTRY_HEADER + (i + 1) + this.HYD_FLAG + mapManuOrder.get(row.getCell("manuOrder").getValue()) + this.HCF_INFO));
                    SysUtil.abort();
                }
                mapManuOrder.put(row.getCell("manuOrder").getValue(), i + 1);
            }
        }
        if (this.kdtEntrys.getRowCount() > 0) {
            for (i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
                row = this.kdtEntrys.getRow(i);
                if (row.getCell("newPlanBeginDate").getValue() == null || "".equals(row.getCell("newPlanBeginDate").getValue())) {
                    MsgBox.showWarning((String)(this.ENTRY_HEADER + (i + 1) + this.HXJHKGRQ_ISNOTNULL));
                    SysUtil.abort();
                }
                if (row.getCell("newPlanEndDate").getValue() == null || "".equals(row.getCell("newPlanEndDate").getValue())) {
                    MsgBox.showWarning((String)(this.ENTRY_HEADER + (i + 1) + this.HXJHWGRQ_ISNOTNULL));
                    SysUtil.abort();
                }
                if (com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED != row.getCell("orderStatus").getValue() && com.kingdee.eas.scm.common.BillBaseStatusEnum.RELEASED != row.getCell("orderStatus").getValue()) {
                    MsgBox.showWarning((String)(this.ENTRY_HEADER + (i + 1) + this.HSCDDZTBSSH_INFO));
                    SysUtil.abort();
                }
                if (row.getCell("oldQty").getValue().equals(row.getCell("newQty").getValue()) && row.getCell("oldPlanEndDate").getValue().equals(row.getCell("newPlanEndDate").getValue()) && row.getCell("oldPlanBeginDate").getValue().equals(row.getCell("newPlanBeginDate").getValue())) {
                    MsgBox.showWarning((String)(this.ENTRY_HEADER + (i + 1) + this.HSJMZGB_INFO));
                    SysUtil.abort();
                }
                if (((Date)row.getCell("newPlanBeginDate").getValue()).compareTo((Date)row.getCell("newPlanEndDate").getValue()) != 1) continue;
                MsgBox.showWarning((String)(this.ENTRY_HEADER + (i + 1) + this.HXJHKGDYWG_INFO));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBillBaseStatus().getValue() == 4) {
            MsgBox.showWarning((String)this.DJYSH_INFO);
            SysUtil.abort();
        }
        if (this.editData.getBillBaseStatus().getValue() != 2) {
            MsgBox.showWarning((String)this.DJWTJ_INFO);
            SysUtil.abort();
        }
        EMMManufactureOrderChangeFactory.getRemoteInstance().passAudit((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()), this.editData);
        this.afterDoAction(e, (IObjectPK)new ObjectUuidPK(this.editData.getId().toString()), this.SUCCESS_INFO);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            int qtyPrecision = 0;
            if (this.editData.getEntrys().get(i) != null) {
                try {
                    MaterialInfo info = this.editData.getEntrys().get(i).getMaterial();
                    IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
                    MultiMeasureUnitInfo multiUnitInfo = imultiUnit.getMultiUnit(info.getId().toString(), info.getBaseUnit().getId().toString());
                    if (multiUnitInfo != null) {
                        qtyPrecision = multiUnitInfo.getQtyPrecision();
                    }
                }
                catch (Exception e2) {
                    logger.error((Object)e2);
                }
            }
            KDTDefaultCellEditor editor = FormattedEditorFactory.getBigDecimalCellEditor((int)qtyPrecision, (boolean)true);
            String sFormat = PrecisionUtil.getFormatString((int)qtyPrecision);
            this.kdtEntrys.getCell(i, "oldQty").setEditor((ICellEditor)editor);
            this.kdtEntrys.getCell(i, "newQty").setEditor((ICellEditor)editor);
            this.kdtEntrys.getCell(i, "oldQty").getStyleAttributes().setNumberFormat(sFormat);
            this.kdtEntrys.getCell(i, "newQty").getStyleAttributes().setNumberFormat(sFormat);
        }
        if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
            this.pkBizDate.setValue((Object)new Date());
        }
        this.setSave(true);
        this.setSaved(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddLine_actionPerformed(e);
    }

    protected void menuItemEnterToNextRow_itemStateChanged(ItemEvent e) throws Exception {
        super.menuItemEnterToNextRow_itemStateChanged(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionXunTongFeed_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBillBaseStatus().getValue() == 2) {
            MsgBox.showWarning((String)this.TJZTDDJBXBC_INFO);
            SysUtil.abort();
        }
        HashMap<Object, String> mapOrder = new HashMap<Object, String>();
        if (this.kdtEntrys.getRowCount() > 0) {
            for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
                IRow row = this.kdtEntrys.getRow(i);
                if (mapOrder.get(row.getCell("manuOrder").getValue()) != null) {
                    MsgBox.showWarning((String)(this.ENTRY_HEADER + (String)mapOrder.get(row.getCell("manuOrder").getValue()) + this.HYD_FLAG + (i + 1) + this.HSCDDCF_INFO));
                    SysUtil.abort();
                    continue;
                }
                mapOrder.put(row.getCell("manuOrder").getValue(), String.valueOf(i + 1));
            }
        }
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk;
        ObjectUuidPK objectUuidPK = this.editData == null ? null : (pk = this.editData.getId() == null ? null : new ObjectUuidPK(this.editData.getId().toString()));
        if (this.editData.getBillBaseStatus().getValue() == 4) {
            MsgBox.showWarning((String)this.DJYSH_INFO);
            SysUtil.abort();
        }
        this.verifySubmit();
        super.actionSubmit_actionPerformed(e);
        this.setSave(true);
        this.setSaved(true);
    }

    private void afterDoAction(ActionEvent e, IObjectPK pk, String msg) throws Exception {
        this.setShowMessagePolicy(0);
        this.setMessageText(msg);
        this.setIsShowTextOnly(true);
        this.showMessage();
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    private void setCopyEntry() throws BOSException {
        HashSet<String> orderSet = new HashSet<String>();
        EMMManufactureOrderChangeEntryCollection EMMMOCEC = this.editData.getEntrys();
        for (int i = 0; i < EMMMOCEC.size(); ++i) {
            if (EMMMOCEC.get(i).getManuOrder() == null) continue;
            orderSet.add(EMMMOCEC.get(i).getManuOrder().getId().toString());
        }
        Object msg = null;
        ManufactureOrderCollection orderCollection = null;
        IManufactureOrder order = ManufactureOrderFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        ev.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", orderSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        orderCollection = order.getManufactureOrderCollection(ev);
        for (int i = 0; i < this.editData.getEntrys().size(); ++i) {
            for (int j = 0; j < orderCollection.size(); ++j) {
                ManufactureOrderInfo mo = orderCollection.get(j);
                if (!this.editData.getEntrys().get(i).getManuOrder().getId().toString().equals(mo.getId().toString())) continue;
                this.editData.getEntrys().get(i).setOldQty(mo.getQty());
                this.editData.getEntrys().get(i).setNewQty(mo.getQty());
                this.editData.getEntrys().get(i).setOldPlanBeginDate(mo.getPlanBeginDate());
                this.editData.getEntrys().get(i).setNewPlanBeginDate(mo.getPlanBeginDate());
                this.editData.getEntrys().get(i).setOldPlanEndDate(mo.getPlanEndDate());
                this.editData.getEntrys().get(i).setNewPlanEndDate(mo.getPlanEndDate());
            }
        }
    }

    public void beforeActionPerformed(ActionEvent e) {
        if (this.btnCopy == e.getSource()) {
            try {
                this.setCopyEntry();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
                MsgBox.showError((String)e1.getMessage());
            }
        }
        super.beforeActionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setBillBaseStatus(BillBaseStatusEnum.ADD);
        this.editData.setAuditor(null);
        this.editData.setAuditTime(null);
        this.editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        this.editData.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.editData.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        this.editData.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBillBaseStatus().getValue() == 4) {
            MsgBox.showWarning((String)this.DJYSH_NOTMODIFY);
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBillBaseStatus().getValue() == 4) {
            MsgBox.showWarning((String)this.DJYSH_NODELETE);
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateFrom_actionPerformed(e);
    }

    public void actionCopyFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyFrom_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionViewSubmitProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSubmitProccess_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionSendingMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendingMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actionViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSignature_actionPerformed(e);
    }

    public void actionSendMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMail_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionNumberSign_actionPerformed(ActionEvent e) throws Exception {
        super.actionNumberSign_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EMMManufactureOrderChangeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        EMMManufactureOrderChangeInfo objectValue = new EMMManufactureOrderChangeInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage")).getBoolean("isBizUnit")) {
            objectValue.put("storageOrgUnit", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage")));
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    protected String getBillNumber(IObjectValue billInfo, String bizOrgUnitID) throws Exception {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getRemoteInstance().getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getRemoteInstance().getNumber(billInfo, ruleInfo);
        }
        return billNumber;
    }
}

