/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.emm.mo.client.AbstractEMMManufactureOrderChangeFilterUI;
import com.kingdee.eas.industry.emm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class EMMManufactureOrderChangeFilterUI
extends AbstractEMMManufactureOrderChangeFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EMMManufactureOrderChangeFilterUI.class);
    private String STORAGE_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"STORAGE_ISNOTNULL");
    protected SelectorListener f7SelectorListener = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorage;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.setFilter();
        this.setSingleFilterElement();
        this.addListener();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void setFilter() throws BOSException {
        StorageOrgUnitInfo storageOrgInfo = SysContext.getSysContext().getCurrentStorageUnit();
        this.prmtStorage.setQueryInfo("com.kingdee.eas.scm.im.inv.app.F7StorageOrgUnitQuery");
        FilterInfo filter = new FilterInfo();
        OrgUnitInfo[] orgs = EMMManufactureOrderChangeFilterUI.getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), "emmmocview");
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.length; ++i) {
            keys.add(orgs[i].getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isbizunit", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        this.prmtStorage.setEntityViewInfo(view);
        if (!storageOrgInfo.isIsBizUnit() || !keys.contains(storageOrgInfo.getId().toString())) {
            storageOrgInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view).get(0);
            this.prmtStorage.setValue((Object)storageOrgInfo);
        } else {
            this.prmtStorage.setValue((Object)storageOrgInfo);
        }
        this.prmtStorage.setEnabledMultiSelection(true);
        this.prmtStorage.setDisplayFormat("$name$");
        this.prmtStorage.setEditFormat("$number$");
        this.prmtStorage.setCommitFormat("$number$");
        this.status.removeItem((Object)BillBaseStatusEnum.ADD);
        this.status.removeItem((Object)BillBaseStatusEnum.AFFIRM);
        this.status.removeItem((Object)BillBaseStatusEnum.ALREADYTURN);
        this.status.removeItem((Object)BillBaseStatusEnum.ALTERING);
        this.status.removeItem((Object)BillBaseStatusEnum.BLOCKED);
        this.status.removeItem((Object)BillBaseStatusEnum.CLOSED);
        this.status.removeItem((Object)BillBaseStatusEnum.COMPLETE);
        this.status.removeItem((Object)BillBaseStatusEnum.DELETED);
        this.status.removeItem((Object)BillBaseStatusEnum.DISPOSEING);
        this.status.removeItem((Object)BillBaseStatusEnum.EDITED);
        this.status.removeItem((Object)BillBaseStatusEnum.FINCLOSED);
        this.status.removeItem((Object)BillBaseStatusEnum.FINISH);
        this.status.removeItem((Object)BillBaseStatusEnum.OPER);
        this.status.removeItem((Object)BillBaseStatusEnum.PUBLISHED);
        this.status.removeItem((Object)BillBaseStatusEnum.RELEASED);
        this.status.removeItem((Object)BillBaseStatusEnum.REVIEW);
        this.status.removeItem((Object)BillBaseStatusEnum.REVIEWCOMPLETE);
        this.status.removeItem((Object)BillBaseStatusEnum.VERSION);
    }

    protected void addListener() {
        if (this.f7SelectorListener == null) {
            this.f7SelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        EMMManufactureOrderChangeFilterUI.this.f7WillShow(e);
                    }
                    catch (Exception exc) {
                        EMMManufactureOrderChangeFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtManuFactureNum.addSelectorListener(this.f7SelectorListener);
        this.prmtManuFactureTo.addSelectorListener(this.f7SelectorListener);
    }

    protected void removeListener() {
        if (this.f7SelectorListener != null) {
            this.prmtManuFactureNum.removeSelectorListener(this.f7SelectorListener);
            this.prmtManuFactureTo.removeSelectorListener(this.f7SelectorListener);
        }
    }

    protected void f7WillShow(SelectorEvent e) {
        KDBizPromptBox f7PromptBox;
        KDBizPromptBox kDBizPromptBox = e == null ? null : (e.getSource() == null ? null : (f7PromptBox = e.getSource() instanceof KDBizPromptBox ? (KDBizPromptBox)e.getSource() : null));
        if (f7PromptBox == null) {
            return;
        }
        f7PromptBox.getName();
        this.setFilterInfo(f7PromptBox);
    }

    protected void setFilterInfo(KDBizPromptBox f7PromptBox) {
        Object[] objectArray;
        if (f7PromptBox == null) {
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> storageOrgUnitIDs = new HashSet<String>();
        Object storageValue = this.prmtStorage.getValue();
        if (storageValue instanceof Object[]) {
            objectArray = (Object[])storageValue;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = storageValue;
        }
        Object[] storageObjects = objectArray;
        if (storageObjects != null && storageObjects.length > 0) {
            for (Object storageObject : storageObjects) {
                String storageID;
                StorageOrgUnitInfo storageInfo;
                StorageOrgUnitInfo storageOrgUnitInfo = storageObject == null ? null : (storageInfo = storageObject instanceof StorageOrgUnitInfo ? (StorageOrgUnitInfo)storageObject : null);
                String string = storageInfo == null ? null : (storageID = storageInfo.getId() == null ? null : storageInfo.getId().toString());
                if (storageID == null || storageID.trim().length() <= 0) continue;
                storageOrgUnitIDs.add(storageID);
            }
        }
        if (storageOrgUnitIDs != null && storageOrgUnitIDs.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", storageOrgUnitIDs, CompareType.INCLUDE));
        }
        entityViewInfo.setFilter(filterInfo);
        f7PromptBox.setEntityViewInfo(entityViewInfo);
        f7PromptBox.getQueryAgent().resetRuntimeEntityView();
    }

    public void setSingleFilterElement() throws BOSException {
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorage);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.STORAGE_ISNOTNULL));
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorage));
        elements.add((FilterElement)new RangeFilterElement("entrys.manuOrder.number", (Component)this.prmtManuFactureNum, (Component)this.prmtManuFactureTo));
        elements.add((FilterElement)new RangeFilterElement("entrys.materialNum", (Component)this.prmtMaterialNum, (Component)this.prmtMaterialTo));
        elements.add((FilterElement)new SingleFilterElement("billBaseStatus", (Component)this.status, (Object)BillBaseStatusEnum.NULL));
        RangeFilterElement bizDates = new RangeFilterElement("bizDate", (Component)this.bizDate, (Component)this.bizToDate);
        elements.add((FilterElement)bizDates);
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
    }

    public static OrgUnitInfo[] getAuthorizedBizOrgUnits(IObjectPK userPK, OrgType orgType, String permissionItem) {
        OrgUnitCollection collection = EMMManufactureOrderChangeFilterUI.getAuthOrgByPermItem(userPK, orgType, permissionItem);
        int size = collection.size();
        OrgUnitInfo[] results = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = collection.toArray();
            System.arraycopy(objects, 0, results, 0, size);
        }
        return results;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(IObjectPK userPK, OrgType orgType, String permItem) {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = null;
        FullOrgUnitCollection result = null;
        try {
            permission = PermissionFactory.getRemoteInstance();
            result = permission.getAuthorizedOrg(userPK, orgType, null, permItem);
        }
        catch (EASBizException e) {
            return collection;
        }
        catch (BOSException e) {
            return collection;
        }
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    protected Date getLastMonthDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.roll(2, -1);
        return calendar.getTime();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.bizToDate.setValue((Object)new Date());
        this.bizDate.setValue((Object)this.getLastMonthDate());
    }
}

