/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.emm.mo.EMMManufactureOrderFacadeFactory;
import com.kingdee.eas.emm.mo.client.AbstractEMMManufactureOrderSplitEditUI;
import com.kingdee.eas.emm.mo.client.EMMManufactureOrderEditUI;
import com.kingdee.eas.emm.mo.client.EMMManufactureOrderTreeUI;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.StandardRootingCollection;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.MMCommonUtils;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import com.kingdee.eas.mm.mo.MOSplitLotModeEnum;
import com.kingdee.eas.mm.mo.MOSplitTypeEnum;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderSplitException;
import com.kingdee.eas.mm.mo.ManufactureOrderSplitFacadeFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.client.BomPromptSelector;
import com.kingdee.eas.mm.mo.client.RoutingPromptSelector;
import com.kingdee.eas.mm.mo.util.MOProductTransactionTypeUtil;
import com.kingdee.eas.mm.mo.util.MORootingUtil;
import com.kingdee.eas.mm.mo.util.NumericUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EMMManufactureOrderSplitEditUI
extends AbstractEMMManufactureOrderSplitEditUI {
    private static final long serialVersionUID = -8350776871631335819L;
    private static final Logger logger = CoreUIObject.getLogger(EMMManufactureOrderSplitEditUI.class);
    private static final Color NECESSARY_BACKGROUND_COLOR = new Color(252, 251, 223);
    private static final BigDecimal BIG_DECIMAL_ZERO = new BigDecimal("0.0000");
    private static final Integer INTEGER_ZERO = new Integer("0");
    private static final Integer INTEGER_ONE = new Integer("1");
    private ManufactureOrderInfo mo = null;
    private BomInfo bom = null;
    private StorageOrgUnitInfo storageOrgUnitInfo = null;
    private Integer precision;
    private F7ContextManager f7Manager = null;
    private ItemListener splitTypeChangeListener = null;
    private ItemListener lotModeChangeListener = null;
    private DataChangeListener splitQtyChangeListener = null;
    private SelectorListener routingSelectorListener = null;
    private SelectorListener bomSelectorListener = null;
    private DataChangeListener materialChangedListener = null;
    private DataChangeListener adminOrgChangedListener = null;
    private DataChangeListener projectChangedListener = null;
    private DataChangeListener trackChangedListener = null;
    private FocusListener focusListener = null;
    private InputVerifier inputVerifier = null;
    private int choice = 1;
    private BizTypeInfo bizTypeStandard = null;
    private ProductTransactionTypeInfo transTypeStandard = null;
    private BizTypeInfo bizTypeReform = null;
    private ProductTransactionTypeInfo transTypeReform = null;
    private boolean isLotEnabled = false;
    private LotParamValueInfo lpv = null;
    private DataChangeListener workDateChangeListener = null;
    private Map materialPlanMap = null;
    private static final int PRECISION_MAX = 8;
    private static final BigDecimal DECIMAL_ZERO = new BigDecimal("0.0000");
    private boolean isCheckBaseUnit = true;

    public boolean isCheckBaseUnit() {
        return this.isCheckBaseUnit;
    }

    public void setCheckBaseUnit(boolean isCheckBaseUnit) {
        this.isCheckBaseUnit = isCheckBaseUnit;
    }

    public EMMManufactureOrderSplitEditUI() throws Exception {
        this.statusBar.setVisible(false);
        this.ftfCurrentSplitQtyParam.setNegatived(false);
        this.ftfCurrentSplitQtyParam.setMinimumValue((Comparable)BIG_DECIMAL_ZERO);
        this.ftfCurrentSplitQtyParam.setCommitsOnValidEdit(true);
        this.ftfCurrentSplitQtyParam.setDataVerifierType(11);
        this.ftfCurrentSplitQtyParam.setRemoveingZeroInDispaly(false);
        this.ftfSplitBlocksParam.setNegatived(false);
        this.ftfSplitBlocksParam.setMinimumValue((Comparable)INTEGER_ZERO);
        this.ftfSplitBlocksParam.setCommitsOnValidEdit(true);
        this.ftfSplitBlocksParam.setDataVerifierType(11);
        this.ftfOrderSplitScaleParam.setNegatived(false);
        this.ftfOrderSplitScaleParam.setMinimumValue((Comparable)INTEGER_ZERO);
        this.ftfOrderSplitScaleParam.setCommitsOnValidEdit(true);
        this.ftfOrderSplitScaleParam.setDataVerifierType(11);
        this.ftfEachOrderQtyParam.setNegatived(false);
        this.ftfEachOrderQtyParam.setMinimumValue((Comparable)BIG_DECIMAL_ZERO);
        this.ftfEachOrderQtyParam.setCommitsOnValidEdit(true);
        this.ftfEachOrderQtyParam.setDataVerifierType(11);
        this.ftfEachOrderQtyParam.setRemoveingZeroInDispaly(false);
        this.dpPlanStartDate.getEditor().setDateTimePattern(CtrlFormatUtilities.getDateFormatString());
        this.dpPlanStartDate.setSupportedEmpty(false);
        this.dpPlanStartDate.setTimeEnabled(true);
        this.dpPlanFinishDate.getEditor().setDateTimePattern(CtrlFormatUtilities.getDateFormatString());
        this.dpPlanFinishDate.setSupportedEmpty(false);
        this.dpPlanFinishDate.setTimeEnabled(true);
        this.spinnerStepLength.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 9999, 1));
        this.spinnerStepLength.setCustomBackground(NECESSARY_BACKGROUND_COLOR);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.pageTechnics, "Center");
        this.add((Component)this.pageParams, "South");
        AbstractAction debugAction = new AbstractAction("DEBUG"){
            private static final long serialVersionUID = 5978834242258043352L;
            private StringBuffer message;
            {
                this.message = new StringBuffer();
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                this.message.setLength(0);
                this.message.append("1. total = ");
                this.message.append("text: ").append(EMMManufactureOrderSplitEditUI.this.ftfCurrentSplitQtyParam.getText()).append(", ");
                this.message.append("value: ").append(EMMManufactureOrderSplitEditUI.this.ftfCurrentSplitQtyParam.getBigDecimalValue()).append('\n');
                this.message.append("2. bolcks = ");
                this.message.append("text: ").append(EMMManufactureOrderSplitEditUI.this.ftfSplitBlocksParam.getText()).append(", ");
                this.message.append("value: ").append(EMMManufactureOrderSplitEditUI.this.ftfSplitBlocksParam.getIntegerValue()).append('\n');
                this.message.append("3. avg = ");
                this.message.append("text: ").append(EMMManufactureOrderSplitEditUI.this.ftfEachOrderQtyParam.getText()).append(", ");
                this.message.append("value: ").append(EMMManufactureOrderSplitEditUI.this.ftfEachOrderQtyParam.getBigDecimalValue()).append('\n');
                this.message.append("4. scale = ");
                this.message.append("text: ").append(EMMManufactureOrderSplitEditUI.this.ftfOrderSplitScaleParam.getText()).append(", ");
                this.message.append("value: ").append(EMMManufactureOrderSplitEditUI.this.ftfOrderSplitScaleParam.getIntegerValue()).append('\n');
                this.message.append("5. lot: ").append(EMMManufactureOrderSplitEditUI.this.tfLotNumberParam.getText()).append('\n');
                this.message.append("6. lpv = ");
                this.message.append("mo: ").append(EMMManufactureOrderSplitEditUI.this.lpv.isManufactureOrder()).append(", ");
                this.message.append("mplan: ").append(EMMManufactureOrderSplitEditUI.this.lpv.isManufacturePlan()).append('\n');
                logger.log(Priority.DEBUG, (Object)this.message.toString());
                MsgBox.showInfo((String)this.message.toString());
            }
        };
        this.getInputMap(2).put(KeyStroke.getKeyStroke(69, 3), debugAction.getValue("Name"));
        this.getActionMap().put(debugAction.getValue("Name"), debugAction);
    }

    public void onLoad() {
        try {
            this.removeListeners();
            this.f7Manager = new F7ContextManager((Component)((Object)this), OrgType.Storage);
            this.mo = (ManufactureOrderInfo)this.getUIContext().get("srcOrder");
            this.storageOrgUnitInfo = this.mo.getStorageOrgUnit();
            this.isLotEnabled = EMMManufactureOrderSplitEditUI.isLotManagementEnabled(this.mo.getMaterial(), this.storageOrgUnitInfo);
            this.initBizBoxByOrgUnit(this.storageOrgUnitInfo);
            this.loadData();
            MOSplitTypeEnum type = (MOSplitTypeEnum)this.cmbSplitTypeParam.getSelectedItem();
            if (MOSplitTypeEnum.REFORM.equals((Object)type)) {
                this.setManufactureStrategyRelated(this.mo.getMaterial(), this.storageOrgUnitInfo);
            }
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Throwable)exc);
        }
        finally {
            this.addListeners();
        }
    }

    protected void setManufactureStrategyRelated(MaterialInfo materialInfo, StorageOrgUnitInfo storageOrgUnitInfo) throws EASBizException, BOSException {
        MaterialPlanInfo materialPlanInfo;
        if (materialInfo != null && storageOrgUnitInfo != null && (materialPlanInfo = MaterialPlanFactory.getRemoteInstance().getPlanInfo(materialInfo.getId().toString(), storageOrgUnitInfo.getId().toString())) != null && materialPlanInfo.getId() != null && materialPlanInfo.getManufactureStrategy() != null) {
            String strategyStr = materialPlanInfo.getManufactureStrategy().getId().toString();
            if ("fpPxtypCS/ihJ30GjB/UJtg0uEU=".equals(strategyStr) || "qAXoUB/tBg/gQKjAYj0WQ9g0uEU=".equals(strategyStr) || "qAYbemEdG9ngQKjAYj0V1dg0uEU=".equals(strategyStr) || "qAYfaBzTrmLgQKjAYj0f3dg0uEU=".equals(strategyStr)) {
                this.prmptProjectParam.setValue(null);
                this.prmptProjectParam.setEnabled(false);
                this.prmptTrackParam.setEnabled(true);
                this.prmptTrackParam.setRequired(true);
                this.prmptTrackParam.setEditable(true);
            } else if ("qAYfaBzUrmLgQKjAYj0f3dg0uEU=".equals(strategyStr)) {
                this.prmptProjectParam.setRequired(false);
                this.prmptProjectParam.setValue(null);
                this.prmptProjectParam.setEnabled(false);
                this.prmptTrackParam.setEnabled(true);
                this.prmptTrackParam.setEditable(true);
            } else if ("GE2FIa4GQ6uhdx0RDGuibtg0uEU=".equals(strategyStr) || "qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(strategyStr)) {
                if (materialPlanInfo.getIsolatedRule().equals((Object)IsolatedRuleEnum.ITEM)) {
                    this.prmptProjectParam.setRequired(true);
                    this.prmptProjectParam.setEnabled(true);
                    this.prmptProjectParam.setEditable(true);
                    this.prmptTrackParam.setValue(null);
                    this.prmptTrackParam.setRequired(false);
                    this.prmptTrackParam.setEditable(true);
                } else if (materialPlanInfo.getIsolatedRule().equals((Object)IsolatedRuleEnum.ITEM_TRACKNO)) {
                    this.prmptProjectParam.setRequired(true);
                    this.prmptProjectParam.setEnabled(true);
                    this.prmptProjectParam.setEditable(true);
                    this.prmptTrackParam.setRequired(true);
                    this.prmptTrackParam.setEnabled(true);
                    this.prmptTrackParam.setEditable(true);
                }
            }
        }
    }

    private void addListeners() {
        if (this.splitTypeChangeListener == null) {
            this.splitTypeChangeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        EMMManufactureOrderSplitEditUI.this.splitTypeChanged(event);
                    }
                }
            };
        }
        this.cmbSplitTypeParam.addItemListener(this.splitTypeChangeListener);
        if (this.lotModeChangeListener == null) {
            this.lotModeChangeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        EMMManufactureOrderSplitEditUI.this.lotModeChanged(event);
                    }
                }
            };
        }
        this.cmbLotModeParam.addItemListener(this.lotModeChangeListener);
        if (this.splitQtyChangeListener == null) {
            this.splitQtyChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    EMMManufactureOrderSplitEditUI.this.splitQtyhanged(event);
                }
            };
        }
        this.ftfCurrentSplitQtyParam.addDataChangeListener(this.splitQtyChangeListener);
        this.ftfEachOrderQtyParam.addDataChangeListener(this.splitQtyChangeListener);
        this.ftfSplitBlocksParam.addDataChangeListener(this.splitQtyChangeListener);
        this.ftfOrderSplitScaleParam.addDataChangeListener(this.splitQtyChangeListener);
        if (this.workDateChangeListener == null) {
            this.workDateChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    EMMManufactureOrderSplitEditUI.this.workDateChanged(event);
                }
            };
        }
        this.dpPlanStartDate.addDataChangeListener(this.workDateChangeListener);
        this.dpPlanFinishDate.addDataChangeListener(this.workDateChangeListener);
        if (this.routingSelectorListener == null) {
            this.routingSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent event) {
                    EMMManufactureOrderSplitEditUI.this.routingSelected(event);
                }
            };
        }
        this.prmptRoutingParam.addSelectorListener(this.routingSelectorListener);
        if (this.bomSelectorListener == null) {
            this.bomSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent event) {
                    EMMManufactureOrderSplitEditUI.this.bomSelected(event);
                }
            };
        }
        this.prmptBOMParam.addSelectorListener(this.bomSelectorListener);
        if (this.materialChangedListener == null) {
            this.materialChangedListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    EMMManufactureOrderSplitEditUI.this.materialChanged(event);
                }
            };
        }
        this.prmptMaterialParam.addDataChangeListener(this.materialChangedListener);
        if (this.adminOrgChangedListener == null) {
            this.adminOrgChangedListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    EMMManufactureOrderSplitEditUI.this.adminOrgChanged(event);
                }
            };
        }
        this.prmptAdminOrgUnit.addDataChangeListener(this.adminOrgChangedListener);
        if (this.projectChangedListener == null) {
            this.projectChangedListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    EMMManufactureOrderSplitEditUI.this.projectChanged(event);
                }
            };
        }
        this.prmptProjectParam.addDataChangeListener(this.projectChangedListener);
        if (this.trackChangedListener == null) {
            this.trackChangedListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    EMMManufactureOrderSplitEditUI.this.trackNumberChanged(event);
                }
            };
        }
        this.prmptTrackParam.addDataChangeListener(this.trackChangedListener);
        if (this.focusListener == null) {
            this.focusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent event) {
                }

                @Override
                public void focusLost(FocusEvent event) {
                }
            };
        }
        this.inputVerifier = new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                KDFormattedTextField component = (KDFormattedTextField)input;
                if (component == EMMManufactureOrderSplitEditUI.this.ftfCurrentSplitQtyParam) {
                    String text = component.getText();
                    if (StringUtils.isEmpty((String)text)) {
                        MsgBox.showInfo((String)EMMManufactureOrderSplitEditUI.this.getResource("SPLIT_PARAM_NULL", new String[]{EMMManufactureOrderSplitEditUI.this.lblCurrentSplitQtyParam.getBoundLabelText()}));
                        return true;
                    }
                    if (new BigDecimal(text).compareTo(EMMManufactureOrderSplitEditUI.this.ftfSplitableQtyParam.getBigDecimalValue()) > 0) {
                        MsgBox.showInfo((String)EMMManufactureOrderSplitEditUI.this.getResource("SPLIT_QTY_MUST_LOWER", new String[]{EMMManufactureOrderSplitEditUI.this.lblCurrentSplitQtyParam.getBoundLabelText(), EMMManufactureOrderSplitEditUI.this.lblSplitableQtyParam.getBoundLabelText()}));
                        return true;
                    }
                } else if (component == EMMManufactureOrderSplitEditUI.this.ftfEachOrderQtyParam) {
                    String text = component.getText();
                    if (StringUtils.isEmpty((String)text)) {
                        String msg = EMMManufactureOrderSplitEditUI.this.getResource("SPLIT_PARAM_NULL", new String[]{EMMManufactureOrderSplitEditUI.this.lblEachOrderQtyParam.getBoundLabelText()});
                        msg = msg + EMMManufactureOrderSplitEditUI.this.getResource("AUTO_CALCULATE_CHOICE", new String[]{EMMManufactureOrderSplitEditUI.this.lblSplitBlocksParam.getBoundLabelText()});
                        EMMManufactureOrderSplitEditUI.this.choice = MsgBox.showConfirm2New((Component)((Object)EMMManufactureOrderSplitEditUI.this), (String)msg);
                        return true;
                    }
                    if (new BigDecimal(text).compareTo(EMMManufactureOrderSplitEditUI.this.ftfCurrentSplitQtyParam.getBigDecimalValue()) > 0) {
                        MsgBox.showInfo((String)EMMManufactureOrderSplitEditUI.this.getResource("SPLIT_QTY_MUST_LOWER", new String[]{EMMManufactureOrderSplitEditUI.this.lblEachOrderQtyParam.getBoundLabelText(), EMMManufactureOrderSplitEditUI.this.lblCurrentSplitQtyParam.getBoundLabelText()}));
                        return true;
                    }
                } else if (component == EMMManufactureOrderSplitEditUI.this.ftfSplitBlocksParam) {
                    String text = component.getText();
                    if (StringUtils.isEmpty((String)text)) {
                        String msg = EMMManufactureOrderSplitEditUI.this.getResource("SPLIT_PARAM_NULL", new String[]{EMMManufactureOrderSplitEditUI.this.lblSplitBlocksParam.getBoundLabelText()});
                        msg = msg + EMMManufactureOrderSplitEditUI.this.getResource("AUTO_CALCULATE_CHOICE", new String[]{EMMManufactureOrderSplitEditUI.this.lblEachOrderQtyParam.getBoundLabelText()});
                        EMMManufactureOrderSplitEditUI.this.choice = MsgBox.showConfirm2New((Component)((Object)EMMManufactureOrderSplitEditUI.this), (String)msg);
                        return true;
                    }
                    if (!EMMManufactureOrderSplitEditUI.isInteger(text)) {
                        MsgBox.showInfo((String)EMMManufactureOrderSplitEditUI.this.getResource("SPLIT_PARAM_MUST_BE_INTEGER", new String[]{EMMManufactureOrderSplitEditUI.this.lblSplitBlocksParam.getBoundLabelText()}));
                        return true;
                    }
                } else if (component == EMMManufactureOrderSplitEditUI.this.ftfOrderSplitScaleParam) {
                    String text = component.getText();
                    if (StringUtils.isEmpty((String)text)) {
                        String msg = EMMManufactureOrderSplitEditUI.this.getResource("SPLIT_PARAM_NULL", new String[]{EMMManufactureOrderSplitEditUI.this.lblOrderSplitScaleParam.getBoundLabelText()});
                        msg = msg + EMMManufactureOrderSplitEditUI.this.getResource("AUTO_DEFAULT_CHOICE", null);
                        EMMManufactureOrderSplitEditUI.this.choice = MsgBox.showConfirm2New((Component)((Object)EMMManufactureOrderSplitEditUI.this), (String)msg);
                        return true;
                    }
                    if (!EMMManufactureOrderSplitEditUI.isInteger(text)) {
                        MsgBox.showInfo((String)EMMManufactureOrderSplitEditUI.this.getResource("SPLIT_PARAM_MUST_BE_INTEGER", new String[]{EMMManufactureOrderSplitEditUI.this.lblOrderSplitScaleParam.getBoundLabelText()}));
                        return true;
                    }
                    if (new Integer(text).compareTo(EMMManufactureOrderSplitEditUI.this.precision) > 0) {
                        MsgBox.showInfo((String)EMMManufactureOrderSplitEditUI.this.getResource("SPLIT_SCALE_MUST_LOWER", new String[]{EMMManufactureOrderSplitEditUI.this.ftfOrderSplitScaleParam.getBoundLabelText(), String.valueOf(EMMManufactureOrderSplitEditUI.this.precision)}));
                        return true;
                    }
                }
                return true;
            }
        };
        this.ftfOrderSplitScaleParam.setInputVerifier(this.inputVerifier);
        this.ftfCurrentSplitQtyParam.setInputVerifier(this.inputVerifier);
        this.ftfEachOrderQtyParam.setInputVerifier(this.inputVerifier);
        this.ftfSplitBlocksParam.setInputVerifier(this.inputVerifier);
    }

    protected void adminOrgChanged(DataChangeEvent event) {
        AdminOrgUnitInfo newValue;
        AdminOrgUnitInfo oldValue = (AdminOrgUnitInfo)event.getOldValue();
        boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = (AdminOrgUnitInfo)event.getNewValue()));
        if (isDifferent) {
            try {
                this.transTypeReform = MOProductTransactionTypeUtil.getDefaultTransType(null, (MaterialInfo)(this.prmptMaterial.getValue() == null ? null : (MaterialInfo)this.prmptMaterial.getValue()), null, (StorageOrgUnitInfo)this.storageOrgUnitInfo, (AdminOrgUnitInfo)newValue, (String)this.bizTypeReform.getId().toString());
                StandardRootingInfo routing = null;
                if (MOSplitTypeEnum.STANDARD.equals(this.cmbSplitTypeParam.getSelectedItem())) {
                    routing = this.getDefaultRouting(this.prmptMaterial.getValue() == null ? null : ((MaterialInfo)this.prmptMaterial.getValue()).getId().toString(), this.storageOrgUnitInfo.getId().toString(), this.transTypeStandard);
                } else if (MOSplitTypeEnum.REFORM.equals(this.cmbSplitTypeParam.getSelectedItem())) {
                    routing = this.getDefaultRouting(this.prmptMaterial.getValue() == null ? null : ((MaterialInfo)this.prmptMaterial.getValue()).getId().toString(), this.storageOrgUnitInfo.getId().toString(), this.transTypeReform);
                }
                this.prmptRoutingParam.setValue(routing);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private static boolean isInteger(String text) {
        try {
            if (StringUtils.isEmpty((String)text)) {
                return false;
            }
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException exc) {
            return false;
        }
    }

    private void removeListeners() {
        if (this.splitTypeChangeListener != null) {
            this.cmbSplitTypeParam.removeItemListener(this.splitTypeChangeListener);
        }
        if (this.lotModeChangeListener != null) {
            this.cmbLotModeParam.removeItemListener(this.lotModeChangeListener);
        }
        if (this.splitQtyChangeListener != null) {
            this.ftfCurrentSplitQtyParam.removeDataChangeListener(this.splitQtyChangeListener);
            this.ftfEachOrderQtyParam.removeDataChangeListener(this.splitQtyChangeListener);
            this.ftfSplitBlocksParam.removeDataChangeListener(this.splitQtyChangeListener);
            this.ftfOrderSplitScaleParam.removeDataChangeListener(this.splitQtyChangeListener);
        }
        if (this.routingSelectorListener != null) {
            this.prmptRoutingParam.removeSelectorListener(this.routingSelectorListener);
        }
        if (this.bomSelectorListener != null) {
            this.prmptBOMParam.removeSelectorListener(this.bomSelectorListener);
        }
        if (this.materialChangedListener != null) {
            this.prmptMaterialParam.removeDataChangeListener(this.materialChangedListener);
        }
        if (this.adminOrgChangedListener != null) {
            this.prmptAdminOrgUnit.removeDataChangeListener(this.adminOrgChangedListener);
        }
        if (this.projectChangedListener != null) {
            this.prmptProjectParam.removeDataChangeListener(this.projectChangedListener);
        }
        if (this.trackChangedListener != null) {
            this.prmptTrackParam.removeDataChangeListener(this.trackChangedListener);
        }
        if (this.focusListener != null) {
            this.ftfSplitBlocksParam.removeFocusListener(this.focusListener);
            this.ftfEachOrderQtyParam.removeFocusListener(this.focusListener);
            this.ftfOrderSplitScaleParam.removeFocusListener(this.focusListener);
        }
        if (this.ftfOrderSplitScaleParam.getInputVerifier() != null) {
            this.ftfOrderSplitScaleParam.setInputVerifier(null);
        }
        if (this.ftfCurrentSplitQtyParam.getInputVerifier() != null) {
            this.ftfCurrentSplitQtyParam.setInputVerifier(null);
        }
        if (this.ftfEachOrderQtyParam.getInputVerifier() != null) {
            this.ftfEachOrderQtyParam.setInputVerifier(null);
        }
        if (this.ftfSplitBlocksParam.getInputVerifier() != null) {
            this.ftfSplitBlocksParam.setInputVerifier(null);
        }
        if (this.workDateChangeListener != null) {
            this.dpPlanStartDate.removeDataChangeListener(this.workDateChangeListener);
            this.dpPlanFinishDate.removeDataChangeListener(this.workDateChangeListener);
        }
    }

    private void loadData() throws BOSException, EASBizException {
        Map splitParams = this.getUIContext();
        this.prmptStorageOrgUnit.setValue((Object)this.storageOrgUnitInfo);
        this.tfBillNumber.setText(this.mo.getNumber());
        this.prmptMaterial.setValue((Object)this.mo.getMaterial());
        this.tfModel.setText(this.mo.getMaterial().getModel());
        this.prmptUnit.setValue((Object)this.mo.getUnit());
        this.bom = (BomInfo)splitParams.get("bom");
        this.prmptBOM.setValue((Object)this.bom);
        this.prmptRouting.setValue((Object)this.mo.getRouting());
        this.tfSplitOperationNumber.setText(((Integer)splitParams.get("oprtNO")).toString());
        this.tfOperationName.setText((String)splitParams.get("oprtName"));
        this.ftfOperationQty.setValue((Object)NumericUtil.emptyToZero(splitParams.get("oprtQty")));
        this.ftfTotalSplitQty.setValue((Object)NumericUtil.emptyToZero(splitParams.get("oprtTotalSplitQty")));
        this.ftfOperationReportQty.setValue((Object)NumericUtil.emptyToZero(splitParams.get("oprtReportQty")));
        this.ftfTotalDispatchQty.setValue((Object)NumericUtil.emptyToZero(splitParams.get("oprtTotalDispatchQty")));
        this.ftfProductFinishedQty.setValue((Object)NumericUtil.emptyToZero((Object)this.mo.getFinishedQty()));
        this.ftfProductToStorageQty.setValue((Object)NumericUtil.emptyToZero((Object)this.mo.getToStroreQty()));
        this.cmbSplitTypeParam.setSelectedItem((Object)MOSplitTypeEnum.STANDARD);
        Calendar calendar = Calendar.getInstance();
        Date startDate = EMMManufactureOrderSplitEditUI.getDateAfterDays(this.storageOrgUnitInfo, calendar.getTime(), 1);
        this.dpPlanStartDate.setValue((Object)startDate);
        int leadingDays = EMMManufactureOrderSplitEditUI.getLeadingDays(this.mo.getMaterial(), this.storageOrgUnitInfo);
        Date finishDate = EMMManufactureOrderSplitEditUI.getDateAfterDays(this.storageOrgUnitInfo, startDate, leadingDays);
        this.dpPlanFinishDate.setValue((Object)finishDate);
        this.prmptMaterialParam.setValue((Object)this.mo.getMaterial());
        this.prmptMaterialParam.setEditable(false);
        this.prmptMaterialParam.setEnabled(false);
        this.tfModelParam.setText(this.mo.getMaterial().getModel());
        this.tfModelParam.setEditable(false);
        this.tfModelParam.setEnabled(false);
        this.prmptUnitParam.setValue((Object)this.mo.getUnit());
        this.prmptUnitParam.setEditable(false);
        this.prmptUnitParam.setEnabled(false);
        this.prmptAdminOrgUnit.setValue((Object)this.mo.getAdminOrgUnit());
        this.prmptProjectParam.setValue((Object)this.mo.getProject());
        this.prmptProjectParam.setEditable(false);
        this.prmptProjectParam.setEnabled(false);
        this.prmptTrackParam.setValue((Object)this.mo.getTrackNumber());
        this.prmptTrackParam.setEditable(false);
        this.prmptTrackParam.setEnabled(false);
        this.prmptRoutingParam.setValue((Object)this.mo.getRouting());
        this.prmptRoutingParam.setEditable(false);
        this.prmptRoutingParam.setEnabled(false);
        this.prmptBOMParam.setValue((Object)this.bom);
        this.prmptBOMParam.setEditable(false);
        this.prmptBOMParam.setEnabled(false);
        BigDecimal availableQty = (BigDecimal)splitParams.get("availableSplitQty");
        this.ftfSplitableQtyParam.setValue((Object)availableQty);
        this.precision = (Integer)splitParams.get("unitScale");
        this.ftfOrderSplitScaleParam.setValue((Object)this.precision);
        this.ftfOrderSplitScaleParam.setMaximumValue((Comparable)this.precision);
        this.ftfCurrentSplitQtyParam.setValue((Object)BIG_DECIMAL_ZERO);
        this.ftfCurrentSplitQtyParam.setMaximumValue((Comparable)availableQty);
        this.ftfCurrentSplitQtyParam.setPrecision(this.precision.intValue());
        this.ftfSplitBlocksParam.setValue((Object)INTEGER_ONE);
        this.ftfEachOrderQtyParam.setValue((Object)BIG_DECIMAL_ZERO);
        this.ftfEachOrderQtyParam.setMaximumValue((Comparable)availableQty);
        this.ftfEachOrderQtyParam.setPrecision(this.precision.intValue());
        if (this.bizTypeStandard == null) {
            this.bizTypeStandard = this.getBizType("401");
        }
        if (this.transTypeStandard == null && this.bizTypeStandard != null) {
            this.transTypeStandard = MOProductTransactionTypeUtil.getDefTransType(null, (String)this.storageOrgUnitInfo.getId().toString(), (String)(this.mo.getAdminOrgUnit() == null ? null : this.mo.getAdminOrgUnit().getId().toString()), (String)this.bizTypeStandard.getId().toString());
        }
        if (this.bizTypeReform == null) {
            this.bizTypeReform = this.getBizType("403");
        }
        if (this.transTypeReform == null && this.bizTypeReform != null) {
            this.transTypeReform = MOProductTransactionTypeUtil.getDefTransType(null, (String)this.storageOrgUnitInfo.getId().toString(), (String)(this.mo.getAdminOrgUnit() == null ? null : this.mo.getAdminOrgUnit().getId().toString()), (String)this.bizTypeReform.getId().toString());
        }
        if (this.lpv == null) {
            this.lpv = LotFacadeFactory.getRemoteInstance().getLotParamValueByOrg(this.storageOrgUnitInfo.getId().toString());
        }
        this.initLotMode(this.mo.getMaterial(), this.mo.getStorageOrgUnit(), MOSplitTypeEnum.STANDARD);
        this.changeAdminOrgUnitEditable();
    }

    private void changeAdminOrgUnitEditable() {
        if (MOSplitTypeEnum.STANDARD.equals(this.cmbSplitTypeParam.getSelectedItem())) {
            if (this.mo.getTechnics() != null && this.mo.getTechnics().size() > 0) {
                int currentSplitOperNo = (Integer)this.getUIContext().get("oprtNO");
                if (this.mo.getFirstOperNo() != currentSplitOperNo) {
                    this.prmptAdminOrgUnit.setEnabled(false);
                }
            }
        } else {
            this.prmptAdminOrgUnit.setEnabled(true);
        }
    }

    private void initLotMode(MaterialInfo material, StorageOrgUnitInfo storage, MOSplitTypeEnum type) {
        try {
            if (MOSplitTypeEnum.STANDARD.equals((Object)type)) {
                if (!EMMManufactureOrderSplitEditUI.isLotManagementEnabled(material, storage)) {
                    this.cmbLotModeParam.setSelectedItem(null);
                    this.cmbLotModeParam.setEditable(false);
                    this.cmbLotModeParam.setEnabled(false);
                    this.tfLotNumberParam.setText(null);
                    this.tfLotNumberParam.setRequired(false);
                    this.tfLotNumberParam.setEditable(false);
                    this.tfLotNumberParam.setEnabled(false);
                } else if (this.lpv == null || !this.lpv.isManufacturePlan() && !this.lpv.isManufactureOrder()) {
                    this.cmbLotModeParam.setSelectedItem(null);
                    this.cmbLotModeParam.setEditable(false);
                    this.cmbLotModeParam.setEnabled(false);
                    this.tfLotNumberParam.setText(null);
                    this.tfLotNumberParam.setRequired(false);
                    this.tfLotNumberParam.setEditable(false);
                    this.tfLotNumberParam.setEnabled(false);
                } else {
                    this.cmbLotModeParam.setSelectedItem((Object)MOSplitLotModeEnum.GENERATE_BY_SOURCE);
                    this.cmbLotModeParam.setEditable(true);
                    this.cmbLotModeParam.setEnabled(true);
                    this.tfLotNumberParam.setText(this.mo.getLot());
                    this.tfLotNumberParam.setRequired(false);
                    this.tfLotNumberParam.setEditable(false);
                    this.tfLotNumberParam.setEnabled(false);
                }
            } else if (MOSplitTypeEnum.REFORM.equals((Object)type)) {
                if (!EMMManufactureOrderSplitEditUI.isLotManagementEnabled(material, storage)) {
                    this.cmbLotModeParam.setSelectedItem(null);
                    this.cmbLotModeParam.setEditable(false);
                    this.cmbLotModeParam.setEnabled(false);
                    this.tfLotNumberParam.setText(null);
                    this.tfLotNumberParam.setRequired(false);
                    this.tfLotNumberParam.setEditable(false);
                    this.tfLotNumberParam.setEnabled(false);
                } else if (this.lpv == null || !this.lpv.isManufacturePlan() && !this.lpv.isManufactureOrder()) {
                    this.cmbLotModeParam.setSelectedItem(null);
                    this.cmbLotModeParam.setEditable(false);
                    this.cmbLotModeParam.setEnabled(false);
                    this.tfLotNumberParam.setText(null);
                    this.tfLotNumberParam.setRequired(false);
                    this.tfLotNumberParam.setEditable(false);
                    this.tfLotNumberParam.setEnabled(false);
                } else {
                    LotRuleInfo lotRule = (LotRuleInfo)ManufactureOrderFactory.getRemoteInstance().invoke("getProperLotRule", new Object[]{material.getId().toString(), this.storageOrgUnitInfo.getId().toString()});
                    if (lotRule == null) {
                        this.cmbLotModeParam.setSelectedItem((Object)MOSplitLotModeEnum.GENERATE_BY_RULE);
                        this.cmbLotModeParam.setEditable(this.isLotEnabled);
                        this.cmbLotModeParam.setEnabled(this.isLotEnabled);
                        this.tfLotNumberParam.setText(null);
                        this.tfLotNumberParam.setRequired(true);
                        this.tfLotNumberParam.setEditable(true);
                        this.tfLotNumberParam.setEnabled(true);
                    } else {
                        LotFrame lotFrame = LotRuleFactory.getRemoteInstance().getLotFrameExtend(material.getId().toString(), this.storageOrgUnitInfo.getId().toString());
                        if (lotFrame != null && lotFrame.getLotRule() != null) {
                            this.cmbLotModeParam.setSelectedItem((Object)MOSplitLotModeEnum.GENERATE_BY_RULE);
                            this.cmbLotModeParam.setEditable(this.isLotEnabled);
                            this.cmbLotModeParam.setEnabled(this.isLotEnabled);
                            lotFrame.setLotRule(lotRule);
                            lotFrame.setSysDate(new Date());
                            lotFrame.setMaterial(material.getNumber());
                            lotFrame.setBillNumber(material.getNumber());
                            lotFrame.setMfg((Date)this.dpPlanFinishDate.getValue());
                            this.tfLotNumberParam.setText(lotFrame.getLotNumber(), false);
                            boolean modifiable = lotFrame.getLotRule().isIsModifiable();
                            this.tfLotNumberParam.setRequired(modifiable);
                            this.tfLotNumberParam.setEditable(modifiable);
                            this.tfLotNumberParam.setEnabled(modifiable);
                        }
                    }
                }
            }
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Throwable)exc);
        }
    }

    private void initBizBoxByOrgUnit(StorageOrgUnitInfo orgInfo) {
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmptMaterialParam, (OrgUnitInfo)orgInfo);
        EntityViewInfo viewInfo = this.prmptMaterialParam.getEntityViewInfo();
        FilterInfo filter = viewInfo.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)"10030,10050", CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        this.prmptMaterialParam.setEntityViewInfo(viewInfo);
        UIHelper.registerProjectF7ForEdit((KDBizPromptBox)this.prmptStorageOrgUnit, null, (KDBizPromptBox)this.prmptProjectParam);
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        UIHelper.registerTrackNumberF7((KDBizPromptBox)this.prmptStorageOrgUnit, null, (KDBizPromptBox)this.prmptProjectParam, (KDBizPromptBox)this.prmptTrackParam, status, (boolean)false, (boolean)true);
        UIHelper.registerBizOrgF7((KDBizPromptBox)this.prmptAdminOrgUnit, null, (OrgUnitInfo)orgInfo, (OrgType)OrgType.Storage, (OrgType)OrgType.Admin, (boolean)false);
    }

    private boolean verify() throws EASBizException, BOSException {
        Date end;
        Date start;
        BigDecimal block;
        LotRuleInfo lotRule;
        MaterialInfo material;
        StringBuffer msg = new StringBuffer();
        if (this.prmptMaterialParam.getValue() == null) {
            msg.append(this.getResource("SPLIT_PARAM_NULL", new String[]{this.lblMaterialNumberParam.getBoundLabelText()}));
            msg.append("\n");
        } else if (MOSplitLotModeEnum.GENERATE_BY_RULE.equals(this.cmbLotModeParam.getSelectedItem()) && EMMManufactureOrderSplitEditUI.isLotManagementEnabled(material = (MaterialInfo)this.prmptMaterialParam.getValue(), this.storageOrgUnitInfo) && (lotRule = (LotRuleInfo)ManufactureOrderFactory.getRemoteInstance().invoke("getProperLotRule", new Object[]{material.getId().toString(), this.storageOrgUnitInfo.getId().toString()})) == null) {
            String lot;
            if (MOSplitTypeEnum.STANDARD.equals(this.cmbSplitTypeParam.getSelectedItem())) {
                msg.append(this.getResource("LOT_RULE_NOT_EXIST", null));
                msg.append("\n");
            } else if (MOSplitTypeEnum.REFORM.equals(this.cmbSplitTypeParam.getSelectedItem()) && this.tfLotNumberParam.isEditable() && this.tfLotNumberParam.isEnabled() && StringUtils.isEmpty((String)(lot = this.tfLotNumberParam.getText()))) {
                msg.append(this.getResource("SPLIT_PARAM_NULL", new String[]{this.lblLotNumberParam.getBoundLabelText()}));
                msg.append("\n");
            }
        }
        if (this.prmptProjectParam.isRequired() && this.prmptProjectParam.getValue() == null) {
            msg.append(this.getResource("SPLIT_PARAM_NULL", new String[]{this.lblProjectParam.getBoundLabelText()}));
            msg.append("\n");
        }
        if (this.prmptTrackParam.isRequired() && this.prmptTrackParam.getValue() == null) {
            msg.append(this.getResource("SPLIT_PARAM_NULL", new String[]{this.lblTrackParam.getBoundLabelText()}));
            msg.append("\n");
        }
        if (this.prmptBOMParam.getValue() == null && MOSplitTypeEnum.REFORM.equals((Object)((MOSplitTypeEnum)this.cmbSplitTypeParam.getSelectedItem()))) {
            msg.append(this.getResource("SPLIT_PARAM_NULL", new String[]{this.lblBOMNumberParam.getBoundLabelText()}));
            msg.append("\n");
        }
        if (StringUtils.isEmpty((String)this.ftfOrderSplitScaleParam.getText())) {
            msg.append(this.getResource("SPLIT_PARAM_NULL", new String[]{this.lblOrderSplitScaleParam.getBoundLabelText()}));
            msg.append("\n");
        }
        if (this.ftfCurrentSplitQtyParam.getBigDecimalValue() == null) {
            msg.append(this.getResource("SPLIT_PARAM_NULL", new String[]{this.lblCurrentSplitQtyParam.getBoundLabelText()}));
            msg.append("\n");
        } else if (this.ftfCurrentSplitQtyParam.getBigDecimalValue().compareTo(BIG_DECIMAL_ZERO) <= 0) {
            msg.append(this.getResource("SPLIT_PARAM_ZERO", new String[]{this.lblCurrentSplitQtyParam.getBoundLabelText()}));
            msg.append("\n");
        }
        if (this.ftfSplitBlocksParam.getIntegerValue() == null) {
            msg.append(this.getResource("SPLIT_PARAM_NULL", new String[]{this.lblSplitBlocksParam.getBoundLabelText()}));
            msg.append("\n");
        } else if (this.ftfSplitBlocksParam.getIntegerValue() == 0) {
            msg.append(this.getResource("SPLIT_PARAM_ZERO", new String[]{this.lblSplitBlocksParam.getBoundLabelText()}));
            msg.append("\n");
        }
        if (this.ftfEachOrderQtyParam.getBigDecimalValue() == null) {
            msg.append(this.getResource("SPLIT_PARAM_NULL", new String[]{this.lblEachOrderQtyParam.getBoundLabelText()}));
            msg.append("\n");
        } else if (this.ftfEachOrderQtyParam.getBigDecimalValue().compareTo(BIG_DECIMAL_ZERO) <= 0) {
            msg.append(this.getResource("SPLIT_PARAM_ZERO", new String[]{this.lblEachOrderQtyParam.getBoundLabelText()}));
            msg.append("\n");
        }
        if (this.ftfCurrentSplitQtyParam.getBigDecimalValue().compareTo(this.ftfSplitableQtyParam.getBigDecimalValue()) > 0) {
            msg.append(this.getResource("SPLIT_QTY_MUST_LOWER", new String[]{this.lblCurrentSplitQtyParam.getBoundLabelText(), this.lblSplitableQtyParam.getBoundLabelText()}));
            msg.append("\n");
        }
        if (this.ftfEachOrderQtyParam.getBigDecimalValue().compareTo(this.ftfCurrentSplitQtyParam.getBigDecimalValue()) > 0) {
            msg.append(this.getResource("SPLIT_QTY_MUST_LOWER", new String[]{this.lblEachOrderQtyParam.getBoundLabelText(), this.lblCurrentSplitQtyParam.getBoundLabelText()}));
            msg.append("\n");
        }
        if (!EMMManufactureOrderSplitEditUI.isInteger(this.ftfSplitBlocksParam.getText())) {
            msg.append(this.getResource("SPLIT_PARAM_MUST_BE_INTEGER", new String[]{this.lblSplitBlocksParam.getBoundLabelText()}));
            msg.append("\n");
        }
        if (!EMMManufactureOrderSplitEditUI.isInteger(this.ftfOrderSplitScaleParam.getText())) {
            msg.append(this.getResource("SPLIT_PARAM_MUST_BE_INTEGER", new String[]{this.lblOrderSplitScaleParam.getBoundLabelText()}));
            msg.append("\n");
        }
        if (this.ftfOrderSplitScaleParam.getIntegerValue().compareTo(this.precision) > 0) {
            msg.append(this.getResource("SPLIT_SCALE_MUST_LOWER", new String[]{this.ftfOrderSplitScaleParam.getBoundLabelText(), String.valueOf(this.precision)}));
            msg.append("\n");
        }
        if (!this.ftfSplitBlocksParam.getIntegerValue().equals(INTEGER_ZERO) && (block = new BigDecimal(this.ftfSplitBlocksParam.getIntegerValue())).multiply(this.ftfEachOrderQtyParam.getBigDecimalValue()).compareTo(this.ftfCurrentSplitQtyParam.getBigDecimalValue()) > 0) {
            msg.append(this.getResource("SPLIT_QTY_MUST_LOWER", new String[]{this.lblEachOrderQtyParam.getBoundLabelText(), this.lblCurrentSplitQtyParam.getBoundLabelText()}));
            msg.append("\n");
        }
        if (this.dpPlanStartDate.getValue() == null) {
            msg.append(this.getResource("SPLIT_PARAM_NULL", new String[]{this.lblPlanStartDate.getBoundLabelText()}));
            msg.append("\n");
        }
        if (this.dpPlanFinishDate.getValue() == null) {
            msg.append(this.getResource("SPLIT_PARAM_NULL", new String[]{this.lblPlanFinishDate.getBoundLabelText()}));
            msg.append("\n");
        }
        if (this.dpPlanStartDate.getValue() != null && this.dpPlanFinishDate.getValue() != null && (start = (Date)this.dpPlanStartDate.getValue()).compareTo(end = (Date)this.dpPlanFinishDate.getValue()) > 0) {
            msg.append(this.getResource("SPLIT_PLAN_DATE_ERROR", new String[]{this.lblPlanStartDate.getBoundLabel().getText(), this.lblPlanFinishDate.getBoundLabelText()}));
            msg.append("\n");
        }
        if (this.isCheckBaseUnit() && MOSplitTypeEnum.REFORM.equals(this.cmbSplitTypeParam.getSelectedItem()) && this.prmptMaterialParam.getValue() != null && (SCMGroupClientUtils.isDiffrent((Object)this.mo.getUnit(), (Object)this.prmptUnitParam.getValue()) || SCMGroupClientUtils.isDiffrent((Object)this.mo.getBaseUnit(), (Object)((MaterialInfo)this.prmptMaterialParam.getValue()).getBaseUnit()))) {
            msg.append(this.getResource("REFORM_UNIT_UNCOMPATIBLE", null));
            msg.append("\n");
        }
        if (msg.length() > 0) {
            String subject = this.getResource("SPLIT_PARAM_ERROR_SUBJECT", null);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)subject, (String)msg.toString(), (int)2);
            return false;
        }
        return true;
    }

    private String getResource(String key, String[] replacements) {
        if (replacements == null) {
            return EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderSplitResource", (String)key);
        }
        return ResourceUtils.getMessage((String)"com.kingdee.eas.mm.mo.ManufactureOrderSplitResource", (String)key, (String[])replacements);
    }

    private static Date getDateAfterDays(StorageOrgUnitInfo storage, Date base, int days) throws BOSException, EASBizException {
        return FactoryCalendarFactory.getRemoteInstance().findDateFromFCalendar(storage.getId().toString(), base, 1, days, 2);
    }

    private static boolean isLotManagementEnabled(MaterialInfo material, StorageOrgUnitInfo storage) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("isLotNumber"));
        selectorItemCollection.add(new SelectorItemInfo("material.id"));
        selectorItemCollection.add(new SelectorItemInfo("orgUnit.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storage.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialInventoryCollection materialInventoryCollection = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(entityViewInfo);
        if (materialInventoryCollection != null && materialInventoryCollection.size() > 0) {
            MaterialInventoryInfo materialInventoryInfo = materialInventoryCollection.get(0);
            return materialInventoryInfo.isIsLotNumber();
        }
        return false;
    }

    private static int getLeadingDays(MaterialInfo material, StorageOrgUnitInfo storage) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("produceLeadTime"));
        selectorItemCollection.add(new SelectorItemInfo("material.id"));
        selectorItemCollection.add(new SelectorItemInfo("orgUnit.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storage.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialPlanCollection materialPlanCollection = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(entityViewInfo);
        if (materialPlanCollection != null && materialPlanCollection.size() > 0) {
            MaterialPlanInfo materialPlanInfo = materialPlanCollection.get(0);
            return materialPlanInfo.getProduceLeadTime();
        }
        return 0;
    }

    private void splitTypeChanged(ItemEvent event) {
        try {
            this.removeListeners();
            MOSplitTypeEnum type = (MOSplitTypeEnum)this.cmbSplitTypeParam.getSelectedItem();
            if (MOSplitTypeEnum.STANDARD.equals((Object)type)) {
                this.loadData();
                this.ftfSplitBlocksParam.setEditable(true);
                this.ftfSplitBlocksParam.setValue((Object)INTEGER_ONE);
                this.ftfEachOrderQtyParam.setEditable(true);
                this.prmptBOMParam.setRequired(false);
            } else if (MOSplitTypeEnum.REFORM.equals((Object)type)) {
                this.prmptMaterialParam.setValue((Object)this.mo.getMaterial());
                this.prmptMaterialParam.setEditable(true);
                this.prmptMaterialParam.setEnabled(true);
                this.prmptProjectParam.setValue((Object)this.mo.getProject());
                this.prmptTrackParam.setValue((Object)this.mo.getTrackNumber());
                this.setMaterialPlanCache();
                this.setProjectTrackNumberEditable();
                this.tfModelParam.setText(this.mo.getMaterial().getModel());
                this.tfModelParam.setEditable(false);
                this.tfModelParam.setEnabled(false);
                this.prmptUnitParam.setValue((Object)this.mo.getUnit());
                this.prmptUnitParam.setEditable(false);
                this.prmptUnitParam.setEnabled(false);
                this.prmptRoutingParam.setValue((Object)this.mo.getRouting());
                this.prmptRoutingParam.setEditable(true);
                this.prmptRoutingParam.setEnabled(true);
                this.prmptBOMParam.setValue((Object)this.bom);
                this.prmptBOMParam.setEditable(true);
                this.prmptBOMParam.setEnabled(true);
                this.prmptBOMParam.setRequired(true);
                this.ftfCurrentSplitQtyParam.setValue((Object)BIG_DECIMAL_ZERO);
                this.ftfCurrentSplitQtyParam.setPrecision(this.precision.intValue());
                this.ftfOrderSplitScaleParam.setValue((Object)this.precision);
                this.ftfSplitBlocksParam.setValue((Object)INTEGER_ONE);
                this.ftfEachOrderQtyParam.setValue((Object)BIG_DECIMAL_ZERO);
                this.ftfEachOrderQtyParam.setPrecision(this.precision.intValue());
                this.ftfSplitBlocksParam.setEditable(false);
                this.ftfEachOrderQtyParam.setEditable(false);
                this.initLotMode(this.mo.getMaterial(), this.mo.getStorageOrgUnit(), MOSplitTypeEnum.REFORM);
                this.setManufactureStrategyRelated(this.mo.getMaterial(), this.mo.getStorageOrgUnit());
            }
            this.changeAdminOrgUnitEditable();
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Throwable)exc);
        }
        finally {
            this.addListeners();
        }
    }

    private void lotModeChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            MaterialInfo material = (MaterialInfo)this.prmptMaterialParam.getValue();
            if (material == null) {
                MsgBox.showInfo((String)this.getResource("SPLIT_PARAM_NULL", new String[]{this.lblMaterialNumberParam.getBoundLabelText()}));
            } else {
                try {
                    MOSplitLotModeEnum mode = (MOSplitLotModeEnum)this.cmbLotModeParam.getSelectedItem();
                    if (MOSplitLotModeEnum.GENERATE_BY_SOURCE.equals((Object)mode)) {
                        this.tfLotNumberParam.setText(this.mo.getLot());
                        this.tfLotNumberParam.setRequired(false);
                        this.tfLotNumberParam.setEditable(false);
                        this.tfLotNumberParam.setEnabled(false);
                    } else if (MOSplitLotModeEnum.GENERATE_BY_RULE.equals((Object)mode)) {
                        MOSplitTypeEnum type = (MOSplitTypeEnum)this.cmbSplitTypeParam.getSelectedItem();
                        if (MOSplitTypeEnum.STANDARD.equals((Object)type)) {
                            this.tfLotNumberParam.setText(null);
                            this.tfLotNumberParam.setRequired(false);
                            this.tfLotNumberParam.setEditable(false);
                            this.tfLotNumberParam.setEnabled(false);
                        } else if (MOSplitTypeEnum.REFORM.equals((Object)type)) {
                            LotRuleInfo lotRule = (LotRuleInfo)ManufactureOrderFactory.getRemoteInstance().invoke("getProperLotRule", new Object[]{material.getId().toString(), this.storageOrgUnitInfo.getId().toString()});
                            if (lotRule == null) {
                                this.tfLotNumberParam.setText(null);
                                this.tfLotNumberParam.setRequired(true);
                                this.tfLotNumberParam.setEditable(true);
                                this.tfLotNumberParam.setEnabled(true);
                            } else {
                                LotFrame lotFrame = LotRuleFactory.getRemoteInstance().getLotFrameExtend(material.getId().toString(), this.storageOrgUnitInfo.getId().toString());
                                if (lotFrame != null && lotFrame.getLotRule() != null) {
                                    lotFrame.setLotRule(lotRule);
                                    lotFrame.setSysDate(new Date());
                                    lotFrame.setMaterial(material.getNumber());
                                    lotFrame.setBillNumber(material.getNumber());
                                    lotFrame.setMfg((Date)this.dpPlanFinishDate.getValue());
                                    this.tfLotNumberParam.setText(lotFrame.getLotNumber());
                                    boolean modifiable = lotFrame.getLotRule().isIsModifiable();
                                    this.tfLotNumberParam.setRequired(modifiable);
                                    this.tfLotNumberParam.setEditable(modifiable);
                                    this.tfLotNumberParam.setEnabled(modifiable);
                                }
                            }
                        }
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Throwable)exc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workDateChanged(DataChangeEvent event) {
        try {
            Date date;
            this.removeListeners();
            String strStorageOrgUnitId = null;
            strStorageOrgUnitId = ((StorageOrgUnitInfo)this.prmptStorageOrgUnit.getValue()).getId().toString();
            if (event.getSource() == this.dpPlanStartDate) {
                Date date2 = (Date)this.dpPlanStartDate.getValue();
                if (!this.isWorkDay(strStorageOrgUnitId, date2)) {
                    Date startDate = EMMManufactureOrderSplitEditUI.getDateAfterDays(this.storageOrgUnitInfo, date2, 1);
                    if (startDate == null) {
                        startDate = date2;
                    }
                    this.dpPlanStartDate.setValue((Object)startDate);
                }
            } else if (event.getSource() == this.dpPlanFinishDate && !this.isWorkDay(strStorageOrgUnitId, date = (Date)this.dpPlanFinishDate.getValue())) {
                Date endDate = EMMManufactureOrderSplitEditUI.getDateAfterDays(this.storageOrgUnitInfo, date, 1);
                if (endDate == null) {
                    endDate = date;
                }
                this.dpPlanFinishDate.setValue((Object)endDate);
            }
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Throwable)exc);
        }
        finally {
            this.addListeners();
        }
    }

    private boolean isWorkDay(String strStorageOrgUnitId, Date date) throws EASBizException, BOSException {
        return FactoryCalendarFactory.getRemoteInstance().isWorkDay(strStorageOrgUnitId, date);
    }

    private void splitQtyhanged(DataChangeEvent event) {
        if (event.getSource() instanceof KDFormattedTextField) {
            this.recalculate((KDFormattedTextField)event.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculate(KDFormattedTextField component) {
        try {
            this.removeListeners();
            BigDecimal total = this.ftfCurrentSplitQtyParam.getBigDecimalValue();
            BigDecimal blocks = this.ftfSplitBlocksParam.getBigDecimalValue();
            BigDecimal avg = this.ftfEachOrderQtyParam.getBigDecimalValue();
            Integer scale = this.ftfOrderSplitScaleParam.getIntegerValue();
            if (scale != null) {
                if (component.equals(this.ftfSplitBlocksParam)) {
                    if (total != null && blocks != null && blocks.intValue() != 0) {
                        this.ftfEachOrderQtyParam.setPrecision(scale.intValue());
                        this.ftfEachOrderQtyParam.setRoundingMode(1);
                        BigDecimal value = total.divide(blocks, (int)scale, 1);
                        this.ftfEachOrderQtyParam.setValue((Object)value);
                        this.ftfEachOrderQtyParam.commitEdit();
                    }
                } else if (component.equals(this.ftfEachOrderQtyParam)) {
                    if (total != null && avg != null && avg.compareTo(BIG_DECIMAL_ZERO) > 0) {
                        this.ftfSplitBlocksParam.setPrecision(0);
                        this.ftfSplitBlocksParam.setRoundingMode(0);
                        BigDecimal value = total.divide(avg, 0);
                        this.ftfSplitBlocksParam.setValue((Object)value.setScale(0, 0));
                        this.ftfSplitBlocksParam.commitEdit();
                    }
                } else if (component.equals(this.ftfOrderSplitScaleParam)) {
                    if (total != null && blocks != null && blocks.intValue() != 0) {
                        this.ftfCurrentSplitQtyParam.setPrecision(scale.intValue());
                        total = total.setScale((int)scale, 1);
                        this.ftfCurrentSplitQtyParam.setRoundingMode(1);
                        this.ftfCurrentSplitQtyParam.setValue((Object)total);
                        this.ftfCurrentSplitQtyParam.commitEdit();
                        this.ftfEachOrderQtyParam.setPrecision(scale.intValue());
                        this.ftfEachOrderQtyParam.setRoundingMode(1);
                        BigDecimal value = total.divide(blocks, (int)scale, 1);
                        this.ftfEachOrderQtyParam.setValue((Object)value);
                        this.ftfEachOrderQtyParam.commitEdit();
                    }
                } else if (component.equals(this.ftfCurrentSplitQtyParam) && total != null && blocks != null && blocks.intValue() != 0) {
                    this.ftfEachOrderQtyParam.setPrecision(scale.intValue());
                    this.ftfEachOrderQtyParam.setRoundingMode(1);
                    BigDecimal value = total.divide(blocks, (int)scale, 1);
                    this.ftfEachOrderQtyParam.setValue((Object)value);
                    this.ftfEachOrderQtyParam.commitEdit();
                }
            }
        }
        catch (ParseException exc) {
            ExceptionHandler.handle((Throwable)exc);
        }
        finally {
            this.addListeners();
        }
    }

    private void routingSelected(SelectorEvent event) {
        MaterialInfo materialInfo = (MaterialInfo)this.prmptMaterialParam.getData();
        String materialId = materialInfo == null ? "null" : materialInfo.getId().toString();
        String orgId = this.storageOrgUnitInfo == null ? "null" : this.storageOrgUnitInfo.getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(60)));
        viewInfo.setFilter(filterInfo);
        this.prmptRoutingParam.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7RootingQuery");
        this.prmptRoutingParam.setEntityViewInfo(viewInfo);
        this.prmptRoutingParam.setSelector((KDPromptSelector)new RoutingPromptSelector((IUIObject)this, this.prmptStorageOrgUnit, this.prmptMaterialParam));
        this.prmptRoutingParam.getQueryAgent().resetRuntimeEntityView();
    }

    private void bomSelected(SelectorEvent event) {
        MaterialInfo materialInfo = (MaterialInfo)this.prmptMaterialParam.getData();
        String materialId = materialInfo == null ? "null" : materialInfo.getId().toString();
        String orgId = this.storageOrgUnitInfo == null ? "null" : this.storageOrgUnitInfo.getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
        viewInfo.setFilter(filterInfo);
        this.prmptBOMParam.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7BomQuery");
        this.prmptBOMParam.setEntityViewInfo(viewInfo);
        this.prmptBOMParam.setSelector((KDPromptSelector)new BomPromptSelector((IUIObject)this, this.prmptStorageOrgUnit, this.prmptMaterialParam, this.prmptProjectParam, this.prmptTrackParam));
        this.prmptBOMParam.getQueryAgent().resetRuntimeEntityView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void materialChanged(DataChangeEvent event) {
        try {
            this.removeListeners();
            MaterialInfo oldValue = (MaterialInfo)event.getOldValue();
            MaterialInfo newValue = (MaterialInfo)event.getNewValue();
            boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
            if (isDifferent) {
                this.prmptProjectParam.setValue(null);
                this.prmptTrackParam.setValue(null);
                UIHelper.registerProjectF7ForEdit((KDBizPromptBox)this.prmptStorageOrgUnit, null, (KDBizPromptBox)this.prmptProjectParam);
                HashSet<Integer> status = new HashSet<Integer>();
                status.add(new Integer(10));
                UIHelper.registerTrackNumberF7((KDBizPromptBox)this.prmptStorageOrgUnit, null, (KDBizPromptBox)this.prmptProjectParam, (KDBizPromptBox)this.prmptTrackParam, status, (boolean)false, (boolean)true);
                if (newValue != null) {
                    MaterialInfo material = (MaterialInfo)this.prmptMaterialParam.getValue();
                    this.setMaterialPlanCache();
                    this.setProjectTrackNumberEditable();
                    this.setMaterialPlanData();
                    ProjectInfo project = (ProjectInfo)this.prmptProjectParam.getValue();
                    TrackNumberInfo track = (TrackNumberInfo)this.prmptTrackParam.getValue();
                    String projectID = project == null ? null : project.getId().toString();
                    String trackID = track == null ? null : track.getId().toString();
                    AdminOrgUnitInfo adminOrg = null;
                    if (this.prmptAdminOrgUnit.getValue() != null) {
                        adminOrg = (AdminOrgUnitInfo)this.prmptAdminOrgUnit.getValue();
                    }
                    this.transTypeReform = MOProductTransactionTypeUtil.getDefaultTransType(null, (MaterialInfo)material, null, (StorageOrgUnitInfo)this.storageOrgUnitInfo, (AdminOrgUnitInfo)adminOrg, (String)this.bizTypeReform.getId().toString());
                    BomInfo bom = BOMExtend2FacadeFactory.getRemoteInstance().getBomByTrcAndPrjID(material.getId().toString(), projectID, trackID, this.storageOrgUnitInfo != null ? this.storageOrgUnitInfo.getId().toString() : null);
                    this.prmptBOMParam.setValue((Object)bom);
                    StandardRootingInfo routing = null;
                    if (MOSplitTypeEnum.STANDARD.equals(this.cmbSplitTypeParam.getSelectedItem())) {
                        routing = this.getDefaultRouting(material.getId().toString(), this.storageOrgUnitInfo.getId().toString(), this.transTypeStandard);
                    } else if (MOSplitTypeEnum.REFORM.equals(this.cmbSplitTypeParam.getSelectedItem())) {
                        routing = this.getDefaultRouting(material.getId().toString(), this.storageOrgUnitInfo.getId().toString(), this.transTypeReform);
                    }
                    this.prmptRoutingParam.setValue(routing);
                    this.tfModelParam.setText(material.getModel());
                    MeasureUnitInfo unit = this.getProdcutUnit(material, this.storageOrgUnitInfo);
                    this.prmptUnitParam.setValue((Object)unit);
                    this.precision = new Integer(unit.getQtyPrecision());
                    this.ftfOrderSplitScaleParam.setMaximumValue((Comparable)this.precision);
                    this.ftfOrderSplitScaleParam.setValue((Object)this.precision);
                    this.ftfCurrentSplitQtyParam.setPrecision(this.precision.intValue());
                    this.ftfEachOrderQtyParam.setPrecision(this.precision.intValue());
                    this.initLotMode(material, this.storageOrgUnitInfo, (MOSplitTypeEnum)this.cmbSplitTypeParam.getSelectedItem());
                    Calendar calendar = Calendar.getInstance();
                    Date startDate = EMMManufactureOrderSplitEditUI.getDateAfterDays(this.storageOrgUnitInfo, calendar.getTime(), 1);
                    this.dpPlanStartDate.setValue((Object)startDate);
                    int leadingDays = EMMManufactureOrderSplitEditUI.getLeadingDays(material, this.storageOrgUnitInfo);
                    Date finishDate = EMMManufactureOrderSplitEditUI.getDateAfterDays(this.storageOrgUnitInfo, startDate, leadingDays);
                    this.dpPlanFinishDate.setValue((Object)finishDate);
                    this.setManufactureStrategyRelated(material, this.storageOrgUnitInfo);
                } else {
                    this.prmptBOMParam.setValue(null);
                    this.prmptRoutingParam.setValue(null);
                    this.tfModelParam.setText(null);
                    this.prmptUnitParam.setValue(null);
                    this.ftfOrderSplitScaleParam.setValue((Object)INTEGER_ZERO);
                    this.ftfCurrentSplitQtyParam.setPrecision(0);
                    this.ftfEachOrderQtyParam.setPrecision(0);
                    this.cmbLotModeParam.setSelectedItem((Object)MOSplitLotModeEnum.GENERATE_BY_SOURCE);
                    this.cmbLotModeParam.setEditable(true);
                    this.cmbLotModeParam.setEnabled(true);
                    this.tfLotNumberParam.setText(null);
                    this.tfLotNumberParam.setRequired(false);
                    this.tfLotNumberParam.setEditable(false);
                    this.tfLotNumberParam.setEnabled(false);
                    this.dpPlanStartDate.setValue(null);
                    this.dpPlanFinishDate.setValue(null);
                    this.prmptAdminOrgUnit.setValue(null);
                }
            }
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Throwable)exc);
        }
        finally {
            this.addListeners();
        }
    }

    private void setMaterialPlanData() {
        MaterialInfo info = this.prmptMaterialParam.getValue() == null ? null : (MaterialInfo)this.prmptMaterialParam.getValue();
        MaterialPlanInfo planInfo = null;
        if (info != null && this.materialPlanMap != null) {
            planInfo = (MaterialPlanInfo)this.materialPlanMap.get(info.getId().toString());
        }
        if (planInfo != null) {
            this.prmptAdminOrgUnit.setValue((Object)planInfo.getDutyDepartment());
        } else {
            this.prmptAdminOrgUnit.setValue(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectChanged(DataChangeEvent e) {
        try {
            this.removeListeners();
            ProjectInfo oldValue = (ProjectInfo)e.getOldValue();
            ProjectInfo newValue = (ProjectInfo)e.getNewValue();
            boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
            if (isDifferent) {
                this.prmptTrackParam.setValue(null);
                ProjectInfo project = (ProjectInfo)this.prmptProjectParam.getValue();
                TrackNumberInfo track = (TrackNumberInfo)this.prmptTrackParam.getValue();
                MaterialInfo material = (MaterialInfo)this.prmptMaterialParam.getValue();
                String materialId = material != null ? material.getId().toString() : null;
                String projectID = project == null ? null : project.getId().toString();
                String trackID = track == null ? null : track.getId().toString();
                String orgId = this.storageOrgUnitInfo != null ? this.storageOrgUnitInfo.getId().toString() : null;
                BomInfo bom = BOMExtend2FacadeFactory.getRemoteInstance().getBomByTrcAndPrjID(materialId, projectID, trackID, orgId);
                this.prmptBOMParam.setValue((Object)bom);
            }
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        finally {
            this.addListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackNumberChanged(DataChangeEvent e) {
        try {
            this.removeListeners();
            TrackNumberInfo oldValue = (TrackNumberInfo)e.getOldValue();
            TrackNumberInfo newValue = (TrackNumberInfo)e.getNewValue();
            boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
            if (isDifferent) {
                ProjectInfo project = (ProjectInfo)this.prmptProjectParam.getValue();
                TrackNumberInfo track = (TrackNumberInfo)this.prmptTrackParam.getValue();
                MaterialInfo material = (MaterialInfo)this.prmptMaterialParam.getValue();
                String materialId = material != null ? material.getId().toString() : null;
                String projectID = project == null ? null : project.getId().toString();
                String trackID = track == null ? null : track.getId().toString();
                String orgId = this.storageOrgUnitInfo != null ? this.storageOrgUnitInfo.getId().toString() : null;
                BomInfo bom = BOMExtend2FacadeFactory.getRemoteInstance().getBomByTrcAndPrjID(materialId, projectID, trackID, orgId);
                this.prmptBOMParam.setValue((Object)bom);
            }
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        finally {
            this.addListeners();
        }
    }

    private void setProjectTrackNumberEditable() throws BOSException {
        MaterialInfo info = (MaterialInfo)this.prmptMaterialParam.getValue();
        if (info == null) {
            return;
        }
        if (this.materialPlanMap == null) {
            return;
        }
        MaterialPlanInfo planInfo = (MaterialPlanInfo)this.materialPlanMap.get(info.getId().toString());
        if (planInfo != null && planInfo.getManufactureStrategy() != null) {
            if (planInfo.getManufactureStrategy().getId().toString().equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || planInfo.getManufactureStrategy().getId().toString().equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || planInfo.getManufactureStrategy().getId().toString().equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || planInfo.getManufactureStrategy().getId().toString().equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) {
                this.prmptProjectParam.setValue(null);
                this.prmptProjectParam.setEnabled(false);
                this.prmptProjectParam.setEditable(false);
                this.prmptProjectParam.setRequired(false);
                this.prmptTrackParam.setRequired(true);
                this.prmptTrackParam.setEnabled(true);
                this.prmptTrackParam.setEditable(true);
            } else if (planInfo.getManufactureStrategy().getId().toString().equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || planInfo.getManufactureStrategy().getId().toString().equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                if (planInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM) {
                    this.prmptProjectParam.setEnabled(true);
                    this.prmptProjectParam.setEditable(true);
                    this.prmptProjectParam.setRequired(true);
                    this.prmptTrackParam.setEnabled(true);
                    this.prmptTrackParam.setEditable(true);
                    this.prmptTrackParam.setRequired(false);
                } else if (planInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM_TRACKNO) {
                    this.prmptProjectParam.setEnabled(true);
                    this.prmptProjectParam.setEditable(true);
                    this.prmptProjectParam.setRequired(true);
                    this.prmptTrackParam.setEnabled(true);
                    this.prmptTrackParam.setEditable(true);
                    this.prmptTrackParam.setRequired(true);
                } else {
                    this.prmptProjectParam.setEnabled(true);
                    this.prmptProjectParam.setEditable(true);
                    this.prmptProjectParam.setRequired(false);
                    this.prmptTrackParam.setEnabled(true);
                    this.prmptTrackParam.setEditable(true);
                    this.prmptTrackParam.setRequired(false);
                }
            } else {
                this.prmptProjectParam.setEnabled(true);
                this.prmptProjectParam.setEditable(true);
                this.prmptProjectParam.setRequired(false);
                this.prmptTrackParam.setEnabled(true);
                this.prmptTrackParam.setEditable(true);
                this.prmptTrackParam.setRequired(false);
            }
        } else {
            this.prmptProjectParam.setEnabled(true);
            this.prmptProjectParam.setEditable(true);
            this.prmptTrackParam.setEnabled(true);
            this.prmptTrackParam.setEditable(true);
        }
    }

    private void setMaterialPlanCache() throws BOSException {
        HashSet<String> materialSet = new HashSet<String>();
        MaterialInfo info = (MaterialInfo)this.prmptMaterialParam.getValue();
        if (info != null) {
            if (this.materialPlanMap == null) {
                materialSet.add(info.getId().toString());
            } else if (this.materialPlanMap.get(info.getId().toString()) == null) {
                materialSet.add(info.getId().toString());
            }
        }
        String orgId = null;
        if (this.prmptStorageOrgUnit.getValue() != null) {
            StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmptStorageOrgUnit.getValue();
            orgId = storage.getId().toString();
        }
        if (orgId != null && materialSet.size() > 0) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("manufactureStrategy.id"));
            sic.add(new SelectorItemInfo("isolatedRule"));
            sic.add(new SelectorItemInfo("dutyDepartment.id"));
            sic.add(new SelectorItemInfo("dutyDepartment.number"));
            sic.add(new SelectorItemInfo("dutyDepartment.name"));
            entityViewInfo.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", materialSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
            entityViewInfo.setFilter(filterInfo);
            MaterialPlanCollection collection = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(entityViewInfo);
            MaterialPlanInfo materialPlanInfo = null;
            for (int i = 0; i < collection.size(); ++i) {
                materialPlanInfo = collection.get(i);
                if (materialPlanInfo == null || materialPlanInfo.getMaterial() == null) continue;
                if (this.materialPlanMap == null) {
                    this.materialPlanMap = new HashMap();
                }
                this.materialPlanMap.put(materialPlanInfo.getMaterial().getId().toString(), materialPlanInfo);
            }
        }
    }

    private MeasureUnitInfo getProdcutUnit(MaterialInfo material, StorageOrgUnitInfo storage) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("productUnit.*"));
        selectorItemCollection.add(new SelectorItemInfo("material.id"));
        selectorItemCollection.add(new SelectorItemInfo("orgUnit.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storage.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialPlanCollection materialPlanCollection = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(entityViewInfo);
        MeasureUnitInfo prodUnit = null;
        if (materialPlanCollection != null && materialPlanCollection.size() > 0) {
            MaterialPlanInfo materialPlanInfo = materialPlanCollection.get(0);
            prodUnit = materialPlanInfo.getProductUnit();
        }
        if (prodUnit != null) {
            return prodUnit;
        }
        MeasureUnitInfo baseUnit = material.getBaseUnit();
        baseUnit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(baseUnit.getId()));
        return baseUnit;
    }

    private BizTypeInfo getBizType(String number) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("number", (Object)number, CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        viewInfo.setFilter(filterInfo);
        BizTypeCollection bizTypeCol = BizTypeFactory.getRemoteInstance().getBizTypeCollection(viewInfo);
        BizTypeInfo type = null;
        if (bizTypeCol != null && bizTypeCol.size() > 0) {
            type = bizTypeCol.get(0);
        }
        return type;
    }

    private StandardRootingInfo getDefaultRouting(String materialID, String storageOrgUnitID, ProductTransactionTypeInfo transTypeInfo) throws BOSException, EASBizException {
        StandardRootingInfo mainRouting = null;
        if (transTypeInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID));
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(60)));
            filterInfo.getFilterItems().add(new FilterItemInfo("isMainRooting", (Object)Boolean.TRUE));
            viewInfo.setFilter(filterInfo);
            viewInfo.setSelector(EMMManufactureOrderSplitEditUI.getSelectors4Routing());
            StandardRootingCollection col = StandardRootingFactory.getRemoteInstance().getStandardRootingCollection(viewInfo);
            if (col != null && col.size() > 0) {
                mainRouting = col.get(0);
            }
            if (mainRouting == null) {
                mainRouting = MORootingUtil.getDefaultRooting(null, (ProductTransactionTypeInfo)transTypeInfo, (String)storageOrgUnitID);
            }
        }
        return mainRouting;
    }

    public boolean checkMaterialLot() throws ManufactureOrderSplitException {
        boolean toBeContinue = true;
        int splitOperationNumber = (Integer)this.getUIContext().get("oprtNO");
        BigDecimal totalSplitQty = (BigDecimal)this.getUIContext().get("oprtTotalSplitQty");
        int blocks = this.ftfSplitBlocksParam.getIntegerValue();
        BigDecimal avgOrderQty = this.ftfEachOrderQtyParam.getBigDecimalValue();
        BigDecimal billQty = NumericUtil.emptyToZero((Object)this.mo.getQty());
        BigDecimal qty = billQty.subtract(totalSplitQty);
        ManufactureOrderStockCollection stocks = this.mo.getStocks();
        MMCommonUtils.objectValueSort((IObjectCollection)stocks, (boolean)true, (String)"operationNo");
        for (int i = 0; i < stocks.size(); ++i) {
            ManufactureOrderStockInfo stockInfo = stocks.get(i);
            if (stockInfo.getOperationNo() < splitOperationNumber) continue;
            BigDecimal planQty = NumericUtil.emptyToZero((Object)stockInfo.getPlannedQty());
            BigDecimal planQtyStockingRatio = planQty.divide(qty, 8, 4);
            BigDecimal subPlanQty = avgOrderQty.multiply(planQtyStockingRatio).setScale(8, 4);
            BigDecimal remainPlanQty = stockInfo.getPlannedQty().subtract(subPlanQty.multiply(new BigDecimal(String.valueOf(blocks))));
            BigDecimal actIssueQty = NumericUtil.emptyToZero((Object)stockInfo.getActIssueQty()).subtract(remainPlanQty);
            BigDecimal rejectedQty = NumericUtil.emptyToZero((Object)stockInfo.getRejectedQty());
            BigDecimal scrapQty = NumericUtil.emptyToZero((Object)stockInfo.getScrapQty());
            BigDecimal materialScrapQty = NumericUtil.emptyToZero((Object)stockInfo.getMaterialScrapQty());
            BigDecimal feedingQty = NumericUtil.emptyToZero((Object)stockInfo.getFeedingQty());
            BigDecimal materialFeedingQty = NumericUtil.emptyToZero((Object)stockInfo.getMaterialFeedingQty());
            BigDecimal retQty = actIssueQty.subtract(rejectedQty).subtract(scrapQty).subtract(materialScrapQty).add(feedingQty).add(materialFeedingQty);
            if (retQty.compareTo(DECIMAL_ZERO) <= 0) continue;
            StorageOrgUnitInfo orgInfo = this.mo.getStorageOrgUnit();
            Context ctx = (Context)this.getUIContext().get("mo_editui_mainOrgContext");
            MaterialInventoryInfo invInfo = null;
            try {
                invInfo = MaterialInventoryFactory.getRemoteInstanceWithObjectContext((Context)ctx).getInventoryInfo(stockInfo.getMaterial().getId().toString(), orgInfo.getId().toString());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (invInfo == null || !invInfo.isIsLotNumber()) continue;
            int confirm = MsgBox.showConfirm2((String)this.getResource("HAS_LOT_MATERIAL", null));
            if (confirm != 2 && confirm != 1) break;
            toBeContinue = false;
            break;
        }
        return toBeContinue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionOrderSplit_actionPerformed(ActionEvent e) {
        EMMManufactureOrderEditUI moEditUI = (EMMManufactureOrderEditUI)((Object)this.getUIContext().get("Owner"));
        Context ctx = (Context)this.getUIContext().get("mo_editui_mainOrgContext");
        EMMManufactureOrderTreeUI moTreeUI = EMMManufactureOrderSplitEditUI.findTreeUI(moEditUI);
        try {
            if (this.verify()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("currentStorageOrgUnitInfo", SysContext.getSysContext().getCurrentStorageUnit());
                params.put("storageOrgUnit", this.storageOrgUnitInfo);
                params.put("srcOrderID", this.mo.getId().toString());
                params.put("bom", this.bom);
                params.put("oprtNO", Integer.valueOf(this.tfSplitOperationNumber.getText()));
                MOSplitTypeEnum splitType = (MOSplitTypeEnum)this.cmbSplitTypeParam.getSelectedItem();
                params.put("splitType", splitType);
                params.put("splitQty", this.ftfCurrentSplitQtyParam.getBigDecimalValue());
                params.put("splitBlocks", this.ftfSplitBlocksParam.getIntegerValue());
                params.put("splitAverage", this.ftfEachOrderQtyParam.getBigDecimalValue());
                params.put("splitScale", this.ftfOrderSplitScaleParam.getIntegerValue());
                params.put("reform_material", this.prmptMaterialParam.getValue());
                params.put("reform_bom", this.prmptBOMParam.getValue());
                params.put("reform_project", this.prmptProjectParam.getValue());
                params.put("reform_track", this.prmptTrackParam.getValue());
                params.put("reform_routing", this.prmptRoutingParam.getValue());
                params.put("reform_customized_lot", this.tfLotNumberParam.getText());
                params.put("lot_generate_mode", this.cmbLotModeParam.getSelectedItem());
                params.put("planStartDate", this.dpPlanStartDate.getValue());
                params.put("planFinishDate", this.dpPlanFinishDate.getValue());
                params.put("dateStepLength", this.spinnerStepLength.getIntegerVlaue());
                params.put("adminOrgUnit", this.prmptAdminOrgUnit.getValue());
                params.put("unit", this.prmptUnitParam.getValue());
                params.put("baseUnit", this.prmptMaterialParam.getValue() != null ? ((MaterialInfo)this.prmptMaterialParam.getValue()).getBaseUnit() : null);
                moEditUI.setMessageText(this.getResource("SPLIT_STARTED", null));
                moEditUI.showMessage();
                this.disposeUIWindow();
                if (!this.checkMaterialLot()) {
                    return;
                }
                if (moTreeUI != null) {
                    moTreeUI.setCursor(Cursor.getPredefinedCursor(3));
                } else {
                    moEditUI.setCursor(Cursor.getPredefinedCursor(3));
                }
                ManufactureOrderCollection result = null;
                if (MOSplitTypeEnum.STANDARD.equals((Object)splitType)) {
                    params.put("bizType", this.bizTypeStandard);
                    params.put("transactionType", this.transTypeStandard);
                    result = ManufactureOrderSplitFacadeFactory.getRemoteInstanceWithObjectContext((Context)ctx).split(params);
                } else if (MOSplitTypeEnum.REFORM.equals((Object)splitType)) {
                    params.put("bizType", this.bizTypeReform);
                    params.put("transactionType", this.transTypeReform);
                    result = ManufactureOrderSplitFacadeFactory.getRemoteInstanceWithObjectContext((Context)ctx).reform(params);
                }
                this.getUIContext().put("splittedOrders", result);
                EMMManufactureOrderSplitEditUI.synchronize(moEditUI, (IObjectPK)new ObjectUuidPK(this.mo.getId().toString()));
                HashMap<String, Object> inParams = new HashMap<String, Object>();
                inParams.put("OLDORDER", this.mo);
                inParams.put("NEWORDERS", result);
                EMMManufactureOrderFacadeFactory.getRemoteInstance().syncTechnicsEx(inParams);
                moEditUI.setMessageText(this.getResource("SPLIT_SUCCEED", null));
                moEditUI.showMessage();
            }
        }
        catch (Exception exc) {
            moEditUI.setMessageText(this.getResource("SPLIT_FAILED", null));
            moEditUI.showMessage();
            if (exc instanceof ManufactureOrderSplitException) {
                MsgBox.showInfo((String)exc.getMessage());
            } else {
                ExceptionHandler.handle((Throwable)exc);
            }
        }
        finally {
            if (moTreeUI != null) {
                moTreeUI.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                moEditUI.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public static void synchronize(EMMManufactureOrderEditUI moEditUI, IObjectPK pk) throws Exception {
        moEditUI.loadOrderData(pk);
        ManufactureOrderInfo mo = (ManufactureOrderInfo)moEditUI.getDataObject();
        EMMManufactureOrderTreeUI moTreeUI = EMMManufactureOrderSplitEditUI.findTreeUI(moEditUI);
        if (moTreeUI != null) {
            moTreeUI.initTree();
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)moTreeUI.manOrderTree.getModel().getRoot();
            ArrayList result = new ArrayList();
            moTreeUI.findTreePathByManufactureOrder(result, new TreePath(root), mo, false);
            if (result.size() > 0) {
                TreePath path = (TreePath)result.get(0);
                moTreeUI.manOrderTree.setSelectionPath(path);
                moTreeUI.manOrderTree.expandPath(path);
            } else {
                moTreeUI.manOrderTree.setSelectionPath(new TreePath(root.getPath()));
            }
        }
    }

    private static EMMManufactureOrderTreeUI findTreeUI(EMMManufactureOrderEditUI moEditUI) {
        for (Container container = moEditUI.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof EMMManufactureOrderTreeUI)) continue;
            return (EMMManufactureOrderTreeUI)((Object)container);
        }
        return null;
    }

    private static SelectorItemCollection getSelectors4Routing() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        return sic;
    }
}

