/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.emm.mo.client.AbstractEMMManufactureOrderStockFilterUI;
import com.kingdee.eas.mm.basedata.IssuePropEnum;
import com.kingdee.eas.mm.basedata.util.MfgBomUtil;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class EMMManufactureOrderStockFilterUI
extends AbstractEMMManufactureOrderStockFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EMMManufactureOrderStockFilterUI.class);
    private static final long serialVersionUID = -4877811519993924954L;
    protected CustomerParams params = null;
    protected SelectorListener f7SelectorListener = null;

    public static Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)strKey);
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "mm_mo_addnew";
        }
        if ("UPDATE".equals(status)) {
            return "mm_mo_update";
        }
        if ("VIEW".equals(status)) {
            return "mm_mo_view";
        }
        return null;
    }

    public void clear() {
        super.setAuthorizedMainOrgs(null);
        super.clear();
        this.comboMOTBaseStatus.setSelectedItem((Object)EntryBaseStatusEnum.NULL);
        this.comboMOTBaseStatus.removeItem((Object)EntryBaseStatusEnum.VERSION);
        this.comboMOTBaseStatus.removeItem((Object)EntryBaseStatusEnum.ALTERING);
        this.comboMOTBaseStatus.removeItem((Object)EntryBaseStatusEnum.ADD);
        this.comboMOTBaseStatus.removeItem((Object)EntryBaseStatusEnum.TEMPORARILYSAVED);
        this.comboMOTBaseStatus.removeItem((Object)EntryBaseStatusEnum.SUBMITED);
        this.comboMOTBaseStatus.removeItem((Object)EntryBaseStatusEnum.DELETED);
        this.comboMOTBaseStatus.removeItem((Object)EntryBaseStatusEnum.BLOCKED);
        this.comboMOTBaseStatus.removeItem((Object)EntryBaseStatusEnum.CLOSED);
        this.comboMOTBaseStatus.removeItem((Object)EntryBaseStatusEnum.PUTIN);
        this.comboMOTBaseStatus.removeItem((Object)EntryBaseStatusEnum.FINISH);
        this.combIssueProp.setSelectedItem((Object)IssuePropEnum.NULL);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        try {
            Object object = this.comboMOTBaseStatus.getSelectedItem();
            if (!EntryBaseStatusEnum.NULL.equals(object)) {
                EntryBaseStatusEnum motBaseStatus = null;
                if (object instanceof EntryBaseStatusEnum) {
                    motBaseStatus = (EntryBaseStatusEnum)object;
                }
                cp.addCustomerParam("comboMOTBaseStatus", String.valueOf(motBaseStatus.getValue()));
            }
            if (this.combIssueProp.getSelectedItem() != null) {
                IssuePropEnum issueProp = (IssuePropEnum)this.combIssueProp.getSelectedItem();
                cp.addCustomerParam("combIssueProp", String.valueOf(issueProp.getValue()));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return cp;
    }

    public FilterInfo getFilterInfo() {
        IssuePropEnum issueProp;
        FilterInfo filterInfo = super.getFilterInfo();
        Object object = this.comboMOTBaseStatus.getSelectedItem();
        if (!EntryBaseStatusEnum.NULL.equals(object) && object instanceof EntryBaseStatusEnum) {
            EntryBaseStatusEnum motBaseStatus = (EntryBaseStatusEnum)object;
            StringBuffer sql = new StringBuffer();
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From T_MM_MFTOrderTechnics MOT\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MOT.FParentID=Stocks.FParentID\r\n");
            sql.append("And MOT.FOperationNO=Stocks.FOperationNO\r\n");
            sql.append("And MOT.FBaseStatus=").append(motBaseStatus.getValue()).append("\r\n");
            filterInfo.getFilterItems().add(new FilterItemInfo("stocks.id", (Object)sql.toString(), CompareType.EXISTS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " And #" + (filterInfo.getFilterItems().size() - 1));
        }
        if (this.combIssueProp.getSelectedItem() != null && (issueProp = (IssuePropEnum)this.combIssueProp.getSelectedItem()) != null && !issueProp.equals((Object)IssuePropEnum.NULL)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("stocks.issueProp", (Object)issueProp.getValue(), CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " And #" + (filterInfo.getFilterItems().size() - 1));
        }
        return filterInfo;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        if (this.params != null) {
            try {
                String value = null;
                value = this.params.getCustomerParam("comboMOTBaseStatus");
                if (value != null) {
                    int motBaseStatusValue = Integer.parseInt(value);
                    this.comboMOTBaseStatus.setSelectedItem((Object)EntryBaseStatusEnum.getEnum((int)motBaseStatusValue));
                } else {
                    this.comboMOTBaseStatus.setSelectedItem((Object)EntryBaseStatusEnum.NULL);
                }
                value = this.params.getCustomerParam("combIssueProp");
                if (value != null) {
                    int issuePropValue = Integer.parseInt(value);
                    this.combIssueProp.setSelectedItem((Object)IssuePropEnum.getEnum((int)issuePropValue));
                } else {
                    this.combIssueProp.setSelectedItem((Object)IssuePropEnum.NULL);
                }
                this.resetTrackNumberEntityViewInfo();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EMMManufactureOrderStockFilterUI.getResource("Stroage_IsNotNull")));
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.VERSION);
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.ALTERING);
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.ADD);
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.FINISH);
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.PUBLISHED);
        Timestamp[] dates = EMMManufactureOrderStockFilterUI.getDefaultDateRange(SCMClientUtils.getServerDate2());
        CompositeFilterElement elements = new CompositeFilterElement(0);
        RangeFilterElement elementBizDate = new RangeFilterElement("bizDate", (Component)this.dateBizDateFrom, (Component)this.dateBizDateTo);
        elementBizDate.setDefaultValue((Object)dates);
        elementBizDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)elementBizDate);
        elements.add((FilterElement)new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit));
        elements.add((FilterElement)new SingleFilterElement("bizType.number", (Component)this.PromptBizType));
        elements.add((FilterElement)new SingleFilterElement("transactionType.number", (Component)this.PromProductTranType));
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.kDBizBillNumFrom, (Component)this.kDBizBillNumTo));
        elements.add((FilterElement)new RangeFilterElement("material1.number", (Component)this.promMaterialNumFrom, (Component)this.promMaterialNumTo));
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtprojectStart);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtprojectEnd);
        elements.add((FilterElement)new RangeFilterElement("project.number", (Component)this.prmtprojectStart, (Component)this.prmtprojectEnd));
        MfgBomUtil.initPrmtMainTenanceFilters((KDBizPromptBox)this.prmtMainTenanceLevel);
        elements.add((FilterElement)new SingleFilterElement("mainTenanceLevel.number", (Component)this.prmtMainTenanceLevel));
        this.prmtttrackNumStart.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        this.prmttrackNumEnd.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtttrackNumStart, (Component)this.prmttrackNumEnd));
        elements.add((FilterElement)new RangeFilterElement("bomNum", (Component)this.promBOMNumFrom, (Component)this.promBOMNumTo));
        UIHelper.registerBizOrgF7((KDBizPromptBox)this.promOrgUnitFrom, null, null, (OrgType)this.getMainBizOrgType(), (OrgType)OrgType.Admin, (boolean)false);
        UIHelper.registerBizOrgF7((KDBizPromptBox)this.promOrgUnitTo, null, null, (OrgType)this.getMainBizOrgType(), (OrgType)OrgType.Admin, (boolean)false);
        elements.add((FilterElement)new RangeFilterElement("adminOrgUnit.number", (Component)this.promOrgUnitFrom, (Component)this.promOrgUnitTo));
        elements.add((FilterElement)new RangeFilterElement("costObject.number", (Component)this.prmtCostObjectFrom, (Component)this.prmtCostObjectTo));
        elements.add((FilterElement)new RangeFilterElement("dispatcher.number", (Component)this.promPersonFrom, (Component)this.promPersonTo));
        elements.add((FilterElement)new RangeFilterElement("stocks.material.number", (Component)this.promEntryMaterialNumFrom, (Component)this.promEntryMaterialNumTo));
        RangeFilterElement planBeginDate = new RangeFilterElement("planBeginDate", (Component)this.datePlanStartFrom, (Component)this.datePlanStartTo);
        planBeginDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)planBeginDate);
        RangeFilterElement planEnfDate = new RangeFilterElement("planEndDate", (Component)this.datePlanEndFrom, (Component)this.datePlanEndTo);
        planEnfDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)planEnfDate);
        RangeFilterElement FactStratDate = new RangeFilterElement("actureBeginDate", (Component)this.dateFactStratFrom, (Component)this.dateFactStratTo);
        FactStratDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)FactStratDate);
        RangeFilterElement FactEndDate = new RangeFilterElement("actureEndDate", (Component)this.dateFactEndFrom, (Component)this.dateFactEndTo);
        FactEndDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)FactEndDate);
        this.f7Manager.registerContextChangeF7(this.promBOMNumFrom, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.promBOMNumTo, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.kDBizBillNumFrom, "storageOrgUnit1.id");
        this.f7Manager.registerContextChangeF7(this.kDBizBillNumTo, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.PromProductTranType, "storageOrgUnit.id");
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.comboBaseStatus, (Object)BillBaseStatusEnum.NULL));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo bizfilter = new FilterInfo();
        bizfilter.getFilterItems().add(new FilterItemInfo("number", (Object)"401,402,403", CompareType.INCLUDE));
        ev.setFilter(bizfilter);
        this.PromptBizType.setEntityViewInfo(ev);
        this.PromProductTranType.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                EMMManufactureOrderStockFilterUI.this.productTranTypeaddEntityView();
            }
        });
        this.promBOMNumFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                EMMManufactureOrderStockFilterUI.this.BOMNumAddEntityView();
            }
        });
        this.promBOMNumTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                EMMManufactureOrderStockFilterUI.this.BOMNumAddEntityView();
            }
        });
        this.setMaterialFilter();
        this.addListener();
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.params = cp;
    }

    public boolean verify() {
        if (!super.verify()) {
            return false;
        }
        if (this.dateBizDateFrom.getValue() == null || this.dateBizDateTo.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"Biz_Date_IsNotNull"));
            return false;
        }
        return true;
    }

    private void BOMNumAddEntityView() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)"4", CompareType.EQUALS));
        try {
            this.promBOMNumFrom.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            this.promBOMNumTo.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            this.promBOMNumFrom.getQueryAgent().resetRuntimeEntityView();
            this.promBOMNumTo.getQueryAgent().resetRuntimeEntityView();
            this.promBOMNumFrom.getEntityViewInfo();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void productTranTypeaddEntityView() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"20", CompareType.EQUALS));
        try {
            this.PromProductTranType.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            this.PromProductTranType.getQueryAgent().resetRuntimeEntityView();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void setMaterialFilter() {
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.promMaterialNumFrom, false, queryInfo);
        this.setBizMaterialF7(this.promMaterialNumTo, false, queryInfo);
        this.setBizMaterialF7(this.promEntryMaterialNumFrom, false, queryInfo);
        this.setBizMaterialF7(this.promEntryMaterialNumTo, false, queryInfo);
        EntityViewInfo view = new EntityViewInfo();
        EntityViewInfo entryview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterInfo entryfilter = new FilterInfo();
        entryfilter.getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)String.valueOf(10040), CompareType.NOTEQUALS));
        view.setFilter(filter);
        entryview.setFilter(entryfilter);
        this.promMaterialNumFrom.setEntityViewInfo(view);
        this.promMaterialNumTo.setEntityViewInfo(view);
        this.promEntryMaterialNumFrom.setEntityViewInfo(entryview);
        this.promEntryMaterialNumTo.setEntityViewInfo(entryview);
        this.promMaterialNumTo.getQueryAgent().resetRuntimeEntityView();
        this.promMaterialNumFrom.getQueryAgent().resetRuntimeEntityView();
        this.promEntryMaterialNumFrom.getQueryAgent().resetRuntimeEntityView();
        this.promEntryMaterialNumTo.getQueryAgent().resetRuntimeEntityView();
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.promMaterialNumFrom, this.promMaterialNumTo, this.promEntryMaterialNumFrom, this.promEntryMaterialNumTo});
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected Date getNextMonthDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        return calendar.getTime();
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected String getViewPermission() {
        return "viewStock";
    }

    protected void addListener() {
        if (this.f7SelectorListener == null) {
            this.f7SelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        EMMManufactureOrderStockFilterUI.this.f7WillShow(e);
                    }
                    catch (Exception exc) {
                        EMMManufactureOrderStockFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtttrackNumStart.addSelectorListener(this.f7SelectorListener);
        this.prmttrackNumEnd.addSelectorListener(this.f7SelectorListener);
    }

    protected void f7WillShow(SelectorEvent e) {
        if (!KDBizPromptBox.class.getName().equals(e.getSource().getClass().getName())) {
            return;
        }
        String f7Name = ((KDBizPromptBox)e.getSource()).getName();
        if (this.prmtttrackNumStart.getName().equals(f7Name) || this.prmttrackNumEnd.getName().equals(f7Name)) {
            this.resetTrackNumberEntityViewInfo();
        }
    }

    protected void resetTrackNumberEntityViewInfo() {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        StringBuffer where = new StringBuffer();
        Object o = this.prmtprojectStart.getValue();
        String startProjectNumber = this.prmtprojectStart.getText();
        if (o != null && ProjectInfo.class.isInstance(o)) {
            startProjectNumber = ((ProjectInfo)o).getNumber();
            where.append("And P.FNumber>='").append(startProjectNumber).append("'\r\n");
            o = this.prmtprojectEnd.getValue();
            String endProjectNumber = this.prmtprojectEnd.getText();
            if (o != null && ProjectInfo.class.isInstance(o)) {
                endProjectNumber = ((ProjectInfo)o).getNumber();
            }
            where.append("And P.FNumber<='").append(endProjectNumber).append("'\r\n");
            sql.append("Select\r\n");
            sql.append("PC.FTrackNumberID\r\n");
            sql.append("From T_MM_Project P\r\n");
            sql.append("Inner Join T_MM_ProjectCar PC On PC.FProjectID=P.FID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append(where.toString());
            sql.append("Group By\r\n");
            sql.append("PC.FTrackNumberID\r\n");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)10, CompareType.EQUALS));
        }
        entityViewInfo.setFilter(filterInfo);
        this.prmtttrackNumStart.setEntityViewInfo(entityViewInfo);
        this.prmtttrackNumStart.getQueryAgent().resetRuntimeEntityView();
        this.prmttrackNumEnd.setEntityViewInfo(entityViewInfo);
        this.prmttrackNumEnd.getQueryAgent().resetRuntimeEntityView();
    }
}

