/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.emm.mo.client.AbstractEmmBomF7ListUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.ManufactureStrategyGroup;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;

public class EmmBomF7ListUI
extends AbstractEmmBomF7ListUI {
    private static final long serialVersionUID = 8135947732719383551L;
    private String BOMTYPE_ISNOTNULL = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"BOMTYPE_ISNOTNULL");
    protected boolean isCanceled = true;
    private Map materialPlanMap = new HashMap();
    protected F7ContextManager f7Manager = null;
    private MaterialInfo materialInfo = null;
    private StorageOrgUnitInfo mainOrgInfo = null;
    private ProjectInfo projectInfo = null;
    private DataChangeListener orgDataChanged = null;

    public EmmBomF7ListUI() throws Exception {
        this.defaultObjectName = "f7EMMBomQueryWithGroupPK";
        this.tblMain.checkParsed(true);
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnok, 0, "Double Clicked");
            ItemAction actConfirm = this.getActionFromActionEvent(evt);
            actConfirm.actionPerformed(evt);
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    public void onLoad() throws Exception {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Storage);
        iProducer.getModel().setPermissionItem("mm_mo_addnew");
        this.prmtstroage.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        this.materialInfo = (MaterialInfo)this.getUIContext().get("MATERIAL");
        this.mainOrgInfo = (StorageOrgUnitInfo)this.getUIContext().get("ORG");
        this.projectInfo = (ProjectInfo)this.getUIContext().get("PROJECT");
        if (this.mainOrgInfo != null) {
            this.initUIMainOrgContext(this.mainOrgInfo.getId().toString());
            this.initMaterialF7(this.mainOrgInfo);
        }
        this.prmtstroage.setValue((Object)this.mainOrgInfo);
        this.prmtMaterial.setValue((Object)this.materialInfo);
        this.prmtProject.setValue((Object)this.projectInfo);
        this.chkBomType.setSelectedItem((Object)BOMTypeEnum.ProConfigBOM);
        this.checkBeforeQuery();
        super.onLoad();
        this.getUIToolBar().setVisible(false);
        this.btnquery.setVisible(true);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        BOMTypeEnum bomType;
        ProjectInfo projectinfo;
        MaterialInfo materialInfo;
        FilterInfo filter = new FilterInfo();
        Integer status = new Integer(4);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)status, CompareType.EQUALS));
        StorageOrgUnitInfo storageinfo = (StorageOrgUnitInfo)this.prmtstroage.getValue();
        if (storageinfo != null) {
            String storageOrgUnitId = storageinfo.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        }
        if ((materialInfo = (MaterialInfo)this.prmtMaterial.getValue()) != null) {
            String materialId = materialInfo.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        }
        if ((projectinfo = (ProjectInfo)this.prmtProject.getValue()) != null) {
            String projectid = projectinfo.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectid, CompareType.EQUALS));
        }
        if ((bomType = (BOMTypeEnum)this.chkBomType.getSelectedItem()) != null && bomType.getValue() != 20) {
            filter.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType.getValue(), CompareType.EQUALS));
        }
        return filter;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.isCanceled = false;
        this.disposeUIWindow();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    private void prmtstroage_dataChanged(DataChangeEvent e) {
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMaterial, (OrgUnitInfo)this.getMainOrgInfo());
    }

    public void removeListener() {
        if (this.orgDataChanged != null) {
            this.prmtstroage.removeDataChangeListener(this.orgDataChanged);
        }
    }

    public void addListener() {
        if (this.orgDataChanged == null) {
            this.orgDataChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        EmmBomF7ListUI.this.prmtstroage_dataChanged(e);
                    }
                    catch (Exception exc) {
                        EmmBomF7ListUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtstroage.addDataChangeListener(this.orgDataChanged);
    }

    private void initMaterialF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMaterial, (OrgUnitInfo)storageOrgInfo);
        EntityViewInfo viewInfo = this.prmtMaterial.getEntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        String attrFilter = "10030,10050,10040";
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)attrFilter, CompareType.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.status", (Object)new Integer(1), CompareType.EQUALS));
        viewInfo.getFilter().mergeFilter(filterInfo, "and");
        viewInfo.getFilter();
    }

    private MaterialPlanInfo getMaterialPlan(String materialId) {
        StorageOrgUnitInfo storageinfo = (StorageOrgUnitInfo)this.prmtstroage.getValue();
        String orgId = storageinfo.getId().toString();
        String key = orgId + materialId;
        MaterialPlanInfo plan = null;
        if (this.materialPlanMap.containsKey(key)) {
            plan = (MaterialPlanInfo)this.materialPlanMap.get(key);
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection selectorColl = new SelectorItemCollection();
            selectorColl.add("manufactureStrategy.id");
            selectorColl.add("isolatedRule");
            view.setSelector(selectorColl);
            try {
                MaterialPlanCollection coll = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
                if (coll != null && coll.size() > 0) {
                    plan = coll.get(0);
                    this.materialPlanMap.put(key, plan);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return plan;
    }

    private FilterInfo getFilterInfo(FilterInfo filter, String materialId) throws BOSException {
        MaterialPlanInfo plan = this.getMaterialPlan(materialId);
        if (plan == null) {
            return filter;
        }
        String strategyId = "NUnM+gEcEADgAA3cwKgL09g0uEU=";
        if (plan.getManufactureStrategy() != null) {
            strategyId = plan.getManufactureStrategy().getId().toString();
        }
        if (ManufactureStrategyGroup.getProjectTrackOrderBomStrategyIdSet().contains(strategyId)) {
            FilterInfo f1 = new FilterInfo();
            Integer bomType = new Integer(40);
            f1.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
            FilterInfo f2 = new FilterInfo();
            bomType = new Integer(45);
            f2.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
            IsolatedRuleEnum isolatedRule = plan.getIsolatedRule();
            if (!IsolatedRuleEnum.NONE.equals((Object)isolatedRule)) {
                String projectId = null;
                if (this.prmtProject.getValue() != null && this.prmtProject.getValue() instanceof ProjectInfo) {
                    projectId = ((ProjectInfo)this.prmtProject.getValue()).getId().toString();
                }
                f2.getFilterItems().add(new FilterItemInfo("orderBomTP.projectId", projectId, CompareType.EQUALS));
            }
            f1.mergeFilter(f2, "or");
            filter.mergeFilter(f1, "and");
        } else if (ManufactureStrategyGroup.getTrackOrderBomStrategyIdSet().contains(strategyId)) {
            FilterInfo f1 = new FilterInfo();
            Integer bomType = new Integer(40);
            f1.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
            FilterInfo f2 = new FilterInfo();
            bomType = new Integer(45);
            f2.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
            f2.getFilterItems().add(new FilterItemInfo("orderBomTP.projectId", null, CompareType.EQUALS));
            f1.mergeFilter(f2, "or");
            filter.mergeFilter(f1, "and");
        } else if (ManufactureStrategyGroup.getNoOrderBomStrategyIdSet().contains(strategyId)) {
            Integer bomType = new Integer(40);
            filter.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
        }
        return filter;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BomFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
    }

    protected String getEditUIName() {
        return null;
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.checkBeforeQuery();
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (this.mainQuery != null && this.mainQuery.getSorter() != null) {
            viewInfo.setSorter(this.mainQuery.getSorter());
        }
        this.getEntityViewInfo(viewInfo);
        this.setDataObject("f7EMMBomQueryWithGroup", (IObjectValue)viewInfo);
        this.execQuery();
    }

    private void checkBeforeQuery() {
        if (BOMTypeEnum.NULL.equals(this.chkBomType.getSelectedItem())) {
            MsgBox.showInfo((String)this.BOMTYPE_ISNOTNULL);
            SysUtil.abort();
        }
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
    }
}

