/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.ps.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.assistant.AbstractPrintIntegrationInfo;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.basedata.assistant.util.CommonPrintIntegrationDataProvider;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.RITypeEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.framework.print.MultiapproveDataProvider;
import com.kingdee.eas.industry.emm.common.util.TransactionTypeUtils;
import com.kingdee.eas.industry.emm.mm.ps.DistributeBillVO;
import com.kingdee.eas.industry.emm.mm.ps.DistributePlanFactory;
import com.kingdee.eas.industry.emm.mm.ps.DistributePlanInfo;
import com.kingdee.eas.industry.emm.mm.ps.DistributeStatusEnum;
import com.kingdee.eas.industry.emm.mm.ps.MasterProductionScheduleExtFacadeFactory;
import com.kingdee.eas.industry.emm.mm.ps.client.AbstractDistributePlanListUI;
import com.kingdee.eas.industry.emm.mm.ps.client.DistributePlanQueryUI;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.scm.common.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.scm.common.util.SCMCommonDataProvider;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.client.util.DCDeliveryUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DistributePlanListUI
extends AbstractDistributePlanListUI {
    private static final long serialVersionUID = 6460655583697415869L;
    private String RESURL = "com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource";
    public CommonQueryDialog commonQueryDialog = null;
    DistributePlanQueryUI conditionPanel = null;

    public DistributePlanListUI() throws Exception {
        this.initCommonQueryDialog();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.startDistributePlanMenu.setEnabled(true);
        this.endDistributePlanMenu.setEnabled(true);
        this.cancelDistributePlanMenu.setEnabled(true);
        this.tblMain.setColumnMoveable(true);
        KDTSortManager kdtSort = this.tblMain.getSortMange();
        if (kdtSort == null) {
            kdtSort = new KDTSortManager(this.tblMain);
        }
        kdtSort.setSortAuto(true);
        kdtSort.setClickCount(1);
    }

    protected void initUserConfig() {
        super.initUserConfig();
        this.tblMain.getViewManager().setFreezeView(0, 16);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            this.commonQueryDialog.setWidth(450);
            this.commonQueryDialog.setHeight(320);
            if (this.getUIContext().get("OwnerWindow") == null) {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            try {
                SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(this.getFilterUI(), this.getMainBizOrgType());
                this.commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
                this.commonQueryDialog.setProcessor((IProcessor)new SCMCommonProcessor());
                ISCMFilter iFilter = (ISCMFilter)this.getFilterUI();
                if (iFilter != null) {
                    iFilter.setBOTPFilter((Map)this.getBOTPMap());
                    this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
                    this.commonQueryDialog.setShowFilter(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQueryDialog;
    }

    protected HashMap getBOTPMap() {
        return (HashMap)this.getUIContext().get("BTPEDITPARAMETER");
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new DistributePlanQueryUI();
        }
        return this.conditionPanel;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain2.getSelectManager().setSelectMode(10);
        this.tblMain.getViewManager().setFreezeView(0, 15);
    }

    private void refreshTabMain2() throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ArrayList<DistributeBillVO> voList = new ArrayList<DistributeBillVO>();
        for (int n = 0; n < selectRows.length; ++n) {
            String stockid = (String)this.tblMain.getRow(selectRows[n]).getCell("stockorderid").getValue();
            DistributeBillVO vo = new DistributeBillVO();
            vo.setStockid(stockid);
            voList.add(vo);
        }
        this.tblMain.getViewManager().setFreezeView(0, 15);
        Gson gson = new Gson();
        String str = gson.toJson(voList);
        MaterialReqBillEntryCollection colls = MasterProductionScheduleExtFacadeFactory.getRemoteInstance().queryMaterialReqByStockId(str);
        this.tblMain2.removeRows();
        for (int n = 0; n < colls.size(); ++n) {
            MaterialReqBillEntryInfo info = colls.get(n);
            MaterialReqBillInfo parent = info.getParent();
            String billid = parent.getId().toString();
            parent = MaterialReqBillFactory.getRemoteInstance().getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(billid));
            String billnumber = parent.getNumber();
            String billstatus = parent.getBaseStatus().getAlias();
            TransactionTypeInfo traninfo = TransactionTypeFactory.getRemoteInstance().getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(parent.getTransactionType().getId().toString()));
            String transactiontype = traninfo.getName();
            String materialnumber = info.getMaterial().getNumber();
            String materialname = info.getMaterial().getName();
            String materialmodel = info.getMaterial().getModel();
            String baseunit = info.getUnit().getName();
            BigDecimal issueQty = info.getIssueQty();
            BigDecimal qty = info.getQty();
            BigDecimal actureqty = (BigDecimal)info.get("actureQty");
            String dept = info.getAdminOrgUnit() == null ? "" : info.getAdminOrgUnit().getName();
            Integer hangup = (Integer)info.get("pendingFlag");
            String projectName = "";
            if (info.getProject() != null) {
                projectName = info.getProject().getNumber();
            }
            String trackName = "";
            if (info.getTrackNumber() != null) {
                info.getTrackNumber().getNumber();
            }
            String workCenter = info.getWorkCenter() == null ? "" : info.getWorkCenter().getName();
            String operation = info.getOperation() == null ? "" : info.getOperation().getName();
            Timestamp demanddate = info.getDemandDate();
            String costObjectName = info.getCostObject().getName();
            String costObjectNumber = info.getCostObject().getNumber();
            Date bizdate = info.getBizDate();
            String storageOrgUnit = info.getStorageOrgUnit().getName();
            String costCenterOrgUnitName = info.getCostCenterOrgUnit() == null ? "" : info.getCostCenterOrgUnit().getName();
            String costCenterOrgUnitNumber = info.getCostCenterOrgUnit() == null ? "" : info.getCostCenterOrgUnit().getNumber();
            String invUpdateType = info.getInvUpdateType().getName();
            IRow curRow = this.tblMain2.addRow();
            curRow.getCell("id").setValue((Object)billid);
            curRow.getCell("number").setValue((Object)billnumber);
            curRow.getCell("basestatus").setValue((Object)billstatus);
            curRow.getCell("trantype").setValue((Object)transactiontype);
            curRow.getCell("materialnumber").setValue((Object)materialnumber);
            curRow.getCell("materialname").setValue((Object)materialname);
            curRow.getCell("materialmode").setValue((Object)materialmodel);
            curRow.getCell("unit").setValue((Object)baseunit);
            curRow.getCell("mustqty").setValue((Object)issueQty);
            curRow.getCell("qty").setValue((Object)qty);
            curRow.getCell("project").setValue((Object)projectName);
            curRow.getCell("tracknumber").setValue((Object)trackName);
            curRow.getCell("workcenter").setValue((Object)workCenter);
            curRow.getCell("process").setValue((Object)operation);
            curRow.getCell("requestdate").setValue((Object)demanddate);
            curRow.getCell("dept").setValue((Object)"");
            curRow.getCell("costobjnumber").setValue((Object)costObjectNumber);
            curRow.getCell("costobjname").setValue((Object)costObjectName);
            curRow.getCell("date").setValue((Object)bizdate);
            curRow.getCell("reqwarehouseorg").setValue((Object)storageOrgUnit);
            curRow.getCell("costcenternumber").setValue((Object)costCenterOrgUnitNumber);
            curRow.getCell("costcentername").setValue((Object)costCenterOrgUnitName);
            curRow.getCell("updatetype").setValue((Object)invUpdateType);
            curRow.getCell("actualqty").setValue((Object)actureqty);
            curRow.getCell("dept").setValue((Object)dept);
            if (hangup == null) {
                curRow.getCell("hangup").setValue((Object)false);
                continue;
            }
            if (hangup == 1) {
                curRow.getCell("hangup").setValue((Object)true);
                continue;
            }
            curRow.getCell("hangup").setValue((Object)false);
        }
        KDTSortManager kdtSort1 = new KDTSortManager(this.tblMain2);
        kdtSort1.setSortAuto(true);
        kdtSort1.setClickCount(1);
        this.tblMain2.setRowCount(colls.size());
        for (int i = 0; i < this.tblMain2.getColumnCount(); ++i) {
            this.tblMain2.getColumn(i).setSortable(true);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        KDTSortManager kdtSortx = this.tblMain.getSortMange();
        kdtSortx.setSortAuto(true);
        kdtSortx.setClickCount(1);
        super.tblMain_tableClicked(e);
        this.refreshTabMain2();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        DistributePlanQueryUI tmp = (DistributePlanQueryUI)this.getFilterUI();
        String wheresql = null;
        try {
            wheresql = tmp.getComponentCondition();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (wheresql == null) {
            return;
        }
        ManufactureOrderStockCollection colls = MasterProductionScheduleExtFacadeFactory.getRemoteInstance().calcuteDistributePlan(wheresql);
        this.tblMain.removeRows();
        this.tblMain2.removeRows();
        for (int n = 0; n < colls.size(); ++n) {
            ManufactureOrderStockInfo info = colls.get(n);
            IRow curRow = this.tblMain.addRow();
            curRow.getCell("storageOrgUnit").setValue((Object)info.getStorageOrgUnit());
            curRow.getCell("storageOrgUnit.name").setValue((Object)info.getStorageOrgUnit().getName());
            DistributeStatusEnum statusEnum = (DistributeStatusEnum)((Object)info.get("DISTRIBUTESTATUS"));
            curRow.getCell("distributestatus").setValue((Object)statusEnum);
            if (statusEnum.compareTo((Object)DistributeStatusEnum.AllDistribute) == 0) {
                curRow.getCell("distributestatus").getStyleAttributes().setBackground(Color.GREEN);
            } else {
                curRow.getCell("distributestatus").getStyleAttributes().setBackground(Color.YELLOW);
            }
            curRow.getCell("requesttime").setValue((Object)info.getDemandTime());
            curRow.getCell("material").setValue((Object)info.getMaterial());
            curRow.getCell("material.number").setValue((Object)info.getMaterial().getNumber());
            curRow.getCell("material.number").getStyleAttributes().setBackground((Color)info.get("MATERIALCOLOR"));
            curRow.getCell("materialname").setValue((Object)info.getMaterial().getName());
            curRow.getCell("materialname").getStyleAttributes().setBackground((Color)info.get("MATERIALCOLOR"));
            curRow.getCell("materialmode").setValue((Object)info.getMaterial().getModel());
            MeasureUnitInfo unitinfo = info.getMaterial().getBaseUnit();
            curRow.getCell("materialunit").setValue((Object)(unitinfo == null ? "" : info.getMaterial().getBaseUnit().getName()));
            curRow.getCell("requestqty").setValue((Object)info.getPlannedQty());
            curRow.getCell("distributedqty").setValue(info.get("DISTRIBUTEDQTY"));
            curRow.getCell("undistributeqty").setValue(info.get("UNDISTRIBUTEQTY"));
            curRow.getCell("distributeorg.name").setValue((Object)info.getStorageOrgUnit().getName());
            WarehouseInfo warehouseinfo = info.getWarehouse();
            curRow.getCell("distwarehouse").setValue((Object)warehouseinfo);
            curRow.getCell("distwarehouse.name").setValue((Object)(warehouseinfo == null ? "" : info.getWarehouse().getName()));
            curRow.getCell("productionorg.name").setValue((Object)info.getParent().getStorageOrgUnit().getName());
            curRow.getCell("project").setValue((Object)info.getParent().getProject());
            curRow.getCell("project.number").setValue((Object)info.getParent().getProject().getName());
            curRow.getCell("tracknumber").setValue((Object)info.getParent().getTrackNumber());
            curRow.getCell("tracknumber.number").setValue((Object)(info.getParent().getTrackNumber() == null ? "" : info.getParent().getTrackNumber().getName()));
            curRow.getCell("station.name").setValue(null);
            curRow.getCell("inventroy").setValue(info.get("INVENTORY"));
            curRow.getCell("backflush").setValue(null);
            curRow.getCell("backflush.name").setValue(null);
            curRow.getCell("backflushqty").setValue(null);
            curRow.getCell("lineedge.name").setValue(null);
            curRow.getCell("lineedgeqty").setValue(null);
            curRow.getCell("minpackage").setValue(info.get("MIXPACKAGE"));
            curRow.getCell("manufactureorder.number").setValue((Object)info.getParent().getNumber());
            curRow.getCell("stockorderid").setValue((Object)info.getId().toString());
            curRow.getCell("techorderid").setValue((Object)info.getBomEntryID());
            curRow.getCell("operation.name").setValue((Object)info.getOperationNo());
            curRow.getCell("operationName").setValue(info.get("operation.Name"));
            curRow.getCell("workcenter.name").setValue(info.getWorkcenter() == null ? null : info.getWorkcenter().getName());
        }
        KDTSortManager kdtSort = this.tblMain.getSortMange();
        if (kdtSort == null) {
            kdtSort = new KDTSortManager(this.tblMain);
        }
        kdtSort.setSortAuto(true);
        kdtSort.setClickCount(1);
        this.tblMain.setRowCount(colls.size());
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        this.tblMain.getViewManager().setFreezeView(0, 15);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DistributePlanFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        DistributePlanInfo objectValue = new DistributePlanInfo();
        return objectValue;
    }

    protected String getKeyFieldName() {
        return "stockorderid";
    }

    @Override
    public void actionCalcuteDistributePlan_actionPerformed(ActionEvent e) throws Exception {
        this.commonQueryDialog.getUiObject().setOprtState(OprtState.EDIT);
        this.tHelper.setDialog(this.commonQueryDialog);
        boolean isok = this.commonQueryDialog.show();
        if (isok) {
            DistributePlanQueryUI tmp = (DistributePlanQueryUI)this.getFilterUI();
            String wheresql = tmp.getComponentCondition();
            ManufactureOrderStockCollection colls = MasterProductionScheduleExtFacadeFactory.getRemoteInstance().calcuteDistributePlan(wheresql);
            this.tblMain.removeRows();
            this.tblMain2.removeRows();
            for (int n = 0; n < colls.size(); ++n) {
                ManufactureOrderStockInfo info = colls.get(n);
                IRow curRow = this.tblMain.addRow();
                curRow.getCell("storageOrgUnit").setValue((Object)info.getStorageOrgUnit());
                curRow.getCell("storageOrgUnit.name").setValue((Object)info.getStorageOrgUnit().getName());
                DistributeStatusEnum statusEnum = (DistributeStatusEnum)((Object)info.get("DISTRIBUTESTATUS"));
                curRow.getCell("distributestatus").setValue((Object)statusEnum);
                if (statusEnum.compareTo((Object)DistributeStatusEnum.AllDistribute) == 0) {
                    curRow.getCell("distributestatus").getStyleAttributes().setBackground(Color.GREEN);
                } else {
                    curRow.getCell("distributestatus").getStyleAttributes().setBackground(Color.YELLOW);
                }
                curRow.getCell("requesttime").setValue((Object)info.getDemandTime());
                curRow.getCell("material").setValue((Object)info.getMaterial());
                curRow.getCell("material.number").setValue((Object)info.getMaterial().getNumber());
                curRow.getCell("material.number").getStyleAttributes().setBackground((Color)info.get("MATERIALCOLOR"));
                curRow.getCell("materialname").setValue((Object)info.getMaterial().getName());
                curRow.getCell("materialname").getStyleAttributes().setBackground((Color)info.get("MATERIALCOLOR"));
                curRow.getCell("materialmode").setValue((Object)info.getMaterial().getModel());
                MeasureUnitInfo unitinfo = info.getMaterial().getBaseUnit();
                curRow.getCell("materialunit").setValue((Object)(unitinfo == null ? "" : info.getMaterial().getBaseUnit().getName()));
                curRow.getCell("requestqty").setValue((Object)info.getPlannedQty());
                curRow.getCell("distributedqty").setValue(info.get("DISTRIBUTEDQTY"));
                curRow.getCell("undistributeqty").setValue(info.get("UNDISTRIBUTEQTY"));
                curRow.getCell("distributeorg.name").setValue((Object)info.getStorageOrgUnit().getName());
                WarehouseInfo warehouseinfo = info.getWarehouse();
                curRow.getCell("distwarehouse").setValue((Object)warehouseinfo);
                curRow.getCell("distwarehouse.name").setValue((Object)(warehouseinfo == null ? "" : info.getWarehouse().getName()));
                curRow.getCell("productionorg.name").setValue((Object)info.getParent().getStorageOrgUnit().getName());
                curRow.getCell("project").setValue((Object)info.getParent().getProject());
                curRow.getCell("project.number").setValue((Object)info.getParent().getProject().getNumber());
                curRow.getCell("tracknumber").setValue((Object)info.getParent().getTrackNumber());
                curRow.getCell("tracknumber.number").setValue((Object)(info.getParent().getTrackNumber() == null ? "" : info.getParent().getTrackNumber().getNumber()));
                curRow.getCell("station.name").setValue(info.get("station.name"));
                curRow.getCell("inventroy").setValue(info.get("INVENTORY"));
                curRow.getCell("backflush").setValue(null);
                curRow.getCell("backflush.name").setValue(null);
                curRow.getCell("backflushqty").setValue(null);
                curRow.getCell("lineedge.name").setValue(null);
                curRow.getCell("lineedgeqty").setValue(null);
                curRow.getCell("minpackage").setValue(info.get("MIXPACKAGE"));
                curRow.getCell("manufactureorder.number").setValue((Object)info.getParent().getNumber());
                curRow.getCell("stockorderid").setValue((Object)info.getId().toString());
                curRow.getCell("techorderid").setValue((Object)info.getBomEntryID());
                curRow.getCell("operation.name").setValue((Object)info.getOperationNo());
                curRow.getCell("operationName").setValue(info.get("operation.Name"));
                curRow.getCell("workcenter.name").setValue(info.getWorkcenter() == null ? null : info.getWorkcenter().getName());
                curRow.getCell("workcenter.id").setValue(info.getWorkcenter() == null ? null : info.getWorkcenter().getId().toString());
            }
            this.doQuery(this.commonQueryDialog);
            KDTSortManager kdtSort = new KDTSortManager(this.tblMain);
            kdtSort.setSortAuto(true);
            kdtSort.setClickCount(1);
            this.tblMain.setRowCount(colls.size());
            for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
                this.tblMain.getColumn(i).setSortable(true);
            }
            this.tblMain.getViewManager().setFreezeView(0, 15);
        }
    }

    @Override
    public void actionSendDistPlan_actionPerformed(ActionEvent e) throws Exception {
        String strInfo;
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"), (Component)((Object)this));
            SysUtil.abort();
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ArrayList<DistributeBillVO> voList = new ArrayList<DistributeBillVO>();
        ArrayList<Integer> arraysWareHouse = new ArrayList<Integer>();
        ArrayList<Integer> zeroInventry = new ArrayList<Integer>();
        ArrayList<Integer> distriInventry = new ArrayList<Integer>();
        ArrayList<DistributeStatusEnum> arraysEnum = new ArrayList<DistributeStatusEnum>();
        HashMap<String, WarehouseInfo> mapWh = new HashMap<String, WarehouseInfo>();
        for (int n = 0; n < selectRows.length; ++n) {
            MaterialInfo material = (MaterialInfo)this.tblMain.getRow(selectRows[n]).getCell("material").getValue();
            WarehouseInfo warehouse = (WarehouseInfo)this.tblMain.getRow(selectRows[n]).getCell("distwarehouse").getValue();
            WarehouseInfo backflush = (WarehouseInfo)this.tblMain.getRow(selectRows[n]).getCell("backflush").getValue();
            ProjectInfo project = (ProjectInfo)this.tblMain.getRow(selectRows[n]).getCell("project").getValue();
            TrackNumberInfo tracknum = (TrackNumberInfo)this.tblMain.getRow(selectRows[n]).getCell("tracknumber").getValue();
            StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.tblMain.getRow(selectRows[n]).getCell("storageOrgUnit").getValue();
            BigDecimal undistributeqty = (BigDecimal)this.tblMain.getRow(selectRows[n]).getCell("undistributeqty").getValue();
            BigDecimal distributedqty = (BigDecimal)this.tblMain.getRow(selectRows[n]).getCell("distributedqty").getValue();
            String stockid = (String)this.tblMain.getRow(selectRows[n]).getCell("stockorderid").getValue();
            String workcenterid = (String)this.tblMain.getRow(selectRows[n]).getCell("workcenter.id").getValue();
            BigDecimal inventroy = (BigDecimal)this.tblMain.getRow(selectRows[n]).getCell("inventroy").getValue();
            DistributeStatusEnum statusEnum = (DistributeStatusEnum)((Object)this.tblMain.getRow(selectRows[n]).getCell("distributestatus").getValue());
            DistributeBillVO vo = new DistributeBillVO();
            vo.setBackflushwhid(backflush == null ? null : backflush.getId().toString());
            vo.setMaterialid(material == null ? null : material.getId().toString());
            vo.setProjectid(project == null ? null : project.getId().toString());
            vo.setTracknumberid(tracknum == null ? null : tracknum.getId().toString());
            vo.setStorageorgid(storageOrgUnit == null ? null : storageOrgUnit.getId().toString());
            vo.setWarehouseid(warehouse == null ? null : warehouse.getId().toString());
            vo.setUndistributeqty(undistributeqty);
            vo.setStockid(stockid);
            voList.add(vo);
            StringBuffer key = new StringBuffer();
            if (warehouse == null || "".equals(warehouse)) {
                arraysWareHouse.add(selectRows[n]);
            } else {
                mapWh.put(key.append(warehouse.getId().toString()).append(workcenterid).toString(), warehouse);
            }
            if (BigDecimal.ZERO.compareTo(inventroy) == 0) {
                zeroInventry.add(selectRows[n]);
            }
            if (distributedqty.compareTo(inventroy) >= 0) {
                distriInventry.add(selectRows[n]);
            }
            if (DistributeStatusEnum.AllDistribute.compareTo((Object)statusEnum) != 0) continue;
            arraysEnum.add(statusEnum);
        }
        if (arraysWareHouse.size() > 0) {
            StringBuffer sbStr = new StringBuffer();
            for (Integer i : arraysWareHouse) {
                strInfo = EASResource.getString((String)this.RESURL, (String)"DXH_INFO", (Object[])new Object[]{i + 1});
                sbStr.append(strInfo + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0114")).append("\n");
            }
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)sbStr.toString(), (Component)((Object)this));
            SysUtil.abort();
        }
        if (zeroInventry.size() > 0) {
            StringBuffer sbStr = new StringBuffer();
            for (Integer i : zeroInventry) {
                strInfo = EASResource.getString((String)this.RESURL, (String)"DXH_INFO", (Object[])new Object[]{i + 1});
                sbStr.append(strInfo + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0115")).append("\n");
            }
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)sbStr.toString(), (Component)((Object)this));
            SysUtil.abort();
        }
        if (mapWh.size() > 1) {
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0116"), (Component)((Object)this));
            SysUtil.abort();
        }
        if (arraysEnum.size() > 0) {
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0117"), (Component)((Object)this));
            SysUtil.abort();
        }
        Gson gson = new Gson();
        String str = gson.toJson(voList);
        String resultStr = MasterProductionScheduleExtFacadeFactory.getRemoteInstance().calcuteDistributeBill(str);
        List volist = (List)gson.fromJson(resultStr, new TypeToken<List<DistributeBillVO>>(){}.getType());
        UIContext uiContext = new UIContext();
        String classUIName = "com.kingdee.eas.industry.emm.mm.ps.client.DistributeBillListUI";
        uiContext.put((Object)"MainMenuName", (Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0118"));
        uiContext.put((Object)"VOLIST", (Object)volist);
        uiContext.put((Object)"TABLE", (Object)this.tblMain);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.industry.emm.mm.ps.client.DistributeBillListUI", (Map)uiContext, null, OprtState.EDIT);
        window.show();
    }

    @Override
    protected void tblMain2_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain2);
            for (int n = 0; n < selectRows.length; ++n) {
                String materialreqid = (String)this.tblMain2.getRow(selectRows[n]).getCell("id").getValue();
                UIContext uiContext = new UIContext();
                String classUIName = "com.kingdee.eas.scm.im.inv.client.MaterialReqBillEditUI";
                uiContext.put((Object)"ID", (Object)materialreqid);
                IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.im.inv.client.MaterialReqBillEditUI", (Map)uiContext, null, OprtState.VIEW);
                window.show();
            }
        }
    }

    @Override
    public void actionDelReqMaterial_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain2);
        MaterialReqBillInfo info = null;
        for (int n = 0; n < selectRows.length; ++n) {
            String materialreqid = (String)this.tblMain2.getRow(selectRows[n]).getCell("id").getValue();
            info = MaterialReqBillFactory.getRemoteInstance().getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(materialreqid));
            if (info == null) continue;
            this.beforeDelete(info);
            MaterialReqBillFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(materialreqid));
        }
        this.refreshTabMain2();
    }

    public void beforeDelete(MaterialReqBillInfo editData) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(editData.getId().toString());
        try {
            DCDeliveryUtil.checkDCDelivery((Component)((Object)this), ids);
        }
        catch (BOSException e3) {
            this.handleException((Exception)((Object)e3));
            SysUtil.abort();
        }
        try {
            RITypeEnum rITypeEnum;
            TransactionTypeInfo tranTypeInfo = editData.getTransactionType();
            if (tranTypeInfo != null && (rITypeEnum = TransactionTypeUtils.getRITypeEnum((TransactionTypeInfo)(tranTypeInfo = TransactionTypeFactory.getRemoteInstance().getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(tranTypeInfo.getId()))))).equals((Object)RITypeEnum.ReqOut)) {
                String sourceBillId = editData.getSourceBillId();
                BillTypeInfo billType = editData.getSourceBillType();
                if (billType != null && billType.getId().toString().equals("50957179-0105-1000-e000-0163c0a812fd463ED552") && sourceBillId != null) {
                    ObjectUuidPK pk = new ObjectUuidPK(sourceBillId);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    MaterialReqBillInfo materialReqBillInfo = MaterialReqBillFactory.getRemoteInstance().getMaterialReqBillInfo((IObjectPK)pk, sic);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    @Override
    public void actionPrintReqMaterial_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedId2Values();
        this.invokeMultiPrintFunction(idList, true);
    }

    protected void invokeMultiPrintFunction(List idList, boolean isPrint) {
        if (idList == null || idList.size() == 0 || this.gettDQueryPKEx() == null || this.getTDFileName() == null) {
            return;
        }
        StringBuffer err = new StringBuffer();
        CoreBaseCollection collection = new CoreBaseCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        HashSet set = new HashSet();
        set.addAll(idList);
        fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(fi);
        try {
            collection = MaterialReqBillFactory.getRemoteInstance().getCollection(view);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        SCMBillBaseInfo aSCMBillBaseInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            aSCMBillBaseInfo = (SCMBillBaseInfo)collection.get(i);
            if (aSCMBillBaseInfo.getBaseStatus() != BillBaseStatusEnum.TEMPORARILYSAVED) continue;
            err.append(EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"BILL") + aSCMBillBaseInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"CANNOTPRINT") + "\n");
        }
        if (err.length() > 0) {
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)(EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"SELECTBILLCANNOTPRINT") + err.toString()), (Component)((Object)this));
            SysUtil.abort();
        }
        StringBuffer failToPrintMsg = new StringBuffer();
        KDNoteHelper tpHelper = new KDNoteHelper();
        try {
            int curNum = 1;
            String bosType = this.getBizInterface().getType().toString();
            IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
            List infoList = pinfo.getBillsPrintInfoByList(idList, bosType);
            tpHelper.prepareBizCall(this.getTDFileName());
            boolean isTimesCtrl = tpHelper.isPrintTimesControllable2(this.getTDFileName());
            if (this.getTDFileName() != null && this.getTDFileName().trim().length() > 0 && isTimesCtrl) {
                for (int i = 0; i < infoList.size(); ++i) {
                    Object[] objs;
                    String msgInfo;
                    String billNumber;
                    int maxNum = tpHelper.getMaxPrintTimes2(this.getTDFileName());
                    int pnum = ((AbstractPrintIntegrationInfo)infoList.get(i)).getPrintedNumber();
                    String billID = ((AbstractPrintIntegrationInfo)infoList.get(i)).getPrintBillID();
                    if (pnum >= maxNum) {
                        idList.remove(billID);
                        billNumber = pinfo.getBillNumberByBosType(bosType, billID);
                        msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.controlinfo1");
                        objs = new Object[]{billNumber, String.valueOf(curNum), String.valueOf(pnum), String.valueOf(maxNum)};
                        failToPrintMsg.append(MessageFormat.format(msgInfo, objs) + "\n");
                        continue;
                    }
                    if (curNum + pnum <= maxNum) continue;
                    idList.remove(billID);
                    billNumber = pinfo.getBillNumberByBosType(bosType, billID);
                    msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.controlinfo2");
                    objs = new Object[]{billNumber, String.valueOf(curNum), String.valueOf(pnum), String.valueOf(maxNum)};
                    failToPrintMsg.append(MessageFormat.format(msgInfo, objs) + "\n");
                }
                if (failToPrintMsg.toString().trim().length() > 0) {
                    String error = EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"FailToPrintMsg");
                    MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)error, (Component)((Object)this));
                }
            }
        }
        catch (KDRSException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (idList == null || idList.size() == 0 || this.gettDQueryPKEx() == null || this.getTDFileName() == null) {
            return;
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        SCMCommonDataProvider mainQueryData = new SCMCommonDataProvider(idList, this.gettDQueryPKEx());
        mainQueryData.setFilter(this.getPrintFilter(idList));
        data.put("MainQuery", (BOSQueryDelegate)mainQueryData);
        MultiapproveDataProvider multiapproveDataSource = new MultiapproveDataProvider(this.getSelectedIdForPrint(), this.isShowMultiapproveHistoryForPrint(), "billId");
        multiapproveDataSource.setMultiapproveDataFilter(this.getMultiapproveDataFilter());
        data.put(this.getMultiapproveQueryNameForPrint(), (BOSQueryDelegate)multiapproveDataSource);
        BOSObjectType bosType = null;
        try {
            bosType = this.getBizInterface().getType();
        }
        catch (Exception e) {
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource"), (Component)((Object)this));
            SysUtil.abort();
        }
        CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(bosType.toString(), PrintIntegrationManager.getPrintQueryPK());
        data.put("PrintQuery", (BOSQueryDelegate)printQueryData);
        PrintIntegrationManager.initPrint((KDNoteHelper)tpHelper, (BOSObjectType)bosType, (List)idList, (String)this.getTDFileName(), (String)"com.kingdee.eas.scm.common.SCMResource", (boolean)false);
        if (isPrint) {
            tpHelper.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            tpHelper.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
        this.setMessageText(null);
    }

    protected ArrayList getSelectedId2Values() {
        int mode = 0;
        ArrayList blockList = this.tblMain2.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain2.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (this.isIgnoreRowCount() && mode == 8) {
            this.tblMain2.setRowCount(this.getRowCountFromDB());
            this.tblMain2.reLayoutAndPaint();
        }
        ArrayList selectList = new ArrayList();
        List selectKeyIdFields = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain2);
        if (mode == 8 && selectRows.length >= KDTDataRequestManager.defaultPageRow - 1) {
            selectKeyIdFields = this.getQueryPkList();
        }
        return ListUiHelper.getSelectedIdValues((KDTable)this.tblMain2, (String)"id", selectList, selectKeyIdFields);
    }

    protected FilterInfo getPrintFilter(List ids) {
        FilterInfo filter = new FilterInfo();
        if (ids.size() == 1) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toArray()[0].toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(1), CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        return filter;
    }

    public IMetaDataPK gettDQueryPKEx() {
        return this.getTDQueryPK();
    }

    protected IMetaDataPK getTDQueryPK() {
        if (this.isSubContractBill()) {
            return MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.MaterialReqSubcontractPrintQuery");
        }
        return MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.MaterialReqPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/IM/Issue/MaterialReqBill";
    }

    public boolean isSubContractBill() {
        boolean isSubContractBill = false;
        Map uiContext = this.getUIContext();
        if (uiContext != null) {
            Map traceFromUIContext;
            if (Boolean.TRUE.equals(uiContext.get("isSubContract"))) {
                isSubContractBill = true;
            } else if ("isSubContract".equals(uiContext.get("UIClassParam"))) {
                uiContext.put("isSubContract", Boolean.TRUE);
                isSubContractBill = true;
            } else if (uiContext.get("BTPNAVCTX") != null && Boolean.TRUE.equals((traceFromUIContext = (Map)uiContext.get("BTPNAVCTX")).get("isSubContract"))) {
                uiContext.put("isSubContract", Boolean.TRUE);
                isSubContractBill = true;
            }
        }
        return isSubContractBill;
    }

    protected boolean isBotpBill(String billTypeID, SCMBillBaseInfo editData) {
        if (this.isBotpBill(editData)) {
            return editData.getSourceBillType().getId().toString().equals(billTypeID);
        }
        return false;
    }

    protected boolean isBotpBill(SCMBillBaseInfo editData) {
        if (editData == null) {
            return false;
        }
        BillTypeInfo billType = editData.getSourceBillType();
        return billType != null;
    }

    public MaterialReqBillInfo getMaterialReqBill(IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("transactionType.*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.material.*"));
        sic.add(new SelectorItemInfo("entry.supplyWarehouse.*"));
        MaterialReqBillInfo materialReqBillInfo = MaterialReqBillFactory.getRemoteInstance().getMaterialReqBillInfo(pk, sic);
        return materialReqBillInfo;
    }

    @Override
    public void actionStartDistributePlan_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb;
        if (this.tblMain2.getRowCount() == 0 || this.tblMain2.getSelectManager().size() == 0) {
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"), (Component)((Object)this));
            SysUtil.abort();
        }
        String idString = "";
        try {
            int size = this.tblMain2.getSelectManager().size();
            for (int i = 0; i < size; ++i) {
                sb = this.tblMain2.getSelectManager().get(i);
                int index = sb.getBottom();
                for (int j = sb.getTop(); j <= index; ++j) {
                    IRow row = this.tblMain2.getRow(j);
                    String id = (String)row.getCell("id").getValue();
                    ObjectUuidPK pk = new ObjectUuidPK(id);
                    if (idString.contains(id)) continue;
                    idString = idString + id + ",";
                    MaterialReqBillInfo materialReqBillInfo = this.getMaterialReqBill((IObjectPK)pk);
                    if (materialReqBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) continue;
                    String strInfo = EASResource.getString((String)this.RESURL, (String)"DXH_INFO", (Object[])new Object[]{j + 1});
                    MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)(strInfo + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0119")), (Component)((Object)this));
                    SysUtil.abort();
                }
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
            SysUtil.abort();
        }
        ArrayList<String> ids = new ArrayList<String>();
        int size = this.tblMain2.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain2.getSelectManager().get(i);
            int index = sb.getBottom();
            for (int j = sb.getTop(); j <= index; ++j) {
                IRow row = this.tblMain2.getRow(j);
                String id = (String)row.getCell("id").getValue();
                ids.add(id);
            }
        }
        try {
            DCDeliveryUtil.checkDCDelivery((Component)((Object)this), ids);
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
            SysUtil.abort();
        }
        try {
            DCDeliveryUtil.checkDisWarehouse((Component)((Object)this), ids);
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
            SysUtil.abort();
        }
        if (ids.size() == 1) {
            try {
                String id = (String)ids.get(0);
                UIContext uiContext = new UIContext();
                uiContext.put((Object)"ID", (Object)id);
                String uiClass = "com.kingdee.eas.scm.im.inv.client.MaterialReqBillEditUI";
                IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.scm.im.inv.client.MaterialReqBillEditUI", (Map)uiContext, null, OprtState.EDIT);
                popUI.show();
            }
            catch (Exception e2) {
                this.handUIException(e2);
            }
        } else {
            try {
                MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0120"), (Component)((Object)this));
            }
            catch (Exception e2) {
                this.handUIException(e2);
            }
        }
    }

    @Override
    public void actionEndDistributePlan_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain2.getRowCount() == 0 || this.tblMain2.getSelectManager().size() == 0) {
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"), (Component)((Object)this));
            SysUtil.abort();
        }
        ArrayList<String> ids = new ArrayList<String>();
        int size = this.tblMain2.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tblMain2.getSelectManager().get(i);
            int index = sb.getBottom();
            for (int j = sb.getTop(); j <= index; ++j) {
                IRow row = this.tblMain2.getRow(j);
                String id = (String)row.getCell("id").getValue();
                ids.add(id);
            }
        }
        try {
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0121"), (Component)((Object)this));
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
    }

    @Override
    public void actionCancelDistributePlan_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain2.getRowCount() == 0 || this.tblMain2.getSelectManager().size() == 0) {
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"), (Component)((Object)this));
            SysUtil.abort();
        }
        ArrayList<String> ids = new ArrayList<String>();
        int size = this.tblMain2.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tblMain2.getSelectManager().get(i);
            int index = sb.getBottom();
            for (int j = sb.getTop(); j <= index; ++j) {
                IRow row = this.tblMain2.getRow(j);
                String id = (String)row.getCell("id").getValue();
                ids.add(id);
            }
        }
        try {
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0122"), (Component)((Object)this));
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
    }

    @Override
    public void actionMatchBatchLoc_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain2.getRowCount() == 0 || this.tblMain2.getSelectManager().size() == 0) {
            MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"), (Component)((Object)this));
            SysUtil.abort();
        }
        ArrayList<String> ids = new ArrayList<String>();
        int size = this.tblMain2.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tblMain2.getSelectManager().get(i);
            int index = sb.getBottom();
            for (int j = sb.getTop(); j <= index; ++j) {
                IRow row = this.tblMain2.getRow(j);
                String id = (String)row.getCell("id").getValue();
                ids.add(id);
            }
        }
        String info = MasterProductionScheduleExtFacadeFactory.getRemoteInstance().matchBatchLocation(ids);
        MsgBox.info((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0029"), (String)(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.ps.EMMEMMmpsResource", (String)"0EMMPS-0123") + info), (Component)((Object)this));
    }
}

