/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.restruct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.em.common.EMException;
import com.kingdee.eas.em.common.utils.EMRequiredUtils;
import com.kingdee.eas.em.common.utils.EMUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillEntryCollection;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillEntryInfo;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillFactory;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillInfo;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqFacadeFactory;
import com.kingdee.eas.industry.emm.mm.restruct.RestructType;
import com.kingdee.eas.industry.emm.mm.restruct.client.AbstractRestructReqBillEditUI;
import com.kingdee.eas.industry.emm.pm.ISqlExecuteFacade;
import com.kingdee.eas.industry.emm.pm.SqlExecuteFacadeFactory;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RestructReqBillEditUI
extends AbstractRestructReqBillEditUI {
    private static final long serialVersionUID = 6056940804614586196L;
    private ItemListener restructTypeListener;
    private ItemListener isextendListener;
    private String TB_COL_MATERIAL = "materialcode";
    private String TB_COL_MATERIALNAME = "material";
    private String TB_COL_MATERIALMODE = "materialmodel";
    private String TB_COL_MEASUERUNIT = "measuerunit";
    private String TB_COL_ISSUEQTY = "issueqty";
    private String TB_COL_REVOKEQTY = "revokeqty";
    private String TB_COL_REJECTEQTY = "rejecteqty";
    private String TB_COL_REJECTORGUNIT = "rejecteorgunit";
    private String TB_COL_BUNITQTY = "bunitqty";
    private String TB_COL_CUNITQTY = "cunitqty";
    private String TB_COL_BISSUEQTY = "bissueqty";
    private String TB_COL_CISSUEQTY = "issuedqty";
    private String TB_COL_BQTY = "bqty";
    private String TB_COL_CQTY = "cqty";
    private KDTEditAdapter entryTableChange;
    private DataChangeListener qtyDataChanged;
    private BigDecimal MOQTY = BigDecimal.ZERO;
    private BigDecimal MOTOSTROREQTY = BigDecimal.ZERO;
    private BigDecimal MOTOTALSPLITQTY = BigDecimal.ZERO;

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtstorageOrgUnit;
    }

    @Override
    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtstorageOrgUnit;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.initF7Filter();
        this.initBillListener();
    }

    private void initF7Filter() {
        OrgUnitInfo orgInfo = (OrgUnitInfo)this.prmtstorageOrgUnit.getData();
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtbmaterial, (OrgUnitInfo)orgInfo, (boolean)false);
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtcmaterial, (OrgUnitInfo)orgInfo, (boolean)false);
        UIHelper.registerProjectF7ForEdit((KDBizPromptBox)this.getMainOrgUnit(), null, (KDBizPromptBox)this.prmtbproject);
        UIHelper.registerProjectF7ForEdit((KDBizPromptBox)this.getMainOrgUnit(), null, (KDBizPromptBox)this.prmtcproject);
        UIHelper.registerTrackNumberF7ForEdit((KDBizPromptBox)this.getMainOrgUnit(), null, (KDBizPromptBox)this.prmtbproject, (KDBizPromptBox)this.prmtbtracknumber, (boolean)false);
        UIHelper.registerTrackNumberF7ForEdit((KDBizPromptBox)this.getMainOrgUnit(), null, (KDBizPromptBox)this.prmtcproject, (KDBizPromptBox)this.prmtctracknumber, (boolean)false);
        IPermission permission = null;
        FullOrgUnitCollection result = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        try {
            permission = PermissionFactory.getRemoteInstance();
            result = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), OrgType.Storage, null, "restructreqbill_view");
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            MsgBox.showInfo((String)e1.getMessage());
            SysUtil.abort();
        }
        catch (BOSException e) {
            e.printStackTrace();
            MsgBox.showInfo((String)e.getMessage());
            SysUtil.abort();
        }
        FullOrgUnitInfo fullInfo = null;
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            StorageOrgUnitInfo info = null;
            try {
                info = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(collection.get(i).getId().toString()));
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            String number = info.getNumber();
            if (!info.isIsBizUnit()) continue;
            keys.add(collection.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtstorageOrgUnit.setEntityViewInfo(view);
        this.prmtmanufactureorder.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                RestructReqBillEditUI.this.initManufactureFilter();
            }
        });
        this.prmtbmaterial.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (RestructReqBillEditUI.this.prmtbmaterial.getValue() != null) {
                    String flag = RestructReqBillEditUI.this.getCheckNullFlag();
                    if (flag.equals("ITEM_TRACKNO")) {
                        RestructReqBillEditUI.this.prmtcproject.setRequired(true);
                        RestructReqBillEditUI.this.prmtbproject.setRequired(true);
                        RestructReqBillEditUI.this.prmtctracknumber.setRequired(true);
                        RestructReqBillEditUI.this.prmtbtracknumber.setRequired(true);
                    } else if (flag.equals("ITEM")) {
                        RestructReqBillEditUI.this.prmtcproject.setRequired(true);
                        RestructReqBillEditUI.this.prmtbproject.setRequired(true);
                        RestructReqBillEditUI.this.prmtctracknumber.setRequired(false);
                        RestructReqBillEditUI.this.prmtbtracknumber.setRequired(false);
                    } else {
                        RestructReqBillEditUI.this.prmtcproject.setRequired(false);
                        RestructReqBillEditUI.this.prmtbproject.setRequired(false);
                        RestructReqBillEditUI.this.prmtctracknumber.setRequired(false);
                        RestructReqBillEditUI.this.prmtbtracknumber.setRequired(false);
                    }
                } else {
                    RestructReqBillEditUI.this.prmtcproject.setRequired(false);
                    RestructReqBillEditUI.this.prmtbproject.setRequired(false);
                    RestructReqBillEditUI.this.prmtctracknumber.setRequired(false);
                    RestructReqBillEditUI.this.prmtbtracknumber.setRequired(false);
                }
            }
        });
        this.prmtmanufactureorder.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ManufactureOrderInfo orderinfo = (ManufactureOrderInfo)RestructReqBillEditUI.this.prmtmanufactureorder.getData();
                ProjectInfo project = null;
                TrackNumberInfo track = null;
                MaterialInfo material = null;
                CostObjectInfo center = null;
                if (orderinfo != null) {
                    RestructType type;
                    project = orderinfo.getProject();
                    track = orderinfo.getTrackNumber();
                    material = orderinfo.getMaterial();
                    center = orderinfo.getCostObject();
                    BigDecimal btructqty = new BigDecimal(0);
                    BigDecimal qty = orderinfo.getQty();
                    BigDecimal finshQty = orderinfo.getFinishedQty();
                    if (RestructReqBillEditUI.this.txtbtructqty.getText() != null && !"".equals(RestructReqBillEditUI.this.txtbtructqty.getText())) {
                        btructqty = new BigDecimal(RestructReqBillEditUI.this.txtbtructqty.getText());
                    }
                    if ((type = (RestructType)((Object)RestructReqBillEditUI.this.restructType.getSelectedItem())).compareTo((Object)RestructType.mftRestruct) == 0) {
                        RestructReqBillEditUI.this.txtbtructqty.setValue((Object)qty.subtract(finshQty));
                    } else if (type.compareTo((Object)RestructType.storageRestruct) == 0) {
                        RestructReqBillEditUI.this.txtbtructqty.setValue((Object)orderinfo.getToStroreQty());
                    }
                    try {
                        if (RestructReqBillEditUI.this.prmtbmaterial.getData() == null) {
                            if (material != null) {
                                material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId().toString()));
                            }
                            RestructReqBillEditUI.this.prmtbmaterial.setData((Object)material);
                        }
                        if (RestructReqBillEditUI.this.prmtbproject.getData() == null) {
                            if (project != null) {
                                project = ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(project.getId().toString()));
                            }
                            RestructReqBillEditUI.this.prmtbproject.setData((Object)project);
                        }
                        if (RestructReqBillEditUI.this.prmtbtracknumber.getData() == null) {
                            if (track != null) {
                                track = TrackNumberFactory.getRemoteInstance().getTrackNumberInfo((IObjectPK)new ObjectUuidPK(track.getId().toString()));
                            }
                            RestructReqBillEditUI.this.prmtbtracknumber.setData((Object)track);
                        }
                        if (RestructReqBillEditUI.this.prmtcostobject.getData() == null) {
                            if (center != null) {
                                center = CostObjectFactory.getRemoteInstance().getCostObjectInfo((IObjectPK)new ObjectUuidPK(center.getId().toString()));
                            }
                            RestructReqBillEditUI.this.prmtcostobject.setData((Object)center);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    RestructReqBillEditUI.this.chkisextend.setEnabled(false);
                    RestructReqBillEditUI.this.chkisextend.setSelected(false);
                } else {
                    RestructReqBillEditUI.this.chkisextend.setEnabled(true);
                }
            }
        });
    }

    public boolean isModify() {
        if (!this.getOprtState().equals("ADDNEW")) {
            return false;
        }
        return super.isModify();
    }

    private void initManufactureFilter() {
        OrgUnitInfo orgunitinfo = (OrgUnitInfo)this.prmtstorageOrgUnit.getData();
        MaterialInfo materialinfo = (MaterialInfo)this.prmtbmaterial.getData();
        ProjectInfo projectinfo = (ProjectInfo)this.prmtbproject.getData();
        TrackNumberInfo tracknumber = (TrackNumberInfo)this.prmtbtracknumber.getData();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        RestructType type = (RestructType)((Object)this.restructType.getSelectedItem());
        if (type.compareTo((Object)RestructType.storageRestruct) == 0) {
            if (orgunitinfo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgunitinfo.getId().toString()));
            }
            if (materialinfo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialinfo.getId().toString()));
            }
            if (projectinfo != null && projectinfo.getNumber() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("project.number", (Object)projectinfo.getNumber()));
            }
            if (tracknumber != null && tracknumber.getNumber() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.number", (Object)tracknumber.getNumber()));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"select fid from T_MM_MANUFACTUREORDER where FTOSTROREQTY = FQTY - FTOTALSPLITQTY", CompareType.INNER));
            FilterInfo statusfilterInfo = new FilterInfo();
            FilterInfo wispfilter = new FilterInfo();
            wispfilter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)8));
            statusfilterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)7));
            try {
                statusfilterInfo.mergeFilter(wispfilter, "or");
                filterInfo.mergeFilter(statusfilterInfo, "and");
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        } else {
            if (orgunitinfo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgunitinfo.getId().toString()));
            }
            if (materialinfo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialinfo.getId().toString()));
            }
            if (projectinfo != null && projectinfo.getNumber() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("project.number", (Object)projectinfo.getNumber()));
            }
            if (tracknumber != null && tracknumber.getNumber() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.number", (Object)tracknumber.getNumber()));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("technics.id", (Object)"select tec.fid from T_MM_MFTOrderTechnics tec left outer join T_MM_MANUFACTUREORDER mm on mm.fid = tec.fid and mm.FPassQty < mm.FQty where (tec.FBASESTATUS = 15 or tec.FBASESTATUS = 5) and tec.FTOTALDISPATCHQTY > 0", CompareType.INNER));
            FilterInfo statusfilterInfo = new FilterInfo();
            statusfilterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)5));
            try {
                filterInfo.mergeFilter(statusfilterInfo, "and");
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }
        viewInfo.setFilter(filterInfo);
        this.prmtmanufactureorder.setEntityViewInfo(viewInfo);
        this.prmtmanufactureorder.getQueryAgent().resetRuntimeEntityView();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.addListener();
        this.setQtyComponentLayout();
        this.prmtcproject.setRequired(false);
        this.prmtbproject.setRequired(false);
        this.prmtctracknumber.setRequired(false);
        this.prmtbtracknumber.setRequired(false);
        this.setEntryEditor();
        this.prmtExtendLevel.setEnabled(false);
    }

    private void addListener() {
        if (this.qtyDataChanged == null) {
            this.qtyDataChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        RestructReqBillEditUI.this.qtyDataChanged_dataChanged(e);
                    }
                    catch (Exception exc) {
                        RestructReqBillEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.txtbtructqty.addDataChangeListener(this.qtyDataChanged);
        this.txtctructqty.addDataChangeListener(this.qtyDataChanged);
        if (this.restructTypeListener == null) {
            this.restructTypeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        RestructReqBillEditUI.this.restructItemChanged(e);
                    }
                    catch (Exception exc) {
                        RestructReqBillEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.restructType.addItemListener(this.restructTypeListener);
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        RestructReqBillEditUI.this.kdtEntries_Changed(e);
                    }
                    catch (Exception exc) {
                        RestructReqBillEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtEntrys.addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    private void qtyDataChanged_dataChanged(DataChangeEvent e) {
        block10: {
            BigDecimal value;
            BigDecimal qty;
            Object _value;
            int row;
            block9: {
                if (e.getSource() == this.txtbtructqty) {
                    BigDecimal toStoreQty;
                    Object _value2 = this.txtbtructqty.getValue(BigDecimal.class);
                    BigDecimal qty2 = _value2 == null ? BigDecimal.ZERO : (BigDecimal)_value2;
                    ManufactureOrderInfo orderinfo = (ManufactureOrderInfo)this.prmtmanufactureorder.getData();
                    this.txtctructqty.setValue((Object)qty2);
                    if (orderinfo == null) {
                        return;
                    }
                    RestructType type = (RestructType)((Object)this.restructType.getSelectedItem());
                    if (type.compareTo((Object)RestructType.mftRestruct) == 0) {
                        BigDecimal finshQty;
                        BigDecimal plannedQty;
                        BigDecimal pfinshQty;
                        if (this.prmtmanufactureorder.getValue() != null && qty2.compareTo(pfinshQty = (plannedQty = orderinfo.getQty()).subtract(finshQty = orderinfo.getFinishedQty())) == 1) {
                            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.restruct.EMMEMMmrestructResource", (String)"Fininsh_Limit") + "(" + pfinshQty + ")"));
                            this.txtbtructqty.setValue((Object)pfinshQty);
                            return;
                        }
                    } else if (type.compareTo((Object)RestructType.storageRestruct) == 0 && this.prmtmanufactureorder.getValue() != null && qty2.compareTo(toStoreQty = orderinfo.getToStroreQty()) == 1) {
                        MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.restruct.EMMEMMmrestructResource", (String)"Qty_Limit") + "(" + toStoreQty + ")"));
                        this.txtbtructqty.setValue((Object)toStoreQty);
                        return;
                    }
                }
                if ((row = this.kdtEntrys.getRowCount()) == 0) {
                    return;
                }
                if (e.getSource() != this.txtbtructqty) break block9;
                _value = this.txtbtructqty.getValue(BigDecimal.class);
                qty = _value == null ? BigDecimal.ZERO : (BigDecimal)_value;
                value = BigDecimal.ZERO;
                for (int n = 0; n < row; ++n) {
                    value = (BigDecimal)this.kdtEntrys.getCell(n, this.TB_COL_BUNITQTY).getValue();
                    this.kdtEntrys.getCell(n, this.TB_COL_BQTY).setValue((Object)value.multiply(qty));
                    value = (BigDecimal)this.kdtEntrys.getCell(n, this.TB_COL_CUNITQTY).getValue();
                    this.kdtEntrys.getCell(n, this.TB_COL_CQTY).setValue((Object)value.multiply(qty));
                }
                break block10;
            }
            if (e.getSource() != this.txtctructqty) break block10;
            _value = this.txtctructqty.getValue(BigDecimal.class);
            qty = _value == null ? BigDecimal.ZERO : (BigDecimal)_value;
            value = BigDecimal.ZERO;
            for (int n = 0; n < row; ++n) {
                value = (BigDecimal)this.kdtEntrys.getCell(n, this.TB_COL_CUNITQTY).getValue();
                this.kdtEntrys.getCell(n, this.TB_COL_CQTY).setValue((Object)value.multiply(qty));
            }
        }
    }

    protected void kdtEntries_Changed(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == this.kdtEntrys.getColumn(this.TB_COL_BUNITQTY).getColumnIndex()) {
            BigDecimal value = (BigDecimal)this.kdtEntrys.getCell(e.getRowIndex(), this.TB_COL_BUNITQTY).getValue();
            Object _value = this.txtbtructqty.getValue(BigDecimal.class);
            BigDecimal btructqty = _value == null ? BigDecimal.ZERO : (BigDecimal)_value;
            this.kdtEntrys.getCell(e.getRowIndex(), this.TB_COL_BQTY).setValue((Object)value.multiply(btructqty));
        } else if (e.getColIndex() == this.kdtEntrys.getColumn(this.TB_COL_CUNITQTY).getColumnIndex()) {
            BigDecimal value = (BigDecimal)this.kdtEntrys.getCell(e.getRowIndex(), this.TB_COL_CUNITQTY).getValue();
            Object _value = this.txtctructqty.getValue(BigDecimal.class);
            BigDecimal btructqty = _value == null ? BigDecimal.ZERO : (BigDecimal)_value;
            this.kdtEntrys.getCell(e.getRowIndex(), this.TB_COL_CQTY).setValue((Object)value.multiply(btructqty));
        }
    }

    private void setEntryEditor() {
        KDBizPromptBox prmtMaterial = new KDBizPromptBox();
        prmtMaterial.setQueryInfo("com.kingdee.eas.basedata.master.material.app.MaterialQuery");
        prmtMaterial.setEditFormat("$number$");
        prmtMaterial.setCommitFormat("$number$");
        prmtMaterial.setDisplayFormat("$number$");
        prmtMaterial.setEnabled(true);
        KDTDefaultCellEditor editorMaterial = new KDTDefaultCellEditor((IKDEditor)prmtMaterial);
        this.kdtEntrys.getColumn(this.TB_COL_MATERIAL).setEditor((ICellEditor)editorMaterial);
        this.kdtEntrys.getColumn(this.TB_COL_MATERIAL).getStyleAttributes().setLocked(false);
        this.kdtEntrys.getColumn(this.TB_COL_ISSUEQTY).getStyleAttributes().setLocked(false);
        this.kdtEntrys.getColumn(this.TB_COL_REVOKEQTY).getStyleAttributes().setLocked(false);
        this.kdtEntrys.getColumn(this.TB_COL_REJECTEQTY).getStyleAttributes().setLocked(false);
        this.kdtEntrys.getColumn(this.TB_COL_BUNITQTY).getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn(this.TB_COL_CUNITQTY).getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn(this.TB_COL_BISSUEQTY).getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn(this.TB_COL_CISSUEQTY).getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn(this.TB_COL_BQTY).getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn(this.TB_COL_CQTY).getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn(this.TB_COL_REVOKEQTY).getStyleAttributes().setLocked(false);
        KDBizPromptBox prmtStorageOrg = new KDBizPromptBox();
        prmtStorageOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        prmtStorageOrg.setEditFormat("$number$");
        prmtStorageOrg.setCommitFormat("$number$");
        prmtStorageOrg.setDisplayFormat("$name$");
        prmtStorageOrg.setEnabled(true);
        KDTDefaultCellEditor editorStorageOrg = new KDTDefaultCellEditor((IKDEditor)prmtStorageOrg);
        this.kdtEntrys.getColumn(this.TB_COL_REJECTORGUNIT).setEditor((ICellEditor)editorStorageOrg);
        this.kdtEntrys.getColumn(this.TB_COL_REJECTORGUNIT).getStyleAttributes().setLocked(false);
        prmtMaterial.addDataChangeListener((DataChangeListener)new MaterialDataChangeListener(editorMaterial, this.kdtEntrys, this.editData));
    }

    public StorageOrgUnitInfo getStorageOrgUnitByMaterialTab(String materialid, String storageid) throws BOSException, EASBizException {
        EntityViewInfo localEntityViewInfo = new EntityViewInfo();
        FilterInfo localFilterInfo = new FilterInfo();
        localFilterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageid, CompareType.EQUALS));
        localFilterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialid, CompareType.EQUALS));
        localEntityViewInfo.setFilter(localFilterInfo);
        MaterialPlanCollection localMaterialPlanCollection = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(localEntityViewInfo);
        MaterialPlanInfo localMaterialPlanInfo = null;
        if (localMaterialPlanCollection != null && localMaterialPlanCollection.size() >= 1) {
            for (int i = 0; i < localMaterialPlanCollection.size(); ++i) {
                MaterialPlanInfo materialPlanInfo = localMaterialPlanCollection.get(i);
                if (materialPlanInfo.getOrgUnit() == null || !materialPlanInfo.getOrgUnit().getId().toString().equals(storageid)) continue;
                localMaterialPlanInfo = materialPlanInfo;
                break;
            }
            return localMaterialPlanInfo.getSupplyOrgUnit();
        }
        return null;
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        RestructType type = (RestructType)((Object)this.restructType.getSelectedItem());
        if (type.compareTo((Object)RestructType.mftRestruct) == 0) {
            this.txtctructqty.setEditable(false);
            this.prmtmanufactureorder.setRequired(true);
            this.prmtmanufactureorder.setEnabled(true);
        } else {
            this.txtctructqty.setEditable(true);
            this.prmtmanufactureorder.setRequired(false);
            this.prmtmanufactureorder.setEnabled(true);
        }
        this.txtretructedqty.setEditable(false);
    }

    private void removeListener() {
        if (this.qtyDataChanged != null) {
            this.txtbtructqty.removeDataChangeListener(this.qtyDataChanged);
            this.txtctructqty.removeDataChangeListener(this.qtyDataChanged);
        }
        if (this.restructTypeListener != null) {
            this.restructType.removeItemListener(this.restructTypeListener);
        }
        if (this.entryTableChange != null) {
            this.kdtEntrys.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
    }

    private void setQtyComponentLayout() {
        Object[] qtyComponents = new Object[]{this.txtbtructqty, this.txtctructqty, this.txtretructedqty};
        KDFormattedTextField formattedText = null;
        for (int i = 0; i < qtyComponents.length; ++i) {
            if (!(qtyComponents[i] instanceof KDFormattedTextField)) continue;
            formattedText = (KDFormattedTextField)qtyComponents[i];
            formattedText.setHorizontalAlignment(4);
        }
    }

    private void initBillListener() {
        this.restructType.addItemListener(this.getOtherDataChanged());
        this.chkisextend.addItemListener(this.getIsEntendDataChanged());
    }

    private ItemListener getOtherDataChanged() {
        if (this.restructTypeListener == null) {
            this.restructTypeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        RestructReqBillEditUI.this.restructItemChanged(e);
                    }
                    catch (Exception exc) {
                        RestructReqBillEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        return this.restructTypeListener;
    }

    private ItemListener getIsEntendDataChanged() {
        if (this.isextendListener == null) {
            this.isextendListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        RestructReqBillEditUI.this.isExtendItemChanged(e);
                    }
                    catch (Exception exc) {
                        RestructReqBillEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        return this.isextendListener;
    }

    private void isExtendItemChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.prmtExtendLevel.setEnabled(true);
        } else {
            this.prmtExtendLevel.setEnabled(false);
            this.prmtExtendLevel.setText("0");
        }
    }

    private void restructItemChanged(ItemEvent e) {
        RestructType type = (RestructType)((Object)e.getItem());
        if (type.compareTo((Object)RestructType.mftRestruct) == 0) {
            this.prmtmanufactureorder.setRequired(true);
            this.prmtmanufactureorder.setEnabled(true);
        } else {
            this.prmtmanufactureorder.setRequired(false);
            this.prmtmanufactureorder.setEnabled(true);
        }
        ManufactureOrderInfo orderinfo = (ManufactureOrderInfo)this.prmtmanufactureorder.getData();
        if (orderinfo != null) {
            BigDecimal qty = orderinfo.getQty();
            BigDecimal finshQty = orderinfo.getFinishedQty();
            if (type.compareTo((Object)RestructType.mftRestruct) == 0) {
                this.txtbtructqty.setValue((Object)qty.subtract(finshQty));
            } else if (type.compareTo((Object)RestructType.storageRestruct) == 0) {
                this.txtbtructqty.setValue((Object)orderinfo.getToStroreQty());
            }
        } else {
            this.txtbtructqty.setValue(null);
            this.txtctructqty.setValue(null);
        }
    }

    public KDTextField getNumTextField() {
        return this.txtnumber;
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    protected HashMap getQueryCondition() throws Exception {
        MaterialInfo material = null;
        HashMap<String, Object> hm = new HashMap<String, Object>();
        boolean isTableFocus = SCMClientUtils.isTableFocus((KDTable)this.kdtEntrys);
        hm.put("STORAGEORGUNIT", (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue());
        hm.put("TABLEHASFOCUS", isTableFocus);
        KDTSelectBlock selectBlock = this.getDetailTable().getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.getDetailTable().getRow(rowIndex);
            if (row == null) {
                return hm;
            }
            ICell cell = row.getCell("material");
            material = (MaterialInfo)cell.getValue();
            hm.put("MATERIAL", material);
        }
        return hm;
    }

    private String getCheckNullFlag() {
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtstorageOrgUnit.getValue();
        MaterialInfo material = (MaterialInfo)this.prmtbmaterial.getValue();
        StringBuffer sql = new StringBuffer();
        sql.append("select tm.FIsolatedRule from T_BD_Material t left outer join T_BD_MaterialPlan tm on t.FID = tm.FMaterialID where tm.FOrgUnit = '");
        sql.append(storage.getId().toString() + "'");
        sql.append(" and t.fid = '");
        sql.append(material.getId().toString()).append("'");
        try {
            ISqlExecuteFacade isql = SqlExecuteFacadeFactory.getRemoteInstance();
            IRowSet rowSet = isql.executeQuery(sql.toString());
            if (rowSet.next()) {
                String iso = rowSet.getString("FIsolatedRule");
                if (iso.equals("ITEM")) {
                    return "ITEM";
                }
                if (iso.equals("ITEM_TRACKNO")) {
                    return "ITEM_TRACKNO";
                }
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (EASBizException e2) {
            e2.printStackTrace();
        }
        catch (SQLException e3) {
            e3.printStackTrace();
        }
        return "";
    }

    public void beforeActionPerformed(ActionEvent e) {
        super.beforeActionPerformed(e);
        if (e.getSource().equals(this.btnSave) || e.getSource().equals(this.btnSubmit) || e.getSource().equals(this.btnDiffCompare)) {
            this.checkNotNullComponent((JComponent)this.prmtbmaterial, this.contbmaterial);
            this.checkNotNullComponent((JComponent)this.prmtcmaterial, this.contcmaterial);
            if (this.prmtbmaterial.getValue() != null) {
                String flag = this.getCheckNullFlag();
                if (flag.equals("ITEM")) {
                    this.checkNotNullComponent((JComponent)this.prmtcproject, this.contcproject);
                    this.checkNotNullComponent((JComponent)this.prmtbproject, this.contbproject);
                } else if (flag.equals("ITEM_TRACKNO")) {
                    this.checkNotNullComponent((JComponent)this.prmtbproject, this.contbproject);
                    this.checkNotNullComponent((JComponent)this.prmtcproject, this.contcproject);
                    this.checkNotNullComponent((JComponent)this.prmtbtracknumber, this.contbtracknumber);
                    this.checkNotNullComponent((JComponent)this.prmtctracknumber, this.contctracknumber);
                }
            }
        }
        this.checkNotNullComponent((JComponent)this.txtbtructqty, this.contbtructqty);
        this.checkNotNullComponent((JComponent)this.txtctructqty, this.contctructqty);
        this.checkNotNullComponent((JComponent)this.pkplanStartWork, this.contplanStartWork);
        this.checkNotNullComponent((JComponent)this.pkplanFinishWork, this.contplanFinishWork);
        if (((RestructType)((Object)this.restructType.getSelectedItem())).compareTo((Object)RestructType.mftRestruct) == 0) {
            this.checkNotNullComponent((JComponent)this.prmtmanufactureorder, this.contmanufactureorder);
        }
        if (e.getSource().equals(this.btnBackMaterial) || e.getSource().equals(this.btnRevokeInv) || e.getSource().equals(this.btnMftRestruct)) {
            if (((BillBaseStatusEnum)((Object)this.baseStatus.getSelectedItem())).compareTo((Object)BillBaseStatusEnum.AUDITED) != 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.restruct.EMMEMMmrestructResource", (String)"0EMMRESTRUCT-0004"));
                SysUtil.abort();
            }
            this.getSelectRestructEntry();
        }
    }

    private void checkNotNullComponent(JComponent com1, KDLabelContainer com2) {
        EMException exception = null;
        if (com1 instanceof KDBizPromptBox) {
            exception = EMRequiredUtils.checkRequiredItem((KDBizPromptBox)((KDBizPromptBox)com1), (KDLabelContainer)com2);
        } else if (com1 instanceof KDFormattedTextField) {
            exception = EMRequiredUtils.checkRequiredItem((JTextField)((KDFormattedTextField)com1), (KDLabelContainer)com2);
        } else if (com1 instanceof KDDatePicker) {
            exception = EMRequiredUtils.checkRequiredItem((KDDatePicker)((KDDatePicker)com1), (KDLabelContainer)com2);
        }
        if (EMUtils.isNotNull((Object)exception)) {
            super.handUIExceptionAndAbort((Exception)exception);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return RestructReqBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        RestructReqBillEntryInfo entryinfo = new RestructReqBillEntryInfo();
        entryinfo.setIsauto(false);
        entryinfo.setBunitqty(BigDecimal.ZERO);
        entryinfo.setBqty(BigDecimal.ZERO);
        entryinfo.setCunitqty(BigDecimal.ZERO);
        entryinfo.setCqty(BigDecimal.ZERO);
        entryinfo.setBissueqty(BigDecimal.ZERO);
        entryinfo.setIssueqty(BigDecimal.ZERO);
        entryinfo.setRejecteqty(BigDecimal.ZERO);
        entryinfo.setRevokeqty(BigDecimal.ZERO);
        entryinfo.setIssuedqty(BigDecimal.ZERO);
        entryinfo.setRejectedqty(BigDecimal.ZERO);
        entryinfo.setRevokedqty(BigDecimal.ZERO);
        return entryinfo;
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "restructreqbill_addnew";
        }
        if ("EDIT".equals(status)) {
            return "restructreqbill_update";
        }
        if ("VIEW".equals(status)) {
            return "restructreqbill_view";
        }
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        RestructReqBillInfo objectValue = new RestructReqBillInfo();
        OrgUnitInfo c_orgunit = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage"));
        if (c_orgunit != null && c_orgunit.getBoolean("isBizUnit")) {
            objectValue.put("storageOrgUnit", c_orgunit);
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setBizDate(new Date());
        return objectValue;
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        return super.beforeAction(bizAction, selectionEntries, event);
    }

    @Override
    public void actionDiffCompare_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        RestructReqBillEntryCollection colls = RestructReqBillFactory.getRemoteInstance().diffCompare(this.editData);
        this.editData.put("entrys", (Object)colls);
        BindingUtility.loadDetailData((IObjectValue)this.editData, (Field)new Field("header"), (DataComponentMap)this.getDataBinder().getDataComponentMap(), null);
    }

    @Override
    public void actionBackMaterial_actionPerformed(ActionEvent e) throws Exception {
        RestructReqFacadeFactory.getRemoteInstance().restructReqTranOtherBill(this.editData, "BACKMATERIAL");
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.restruct.EMMEMMmrestructResource", (String)"0EMMRESTRUCT-0005"));
    }

    @Override
    public void actionRevokeInv_actionPerformed(ActionEvent e) throws Exception {
        RestructReqFacadeFactory.getRemoteInstance().restructReqTranOtherBill(this.editData, "REVOKEINV");
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.restruct.EMMEMMmrestructResource", (String)"0EMMRESTRUCT-0006"));
    }

    @Override
    public void actionMftRestruct_actionPerformed(ActionEvent e) throws Exception {
        RestructReqFacadeFactory.getRemoteInstance().restructReqTranOtherBill(this.editData, "MFTRESTRUCT");
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.restruct.EMMEMMmrestructResource", (String)"0EMMRESTRUCT-0007"));
    }

    private void getSelectRestructEntry() {
        int size = this.kdtEntrys.getSelectManager().size();
        if (size < 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.restruct.EMMEMMmrestructResource", (String)"0EMMRESTRUCT-0008"));
            SysUtil.abort();
        }
        KDTSelectBlock selectBlock = null;
        ArrayList<String> restructEntryList = new ArrayList<String>();
        for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
            selectBlock = this.kdtEntrys.getSelectManager().get(blockIndex);
            int top = selectBlock.getBeginRow();
            int bottom = selectBlock.getEndRow();
            for (int i = top; i <= bottom; ++i) {
                if (this.kdtEntrys.getRow(i) != null && this.kdtEntrys.getRow(i).getCell("id") != null && this.kdtEntrys.getRow(i).getCell("id").getValue() != null) {
                    String entryid = this.kdtEntrys.getRow(i).getCell("id").getValue().toString();
                    restructEntryList.add(entryid);
                    continue;
                }
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.restruct.EMMEMMmrestructResource", (String)"0EMMRESTRUCT-0009"));
                SysUtil.abort();
            }
        }
        this.editData.put("SELECTENTRYS", restructEntryList);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        RestructReqBillInfo bill = this.editData;
        if (bill.getId() == null) {
            return;
        }
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("BTPNAVCTX", this.getUIContext());
        if (this.getUIContext().get("selectedEntries") != null) {
            uiContext.put("selectedEntries", this.getUIContext().get("selectedEntries"));
        }
        String billID = bill.getId().toString();
        uiContext.put("billInfoID", billID);
        uiContext.put("findType", new Integer(1));
        uiContext.put("findBillType", "down");
        IUIFactory uiFactory = this.createUIFactory((CoreBillEditUI)this);
        IUIWindow window = uiFactory.create("com.kingdee.eas.industry.emm.qm.qc.client.NCRBTPRelationNavUI", uiContext, null);
        if (window instanceof UIModelDialog) {
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension maxSize = new Dimension(820, 650);
            if ((double)screenDim.width > maxSize.getWidth() || (double)screenDim.height > maxSize.getHeight()) {
                screenDim = maxSize;
            }
            ((JPanel)((UIModelDialog)window).getContentPane()).setPreferredSize(screenDim);
        }
        window.show();
    }

    private IUIFactory createUIFactory(CoreBillEditUI billEditUI) throws Exception {
        IUIWindow window = billEditUI.getUIWindow();
        if (window != null && window instanceof UIModelDialog) {
            return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        }
        return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
    }

    private class MaterialDataChangeListener
    implements DataChangeListener {
        private KDTDefaultCellEditor editor;
        private KDTable table;
        private RestructReqBillInfo editData;

        public MaterialDataChangeListener(KDTDefaultCellEditor _editor, KDTable _table, RestructReqBillInfo _editData) {
            this.editor = _editor;
            this.table = _table;
            this.editData = _editData;
        }

        public void dataChanged(DataChangeEvent eventObj) {
            MaterialInfo material = (MaterialInfo)this.editor.getValue();
            SelectorItemCollection itemcoll = new SelectorItemCollection();
            itemcoll.add(new SelectorItemInfo("number"));
            itemcoll.add(new SelectorItemInfo("name"));
            itemcoll.add(new SelectorItemInfo("model"));
            itemcoll.add(new SelectorItemInfo("supplyOrgUnit.*"));
            itemcoll.add(new SelectorItemInfo("baseUnit.*"));
            try {
                material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId().toString()), itemcoll);
            }
            catch (EASBizException ex) {
                RestructReqBillEditUI.this.handUIException(ex);
            }
            catch (BOSException ex) {
                RestructReqBillEditUI.this.handUIException(ex);
            }
            int rowIndex = this.table.getSelectManager().getActiveRowIndex();
            Object entryobj = this.table.getRow(rowIndex).getUserObject();
            if (entryobj instanceof RestructReqBillEntryInfo) {
                RestructReqBillEntryInfo tmp = (RestructReqBillEntryInfo)entryobj;
                tmp.setMaterial(material);
                tmp.setMaterialcode(material.getNumber());
                tmp.setMaterialmodel(material.getModel());
                this.table.getRow(rowIndex).setUserObject((Object)tmp);
                ICell cellMaterialName = this.table.getCell(rowIndex, RestructReqBillEditUI.this.TB_COL_MATERIALNAME);
                cellMaterialName.setValue((Object)material);
                ICell cellMaterialMode = this.table.getCell(rowIndex, RestructReqBillEditUI.this.TB_COL_MATERIALMODE);
                cellMaterialMode.setValue((Object)material.getModel());
                ICell cellMaterialUnit = this.table.getCell(rowIndex, RestructReqBillEditUI.this.TB_COL_MEASUERUNIT);
                cellMaterialUnit.setValue((Object)(material.getBaseUnit() == null ? "" : material.getBaseUnit().getName()));
                ICell cellRejectOrgUnit = this.table.getCell(rowIndex, RestructReqBillEditUI.this.TB_COL_REJECTORGUNIT);
                try {
                    StorageOrgUnitInfo storage;
                    if (this.editData.getStorageOrgUnit() != null && (storage = RestructReqBillEditUI.this.getStorageOrgUnitByMaterialTab(material.getId().toString(), this.editData.getStorageOrgUnit().getId().toString())) != null) {
                        StorageOrgUnitInfo info = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storage.getId().toString()));
                        cellRejectOrgUnit.setValue((Object)info);
                    }
                }
                catch (Exception ex) {
                    RestructReqBillEditUI.this.handUIException(ex);
                }
            }
        }
    }
}

