/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.sc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.zj.ISqlExcFacade;
import com.kingdee.eas.basedata.zj.SqlExcFacadeFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.industry.emm.mm.sc.client.AbstractModifyTotalHistoryUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class ModifyTotalHistoryUI
extends AbstractModifyTotalHistoryUI {
    private static final Logger logger = CoreUIObject.getLogger(ModifyTotalHistoryUI.class);
    private String entryId;
    private String billId;
    private ISqlExcFacade ief;
    private BigDecimal budgetAmount;

    public ModifyTotalHistoryUI() throws Exception {
        this.txtnew.setHorizontalAlignment(2);
        this.txtnew.setDataType(1);
        this.txtnew.setSupportedEmpty(true);
        this.txtnew.setMinimumValue((Comparable)new BigDecimal("0"));
        this.txtnew.setMaximumValue((Comparable)new BigDecimal("1.0E18"));
        this.txtnew.setPrecision(2);
        this.txtnew.setRequired(true);
        this.txtold.setEnabled(false);
        this.kDTable1.getStyleAttributes().setLocked(true);
        this.btnOk.setEnabled(true);
    }

    protected void validateTree() {
        super.validateTree();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initLayout();
        this.ief = SqlExcFacadeFactory.getRemoteInstance();
        Map context = this.getUIContext();
        this.txtold.setValue(context.get("old"));
        this.entryId = (String)context.get("entryId");
        this.billId = (String)context.get("billId");
        this.budgetAmount = (BigDecimal)context.get("budgetAmount");
        this.kDTable1.checkParsed();
        this.initTable();
    }

    public void show() {
        super.show();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void initTable() throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/ select FEntryID as eid,FUserID as usid,u.fnumber as uNumber,u.fname_l2 as uName,FOldAmount,FNewAmount,FModifyTime ");
        sql.append(" from CT_SC_YearScModifyRecord rec");
        sql.append(" inner join t_pm_user u on u.fid=rec.FUserID");
        sql.append(" where rec.FEntryID='" + this.entryId + "'");
        sql.append(" order by rec.FModifyTime DESC");
        IRowSet rs = this.ief.executeQuery(sql.toString());
        while (rs.next()) {
            IRow row = this.kDTable1.addRow();
            row.getCell("userNumber").setValue((Object)rs.getString("uNumber"));
            row.getCell("userName").setValue((Object)rs.getString("uName"));
            row.getCell("date").setValue((Object)rs.getDate("FModifyTime"));
            row.getCell("oldAmount").setValue((Object)rs.getBigDecimal("FOldAmount"));
            row.getCell("newAmount").setValue((Object)rs.getBigDecimal("FNewAmount"));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal oldAmount;
        BigDecimal newAmount;
        if (this.txtnew.getNumberValue() == null) {
            this.txtnew.setNumberValue((Number)0);
        }
        if ((newAmount = new BigDecimal(this.txtnew.getNumberValue().toString())).compareTo(oldAmount = new BigDecimal(this.txtold.getNumberValue().toString())) == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0076"));
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/ select sum(nvl(cfamount,0)) as amount from CT_SC_YearScRequestBillEntry");
        sql.append(" where fparentid='" + this.billId + "' and fid<>'" + this.entryId + "'");
        IRowSet rs = this.ief.executeQuery(sql.toString());
        BigDecimal other = BigDecimal.ZERO;
        if (rs.next()) {
            other = rs.getBigDecimal("amount");
        }
        if (other == null) {
            other = BigDecimal.ZERO;
        }
        if (other.add(newAmount).compareTo(this.budgetAmount) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0077"));
            return;
        }
        sql.setLength(0);
        this.ief.executeUpdate("/*dialect*/ update CT_SC_YearScRequestBillEntry set cfamount=" + newAmount.toString() + " where fid='" + this.entryId + "'");
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        sql.setLength(0);
        sql.append("/*dialect*/insert into CT_SC_YearScModifyRecord (FUserID,FOldAmount,FNewAmount,FModifyTime,FEntryID) values (");
        sql.append("'" + userInfo.getId().toString() + "',");
        sql.append("" + oldAmount.toString() + ",");
        sql.append("" + newAmount.toString() + ",");
        sql.append("sysdate,");
        sql.append("'" + this.entryId + "')");
        this.ief.executeUpdate(sql.toString());
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0078"));
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

