/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.fcs.algorithm.method;

import com.kingdee.eas.industry.emm.project.fcs.algorithm.method.AbstractAlgorithm;
import java.math.BigDecimal;
import java.math.MathContext;

public class ExponentialSmoothingAlgotithm
extends AbstractAlgorithm {
    protected double[] source;
    protected int initialStep;
    protected BigDecimal alpha;

    public ExponentialSmoothingAlgotithm(double[] source, int initialStep, double alpha) {
        this.source = source;
        this.initialStep = initialStep;
        this.alpha = new BigDecimal(alpha);
        if (source == null) {
            throw new IllegalArgumentException("source data can not be null");
        }
        if (initialStep > source.length) {
            throw new IllegalArgumentException("initialStep can not be over source data's length");
        }
    }

    @Override
    public BigDecimal[] calc() {
        BigDecimal initial = BigDecimal.ZERO.setScale(this.scale, this.roundingMode);
        for (int i = 0; i < this.initialStep; ++i) {
            initial.add(new BigDecimal(this.source[i]));
        }
        MathContext mc = new MathContext(this.scale, this.roundingMode);
        initial = initial.divide(new BigDecimal(this.initialStep), mc);
        BigDecimal[] ret = new BigDecimal[this.source.length + 1];
        int index = 0;
        do {
            if (index < this.source.length) {
                initial = this.alpha.multiply(new BigDecimal(this.source[index])).add(BigDecimal.ONE.subtract(this.alpha).multiply(initial));
                ret[index] = initial.setScale(this.scale, this.roundingMode);
                continue;
            }
            initial = this.alpha.multiply(new BigDecimal(this.source[index - 1])).add(BigDecimal.ONE.subtract(this.alpha).multiply(initial));
            ret[index] = initial.setScale(this.scale, this.roundingMode);
        } while (++index <= this.source.length);
        return ret;
    }
}

