/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.fcs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.industry.emm.project.fcs.SaleMaterialABCFacadeFactory;
import com.kingdee.eas.industry.emm.project.fcs.client.AbstractSOPMaterialABCUI;
import com.kingdee.eas.industry.emm.project.fcs.client.SOPMaterialABCFilterUI;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ABCArithmetic;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class SOPMaterialABCUI
extends AbstractSOPMaterialABCUI {
    private static final Logger logger = CoreUIObject.getLogger(SOPMaterialABCUI.class);
    private ABCArithmetic abc = null;

    public SOPMaterialABCUI() throws Exception {
        this.tblMaterial.checkParsed();
        this.tblMaterial.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMaterial.getStyleAttributes().setLocked(true);
        this.enableExportExcel(this.tblMaterial);
        this.abc = new ABCArithmetic("FABC", "FPercentMaterial");
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        initParam.setString("init_title", "AA");
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return CommRptBaseFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMaterial;
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        return new SOPMaterialABCFilterUI();
    }

    public Object getTablePreferenceSchemaKey() {
        return this.queryDialog.getCurrentSolutionInfo().getId();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PURCHASINGMANAGEMENT;
    }

    public boolean isAsynchronism() {
        return true;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        CustomerParams cp = null;
        try {
            SCMBillFilterUI rbqp;
            this.initQueryDialog();
            this.userPanel.getUIContext().clear();
            this.userPanel.getUIContext().putAll(this.getUIContext());
            if (useDefaultSolution) {
                QuerySolutionInfo solution;
                QueryPanelInfo qpi;
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName) && (qpi = (solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName)).getQueryPanelInfo().get(0)) != null) {
                    try {
                        cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            boolean ok = false;
            if ((cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                rbqp = (SCMBillFilterUI)this.queryDialog.getUserPanel(0);
                this.params = rbqp.getCustomCondition();
                ok = true;
            }
            if (cp != null) {
                rbqp = (SCMBillFilterUI)this.getCustomerQueryPanel();
                rbqp.setCustomerParams(cp);
                rbqp.loadData(null);
                this.params = rbqp.getCustomCondition();
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = this.getCustomerQueryPanel();
            this.userPanel.loadFields();
            Dimension dd = this.userPanel.getSize();
            this.queryDialog.setMaxReturnCountVisible(false);
            this.queryDialog.setWidth(517);
            this.queryDialog.setHeight(dd.height);
            this.queryDialog.addUserPanel((KDPanel)this.userPanel);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.userPanel.getUITitle());
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            Method m = this.userPanel.getClass().getMethod("onInit", RptParams.class);
            m.invoke((Object)this.userPanel, this.getUIContextInitParams());
            this.userPanel.initLayout();
            if (this.params != null) {
                this.userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params));
            }
        }
    }

    protected void query() {
        this.tblMaterial.removeColumns();
        this.abc.setPercent(Double.valueOf(this.params.getString("aPercent")).doubleValue(), Double.valueOf(this.params.getString("bPercent")).doubleValue());
        this.abc.reset();
        this.tblMaterial.removeRows();
        this.initUserConfig();
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            this.tblMaterial.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams pp = new RptParams();
            if (from == 0) {
                int precision;
                pp.clear();
                pp.putAll(this.params.toMap());
                CompanyOrgUnitInfo ficompanyOrgInfo = SysContext.getSysContext().getCurrentFIUnit();
                if (ficompanyOrgInfo != null && ficompanyOrgInfo.getBaseCurrency() != null) {
                    CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getBaseCurrency().getId()));
                    precision = baseCurrInfo.getPrecision();
                } else {
                    precision = 2;
                }
                pp.setString("currPrecision", "" + precision);
                RptParams rpt = SaleMaterialABCFacadeFactory.getRemoteInstance().createTempTable(pp);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMaterial);
                if (this.tblMaterial.getRowCount() < 100) {
                    this.tblMaterial.setRowCount(from + this.tblMaterial.getRowCount());
                } else {
                    int forNextFetchCount = 100;
                    this.tblMaterial.setRowCount(from + len + forNextFetchCount);
                }
            }
            pp.setString("tempTable", this.getTempTable());
            RptParams rpt = SaleMaterialABCFacadeFactory.getRemoteInstance().query(pp, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            this.abc.Calculate(rs);
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tblMaterial, (KDTableInsertHandler)new KDTableInsertHandler(){

                public void setTableRowData(IRow row, Object[] rowData) {
                    int n = rowData.length;
                    for (int i = 0; i < n; ++i) {
                        row.getCell(i).setValue(rowData[i]);
                    }
                    row.getCell("Famount").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)2, (boolean)false));
                    row.getCell("FPercentMaterial").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)4, (boolean)true));
                    row.getCell("Fprice").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)4, (boolean)true));
                    row.getCell("FQty").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)4, (boolean)true));
                }
            });
            this.tblMaterial.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
            if (from == 0) {
                this.initUserConfig();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }
}

