/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.AbstractDataBaseInfo;
import com.kingdee.eas.industry.report.client.AbstractOperationLackAnalysisRptFilterUI;
import com.kingdee.eas.scm.common.client.BizDateUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import org.apache.log4j.Logger;

public class OperationLackAnalysisRptFilterUI
extends AbstractOperationLackAnalysisRptFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(OperationLackAnalysisRptFilterUI.class);
    protected SelectorListener selectorListener;

    public OperationLackAnalysisRptFilterUI() throws Exception {
        this.isReport = true;
        this.initElementsInfo();
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.initListener();
        this.setF7Filter();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
        this.prmtSou.setRequired(true);
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
        InvClientUtils.getMaterialF7ForReportFilterUI((KDBizPromptBox)this.prmtMaterial, (Object)((Object)this));
        this.prmtMaterial.setDisplayFormat("$name$");
        this.prmtMaterial.setCommitFormat("$number$");
        this.prmtMaterial.setEditFormat("$number$");
        this.prmtSou.setEnabledMultiSelection(false);
        this.prmtProject.setDisplayFormat("$name$");
        this.prmtProject.setCommitFormat("$number$");
        this.prmtProject.setEditFormat("$number$");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        filter.mergeFilter(SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"id", (String)"emm_OperationLackAnalysis80zb_menu"), "AND");
        this.prmtSou.setEntityViewInfo(view);
        StorageOrgUnitInfo storInfo = SysContext.getSysContext().getCurrentStorageUnit();
        if (storInfo != null && storInfo.isIsBizUnit()) {
            this.prmtSou.setValue((Object)storInfo);
        } else {
            storInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view).get(0);
            this.prmtSou.setValue((Object)storInfo);
        }
    }

    private void setF7Filter() {
        this.f7Manager.registerContextChangeF7(this.prmtMaterial, "storageOrgUnit.id");
        this.registerWarehouseF7(this.prmtSou, this.prmtWarehouse);
        this.prmtWarehouse.setEnabledMultiSelection(true);
        this.prmtWorkShop.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7WorkcenterQuery");
        this.prmtWorkShop.setEnabledMultiSelection(false);
        this.prmtWorkShop.addCommonF7KDTableListener((CommonF7KDTableListener)new CommonF7KDTableListenerImpl(EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0019"), this.prmtWorkShop));
        this.chkMaterialProp.setSelectedItem((Object)MaterialAttributeEnum.FABRICATEDPART);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        this.prmtProject.setEntityViewInfo(entityViewInfo);
    }

    public void registerWarehouseF7(KDBizPromptBox prmtStorageOrgUnit, KDBizPromptBox prmtWarehouse) {
        prmtWarehouse.setEditable(true);
        prmtWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        prmtWarehouse.setDisplayFormat("$name$");
        prmtWarehouse.setEditFormat("$number$");
        prmtWarehouse.setCommitFormat("$number$");
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        if (prmtStorageOrgUnit.getValue() != null) {
            Object object = prmtStorageOrgUnit.getValue();
            if (object instanceof StorageOrgUnitInfo) {
                storageOrgUnitInfo = (StorageOrgUnitInfo)prmtStorageOrgUnit.getValue();
            }
            if (object instanceof OrgUnitInfo) {
                OrgUnitInfo orgUnitInfo = (OrgUnitInfo)prmtStorageOrgUnit.getValue();
                ObjectUuidPK orgPK = new ObjectUuidPK(orgUnitInfo.getId());
                try {
                    storageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)orgPK);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        if (storageOrgUnitInfo != null) {
            try {
                prmtWarehouse.setEntityViewInfo(SCMClientUtils.getWarehouseFilter(storageOrgUnitInfo, (int)1));
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void initListener() {
        super.initListener();
        if (this.selectorListener == null) {
            this.selectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    if (e.getSource().equals(OperationLackAnalysisRptFilterUI.this.prmtWarehouse)) {
                        OperationLackAnalysisRptFilterUI.this.selectorWarehouse();
                    }
                    if (e.getSource().equals(OperationLackAnalysisRptFilterUI.this.prmtWorkShop)) {
                        OperationLackAnalysisRptFilterUI.this.workCenterWillShow(e);
                    }
                }
            };
        }
        this.prmtWarehouse.addSelectorListener(this.selectorListener);
        this.prmtWorkShop.addSelectorListener(this.selectorListener);
    }

    protected void removeListener() {
        if (this.selectorListener != null) {
            this.prmtWarehouse.removeSelectorListener(this.selectorListener);
            this.prmtWorkShop.removeSelectorListener(this.selectorListener);
        }
    }

    protected void selectorWarehouse() {
        String storageid;
        Object[] storage;
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        Object object = this.prmtSou.getValue();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (object instanceof StorageOrgUnitInfo) {
            storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtSou.getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString()));
        }
        if (object instanceof Object[] && (storage = (Object[])this.prmtSou.getData()) != null && storage.length > 0 && (storageid = this.checkID(storage)) != null && !"".equals(storageid)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageid, CompareType.INNER));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtWarehouse.setEntityViewInfo(viewInfo);
        this.prmtWarehouse.getQueryAgent().resetRuntimeEntityView();
    }

    public String checkID(Object[] infos) {
        String hasContext = null;
        if (infos == null || infos[0] == "") {
            infos = new Object[]{null};
        }
        if (infos[0] != null) {
            hasContext = this.getOrgListId(infos);
        }
        return hasContext;
    }

    public String getOrgListId(Object[] infos) {
        StringBuffer id = new StringBuffer();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            id.append(",'" + ((AbstractDataBaseInfo)infos[i]).getId().toString() + "'");
        }
        String listId = id.toString().substring(1, id.toString().length());
        return listId;
    }

    public void workCenterWillShow(SelectorEvent e) {
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        Object object = this.prmtSou.getValue();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (object instanceof StorageOrgUnitInfo) {
            storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtSou.getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString()));
        }
        if (object instanceof OrgUnitInfo) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.prmtSou.getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnitInfo.getId().toString()));
        }
        if (object instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnitInfos = (OrgUnitInfo[])this.prmtSou.getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnitInfos[0].getId().toString()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isWorkShop", (Object)true));
        viewInfo.setFilter(filterInfo);
        this.prmtWorkShop.setEntityViewInfo(viewInfo);
        this.prmtWorkShop.getQueryAgent().resetRuntimeEntityView();
    }

    private void initElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit", (Component)this.prmtSou);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, InvClientUtils.getResource((String)"StorageOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        SingleFilterElement projectElement = new SingleFilterElement("project", (Component)this.prmtProject);
        elements.add((FilterElement)projectElement);
        SingleFilterElement materialElement = new SingleFilterElement("material", (Component)this.prmtMaterial);
        elements.add((FilterElement)materialElement);
        SingleFilterElement startDateElements = new SingleFilterElement("startDate", (Component)this.dpStartDate);
        startDateElements.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0020")));
        elements.add((FilterElement)startDateElements);
        SingleFilterElement endDateElements = new SingleFilterElement("endDate", (Component)this.dpEndDate);
        endDateElements.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0021")));
        elements.add((FilterElement)endDateElements);
        elements.add((FilterElement)new SingleFilterElement("analysisMaterial", (Component)this.kdRadioMaterial));
        elements.add((FilterElement)new SingleFilterElement("analysisOperation", (Component)this.kdRadioOperation));
        elements.add((FilterElement)new SingleFilterElement("isOnlyKeyMaterial", (Component)this.chkBoxKeyMaterial));
        elements.add((FilterElement)new SingleFilterElement("isOnlyShortage", (Component)this.chkShortage));
        SingleFilterElement warehouseElement = new SingleFilterElement("warehouse", (Component)this.prmtWarehouse);
        elements.add((FilterElement)warehouseElement);
        SingleFilterElement workShopElement = new SingleFilterElement("workShop", (Component)this.prmtWorkShop);
        elements.add((FilterElement)workShopElement);
        SingleFilterElement materialPropElement = new SingleFilterElement("materialProp", (Component)this.chkMaterialProp);
        elements.add((FilterElement)materialPropElement);
        SingleFilterElement gongweiElement = new SingleFilterElement("gongwei", (Component)this.txtgongwei);
        elements.add((FilterElement)gongweiElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "storageOrgUnit");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.dpStartDate);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.dpEndDate);
        if (this.prmtSou.getValue() == null) {
            this.prmtSou.setValue((Object)SysContext.getSysContext().getCurrentStorageUnit());
        }
        if (!this.kdRadioMaterial.isSelected() && !this.kdRadioOperation.isSelected()) {
            this.kdRadioOperation.setSelected(true);
        }
        this.chkBoxKeyMaterial.setSelected(true);
    }

    public boolean verify() {
        if (!BizDateUtil.checkDateOneMonth((KDDatePicker)this.dpStartDate, (KDDatePicker)this.dpEndDate)) {
            return false;
        }
        return super.verify();
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit";
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtSou;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    private class CommonF7KDTableListenerImpl
    implements CommonF7KDTableListener {
        private KDBizPromptBox prmtBox;
        private String title;

        private CommonF7KDTableListenerImpl(String title, KDBizPromptBox prmtBox) {
            this.prmtBox = prmtBox;
            this.title = title;
        }

        public void onTableStructureCreated(KDTable arg0) {
            ((KDCommonPromptDialog)this.prmtBox.getSelector()).setTitle(this.title);
        }
    }
}

