/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.client.AbstractBomChangeFilterUI;
import com.kingdee.eas.mm.basedata.util.MfgBomUtil;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class BomChangeFilterUI
extends AbstractBomChangeFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BomChangeFilterUI.class);
    protected DataChangeListener f7DataChangeListener = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void addListener() {
        if (this.f7DataChangeListener == null) {
            this.f7DataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        BomChangeFilterUI.this.f7DataChanged(e);
                    }
                    catch (Exception exc) {
                        BomChangeFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.f7DataChangeListener);
        this.prmtDesignMode.addDataChangeListener(this.f7DataChangeListener);
    }

    public void f7DataChanged(DataChangeEvent e) {
        if (e.getSource() == null) {
            return;
        }
        if (!(e.getSource() instanceof KDBizPromptBox)) {
            return;
        }
        String f7Name = ((KDBizPromptBox)e.getSource()).getName();
        boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (!isDifferent) {
            return;
        }
        if (this.prmtStorageOrgUnit.getName().equals(f7Name)) {
            this.prmtBom.setValue(null);
            this.prmtmaterial.setValue(null);
            this.setBomFilter();
        } else if (this.prmtDesignMode.getName().equals(f7Name)) {
            this.prmtBom.setValue(null);
            this.prmtmaterial.setValue(null);
            this.setBomFilter();
        }
    }

    protected void setBomFilter() {
        HashSet<String> idset = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        Object orgObj = this.prmtStorageOrgUnit.getValue();
        if (!BomChangeFilterUI.isNull(orgObj)) {
            StorageOrgUnitInfo[] tnis = null;
            if (orgObj instanceof StorageOrgUnitInfo) {
                tnis = new StorageOrgUnitInfo[]{(StorageOrgUnitInfo)orgObj};
            } else if (orgObj instanceof StorageOrgUnitInfo[]) {
                tnis = (StorageOrgUnitInfo[])orgObj;
            } else if (orgObj instanceof Object[]) {
                Object[] objs = (Object[])orgObj;
                tnis = new StorageOrgUnitInfo[objs.length];
                System.arraycopy(objs, 0, tnis, 0, objs.length);
            }
            for (int i = 0; i < tnis.length; ++i) {
                idset.add(tnis[i].getId().toString());
            }
            Object dsOrg = this.prmtDesignMode.getValue();
            if (!BomChangeFilterUI.isNull(dsOrg)) {
                HashSet<String> dsIDset = new HashSet<String>();
                DesignModeInfo[] dsArray = null;
                if (dsOrg instanceof DesignModeInfo) {
                    dsArray = new DesignModeInfo[]{(DesignModeInfo)dsOrg};
                } else if (dsOrg instanceof DesignModeInfo[]) {
                    dsArray = (DesignModeInfo[])dsOrg;
                } else if (dsOrg instanceof Object[]) {
                    Object[] objs = (Object[])dsOrg;
                    dsArray = new DesignModeInfo[objs.length];
                    System.arraycopy(objs, 0, dsArray, 0, objs.length);
                }
                for (int i = 0; i < dsArray.length; ++i) {
                    dsIDset.add(dsArray[i].getId().toString());
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("designMode.id", dsIDset, CompareType.INCLUDE));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", idset, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)"4", CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("bom.id in (select fbomid from T_MM_BomChange)"));
            view.setFilter(filterInfo);
            this.prmtBom.setEntityViewInfo(view);
        } else {
            this.prmtBom.setEntityViewInfo(null);
        }
    }

    public static boolean isNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            if (objs == null || objs.length == 0) {
                return true;
            }
            boolean hasObj = false;
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null) continue;
                hasObj = true;
                break;
            }
            return !hasObj;
        }
        return false;
    }

    public void clear() {
        super.clear();
        this.prmtNumber.setValue(null);
        this.prmtmaterial.setValue(null);
        this.prmtBom.setValue(null);
        this.prmtProject.setValue(null);
        this.kDComboBox3.setSelectedItem(null);
        try {
            this.setMainBizOrgF7("emm_bomchangebill_view");
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        try {
            this.prmtDesignMode.setValue((Object)MfgBomUtil.getDefaultDesignMode(null));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected String getViewPermission() {
        return super.getViewPermission();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.addListener();
        this.prmtStorageOrgUnit.setRequired(true);
        this.setFilterElement();
        this.prmtStorageOrgUnit.setEnabledMultiSelection(true);
        this.setMainBizOrgF7("emm_bomchangebill_view");
    }

    private void setMainBizOrgF7(String string) throws EASBizException, BOSException {
        StorageOrgUnitInfo storageInfo;
        FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (String)string);
        StorageOrgUnitInfo info = null;
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        ArrayList<String> numberLs = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            info = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(collection.get(i).getId().toString()));
            String number = info.getNumber();
            if (!info.isIsBizUnit()) continue;
            keys.add(collection.get(i).getId().toString());
            numberLs.add(number);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtStorageOrgUnit.setEntityViewInfo(view);
        String currentStoID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (keys.contains(currentStoID)) {
            storageInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentStoID));
            this.prmtStorageOrgUnit.setValue((Object)storageInfo);
        } else {
            storageInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(keys.iterator().next().toString()));
            this.prmtStorageOrgUnit.setValue((Object)storageInfo);
        }
        EntityViewInfo bomView = new EntityViewInfo();
        FilterInfo bomFilter = new FilterInfo();
        bomFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        bomView.setFilter(bomFilter);
        this.prmtBom.setEntityViewInfo(bomView);
    }

    public void setFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_2")));
        elements.add((FilterElement)mainOrgElement);
        SingleFilterElement designModeElement = new SingleFilterElement("designMode.number", (Component)this.prmtDesignMode);
        elements.add((FilterElement)designModeElement);
        SingleFilterElement id = new SingleFilterElement("number", (Component)this.prmtNumber);
        elements.add((FilterElement)id);
        SingleFilterElement material = new SingleFilterElement("material.number", (Component)this.prmtmaterial);
        elements.add((FilterElement)material);
        SingleFilterElement bom = new SingleFilterElement("bom.number", (Component)this.prmtBom);
        elements.add((FilterElement)bom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtProject);
        SingleFilterElement project = new SingleFilterElement("project.number", (Component)this.prmtProject);
        elements.add((FilterElement)project);
        SingleFilterElement baseStatus = new SingleFilterElement("baseStatus", (Component)this.kDComboBox3);
        elements.add((FilterElement)baseStatus);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "storageOrgUnit.id");
    }
}

