/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.CoreMaterialFactory;
import com.kingdee.eas.mm.basedata.CoreMaterialInfo;
import com.kingdee.eas.mm.basedata.client.AbstractCoreMaterialListUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class CoreMaterialListUI
extends AbstractCoreMaterialListUI {
    private static final Logger logger = CoreUIObject.getLogger(CoreMaterialListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"EM_GJWLDY"));
        this.btnMaterial.setEnabled(true);
    }

    @Override
    public void actionProjectAdd_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("mode", "project");
        this.actionAddNew_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.getUIContext().put("mode", null);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        StorageOrgUnitInfo storage = SysContext.getSysContext().getCurrentStorageUnit();
        if (storage != null) {
            String number = storage.getNumber();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)number, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"nodata", CompareType.EQUALS));
        }
        return filter;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CoreMaterialFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        CoreMaterialInfo objectValue = new CoreMaterialInfo();
        return objectValue;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            dialog.addUserPanel((KDPanel)new CoreMaterialQueryPanel());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return dialog;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    private class CoreMaterialQueryPanel
    extends CustomerQueryPanel {
        private static final long serialVersionUID = 1L;
        private KDBizPromptBox prmtStorageOrgUnit = new KDBizPromptBox();
        private KDBizPromptBox prmtMaterial;

        public CoreMaterialQueryPanel() throws Exception {
            this.prmtStorageOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
            this.prmtStorageOrgUnit.setEnabledMultiSelection(false);
            this.prmtStorageOrgUnit.setEditFormat("$number$");
            this.prmtStorageOrgUnit.setDisplayFormat("$name$");
            this.prmtMaterial = new KDBizPromptBox();
            InvClientUtils.getMaterialF7ForReportFilterUI((KDBizPromptBox)this.prmtMaterial, (Object)((Object)this));
            this.prmtMaterial.setEnabledMultiSelection(false);
            this.prmtMaterial.setEditFormat("$number$");
            this.prmtMaterial.setDisplayFormat("$name$");
        }

        public void onLoad() throws Exception {
            super.onLoad();
            this.setLayout(null);
            KDLabelContainer cont = new KDLabelContainer((JComponent)this.prmtStorageOrgUnit);
            cont.setBoundLabelLength(100);
            cont.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"EM_KCZZ"));
            cont.setBoundLabelUnderline(true);
            cont.setBounds(10, 10, 300, 20);
            this.add((Component)cont);
            cont = new KDLabelContainer((JComponent)this.prmtMaterial);
            cont.setBoundLabelLength(100);
            cont.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"EM_WL"));
            cont.setBoundLabelUnderline(true);
            cont.setBounds(10, 40, 300, 20);
            this.add((Component)cont);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            filter.mergeFilter(SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"id", (String)"emm_gjwlsz80zb_CorematerialListUI_menu"), "AND");
            this.prmtStorageOrgUnit.setEntityViewInfo(view);
            StorageOrgUnitInfo storInfo = SysContext.getSysContext().getCurrentStorageUnit();
            if (storInfo != null && storInfo.isIsBizUnit()) {
                this.prmtStorageOrgUnit.setValue((Object)storInfo);
            } else {
                storInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view).get(0);
                this.prmtStorageOrgUnit.setValue((Object)storInfo);
            }
        }

        public void setCustomerParams(CustomerParams cp) {
            StorageOrgUnitInfo s;
            String str = cp.getCustomerParam("storageOrgUnit.id");
            if (!StringUtil.isEmptyString((String)str)) {
                s = new StorageOrgUnitInfo();
                s.setId(BOSUuid.read((String)str));
                s.setName(cp.getCustomerParam("storageOrgUnit.name"));
                s.setNumber(cp.getCustomerParam("storageOrgUnit.number"));
            }
            if (!StringUtil.isEmptyString((String)(str = cp.getCustomerParam("material.id")))) {
                s = new MaterialInfo();
                s.setId(BOSUuid.read((String)str));
                s.setName(cp.getCustomerParam("material.name"));
                s.setNumber(cp.getCustomerParam("material.number"));
            }
        }

        public CustomerParams getCustomerParams() {
            MaterialInfo m;
            CustomerParams ret = new CustomerParams();
            StorageOrgUnitInfo s = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            if (s != null) {
                ret.addCustomerParam("storageOrgUnit.id", s.getId().toString());
                ret.addCustomerParam("storageOrgUnit.name", s.getName());
                ret.addCustomerParam("storageOrgUnit.number", s.getNumber());
            }
            if ((m = (MaterialInfo)this.prmtMaterial.getValue()) != null) {
                ret.addCustomerParam("material.id", m.getId().toString());
                ret.addCustomerParam("material.name", m.getName());
                ret.addCustomerParam("material.number", m.getNumber());
            }
            return ret;
        }

        public FilterInfo getFilterInfo() {
            MaterialInfo m;
            FilterInfo filter = new FilterInfo();
            StorageOrgUnitInfo s = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            if (s != null) {
                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)s.getId()));
            }
            if ((m = (MaterialInfo)this.prmtMaterial.getValue()) != null) {
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)m.getId()));
            }
            return filter;
        }
    }
}

