/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.MainTenanceLevelInfo;
import com.kingdee.eas.mm.basedata.MfgBomFacadeFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.AbstractMfgBomBackSearchUI;
import com.kingdee.eas.mm.basedata.util.MfgBomUtil;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MfgBomBackSearchUI
extends AbstractMfgBomBackSearchUI {
    private static final Logger logger = CoreUIObject.getLogger(MfgBomBackSearchUI.class);
    private String RESURL = "com.kingdee.eas.zjbom.BOMLanResource";

    public MfgBomBackSearchUI() throws Exception {
        this.setPreferredSize(new Dimension(1024, 700));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private static final SelectorItemCollection getBomHeadSelectSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bomtype"));
        sic.add(new SelectorItemInfo("designMode.id"));
        sic.add(new SelectorItemInfo("designMode.number"));
        sic.add(new SelectorItemInfo("designMode.name"));
        sic.add(new SelectorItemInfo("designMode.project"));
        sic.add(new SelectorItemInfo("designMode.trackNumber"));
        sic.add(new SelectorItemInfo("mainTenanceLevel.id"));
        sic.add(new SelectorItemInfo("mainTenanceLevel.number"));
        sic.add(new SelectorItemInfo("mainTenanceLevel.name"));
        sic.add(new SelectorItemInfo("storageOrgunit.id"));
        sic.add(new SelectorItemInfo("storageOrgunit.number"));
        sic.add(new SelectorItemInfo("storageOrgunit.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("material.baseUnit.id"));
        sic.add(new SelectorItemInfo("material.baseUnit.name"));
        sic.add(new SelectorItemInfo("baseStatus"));
        return sic;
    }

    private static final SelectorItemCollection getBomEntrySelectSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.designMode.id"));
        sic.add(new SelectorItemInfo("parent.designMode.number"));
        sic.add(new SelectorItemInfo("parent.designMode.name"));
        sic.add(new SelectorItemInfo("parent.designMode.project"));
        sic.add(new SelectorItemInfo("parent.designMode.trackNumber"));
        sic.add(new SelectorItemInfo("parent.mainTenanceLevel.id"));
        sic.add(new SelectorItemInfo("parent.mainTenanceLevel.number"));
        sic.add(new SelectorItemInfo("parent.mainTenanceLevel.name"));
        sic.add(new SelectorItemInfo("parent.project.id"));
        sic.add(new SelectorItemInfo("parent.project.number"));
        sic.add(new SelectorItemInfo("parent.project.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("material.baseUnit.id"));
        sic.add(new SelectorItemInfo("material.baseUnit.name"));
        return sic;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtCountRation.setHorizontalAlignment(4);
        if (this.getUIContext().get("bomid") != null && !this.getUIContext().get("bomid").equals("")) {
            String bomid = this.getUIContext().get("bomid").toString();
            BomInfo bomInfo = BomFactory.getRemoteInstance().getBomInfo((IObjectPK)new ObjectUuidPK(bomid), MfgBomBackSearchUI.getBomHeadSelectSic());
            this.prmtChildMaNum.setValue((Object)bomInfo.getMaterial());
            this.txtChildMaName.setText(bomInfo.getMaterial().getName());
            this.txtChildModel.setText(bomInfo.getMaterial().getModel());
            this.txtUnit.setText(bomInfo.getMaterial().getBaseUnit().getName());
            this.prmtProject.setValue((Object)bomInfo.getProject());
            this.prmtMainTenanceLevel.setValue((Object)bomInfo.getMainTenanceLevel());
        } else if (this.getUIContext().get("entryid") != null && !this.getUIContext().get("entryid").equals("")) {
            String entryid = this.getUIContext().get("entryid").toString();
            BomEntryInfo entryInfo = BomEntryFactory.getRemoteInstance().getBomEntryInfo((IObjectPK)new ObjectUuidPK(entryid), MfgBomBackSearchUI.getBomEntrySelectSic());
            this.prmtChildMaNum.setValue((Object)entryInfo.getMaterial());
            this.txtChildMaName.setText(entryInfo.getMaterial().getName());
            this.txtChildModel.setText(entryInfo.getMaterial().getModel());
            this.txtUnit.setText(entryInfo.getMaterial().getBaseUnit().getName());
            this.prmtProject.setValue((Object)entryInfo.getParent().getProject());
            this.prmtMainTenanceLevel.setValue((Object)entryInfo.getParent().getMainTenanceLevel());
        } else if (this.prmtChildMaNum.getValue() != null) {
            MaterialInfo material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(((MaterialInfo)this.prmtChildMaNum.getValue()).getId()));
            MeasureUnitInfo unit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(material.getBaseUnit().getId()));
            this.prmtChildMaNum.setValue((Object)material);
            this.txtChildMaName.setText(material.getName());
            this.txtChildModel.setText(material.getModel());
            this.txtUnit.setText(unit.getName());
        }
        UIHelper.registerProjectF7ForEdit(null, null, (KDBizPromptBox)this.prmtProject);
        UIHelper.registerTrackNumberF7ForEdit(null, null, (KDBizPromptBox)this.prmtProject, (KDBizPromptBox)this.prmtTrack, (boolean)false);
        MfgBomUtil.initPrmtMainTenanceFilters((KDBizPromptBox)this.prmtMainTenanceLevel);
        this.kdtEntrys.getSelectManager().setSelectMode(10);
        this.prmtChildMaNum.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object oldValue;
                if (e == null) {
                    return;
                }
                Object newValue = e.getNewValue();
                Boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)newValue, (Object)(oldValue = e.getOldValue()));
                if (!isDifferent.booleanValue()) {
                    return;
                }
                try {
                    MfgBomBackSearchUI.this.childMaDataChange();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    MfgBomBackSearchUI.this.handUIException(e1);
                }
            }
        });
        this.prmtProject.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object oldValue;
                if (e == null) {
                    return;
                }
                Object newValue = e.getNewValue();
                Boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)newValue, (Object)(oldValue = e.getOldValue()));
                if (!isDifferent.booleanValue()) {
                    return;
                }
                MfgBomBackSearchUI.this.projectChange();
            }
        });
        this.prmtMainTenanceLevel.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object oldValue;
                if (e == null) {
                    return;
                }
                Object newValue = e.getNewValue();
                Boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)newValue, (Object)(oldValue = e.getOldValue()));
                if (!isDifferent.booleanValue()) {
                    return;
                }
                MfgBomBackSearchUI.this.kdtEntrys.removeRows();
            }
        });
    }

    private void projectChange() {
        this.prmtTrack.setValue(null);
        this.kdtEntrys.removeRows();
    }

    private void childMaDataChange() throws EASBizException, BOSException {
        this.txtChildMaName.setText(null);
        this.txtChildModel.setText(null);
        this.txtUnit.setText(null);
        this.prmtProject.setValue(null);
        this.txtCountRation.setText(null);
        this.kdtEntrys.removeRows();
        if (this.prmtChildMaNum.getValue() != null) {
            MaterialInfo material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(((MaterialInfo)this.prmtChildMaNum.getValue()).getId()));
            MeasureUnitInfo unit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(material.getBaseUnit().getId()));
            this.prmtChildMaNum.setValue((Object)material);
            this.txtChildMaName.setText(material.getName());
            this.txtChildModel.setText(material.getModel());
            this.txtUnit.setText(unit.getName());
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        Component[] cps;
        LongTimeDialog dialog = new LongTimeDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public void afterExec(Object result) throws Exception {
                MfgBomBackSearchUI.this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"ZZBOMFCHWB_END"));
            }

            public Object exec() {
                try {
                    MfgBomBackSearchUI.this.bomBackSearch();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    MfgBomBackSearchUI.this.handleException(e1);
                    SysUtil.abort();
                }
                return "";
            }
        });
        for (Component cp : cps = dialog.getContentPane().getComponents()) {
            if (!(cp instanceof JLabel)) continue;
            ((JLabel)cp).setText("\u6570\u636e\u53cd\u67e5\u4e2d\uff0c\u8bf7\u7a0d\u5019...");
        }
        dialog.show();
    }

    protected void bomBackSearch() throws Exception {
        this.kdtEntrys.removeRows();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (this.prmtChildMaNum.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"WSHZXWLBM_NOT_WRITE"));
            return;
        }
        MaterialInfo material = (MaterialInfo)this.prmtChildMaNum.getValue();
        paramMap.put("childMaterialInfo", material);
        if (this.prmtProject.getValue() != null) {
            paramMap.put("projectInfo", (ProjectInfo)this.prmtProject.getValue());
        }
        if (this.prmtTrack.getValue() != null) {
            paramMap.put("trackNumberInfo", (TrackNumberInfo)this.prmtTrack.getValue());
        }
        if (this.prmtMaterial.getValue() != null) {
            paramMap.put("materialInfo", (MaterialInfo)this.prmtMaterial.getValue());
        }
        if (this.prmtMainTenanceLevel.getValue() != null) {
            paramMap.put("mainTenanceLevelInfo", (MainTenanceLevelInfo)this.prmtMainTenanceLevel.getValue());
        }
        boolean bomBaseStatusIsAudit = false;
        if (this.cbxBaseStatusAudit.isSelected()) {
            bomBaseStatusIsAudit = true;
        }
        paramMap.put("bomBaseStatusIsAudit", bomBaseStatusIsAudit);
        Map result = MfgBomFacadeFactory.getRemoteInstance().mfgBomBackExpand(paramMap);
        if (result.get("returnRowSet") != null) {
            IRowSet rs = (IRowSet)result.get("returnRowSet");
            BigDecimal ration = BigDecimal.ZERO;
            if (result.get("sumQty") != null) {
                ration = new BigDecimal(result.get("sumQty").toString());
            }
            while (rs.next()) {
                IRow row = this.kdtEntrys.addRow();
                row.getCell("level").setValue((Object)rs.getString("FLevel"));
                row.getCell("materialNum").setValue((Object)rs.getString("FmaterialNumber"));
                row.getCell("materialName").setValue((Object)rs.getString("FMaterialName"));
                row.getCell("model").setValue((Object)rs.getString("Fmodel"));
                row.getCell("unit").setValue((Object)rs.getString("Funitname"));
                row.getCell("qty").setValue((Object)rs.getString("Fqty"));
                row.getCell("storageOrgUnit").setValue((Object)rs.getString("FstorageorgUnitName"));
                row.getCell("projectNum").setValue((Object)rs.getString("FProjectNumber"));
                row.getCell("projectName").setValue((Object)rs.getString("FProjectName"));
                row.getCell("trackNum").setValue((Object)rs.getString("FBeginTrackNumber"));
                row.getCell("trackName").setValue((Object)rs.getString("FBeginTrackName"));
                row.getCell("designMode").setValue((Object)rs.getString("fdesignModeName"));
                row.getCell("mainTenanceLevelName").setValue((Object)rs.getString("FMainTenanceLevelName"));
            }
            this.txtCountRation.setText(ration.toString());
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDTable getTableForCommon() {
        return this.kdtEntrys;
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(msgResource);
        this.showMessage();
    }

    @Override
    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPreview_actionPerformed(e);
        this.preparePrintPage(this.kdtEntrys);
        this.kdtEntrys.getPrintManager().printPreview();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.kdtEntrys);
        this.kdtEntrys.getPrintManager().print();
    }
}

