/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.basedata.SupplyRelationshipDefinitionEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.basedata.SupplyRelationshipDefinitionEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.SupplyRelationshipDefinitionInfo;
import com.kingdee.eas.mm.mo.CalculateResultScopeVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class InventoryMaterialSingleton {
    private static InventoryMaterialSingleton instance;
    private Context ctx;
    private static HashMap<String, BigDecimal> mapInventory;
    private static HashMap<String, String> mapSolatedRule;
    static final String querySolatedruleSqlAll = " select case when k.fisprojectnumber||k.fistrackingnumber = '00' then 'NONE'  when k.fisprojectnumber||k.fistrackingnumber = '10' then 'ITEM'  when k.fisprojectnumber||k.fistrackingnumber = '11' then 'ITEM_TRACKNO'  else 'NONE' end fisolatedrule,k.forgunit forgunit,k.fmaterialid fmaterialid   from t_Bd_Materialinventory k ";
    static final String queryInventroyAll = " select a.fmaterialid, a.fstorageOrgunitid, a.fcurstoreqty,  a.fprojectid, a.ftracknumberid, a.fwarehouseid, a.flocationid  from T_IM_Inventory a  left join T_DB_WAREHOUSE b on a.fwarehouseid = b.fid  left join T_IM_STORESTATE e on a.fstorestatusid = e.fid  where e.fnumber in ('1','201','202','203') ";
    static final String queryInventroyAllNew = "select a.fmaterialid,  a.fstorageOrgunitid,  a.fcurstoreqty,  a.fprojectid,  a.ftracknumberid,  a.fwarehouseid,  (case when a.flocationid = 'EgkAAABc3XMgX/hq' then null else a.flocationid end ) flocationid ,  d.fisolatedrule  from T_IM_Inventory a  left join T_DB_WAREHOUSE b   on a.fwarehouseid = b.fid  left join T_IM_STORESTATE e   on a.fstorestatusid = e.fid  inner join (  select case   when k.fisprojectnumber || k.fistrackingnumber = '00' then  'NONE'  when k.fisprojectnumber || k.fistrackingnumber = '10' then  'ITEM'  when k.fisprojectnumber || k.fistrackingnumber = '11' then  'ITEM_TRACKNO'  else  'NONE'  end fisolatedrule,  k.forgunit forgunit,  k.fmaterialid fmaterialid  from t_Bd_Materialinventory k) d on d.forgunit = a.fstorageOrgunitid and d.fmaterialid = a.fmaterialid  where e.fnumber in ('1', '201', '202', '203') ";
    static final String SOLATEDRULE_NONE = "NONE";
    static final String SOLATEDRULE_ITEM = "ITEM";
    static final String SOLATEDRULE_ITEMTRACK = "ITEM_TRACKNO";
    static final String SOLATEDRULE = "FISOLATEDRULE";
    static final String FORGUNIT = "FORGUNIT";
    static final String FMATERIALID = "fmaterialid";
    static final String FSTORAGEORGUNITID = "fstorageOrgunitid";
    static final String FPROJECTID = "fprojectid";
    static final String FTRACKNUMBERID = "ftracknumberid";
    static final String FWAREHOUSEID = "fwarehouseid";
    static final String FLOCATIONID = "flocationid";
    static final String FCURSTOREQTY = "fcurstoreqty";

    private InventoryMaterialSingleton(Context _ctx) throws BOSException, EASBizException {
        this.ctx = _ctx;
        this.initSolatedRule();
        this.initInventoryMaterialSingleton();
    }

    private void initSolatedRule() throws BOSException, EASBizException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)querySolatedruleSqlAll);
            while (rs.next()) {
                String solatedrule = rs.getString(SOLATEDRULE);
                String forgunit = rs.getString(FORGUNIT);
                String materialid = rs.getString(FMATERIALID);
                String solatedrulehash = forgunit.hashCode() + "" + materialid.hashCode();
                mapSolatedRule.put(solatedrulehash, solatedrule);
            }
        }
        catch (Exception ex) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.mm.mo.EMMEMMoResource", (String)"0EMMMO-0112", (Locale)this.ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.mo.EMMEMMoResource", (String)"0EMMMO-0114", (Locale)this.ctx.getLocale())));
        }
    }

    private void initInventoryMaterialSingleton() throws BOSException, EASBizException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)queryInventroyAllNew);
            while (rs.next()) {
                String smpthashcode;
                BigDecimal qty;
                String solatedrule = rs.getString(SOLATEDRULE);
                String materialid = rs.getString(FMATERIALID);
                String storageorgunitid = rs.getString(FSTORAGEORGUNITID);
                String projectid = rs.getString(FPROJECTID);
                String tracknumberid = rs.getString(FTRACKNUMBERID);
                String warehouseid = rs.getString(FWAREHOUSEID);
                String locationid = rs.getString(FLOCATIONID);
                BigDecimal bigDecimal = qty = rs.getBigDecimal(FCURSTOREQTY) == null ? BigDecimal.ZERO : rs.getBigDecimal(FCURSTOREQTY);
                if (SOLATEDRULE_NONE.equals(solatedrule)) {
                    if (projectid == null && tracknumberid == null && warehouseid != null && locationid != null) {
                        String smwlhashcode = storageorgunitid.hashCode() + "" + materialid.hashCode() + "" + warehouseid.hashCode() + "" + locationid.hashCode();
                        if (mapInventory.get(smwlhashcode) != null) {
                            mapInventory.get(smwlhashcode).add(qty);
                        } else {
                            mapInventory.put(smwlhashcode, qty);
                        }
                    }
                    if (projectid == null && tracknumberid == null && warehouseid != null) {
                        String smwhashcode = storageorgunitid.hashCode() + "" + materialid.hashCode() + "" + warehouseid.hashCode();
                        if (mapInventory.get(smwhashcode) != null) {
                            mapInventory.get(smwhashcode).add(qty);
                        } else {
                            mapInventory.put(smwhashcode, qty);
                        }
                    }
                    if (projectid != null || tracknumberid != null) continue;
                    String smhashcode = storageorgunitid.hashCode() + "" + materialid.hashCode();
                    if (mapInventory.get(smhashcode) != null) {
                        mapInventory.get(smhashcode).add(qty);
                        continue;
                    }
                    mapInventory.put(smhashcode, qty);
                    continue;
                }
                if (SOLATEDRULE_ITEM.equals(solatedrule)) {
                    String smphashcode;
                    if (warehouseid != null && locationid != null) {
                        String smpwlhashcode = storageorgunitid.hashCode() + "" + materialid.hashCode() + "" + projectid.hashCode() + "" + warehouseid.hashCode() + "" + locationid.hashCode();
                        if (mapInventory.get(smpwlhashcode) != null) {
                            mapInventory.get(smpwlhashcode).add(qty);
                        } else {
                            mapInventory.put(smpwlhashcode, qty);
                        }
                    }
                    if (warehouseid != null) {
                        String smpwhashcode = storageorgunitid.hashCode() + "" + materialid.hashCode() + "" + projectid.hashCode() + "" + warehouseid.hashCode();
                        if (mapInventory.get(smpwhashcode) != null) {
                            mapInventory.get(smpwhashcode).add(qty);
                        } else {
                            mapInventory.put(smpwhashcode, qty);
                        }
                    }
                    if (mapInventory.get(smphashcode = storageorgunitid.hashCode() + "" + materialid.hashCode() + "" + projectid.hashCode()) != null) {
                        mapInventory.get(smphashcode).add(qty);
                        continue;
                    }
                    mapInventory.put(smphashcode, qty);
                    continue;
                }
                if (!SOLATEDRULE_ITEMTRACK.equals(solatedrule)) continue;
                if (warehouseid != null && locationid != null) {
                    String smptwlhashcode = storageorgunitid.hashCode() + "" + materialid.hashCode() + "" + projectid.hashCode() + "" + tracknumberid.hashCode() + "" + warehouseid.hashCode() + "" + locationid.hashCode();
                    if (mapInventory.get(smptwlhashcode) != null) {
                        mapInventory.get(smptwlhashcode).add(qty);
                    } else {
                        mapInventory.put(smptwlhashcode, qty);
                    }
                }
                if (warehouseid != null) {
                    String smptwhashcode = storageorgunitid.hashCode() + "" + materialid.hashCode() + "" + projectid.hashCode() + "" + tracknumberid.hashCode() + "" + warehouseid.hashCode();
                    if (mapInventory.get(smptwhashcode) != null) {
                        mapInventory.get(smptwhashcode).add(qty);
                    } else {
                        mapInventory.put(smptwhashcode, qty);
                    }
                }
                if (mapInventory.get(smpthashcode = storageorgunitid.hashCode() + "" + materialid.hashCode() + "" + projectid.hashCode() + "" + tracknumberid.hashCode()) != null) {
                    mapInventory.get(smpthashcode).add(qty);
                    continue;
                }
                mapInventory.put(smpthashcode, qty);
            }
        }
        catch (Exception ex) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.mm.mo.EMMEMMoResource", (String)"0EMMMO-0112", (Locale)this.ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.mo.EMMEMMoResource", (String)"0EMMMO-0114", (Locale)this.ctx.getLocale())));
        }
    }

    public static synchronized InventoryMaterialSingleton getInstance(Context ctx) throws BOSException, EASBizException {
        if (instance == null) {
            instance = new InventoryMaterialSingleton(ctx);
        }
        return instance;
    }

    public String getSolatedRule(String materialid, String orgid) throws BOSException, EASBizException {
        String solatedrule = SOLATEDRULE_NONE;
        String solatedrulehash = orgid.hashCode() + "" + materialid.hashCode();
        if (mapSolatedRule.get(solatedrulehash) != null) {
            solatedrule = mapSolatedRule.get(solatedrulehash);
        }
        return solatedrule;
    }

    public void getInventoryQty(CalculateResultScopeVO vo) throws BOSException, EASBizException {
        SupplyRelationshipDefinitionInfo supplyrd = vo.getSupplymethod();
        ArrayList<SupplyRelationshipDefinitionEntryInfo> entrys = new ArrayList<SupplyRelationshipDefinitionEntryInfo>();
        if (supplyrd != null) {
            SupplyRelationshipDefinitionEntryCollection supplyrdcolls = supplyrd.getEntry();
            for (int n = 0; n < supplyrdcolls.size(); ++n) {
                SupplyRelationshipDefinitionEntryInfo entryinfo = supplyrdcolls.get(n);
                StorageOrgUnitInfo proorg = entryinfo.getProductOrgUnit();
                if (!vo.getWorkstorageorgid().equals(proorg.getId().toString())) continue;
                entrys.add(entryinfo);
            }
        } else {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.mo.EMMEMMoResource", (String)"0EMMMO-0115", (Locale)this.ctx.getLocale())));
        }
        vo.setSolatedrule(this.getSolatedRule(vo.getMaterialid(), vo.getSupplystorageorgid()));
        BigDecimal inventoryqty = BigDecimal.ZERO;
        ArrayList<String> hashcolls = new ArrayList<String>();
        for (int n = 0; n < entrys.size(); ++n) {
            String tracknumcode;
            SupplyRelationshipDefinitionEntryInfo entryinfo = (SupplyRelationshipDefinitionEntryInfo)entrys.get(n);
            String solatedrule = this.getSolatedRule(vo.getMaterialid(), entryinfo.getSupplyOrgUnit().getId().toString());
            String inventoryhash = "";
            String warehouseidhashcode = entryinfo.getWareHouse() == null ? "" : entryinfo.getWareHouse().getId().toString().hashCode() + "";
            String locationidhashcode = entryinfo.getLocation() == null ? "" : entryinfo.getLocation().getId().toString().hashCode() + "";
            String projectcode = vo.getProjectid() == null ? "" : vo.getProjectid().hashCode() + "";
            String string = tracknumcode = vo.getTracknumberid() == null ? "" : vo.getTracknumberid().hashCode() + "";
            inventoryhash = SOLATEDRULE_NONE.equals(solatedrule) ? entryinfo.getSupplyOrgUnit().getId().toString().hashCode() + "" + vo.getMaterialid().hashCode() + "" + warehouseidhashcode + locationidhashcode : (SOLATEDRULE_ITEM.equals(solatedrule) ? entryinfo.getSupplyOrgUnit().getId().toString().hashCode() + "" + vo.getMaterialid().hashCode() + "" + projectcode + warehouseidhashcode + locationidhashcode : entryinfo.getSupplyOrgUnit().getId().toString().hashCode() + "" + vo.getMaterialid().hashCode() + "" + projectcode + "" + tracknumcode + "" + warehouseidhashcode + locationidhashcode);
            inventoryqty = inventoryqty.add(mapInventory.get(inventoryhash) == null ? BigDecimal.ZERO : mapInventory.get(inventoryhash));
            hashcolls.add(inventoryhash);
        }
        BigDecimal actualqty = BigDecimal.ZERO;
        BigDecimal occupyInventory = BigDecimal.ZERO;
        if (inventoryqty.doubleValue() >= vo.getQty().doubleValue()) {
            occupyInventory = vo.getQty();
            this.backWriteHashCache(hashcolls, inventoryqty.subtract(vo.getQty()));
            actualqty = BigDecimal.ZERO;
        } else {
            this.backWriteHashCache(hashcolls, BigDecimal.ZERO);
            occupyInventory = inventoryqty;
            actualqty = vo.getQty().subtract(inventoryqty);
        }
        vo.setOccupyInventory(occupyInventory);
        vo.setActInvqty(actualqty);
        vo.setInventoryqty(inventoryqty);
        vo.setActqty(actualqty);
    }

    private void backWriteHashCache(List<String> hashcolls, BigDecimal qty) {
        for (int n = 0; n < hashcolls.size(); ++n) {
            if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal inventoryQty = mapInventory.get(hashcolls.get(n));
            if (qty.compareTo(inventoryQty) >= 0) {
                qty = qty.subtract(inventoryQty);
                mapInventory.put(hashcolls.get(n), BigDecimal.ZERO);
                continue;
            }
            qty = BigDecimal.ZERO;
            mapInventory.put(hashcolls.get(n), inventoryQty.subtract(qty));
        }
    }

    public void clear() {
        instance = null;
        mapInventory.clear();
        mapSolatedRule.clear();
    }

    static {
        mapInventory = new HashMap();
        mapSolatedRule = new HashMap();
    }
}

