/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.schedule.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IBomEntry;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class BOMTreeUtil {
    private String RESURL = "com.kingdee.eas.mm.report.EMMEMReportResource";
    private int DEFAULT_INITIAL_LEVEL = 100;
    private int DEFAULT_EXPAND_LEVEL = 3;
    private final Context ctx;
    private final KDTree tree;
    private IBomEntry ib = null;
    public final Set error = new HashSet();
    private String projectId = null;
    private String storageOrgId = null;

    public BOMTreeUtil(Context ctx, KDTree tree) throws BOSException {
        if (ctx == null || tree == null) {
            throw new BOSException("not Context or KDTree");
        }
        this.ctx = ctx;
        this.tree = tree;
    }

    public BOMTreeUtil(Context ctx, KDTree tree, int initialLevel, int expandLevel) throws BOSException {
        this(ctx, tree);
        this.DEFAULT_INITIAL_LEVEL = initialLevel;
        this.DEFAULT_EXPAND_LEVEL = expandLevel;
    }

    public BOMTreeUtil newTree(MaterialInfo material, ProjectInfo project, StorageOrgUnitInfo storageOrg) throws BOSException {
        if (project != null) {
            this.projectId = project.getId().toString();
        }
        this.storageOrgId = storageOrg.getId().toString();
        return this.newTree(material);
    }

    public BOMTreeUtil newTree(MaterialInfo material) throws BOSException {
        this.error.clear();
        BomTreeNode root = new BomTreeNode(EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0073"));
        if (material != null) {
            root = this.newNode(material);
            root.setLongNumber();
        }
        this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)((Object)root)));
        this.tree.setShowsRootHandles(true);
        this.ib = BomEntryFactory.getRemoteInstanceWithObjectContext((Context)this.ctx);
        this.recursionSetNodeChild(root, 2);
        return this;
    }

    public void recursionSetNodeChild(BomTreeNode parent, int level) throws BOSException {
        CoreBaseInfo info;
        int i;
        if (level > this.DEFAULT_INITIAL_LEVEL) {
            String strInfo = EASResource.getString((String)this.RESURL, (String)"CCZDMRCJ_INFO", (Object[])new Object[]{this.DEFAULT_INITIAL_LEVEL});
            this.error.add(strInfo);
            return;
        }
        if (level <= this.DEFAULT_EXPAND_LEVEL) {
            this.tree.expandOnLevel(level);
        }
        if (parent == null || parent.getUserObject() == null || !MaterialInfo.class.isInstance(parent.getUserObject())) {
            return;
        }
        MaterialInfo material = (MaterialInfo)parent.getUserObject();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = this.getDefaultFilterForTree(null);
        fi.getFilterItems().add(new FilterItemInfo("parent.material.id", (Object)material.getId().toString()));
        evi.setFilter(fi);
        evi.setSelector(this.getSelectorForTree(null));
        CoreBaseCollection collection = this.ib.getCollection(evi);
        int size = collection.size();
        ArrayList<BomTreeNode> childs = new ArrayList<BomTreeNode>();
        for (i = 0; i < size && BomEntryInfo.class.isInstance(info = collection.get(i)); ++i) {
            BomTreeNode newChild;
            MaterialInfo childMaterial;
            BomEntryInfo entry = (BomEntryInfo)info;
            if (i == 0) {
                BomInfo bom = entry.getParent();
                parent.setText(material.getName() + "(" + bom.getName() + ")&" + bom.getNumber());
            }
            if ((childMaterial = entry.getMaterial()) == null || (newChild = this.newNode(childMaterial)) == null) continue;
            parent.add((MutableTreeNode)((Object)newChild));
            if (newChild.setLongNumber()) {
                childs.add(newChild);
                continue;
            }
            String strInfo = EASResource.getString((String)this.RESURL, (String)"BOMSJDCF_INFO", (Object[])new Object[]{level, material.getName(), material.getNumber()});
            this.error.add(strInfo);
        }
        int s = childs.size();
        for (i = 0; i < s; ++i) {
            this.recursionSetNodeChild((BomTreeNode)((Object)childs.get(i)), level + 1);
        }
    }

    public BomTreeNode newNode(MaterialInfo material) {
        BomTreeNode newChild = new BomTreeNode(material.getName());
        newChild.setUserObject(material);
        if (material != null) {
            newChild.number = material.getNumber();
        }
        return newChild;
    }

    public void showError(Component com) {
        if (this.error.size() > 0) {
            StringBuilder errorDetail = new StringBuilder();
            Iterator it = this.error.iterator();
            while (it.hasNext()) {
                errorDetail.append(it.next()).append("\n");
            }
            String strInfo = EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0074");
            MsgBox.showDetailAndOK((Component)com, (String)strInfo, (String)errorDetail.toString(), (int)0);
        }
    }

    public int getTreeInitialLevel() {
        return this.DEFAULT_INITIAL_LEVEL;
    }

    public int getTreeExpandLevel() {
        return this.DEFAULT_EXPAND_LEVEL;
    }

    public FilterInfo getDefaultFilterForTree(FilterInfo filter) {
        if (filter == null) {
            filter = new FilterInfo();
        }
        if (!StringUtils.isEmpty((String)this.projectId)) {
            filter.getFilterItems().add(new FilterItemInfo("parent.project.id", (Object)this.projectId));
        }
        return filter;
    }

    public SelectorItemCollection getSelectorForTree(SelectorItemCollection selectItem) {
        if (selectItem == null) {
            selectItem = new SelectorItemCollection();
        }
        selectItem.add(new SelectorItemInfo("parent.name"));
        selectItem.add(new SelectorItemInfo("parent.number"));
        selectItem.add(new SelectorItemInfo("parent.material.name"));
        selectItem.add(new SelectorItemInfo("parent.material.number"));
        selectItem.add(new SelectorItemInfo("material.name"));
        selectItem.add(new SelectorItemInfo("material.number"));
        return selectItem;
    }

    public KDTree getTree() {
        return this.tree;
    }

    public static MaterialInfo getNodeUserObject(KDTree tree) {
        Object selectNode = tree.getLastSelectedPathComponent();
        if (selectNode == null || !DefaultKingdeeTreeNode.class.isInstance(selectNode)) {
            return null;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)selectNode;
        Object uo = node.getUserObject();
        if (uo != null && MaterialInfo.class.isInstance(uo)) {
            return (MaterialInfo)uo;
        }
        return null;
    }

    class BomTreeNode
    extends DefaultKingdeeTreeNode {
        public final Set longNumber;
        public String number;

        public BomTreeNode() {
            this.longNumber = new HashSet();
            this.number = null;
        }

        public BomTreeNode(Object userObject) {
            super(userObject);
            this.longNumber = new HashSet();
            this.number = null;
        }

        public boolean setLongNumber() {
            TreeNode parent = this.getParent();
            if (parent != null && BomTreeNode.class.isInstance(parent)) {
                BomTreeNode p = (BomTreeNode)((Object)parent);
                this.longNumber.addAll(p.longNumber);
                this.longNumber.add(p.number);
                if (this.number != null && this.longNumber.contains(this.number)) {
                    return false;
                }
            }
            return true;
        }
    }
}

