/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.schedule.client.util;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.report.schedule.client.util.FlowchartNode;
import org.apache.log4j.Logger;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.DefaultEdge;

public abstract class CellListener
implements GraphModelListener {
    private static final Logger logger = CoreUIObject.getLogger(CellListener.class);

    public void graphChanged(GraphModelEvent e) {
        Object[] insert = e.getChange().getInserted();
        Object[] change = e.getChange().getChanged();
        Object[] remove = e.getChange().getRemoved();
        try {
            if (insert != null) {
                this.insertCell(insert);
            } else if (remove != null) {
                this.removeCell(remove);
            } else if (change != null) {
                this.changeCell(change);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public final void insertCell(Object[] insert) throws Exception {
        if (insert == null) {
            return;
        }
        for (int i = 0; i < insert.length; ++i) {
            Object o = insert[i];
            if (DefaultEdge.class.isInstance(o)) {
                this.insertEdge((DefaultEdge)o);
                continue;
            }
            if (!FlowchartNode.class.isInstance(o)) continue;
            this.insertNode((FlowchartNode)((Object)o));
        }
    }

    public abstract void insertEdge(DefaultEdge var1) throws Exception;

    public abstract void insertNode(FlowchartNode var1) throws Exception;

    public final void changeCell(Object[] change) throws Exception {
        if (change == null) {
            return;
        }
        for (int i = 0; i < change.length; ++i) {
            Object o = change[i];
            if (DefaultEdge.class.isInstance(o)) {
                this.changeEdge((DefaultEdge)o);
                continue;
            }
            if (!FlowchartNode.class.isInstance(o)) continue;
            this.changeNode((FlowchartNode)((Object)o));
        }
    }

    public abstract void changeEdge(DefaultEdge var1) throws Exception;

    public abstract void changeNode(FlowchartNode var1) throws Exception;

    public final void removeCell(Object[] remove) throws Exception {
        if (remove == null) {
            return;
        }
        for (int i = 0; i < remove.length; ++i) {
            Object o = remove[i];
            if (DefaultEdge.class.isInstance(o)) {
                this.removeEdge((DefaultEdge)o);
                continue;
            }
            if (!FlowchartNode.class.isInstance(o)) continue;
            this.removeNode((FlowchartNode)((Object)o));
        }
    }

    public abstract void removeEdge(DefaultEdge var1) throws Exception;

    public abstract void removeNode(FlowchartNode var1) throws Exception;
}

