/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.schedule.client.util;

import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.report.schedule.TemplateSetEntryCollection;
import com.kingdee.eas.mm.report.schedule.TemplateSetEntryInfo;
import com.kingdee.eas.mm.report.schedule.client.util.FlowchartNode;
import com.kingdee.eas.mm.report.schedule.client.util.GraphEd;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JLayeredPane;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;

public class FlowChartPane
extends GraphEd {
    private static final Logger logger = CoreUIObject.getLogger(FlowChartPane.class);
    protected final List<FlowchartNode> allNodes = new ArrayList<FlowchartNode>();
    private static final String RES_CLASS_NAME = "com.kingdee.eas.mm.report.schedule.client.ScheduleResource";

    public void init(KDScrollPane flowChartPane) {
        System.setProperty("sun.java2d.d3d", "false");
        flowChartPane.add((Component)this, (Object)JLayeredPane.FRAME_CONTENT_LAYER);
        this.setSize(flowChartPane.getWidth(), flowChartPane.getHeight());
    }

    public void init(Container container) {
        container.add((Component)this, Float.valueOf(0.5f));
        this.setSize(container.getParent().getSize());
    }

    public void initListener(GraphModelListener listener) {
        this.graph.getModel().addGraphModelListener(listener);
    }

    public List<FlowchartNode> initNode(TemplateSetEntryCollection entry) {
        this.allNodes.clear();
        if (entry == null || entry.size() == 0) {
            return this.allNodes;
        }
        for (int i = 0; i < entry.size(); ++i) {
            FlowchartNode node = this.addNode(entry.get(i));
            this.allNodes.add(node);
        }
        this.initEdge(this.allNodes);
        return this.allNodes;
    }

    private void initEdge(List<FlowchartNode> nodes) {
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            FlowchartNode node = nodes.get(i);
            try {
                List<DefaultEdge> edges = node.initEdge(node.getInfo().getNode(), nodes);
                for (DefaultEdge e : edges) {
                    this.insert((DefaultGraphCell)e);
                }
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"FlowChartPane add edge is error", (Throwable)e);
            }
        }
    }

    public void set(int w, int h) {
        this.setSize(w, h);
    }

    public FlowchartNode addNode(TemplateSetEntryInfo info) {
        FlowchartNode node = FlowchartNode.createNode(info);
        this.insert(node);
        return node;
    }

    @Override
    public Map createCellAttributes(Point2D point) {
        Hashtable map = new Hashtable();
        point = this.graph != null ? this.graph.snap((Point2D)point.clone()) : (Point2D)point.clone();
        GraphConstants.setBounds(map, (Rectangle2D)new Rectangle2D.Double(point.getX(), point.getY(), 0.0, 0.0));
        GraphConstants.setResize(map, (boolean)true);
        GraphConstants.setGradientColor(map, (Color)Color.yellow);
        GraphConstants.setBorderColor(map, (Color)Color.black);
        GraphConstants.setBackground(map, (Color)Color.white);
        GraphConstants.setOpaque(map, (boolean)true);
        return map;
    }

    @Override
    protected DefaultGraphCell createDefaultGraphCell() {
        FlowchartNode cell = new FlowchartNode("Cell " + new Integer(this.cellCount++));
        cell.addPort();
        return cell;
    }

    @Override
    protected DefaultEdge createDefaultEdge() {
        DefaultEdge edge = new DefaultEdge();
        return edge;
    }

    @Override
    public Map createEdgeAttributes() {
        Hashtable map = new Hashtable();
        GraphConstants.setLineEnd(map, (int)4);
        GraphConstants.setLabelAlongEdge(map, (boolean)true);
        return map;
    }

    public void actionPerformed_add(ActionEvent e) {
        DefaultGraphCell vertex = this.createDefaultGraphCell();
        vertex.getAttributes().applyMap(this.createCellAttributes(new Point(10, 10)));
        this.graph.getGraphLayoutCache().insert((Object)vertex);
    }

    public void actionPerformed_remove(ActionEvent e) {
        if (!this.graph.isSelectionEmpty()) {
            Object[] cells = this.graph.getSelectionCells();
            cells = this.graph.getDescendants(cells);
            this.graph.getModel().remove(cells);
        }
    }

    @Override
    public JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.remove = new AbstractAction(FlowChartPane.getResourceInfo("delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowChartPane.this.actionPerformed_remove(e);
            }
        };
        this.remove.setEnabled(false);
        toolbar.add(this.remove);
        toolbar.addSeparator();
        this.zoom = new AbstractAction(FlowChartPane.getResourceInfo("zoom")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowChartPane.this.graph.setScale(1.0);
            }
        };
        toolbar.add(this.zoom);
        this.zoomIn = new AbstractAction(FlowChartPane.getResourceInfo("zoom_in")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowChartPane.this.graph.setScale(1.1 * FlowChartPane.this.graph.getScale());
            }
        };
        toolbar.add(this.zoomIn);
        this.zoomOut = new AbstractAction(FlowChartPane.getResourceInfo("zoom_out")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowChartPane.this.graph.setScale(FlowChartPane.this.graph.getScale() / 1.1);
            }
        };
        toolbar.add(this.zoomOut);
        return toolbar;
    }

    public void setOperate(boolean operate) {
        this.graph.setEnabled(operate);
        this.graph.setPortsVisible(false);
    }

    private static String getResourceInfo(String resourceName) {
        return EASResource.getString((String)RES_CLASS_NAME, (String)resourceName);
    }
}

