/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.schedule.client.util;

import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.report.schedule.TemplateSetEntryInfo;
import com.kingdee.eas.mm.report.schedule.client.util.GPCellViewFactory;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.apache.log4j.Logger;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;

public class FlowchartNode
extends DefaultGraphCell {
    private static final long serialVersionUID = 8159834608192387451L;
    private static final Logger logger = CoreUIObject.getLogger(FlowchartNode.class);
    public Object initObject = "";
    private List<DefaultEdge> edges = new ArrayList<DefaultEdge>();
    private TemplateSetEntryInfo info;

    public FlowchartNode() {
    }

    public FlowchartNode(String text) {
        super((Object)text);
        this.initObject = text;
    }

    public void setText(List<String> textLine) {
        if (textLine == null) {
            return;
        }
        if (textLine.size() == 0) {
            this.setUserObject("");
            return;
        }
        if (textLine.size() == 1) {
            this.setUserObject(textLine.get(0));
            return;
        }
        StringBuffer text = new StringBuffer();
        for (String rn : textLine) {
            text.append("").append(rn).append("<br>");
        }
        text.append("</font></html>");
        text.insert(0, "<html><font color=\"#337733\"  size=-1>");
        this.setUserObject(text);
    }

    public static FlowchartNode createNode(TemplateSetEntryInfo info) {
        if (info == null) {
            return null;
        }
        String text = info.getNode();
        if (info.getMaterial() != null && info.getOperation() != null) {
            text = info.getMaterial().getName() + " : " + info.getOperationNo() + "/" + info.getOperation().getName();
        }
        FlowchartNode cell = (FlowchartNode)FlowchartNode.createVertex(10.0, 10.0, text.length() * 12, 30.0, Color.green, true, new FlowchartNode(text), null);
        cell.setInfo(info);
        if (!StringUtils.isEmpty((String)info.getNode())) {
            cell.initJSON(info.getNode());
        }
        return cell;
    }

    public void addDefaultEdge(DefaultEdge edge) {
        if (edge == null || this.edges.contains(edge)) {
            return;
        }
        this.edges.add(edge);
    }

    public boolean removeDefaultEdge(DefaultEdge edge) {
        if (edge == null || !this.edges.contains(edge)) {
            return false;
        }
        return this.edges.remove(edge);
    }

    public TemplateSetEntryInfo getInfo() {
        return this.info;
    }

    public void setInfo(TemplateSetEntryInfo info) {
        this.info = info;
    }

    public String getJSON() throws JSONException {
        Rectangle2D r = null;
        JSONObject json = new JSONObject();
        json.put("unique", (Object)this.getUniqueIdentification());
        JSONObject bounds = new JSONObject();
        r = GraphConstants.getBounds((Map)this.getAttributes());
        bounds.put("width", r.getWidth());
        bounds.put("height", r.getHeight());
        bounds.put("x", r.getX());
        bounds.put("y", r.getY());
        json.put("rectangle2D", (Object)bounds);
        JSONArray edgeArray = new JSONArray();
        JSONObject edge = null;
        int index = 0;
        for (int i = 0; i < this.edges.size(); ++i) {
            DefaultEdge e = this.edges.get(i);
            edge = new JSONObject();
            Object target = e.getTarget();
            if (DefaultPort.class.isInstance(target)) {
                target = ((DefaultPort)target).getParent();
            }
            if (!FlowchartNode.class.isInstance(target)) continue;
            FlowchartNode node = (FlowchartNode)((Object)target);
            edge.put("target", (Object)node.getUniqueIdentification());
            edgeArray.put(index, (Object)edge);
            ++index;
        }
        json.put("edges", (Object)edgeArray);
        return json.toString();
    }

    public void initJSON(String info) {
        Rectangle2D r = null;
        try {
            JSONObject json = new JSONObject(info);
            JSONObject bounds = json.getJSONObject("rectangle2D");
            r = GraphConstants.getBounds((Map)this.getAttributes());
            r.setFrame(bounds.getDouble("x"), bounds.getDouble("y"), bounds.getDouble("width"), bounds.getDouble("height"));
        }
        catch (Exception e) {
            logger.error((Object)"init FlowchartNode's json is error", (Throwable)e);
        }
    }

    public List<DefaultEdge> initEdge(String info, List<FlowchartNode> nodes) {
        ArrayList<DefaultEdge> edges = new ArrayList<DefaultEdge>();
        try {
            if (StringUtil.isEmpty((String)info)) {
                return edges;
            }
            JSONObject json = new JSONObject(info);
            JSONArray edgeArray = json.getJSONArray("edges");
            FlowchartNode source = this;
            FlowchartNode target = null;
            JSONObject edge = null;
            for (int i = 0; i < edgeArray.length(); ++i) {
                try {
                    edge = edgeArray.getJSONObject(i);
                    target = null;
                    for (FlowchartNode node : nodes) {
                        if (!node.getUniqueIdentification().equals(edge.get("target"))) continue;
                        target = node;
                        break;
                    }
                    if (target == null) continue;
                    DefaultEdge e = FlowchartNode.newEdge(source, target);
                    edges.add(e);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("init FlowchartNode's edge is error [" + edge + "]"), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("FlowchartNode's initEdge is error [" + info + "]"), (Throwable)e);
        }
        return edges;
    }

    public String getUniqueIdentification() {
        if (this.info.getOperation() != null && this.info.getMaterial() != null) {
            return this.info.getOperationNo() + this.info.getOperation().getId().toString() + this.info.getMaterial().getId().toString();
        }
        return null;
    }

    public static DefaultEdge newEdge(FlowchartNode source, FlowchartNode target) {
        DefaultEdge edge0 = new DefaultEdge();
        edge0.setSource((Object)source.getChildAt(0));
        edge0.setTarget((Object)target.getChildAt(0));
        GraphConstants.setLineEnd((Map)edge0.getAttributes(), (int)4);
        GraphConstants.setEndFill((Map)edge0.getAttributes(), (boolean)true);
        return edge0;
    }

    private static DefaultGraphCell createVertex(double x, double y, double w, double h, Color bg, boolean raised, DefaultGraphCell cell, String viewClass) {
        if (viewClass != null) {
            GPCellViewFactory.setViewClass((Map)cell.getAttributes(), viewClass);
        }
        GraphConstants.setBounds((Map)cell.getAttributes(), (Rectangle2D)new Rectangle2D.Double(x, y, w, h));
        if (bg != null) {
            GraphConstants.setGradientColor((Map)cell.getAttributes(), (Color)bg);
            GraphConstants.setOpaque((Map)cell.getAttributes(), (boolean)true);
        }
        if (raised) {
            GraphConstants.setBorder((Map)cell.getAttributes(), (Border)BorderFactory.createRaisedBevelBorder());
        } else {
            GraphConstants.setBorderColor((Map)cell.getAttributes(), (Color)Color.black);
        }
        cell.addPort();
        return cell;
    }
}

