/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.schedule.client.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jgraph.JGraph;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphUndoManager;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortRenderer;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

public class GraphEd
extends JApplet
implements GraphSelectionListener,
KeyListener {
    protected JGraph graph = this.createGraph();
    protected GraphUndoManager undoManager;
    protected Action add;
    protected Action remove;
    protected Action zoom;
    protected Action zoomIn;
    protected Action zoomOut;
    protected int cellCount = 0;

    public static void main(String[] args) {
        System.setProperty("sun.java2d.d3d", "false");
        JFrame frame = new JFrame("GraphEd");
        frame.getContentPane().add(new GraphEd());
        URL jgraphUrl = GraphEd.class.getClassLoader().getResource("org/jgraph/example/resources/jgraph.gif");
        if (jgraphUrl != null) {
            ImageIcon jgraphIcon = new ImageIcon(jgraphUrl);
            frame.setIconImage(jgraphIcon.getImage());
        }
        frame.setSize(520, 390);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public GraphEd() {
        this.graph.setMarqueeHandler(this.createMarqueeHandler());
        this.undoManager = new GraphUndoManager(){

            public void undoableEditHappened(UndoableEditEvent e) {
                super.undoableEditHappened(e);
                GraphEd.this.updateHistoryButtons();
            }
        };
        this.populateContentPane();
        this.installListeners(this.graph);
    }

    @Override
    public void destroy() {
        super.destroy();
        PortView.renderer = new PortRenderer();
        EdgeView.renderer = new EdgeRenderer();
        AbstractCellView.cellEditor = new DefaultGraphCellEditor();
        VertexView.renderer = new VertexRenderer();
    }

    protected void populateContentPane() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createToolBar(), "North");
        this.getContentPane().add((Component)new JScrollPane((Component)this.graph), "Center");
    }

    protected JGraph createGraph() {
        MyGraph graph = new MyGraph((GraphModel)new MyModel());
        graph.getGraphLayoutCache().setFactory((CellViewFactory)new DefaultCellViewFactory(){

            protected EdgeView createEdgeView(Object cell) {
                return new EdgeView(cell){

                    public CellHandle getHandle(GraphContext context) {
                        return new MyEdgeHandle(this, context);
                    }
                };
            }
        });
        return graph;
    }

    protected void installListeners(JGraph graph) {
        graph.getModel().addUndoableEditListener((UndoableEditListener)this.undoManager);
        graph.getSelectionModel().addGraphSelectionListener((GraphSelectionListener)this);
        graph.addKeyListener((KeyListener)this);
    }

    protected void uninstallListeners(JGraph graph) {
        graph.getModel().removeUndoableEditListener((UndoableEditListener)this.undoManager);
        graph.getSelectionModel().removeGraphSelectionListener((GraphSelectionListener)this);
        graph.removeKeyListener((KeyListener)this);
    }

    protected BasicMarqueeHandler createMarqueeHandler() {
        return new MyMarqueeHandler();
    }

    public void insert(Point2D point) {
        DefaultGraphCell vertex = this.createDefaultGraphCell();
        vertex.getAttributes().applyMap(this.createCellAttributes(point));
        this.graph.getGraphLayoutCache().insert((Object)vertex);
    }

    public void insert(DefaultGraphCell cell) {
        this.graph.getGraphLayoutCache().insert((Object)cell);
    }

    public Map createCellAttributes(Point2D point) {
        Hashtable map = new Hashtable();
        point = this.graph != null ? this.graph.snap((Point2D)point.clone()) : (Point2D)point.clone();
        GraphConstants.setBounds(map, (Rectangle2D)new Rectangle2D.Double(point.getX(), point.getY(), 0.0, 0.0));
        GraphConstants.setResize(map, (boolean)true);
        GraphConstants.setGradientColor(map, (Color)Color.yellow);
        GraphConstants.setBorderColor(map, (Color)Color.black);
        GraphConstants.setBackground(map, (Color)Color.white);
        GraphConstants.setOpaque(map, (boolean)true);
        return map;
    }

    protected DefaultGraphCell createDefaultGraphCell() {
        DefaultGraphCell cell = new DefaultGraphCell((Object)("Cell " + new Integer(this.cellCount++)));
        cell.addPort();
        return cell;
    }

    public void connect(Port source, Port target) {
        DefaultEdge edge = this.createDefaultEdge();
        if (this.graph.getModel().acceptsSource((Object)edge, (Object)source) && this.graph.getModel().acceptsTarget((Object)edge, (Object)target)) {
            edge.getAttributes().applyMap(this.createEdgeAttributes());
            this.graph.getGraphLayoutCache().insertEdge((Object)edge, (Object)source, (Object)target);
        }
    }

    protected DefaultEdge createDefaultEdge() {
        DefaultEdge edge = new DefaultEdge();
        return edge;
    }

    public Map createEdgeAttributes() {
        Hashtable map = new Hashtable();
        GraphConstants.setLineEnd(map, (int)4);
        GraphConstants.setLabelAlongEdge(map, (boolean)true);
        return map;
    }

    public void group(Object[] cells) {
        if ((cells = this.graph.order(cells)) != null && cells.length > 0) {
            DefaultGraphCell group = this.createGroupCell();
            this.graph.getGraphLayoutCache().insertGroup((Object)group, cells);
        }
    }

    protected DefaultGraphCell createGroupCell() {
        return new DefaultGraphCell();
    }

    protected int getCellCount(JGraph graph) {
        Object[] cells = graph.getDescendants(graph.getRoots());
        return cells.length;
    }

    public void ungroup(Object[] cells) {
        this.graph.getGraphLayoutCache().ungroup(cells);
    }

    public boolean isGroup(Object cell) {
        CellView view = this.graph.getGraphLayoutCache().getMapping(cell, false);
        if (view != null) {
            return !view.isLeaf();
        }
        return false;
    }

    public void toFront(Object[] c) {
        this.graph.getGraphLayoutCache().toFront(c);
    }

    public void toBack(Object[] c) {
        this.graph.getGraphLayoutCache().toBack(c);
    }

    public void undo() {
        try {
            this.undoManager.undo((Object)this.graph.getGraphLayoutCache());
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            this.updateHistoryButtons();
        }
    }

    public void redo() {
        try {
            this.undoManager.redo((Object)this.graph.getGraphLayoutCache());
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            this.updateHistoryButtons();
        }
    }

    protected void updateHistoryButtons() {
    }

    public void valueChanged(GraphSelectionEvent e) {
        boolean enabled;
        boolean bl = enabled = !this.graph.isSelectionEmpty();
        if (this.remove != null) {
            this.remove.setEnabled(enabled);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.remove.actionPerformed(null);
        }
    }

    public JPopupMenu createPopupMenu(final Point pt, final Object cell) {
        JPopupMenu menu = new JPopupMenu();
        if (cell != null) {
            menu.add(new AbstractAction("Edit"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphEd.this.graph.startEditingAtCell(cell);
                }
            });
        }
        if (!this.graph.isSelectionEmpty()) {
            menu.addSeparator();
            menu.add(new AbstractAction("Remove"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphEd.this.remove.actionPerformed(e);
                }
            });
        }
        menu.addSeparator();
        menu.add(new AbstractAction("Insert"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GraphEd.this.insert(pt);
            }
        });
        return menu;
    }

    public JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        return toolbar;
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public void setGraph(JGraph graph) {
        this.graph = graph;
    }

    protected String getVersion() {
        return "JGraph (v5.13.0.0)";
    }

    public Action getRemove() {
        return this.remove;
    }

    public void setRemove(Action remove) {
        this.remove = remove;
    }

    public class EventRedirector
    extends AbstractAction {
        protected Action action;

        public EventRedirector(Action a, ImageIcon icon) {
            super("", icon);
            this.action = a;
        }

        public EventRedirector(Action a, String text) {
            super(text, null);
            this.action = a;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            e = new ActionEvent(GraphEd.this.graph, e.getID(), e.getActionCommand(), e.getModifiers());
            this.action.actionPerformed(e);
        }
    }

    public class MyMarqueeHandler
    extends BasicMarqueeHandler {
        protected Point2D start;
        protected Point2D current;
        protected PortView port;
        protected PortView firstPort;
        protected JComponent highlight = this.createHighlight();

        protected JComponent createHighlight() {
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createBevelBorder(0));
            panel.setVisible(false);
            panel.setOpaque(false);
            return panel;
        }

        public boolean isForceMarqueeEvent(MouseEvent e) {
            if (e.isShiftDown()) {
                return false;
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                return true;
            }
            this.port = this.getSourcePortAt(e.getPoint());
            if (this.port != null && GraphEd.this.graph.isPortsVisible()) {
                return true;
            }
            return super.isForceMarqueeEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                Object cell = GraphEd.this.graph.getFirstCellForLocation((double)e.getX(), (double)e.getY());
                JPopupMenu menu = GraphEd.this.createPopupMenu(e.getPoint(), cell);
                menu.show((Component)GraphEd.this.graph, e.getX(), e.getY());
            } else if (this.port != null && GraphEd.this.graph.isPortsVisible()) {
                this.start = GraphEd.this.graph.toScreen(this.port.getLocation());
                this.firstPort = this.port;
            } else {
                super.mousePressed(e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.start != null) {
                Graphics g = GraphEd.this.graph.getGraphics();
                PortView newPort = this.getTargetPortAt(e.getPoint());
                if (newPort == null || newPort != this.port) {
                    this.paintConnector(Color.black, GraphEd.this.graph.getBackground(), g);
                    this.port = newPort;
                    this.current = this.port != null ? GraphEd.this.graph.toScreen(this.port.getLocation()) : GraphEd.this.graph.snap((Point2D)e.getPoint());
                    this.paintConnector(GraphEd.this.graph.getBackground(), Color.black, g);
                }
            }
            super.mouseDragged(e);
        }

        public PortView getSourcePortAt(Point2D point) {
            PortView result;
            GraphEd.this.graph.setJumpToDefaultPort(false);
            try {
                result = GraphEd.this.graph.getPortViewAt(point.getX(), point.getY());
            }
            finally {
                GraphEd.this.graph.setJumpToDefaultPort(true);
            }
            return result;
        }

        protected PortView getTargetPortAt(Point2D point) {
            return GraphEd.this.graph.getPortViewAt(point.getX(), point.getY());
        }

        public void mouseReleased(MouseEvent e) {
            this.highlight(GraphEd.this.graph, null);
            if (e != null && this.port != null && this.firstPort != null && this.firstPort != this.port) {
                GraphEd.this.connect((Port)this.firstPort.getCell(), (Port)this.port.getCell());
                e.consume();
            } else {
                GraphEd.this.graph.repaint();
            }
            this.port = null;
            this.firstPort = null;
            this.current = null;
            this.start = null;
            super.mouseReleased(e);
        }

        public void mouseMoved(MouseEvent e) {
            if (e != null && this.getSourcePortAt(e.getPoint()) != null && GraphEd.this.graph.isPortsVisible()) {
                GraphEd.this.graph.setCursor(new Cursor(12));
                e.consume();
            } else {
                super.mouseMoved(e);
            }
        }

        protected void paintConnector(Color fg, Color bg, Graphics g) {
            if (GraphEd.this.graph.isXorEnabled()) {
                g.setColor(fg);
                g.setXORMode(bg);
                this.paintPort(GraphEd.this.graph.getGraphics());
                this.drawConnectorLine(g);
            } else {
                Rectangle dirty = new Rectangle((int)this.start.getX(), (int)this.start.getY(), 1, 1);
                if (this.current != null) {
                    dirty.add(this.current);
                }
                dirty.grow(1, 1);
                GraphEd.this.graph.repaint(dirty);
                this.highlight(GraphEd.this.graph, (CellView)this.port);
            }
        }

        public void paint(JGraph graph, Graphics g) {
            super.paint(graph, g);
            if (!graph.isXorEnabled()) {
                g.setColor(Color.black);
                this.drawConnectorLine(g);
            }
        }

        protected void drawConnectorLine(Graphics g) {
            if (this.firstPort != null && this.start != null && this.current != null) {
                g.drawLine((int)this.start.getX(), (int)this.start.getY(), (int)this.current.getX(), (int)this.current.getY());
            }
        }

        protected void paintPort(Graphics g) {
            if (this.port != null) {
                boolean o = GraphConstants.getOffset((Map)this.port.getAllAttributes()) != null;
                Rectangle2D r = o ? this.port.getBounds() : this.port.getParentView().getBounds();
                r = GraphEd.this.graph.toScreen((Rectangle2D)r.clone());
                r.setFrame(r.getX() - 3.0, r.getY() - 3.0, r.getWidth() + 6.0, r.getHeight() + 6.0);
                GraphEd.this.graph.getUI().paintCell(g, (CellView)this.port, r, true);
            }
        }

        protected void highlight(JGraph graph, CellView cellView) {
            if (cellView != null) {
                this.highlight.setBounds(this.getHighlightBounds(graph, cellView));
                if (this.highlight.getParent() == null) {
                    graph.add((Component)this.highlight);
                    this.highlight.setVisible(true);
                }
            } else if (this.highlight.getParent() != null) {
                this.highlight.setVisible(false);
                this.highlight.getParent().remove(this.highlight);
            }
        }

        protected Rectangle getHighlightBounds(JGraph graph, CellView cellView) {
            boolean offset = GraphConstants.getOffset((Map)cellView.getAllAttributes()) != null;
            Rectangle2D r = offset ? cellView.getBounds() : cellView.getParentView().getBounds();
            r = graph.toScreen((Rectangle2D)r.clone());
            int s = 3;
            return new Rectangle((int)(r.getX() - (double)s), (int)(r.getY() - (double)s), (int)(r.getWidth() + (double)(2 * s)), (int)(r.getHeight() + (double)(2 * s)));
        }
    }

    public static class MyModel
    extends DefaultGraphModel {
        public boolean acceptsSource(Object edge, Object port) {
            return ((Edge)edge).getTarget() != port;
        }

        public boolean acceptsTarget(Object edge, Object port) {
            return ((Edge)edge).getSource() != port;
        }
    }

    public static class MyEdgeHandle
    extends EdgeView.EdgeHandle {
        public MyEdgeHandle(EdgeView edge, GraphContext ctx) {
            super(edge, ctx);
        }

        public boolean isAddPointEvent(MouseEvent event) {
            return event.isShiftDown();
        }

        public boolean isRemovePointEvent(MouseEvent event) {
            return event.isShiftDown();
        }
    }

    public static class MyGraph
    extends JGraph {
        public MyGraph(GraphModel model) {
            this(model, null);
        }

        public MyGraph(GraphModel model, GraphLayoutCache cache) {
            super(model, cache);
            this.setPortsVisible(true);
            this.setGridEnabled(true);
            this.setGridSize(6.0);
            this.setTolerance(2);
            this.setInvokesStopCellEditing(true);
            this.setCloneable(true);
            this.setJumpToDefaultPort(true);
        }
    }
}

