/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.DesignModeFactory;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.DIETemplateCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.DesignBOMBillFactory;
import com.kingdee.eas.zjbom.DesignBOMBillInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class DesignBOMBillDataImport
extends AbstractDataTransmission {
    public String RESURL = "com.kingdee.eas.zjbom.DesignBomImportResource";

    public int getSubmitType() {
        return 1;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return DesignBOMBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<?, ?> exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        return null;
    }

    public DesignModeInfo getDesignModeInfo(Context ctx, String dsid) throws TaskExternalException {
        DesignModeInfo dsInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("project"));
        sic.add(new SelectorItemInfo("trackNumber"));
        try {
            dsInfo = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeInfo((IObjectPK)new ObjectUuidPK(dsid), sic);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return dsInfo;
    }

    public void checkDatas(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        DesignBOMBillInfo info = (DesignBOMBillInfo)coreBaseInfo;
        String errorString = "";
        if (info.getPartNo() == null || "".equals(info.getPartNo())) {
            errorString = ResourceBase.getString((String)this.RESURL, (String)"label0", (Locale)ctx.getLocale());
            throw new TaskExternalException(errorString);
        }
        if (info.getName() == null || "".equals(info.getName())) {
            errorString = ResourceBase.getString((String)this.RESURL, (String)"label2", (Locale)ctx.getLocale(), (Object[])new String[]{info.getPartNo()});
            throw new TaskExternalException(errorString);
        }
        if (info.getParentNo() == null || "".equals(info.getParentNo())) {
            errorString = ResourceBase.getString((String)this.RESURL, (String)"label1", (Locale)ctx.getLocale(), (Object[])new String[]{info.getPartNo()});
            throw new TaskExternalException(errorString);
        }
        if (info.getParentName() == null || "".equals(info.getParentName())) {
            errorString = ResourceBase.getString((String)this.RESURL, (String)"label3", (Locale)ctx.getLocale(), (Object[])new String[]{info.getParentNo()});
            throw new TaskExternalException(errorString);
        }
        if (info.getQuantity() == null || info.getQuantity().compareTo(BigDecimal.ZERO) < 0) {
            errorString = ResourceBase.getString((String)this.RESURL, (String)"label5", (Locale)ctx.getLocale(), (Object[])new String[]{info.getPartNo(), info.getParentNo()});
            throw new TaskExternalException(errorString);
        }
        if (info.getUnit() == null || "".equals(info.getUnit())) {
            errorString = ResourceBase.getString((String)this.RESURL, (String)"label6", (Locale)ctx.getLocale(), (Object[])new String[]{info.getPartNo(), info.getParentNo()});
            throw new TaskExternalException(errorString);
        }
        if (info.getBatch() == null || "".equals(info.getBatch())) {
            info.setBatch("NULL");
        }
        if (info.getParentQty() == null) {
            info.setParentQty(BigDecimal.ONE);
        }
        if (info.getPMUnit() == null || "".equals(info.getPMUnit())) {
            info.setPMUnit("PCS");
        }
        if (info.getWeight() == null) {
            info.setWeight(BigDecimal.ZERO);
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" Select fid,cfstate from ct_zjb_designbombill a");
        sql.append(" where a.cfpartno = '").append(info.getPartNo()).append("' ");
        sql.append(" And a.cfparentno = '").append(info.getParentNo()).append("' ");
        if (info.getMakeFlow() != null && !"".equals(info.getMakeFlow())) {
            sql.append(" And a.cfmakeflow = '").append(info.getMakeFlow()).append("' ");
        }
        if (info.getProjectNo() != null && !"".equals(info.getProjectNo())) {
            sql.append(" And a.cfprojectno = '").append(info.getProjectNo()).append("' ");
        } else {
            sql.append(" And a.cfprojectno is null ");
        }
        if (info.getEndCarNo() != null && !"".equals(info.getEndCarNo())) {
            sql.append(" And a.cfendcarno = '").append(info.getEndCarNo()).append("' ");
        } else {
            sql.append(" And a.cfendcarno is null ");
        }
        if (info.getBeginCarNo() != null && !"".equals(info.getBeginCarNo())) {
            sql.append(" And a.cfbegincarno = '").append(info.getBeginCarNo()).append("' ");
        } else {
            sql.append(" And a.cfbegincarno is null ");
        }
        try {
            boolean isfind = false;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String fid = rs.getString("fid");
                int fstate = rs.getInt("cfstate");
                if (fstate == 4) {
                    errorString = ResourceBase.getString((String)this.RESURL, (String)"label9", (Locale)ctx.getLocale(), (Object[])new String[]{info.getPartNo(), info.getParentNo(), info.getMakeFlow()});
                    throw new TaskExternalException(errorString);
                }
                info.setId(BOSUuid.read((String)fid));
                isfind = true;
            }
            if (!isfind) {
                info.setState(BillBaseStatusEnum.TEMPORARILYSAVED);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new TaskExternalException(ResourceBase.getString((String)this.RESURL, (String)"label8", (Locale)ctx.getLocale()), (Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new TaskExternalException(ResourceBase.getString((String)this.RESURL, (String)"label8", (Locale)ctx.getLocale()), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            for (int i = 0; i < hsData.size(); ++i) {
                Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
                this.verifyEmpty(ctx, lineData);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new TaskExternalException(e.getMessage());
        }
        return super.transmit(hsData, ctx);
    }

    protected String getTemplateNumber() {
        return "DesignBOM";
    }

    private void verifyEmpty(Context ctx, Hashtable hsData) throws BOSException {
        String templateNum = this.getTemplateNumber();
        if (EmptyUtil.isEmpty((String)templateNum)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)templateNum));
        view.setFilter(filter);
        DIETemplateCollection tepleteColl = DIETemplateFactory.getLocalInstance((Context)ctx).getDIETemplateCollection(view);
        if (tepleteColl.size() == 0) {
            return;
        }
        DIETemplateInfo teplateInfo = tepleteColl.get(0);
        DIETemplateFieldEntryCollection entryColl = teplateInfo.getFieldEntries();
        for (DIETemplateFieldEntryInfo entry : entryColl) {
            String fieldNum = entry.getNumber();
            boolean isRequired = entry.isIsNeed();
            Object data = ((DataToken)hsData.get((Object)fieldNum)).data;
            if (!isRequired || !EmptyUtil.isEmpty((Object)data)) continue;
            String fieldName = entry.getName();
            throw new BOSException("\u5b57\u6bb5:" + fieldName + " \u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        CoreBaseCollection bills = new CoreBaseCollection();
        bills.add(coreBaseInfo);
        this.checkDatas(coreBaseInfo, ctx);
        DesignBOMBillInfo info = (DesignBOMBillInfo)coreBaseInfo;
        try {
            if (info.getId() == null) {
                this.getController(ctx).addnew((CoreBaseInfo)info);
                this.getController(ctx).save((CoreBaseInfo)info);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public static boolean hasPermission(String permItemName, ObjectUuidPK orgIdPK) throws EASBizException, BOSException {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        return PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgIdPK, permItemName);
    }
}

