/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.zjbom.BomFlowInitCollection;
import com.kingdee.eas.zjbom.BomFlowInitFactory;
import com.kingdee.eas.zjbom.BomFlowInitInfo;
import com.kingdee.eas.zjbom.client.AbstractBomFlowInitUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BomFlowInitUI
extends AbstractBomFlowInitUI {
    private static final Logger logger = CoreUIObject.getLogger(BomFlowInitUI.class);
    private ChangeListener radioChangeListener = null;

    protected void removeListener() {
        if (this.radioChangeListener != null) {
            this.kDRadioButtonOldBom.removeChangeListener(this.radioChangeListener);
            this.kDRadioButtonNewBom.removeChangeListener(this.radioChangeListener);
        }
    }

    protected void addListener() {
        if (this.radioChangeListener == null) {
            this.radioChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    try {
                        BomFlowInitUI.this.radioStateChanged(e);
                    }
                    catch (Exception e1) {
                        BomFlowInitUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.kDRadioButtonNewBom.addChangeListener(this.radioChangeListener);
        this.kDRadioButtonOldBom.addChangeListener(this.radioChangeListener);
    }

    protected void radioStateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.kDRadioButtonNewBom) || e.getSource().equals(this.kDRadioButtonOldBom)) {
            if (e.getSource().equals(this.kDRadioButtonNewBom) && this.kDRadioButtonNewBom.isSelected()) {
                this.kDRadioButtonOldBom.setSelected(false);
            }
            if (e.getSource().equals(this.kDRadioButtonOldBom) && this.kDRadioButtonOldBom.isSelected()) {
                this.kDRadioButtonNewBom.setSelected(false);
            }
        }
    }

    protected void initDates() throws Exception {
        BomFlowInitCollection coll = BomFlowInitFactory.getRemoteInstance().getCollection();
        this.kDTable1.checkParsed();
        this.kDTable2.checkParsed();
        this.kDTable1.removeRows();
        this.kDTable2.removeRows();
        if (coll != null && coll.size() > 0) {
            BomFlowInitInfo info = null;
            IRow arow = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                if (info.getType() == 1) {
                    arow = this.kDTable1.addRow();
                } else {
                    if (info.getType() != 2) continue;
                    arow = this.kDTable2.addRow();
                }
                arow.getCell("menuname").setValue((Object)info.getMenuName());
            }
            if (coll.get(0).getFlowType() == 1) {
                this.kDRadioButtonOldBom.setSelected(true);
                this.kDRadioButtonNewBom.setSelected(false);
            } else {
                this.kDRadioButtonOldBom.setSelected(false);
                this.kDRadioButtonNewBom.setSelected(true);
            }
        }
    }

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        this.initDates();
        this.addListener();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        int flowType = 0;
        if (this.kDRadioButtonOldBom.isSelected()) {
            flowType = 1;
        } else if (this.kDRadioButtonNewBom.isSelected()) {
            flowType = 2;
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.zjbom.PLMMaterialResource", (String)"label11"));
            SysUtil.abort();
        }
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.zjbom.PLMMaterialResource", (String)"label12")) == 2) {
            SysUtil.abort();
        }
        BomFlowInitFactory.getRemoteInstance().initBomFlowType(flowType);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.zjbom.PLMMaterialResource", (String)"label13"));
    }

    @Override
    protected void btnCancal_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }
}

