/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.zj.SqlExcFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.zjbom.client.AbstractDesigBOMMiddleBillTreeFilterUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class DesigBOMMiddleBillTreeFilterUI
extends AbstractDesigBOMMiddleBillTreeFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DesigBOMMiddleBillTreeFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtProject.setRequired(true);
    }

    public Date changeDate(Date date, int day) {
        Date needDate = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, day);
        needDate = calendar.getTime();
        return needDate;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.prmtProject.getData() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)((ProjectInfo)this.prmtProject.getData()).getId(), CompareType.EQUALS));
        }
        if (this.prmtMaterialFrom.getData() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)((MaterialInfo)this.prmtMaterialFrom.getData()).getNumber(), CompareType.GREATER_EQUALS));
        }
        if (this.prmtMaterialTo.getData() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)((MaterialInfo)this.prmtMaterialTo.getData()).getNumber(), CompareType.LESS_EQUALS));
        }
        return filterInfo;
    }

    public void setFilterInfo(FilterInfo arg0) {
        this.prmtProject.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        try {
            FilterItemCollection currentFilterItemCollection = arg0.getFilterItems();
            for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("material.number") && filterItemInfo.getCompareExpression().equals(CompareType.GREATER_EQUALS.toString())) {
                    this.prmtMaterialFrom.setValue((Object)this.getMaterialInfobyNumber((String)filterItemInfo.getCompareValue()));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("material.number") && filterItemInfo.getCompareExpression().equals(CompareType.LESS_EQUALS.toString())) {
                    this.prmtMaterialTo.setValue((Object)this.getMaterialInfobyNumber((String)filterItemInfo.getCompareValue()));
                    continue;
                }
                if (!filterItemInfo.getPropertyName().equalsIgnoreCase("project.id") || filterItemInfo.getCompareValue() == null) continue;
                this.prmtProject.setValue((Object)this.getProject(filterItemInfo.getCompareValue().toString()));
            }
        }
        catch (EASBizException e) {
            MsgBox.showInfo((Component)((Object)this), (String)"EASBIZException ");
            e.printStackTrace();
        }
        catch (BOSException e) {
            MsgBox.showInfo((Component)((Object)this), (String)"BOSBIZException ");
            e.printStackTrace();
        }
        super.setFilterInfo(arg0);
    }

    private ProjectInfo getProject(String id) throws EASBizException, BOSException {
        ProjectInfo projectInfo = null;
        projectInfo = ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(id));
        return projectInfo;
    }

    private MaterialInfo getMaterialInfobyNumber(String number) throws EASBizException, BOSException {
        String id = null;
        String sql = "select fid from t_bd_material where fnumber='" + number + "'";
        IRowSet rs = SqlExcFacadeFactory.getRemoteInstance().executeQuery(sql);
        try {
            if (!rs.next()) {
                return null;
            }
            id = rs.getString("fid");
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(id));
    }

    public boolean verify() {
        if (this.prmtProject.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0515"));
            return false;
        }
        return super.verify();
    }
}

