/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.zj.SqlExcFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.zjbom.client.AbstractProcessBomChangeReqFilterUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class ProcessBomChangeReqFilterUI
extends AbstractProcessBomChangeReqFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ProcessBomChangeReqFilterUI.class);

    public ProcessBomChangeReqFilterUI() throws Exception {
        this.prmtStorageOrgUnit.setDisplayFormat("$name$");
        this.prmtStorageOrgUnit.setEditFormat("$number$");
        this.prmtStorageOrgUnit.setCommitFormat("$number$");
        this.prmtParentPts.setDisplayFormat("$name$");
        this.prmtParentPts.setEditFormat("$number$");
        this.prmtParentPts.setCommitFormat("$number$");
        this.prmtProjectNo.setDisplayFormat("$name$");
        this.prmtProjectNo.setEditFormat("$number$");
        this.prmtProjectNo.setCommitFormat("$number$");
        this.prmtEntry.setDisplayFormat("$name$");
        this.prmtEntry.setEditFormat("$number$");
        this.prmtEntry.setCommitFormat("$number$");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        StorageOrgUnitInfo storageOrgUnit = this.getStorageOrgUnitInfo();
        StorageOrgUnitInfo storageOrgInfo = SysContext.getSysContext().getCurrentStorageUnit();
        FilterInfo filters = new FilterInfo();
        OrgUnitInfo[] orgs = ProcessBomChangeReqFilterUI.getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), "emm_pbomchange_addnew");
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.length; ++i) {
            keys.add(orgs[i].getId().toString());
        }
        filters.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        filters.getFilterItems().add(new FilterItemInfo("isbizunit", (Object)new Integer(1)));
        filters.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        EntityViewInfo views = new EntityViewInfo();
        views.setFilter(filters);
        this.prmtStorageOrgUnit.setEntityViewInfo(views);
        try {
            if (!storageOrgInfo.isIsBizUnit() || !keys.contains(storageOrgInfo.getId().toString())) {
                storageOrgInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(views).get(0);
                this.prmtStorageOrgUnit.setValue((Object)storageOrgInfo);
            } else {
                this.prmtStorageOrgUnit.setValue((Object)storageOrgInfo);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.prmtEntry.setValue(null);
        this.prmtParentPts.setValue(null);
        this.prmtProjectNo.setValue(null);
        this.prmtProjectNo.setQueryInfo("com.kingdee.eas.mm.project.app.F7ProjectQuery");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        this.prmtProjectNo.setEntityViewInfo(view);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public static OrgUnitInfo[] getAuthorizedBizOrgUnits(IObjectPK userPK, OrgType orgType, String permissionItem) {
        OrgUnitCollection collection = ProcessBomChangeReqFilterUI.getAuthOrgByPermItem(userPK, orgType, permissionItem);
        int size = collection.size();
        OrgUnitInfo[] results = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = collection.toArray();
            System.arraycopy(objects, 0, results, 0, size);
        }
        return results;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(IObjectPK userPK, OrgType orgType, String permItem) {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = null;
        FullOrgUnitCollection result = null;
        try {
            permission = PermissionFactory.getRemoteInstance();
            result = permission.getAuthorizedOrg(userPK, orgType, null, permItem);
        }
        catch (EASBizException e) {
            return collection;
        }
        catch (BOSException e) {
            return collection;
        }
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public boolean verify() {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-1003"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        if (this.prmtEntry.getValue() != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("pts.id", (Object)((MaterialInfo)this.prmtEntry.getValue()).getId(), CompareType.EQUALS));
        }
        if (this.prmtParentPts.getValue() != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("parentPts.id", (Object)((MaterialInfo)this.prmtParentPts.getValue()).getId(), CompareType.EQUALS));
        }
        if (this.prmtProjectNo.getValue() != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("projectNo.id", (Object)((ProjectInfo)this.prmtProjectNo.getValue()).getId(), CompareType.EQUALS));
        }
        if (this.prmtStorageOrgUnit.getValue() != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId(), CompareType.EQUALS));
        }
        return this.filterInfo;
    }

    protected StorageOrgUnitInfo getStorageOrgUnitInfo() {
        String currUser = SysContext.getSysContext().getUserName();
        StorageOrgUnitInfo storageOrgUnit = SysContext.getSysContext().getCurrentStorageUnit();
        if (storageOrgUnit == null) {
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct po.forgid as fid from T_PM_OrgRange po\r\n");
            sql.append("inner join T_ORG_Storage tos\r\n");
            sql.append("on po.forgid = tos.fid\r\n");
            sql.append("inner join t_pm_user tu\r\n");
            sql.append("on po.fuserid = tu.fid\r\n");
            sql.append("where tu.fnumber='" + currUser + "'\r\n");
            sql.append("order by po.forgid\r\n");
            String unitId = null;
            try {
                IRowSet rowset = SqlExcFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
                if (rowset.next()) {
                    unitId = rowset.getString("fid");
                }
            }
            catch (Exception ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (unitId != null) {
                try {
                    storageOrgUnit = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitId));
                }
                catch (Exception e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (BOSException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return storageOrgUnit;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.clear();
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            try {
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                String name = filterItemInfo.getPropertyName();
                if (name.equalsIgnoreCase("pts.id")) {
                    this.prmtEntry.setValue((Object)MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                }
                if (name.equalsIgnoreCase("parentPts.id")) {
                    this.prmtParentPts.setValue((Object)MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                }
                if (!name.equalsIgnoreCase("projectNo.id")) continue;
                this.prmtProjectNo.setValue((Object)ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.contStorageOrgUnit.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.mm.control.LotTraceResource", (String)"StorageLabel"));
        this.contParentPts.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0317") + "(EAS)");
        this.contProjectNo.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.mm.mo.MOSheduleResource", (String)"projectNumber"));
        this.contEntry.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.mm.basedata.BOMDataTransferResource", (String)"res_82"));
    }
}

