/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.clientUtil.ComponentUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.industry.emm.common.client.OprtState;
import com.kingdee.eas.industry.emm.project.biz.basedata.PermissionCheckFacadeFactory;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryInfo;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.util.MfgBomUtil;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ConvertStatusEnum;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.IBomConvertLog;
import com.kingdee.eas.zjbom.convert.bomConvertFacadeFactory;
import com.kingdee.eas.zjbom.convert.bomConvertToPBomFacadeFactory;
import com.kingdee.eas.zjbom.convert.client.AbstractBomConvertToPbomOneKeyUI;
import com.kingdee.eas.zjbom.convert.operationTypeEnum;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BomConvertToPbomOneKeyUI
extends AbstractBomConvertToPbomOneKeyUI {
    private static final Logger logger = CoreUIObject.getLogger(BomConvertToPbomOneKeyUI.class);
    private String RESURL = "com.kingdee.eas.zjbom.convert.convertBomResource";
    private String RESURL2 = "com.kingdee.eas.zjbom.convert.BomConvertToPBOMResource";
    private String logID;
    private int okCount = 0;
    private boolean isConvertIng = false;
    private BomConvertLogInfo info = null;
    private ChangeListener radioChangeListener = null;
    private static final int REFRESH_INTERVAL = 2000;
    private BomConvertToPbomOneKeyRunThread refresher;
    private DateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    protected DataChangeListener f7DataChangeListener = null;
    protected PreChangeListener f7PreChangeListener = null;
    protected SelectorListener f7SelectorListener = null;
    protected boolean isProjectChange = false;
    protected boolean isTrackChange = false;
    protected boolean isBomChange = false;
    protected boolean isStorageOrgUnitChange = false;
    protected boolean isDesignModeChange = false;
    protected boolean isSetDefaultValue = false;
    protected KDTEditListener kdtEditListener;
    protected KDTActiveCellListener kdtActiveCellListener;
    protected boolean isExecIng = false;
    protected KDBizPromptBox prmtStandardRooting = new KDBizPromptBox();
    protected KDBizPromptBox prmtMRWorkProcess = new KDBizPromptBox();
    protected Map<String, StandardRootingInfo> stdInfoCacheMap = null;
    protected Map<String, MRWorkProcesEntryInfo> mrwInfoCacheMap = null;
    private int execStep = 0;

    protected IObjectValue createNewData() {
        return null;
    }

    protected IBomConvertLog getBizInterface() throws Exception {
        return BomConvertLogFactory.getRemoteInstance();
    }

    private String getViewPermissionItem() {
        return "mm_pbom_view";
    }

    private String getSavePermissionItem() {
        return "mm_pbom_addnew";
    }

    private void setPrmtDesignModeDefaultValue() throws Exception {
        DesignModeInfo defSdInfo = MfgBomUtil.getDefaultDesignMode(null);
        this.prmtDesignMode.setValue((Object)defSdInfo);
    }

    protected void initPrmtDesignMode() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)8, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtDesignMode.setEntityViewInfo(view);
    }

    private void initPrmtStorageOrgUnit() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(PermissionCheckFacadeFactory.getRemoteInstance().getOrgIdPermission(this.getViewPermissionItem())), CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtStorageOrgUnit.setEntityViewInfo(view);
    }

    private void setPrmtStorageOrgUnitDefaultValue() throws Exception {
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)this.getViewPermissionItem());
        this.prmtStorageOrgUnit.setValue((Object)orgInfo);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtDesignMode.setRequired(true);
        this.prmtBOM.setRequired(true);
        this.prmtProject.setRequired(false);
        this.prmtTrackNumber.setRequired(false);
        this.prmtStorageOrgUnit.setRequired(true);
        this.initPrmtStorageOrgUnit();
        this.setPrmtStorageOrgUnitDefaultValue();
        this.initPrmtDesignMode();
        this.setPrmtDesignModeDefaultValue();
        this.contTrackNumber.setVisible(false);
        this.kDRadioButtonBom.setSelected(true);
        this.cbx_DispHaveNoEndDatas.setSelected(true);
        this.setdefValue();
    }

    @Override
    public void loadFields() {
        this.removeListener(false);
        this.isExecIng = false;
        super.loadFields();
        UIHelper.registerProjectF7ForEdit((KDBizPromptBox)this.prmtStorageOrgUnit, null, (KDBizPromptBox)this.prmtProject);
        this.kdConvertStep.checkParsed();
        this.kdtEntrysSetEditor();
        this.kdtEntrysSetRender();
        this.addListener();
        this.isExecIng = true;
    }

    protected void kdtEntrysSetEditor() {
        KDComboBox comboExecStatus = new KDComboBox();
        comboExecStatus.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.zjbom.convert.ExecStatusEnum").toArray());
        this.kdConvertStep.getColumn("execStatus").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboExecStatus));
        this.kdConvertStep.getColumn("stepname").getStyleAttributes().setWrapText(true);
        this.kdConvertStep.getColumn("execResult").getStyleAttributes().setWrapText(true);
        this.kdConvertStep.getHead().setRowHeight(0, 32);
    }

    protected void kdtEntrysSetRender() {
        this.prmtStandardRooting.setName("prmtStandardRooting");
        this.prmtStandardRooting.setEditFormat("$number$");
        this.prmtStandardRooting.setDisplayFormat("$number$");
        this.prmtStandardRooting.setCommitFormat("$number$");
        this.prmtStandardRooting.setEditable(false);
        this.prmtStandardRooting.setQueryInfo("com.kingdee.eas.zjbom.convert.app.F7StandardRootingHeadQuery");
        this.prmtStandardRooting.setEnabledMultiSelection(false);
        this.kdConvertStep.getColumn("standardRooting").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtStandardRooting));
        ObjectValueRender localObjectValueRender2 = new ObjectValueRender();
        localObjectValueRender2.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdConvertStep.getColumn("standardRooting").setRenderer((IBasicRender)localObjectValueRender2);
        this.prmtMRWorkProcess.setName("prmtMRWorkProcess");
        this.prmtMRWorkProcess.setEditFormat("$wpSeq$");
        this.prmtMRWorkProcess.setDisplayFormat("$operation.name$");
        this.prmtMRWorkProcess.setCommitFormat("$wpSeq$");
        this.prmtMRWorkProcess.setEditable(false);
        this.prmtMRWorkProcess.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7MRWorkProcessEntryQuery");
        this.prmtMRWorkProcess.setEnabledMultiSelection(false);
        this.kdConvertStep.getColumn("operationNo").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtMRWorkProcess));
        ObjectValueRender localObjectValueRender1 = new ObjectValueRender();
        localObjectValueRender1.setFormat((IDataFormat)new BizDataFormat("$operation.name$"));
        this.kdConvertStep.getColumn("operationNo").setRenderer((IBasicRender)localObjectValueRender1);
    }

    protected void removeListener(boolean removePrmt) {
        if (this.f7DataChangeListener != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.f7DataChangeListener);
            this.prmtProject.removeDataChangeListener(this.f7DataChangeListener);
            this.prmtTrackNumber.removeDataChangeListener(this.f7DataChangeListener);
            this.prmtBOM.removeDataChangeListener(this.f7DataChangeListener);
            this.prmtDesignMode.removeDataChangeListener(this.f7DataChangeListener);
        }
        if (this.f7PreChangeListener != null) {
            this.prmtStorageOrgUnit.removePreChangeListener(this.f7PreChangeListener);
            this.prmtProject.removePreChangeListener(this.f7PreChangeListener);
            this.prmtTrackNumber.removePreChangeListener(this.f7PreChangeListener);
            this.prmtBOM.removePreChangeListener(this.f7PreChangeListener);
            this.prmtDesignMode.removePreChangeListener(this.f7PreChangeListener);
        }
        if (this.f7SelectorListener != null) {
            this.prmtStorageOrgUnit.removeSelectorListener(this.f7SelectorListener);
            this.prmtProject.removeSelectorListener(this.f7SelectorListener);
            this.prmtTrackNumber.removeSelectorListener(this.f7SelectorListener);
            this.prmtBOM.removeSelectorListener(this.f7SelectorListener);
            this.prmtDesignMode.removeSelectorListener(this.f7SelectorListener);
        }
        if (this.radioChangeListener != null) {
            this.kDRadioButtonBom.removeChangeListener(this.radioChangeListener);
            this.kDRadioButtonBomChild.removeChangeListener(this.radioChangeListener);
            this.kDRadioButtonProject.removeChangeListener(this.radioChangeListener);
            this.cbx_DispHaveNoEndDatas.removeChangeListener(this.radioChangeListener);
        }
        if (!removePrmt) {
            if (this.kdtEditListener != null) {
                this.kdConvertStep.removeKDTEditListener(this.kdtEditListener);
            }
            if (this.kdtActiveCellListener != null) {
                this.kdConvertStep.removeKDTActiveCellListener(this.kdtActiveCellListener);
            }
        }
    }

    protected void addListener() {
        if (this.radioChangeListener == null) {
            this.radioChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    try {
                        BomConvertToPbomOneKeyUI.this.radioStateChanged(e);
                    }
                    catch (Exception e1) {
                        BomConvertToPbomOneKeyUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.kDRadioButtonBom.addChangeListener(this.radioChangeListener);
        this.kDRadioButtonBomChild.addChangeListener(this.radioChangeListener);
        this.kDRadioButtonProject.addChangeListener(this.radioChangeListener);
        this.cbx_DispHaveNoEndDatas.addChangeListener(this.radioChangeListener);
        if (this.f7DataChangeListener == null) {
            this.f7DataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        BomConvertToPbomOneKeyUI.this.f7DataChange(e);
                    }
                    catch (Exception exc) {
                        BomConvertToPbomOneKeyUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.f7DataChangeListener);
        this.prmtProject.addDataChangeListener(this.f7DataChangeListener);
        this.prmtTrackNumber.addDataChangeListener(this.f7DataChangeListener);
        this.prmtBOM.addDataChangeListener(this.f7DataChangeListener);
        this.prmtDesignMode.addDataChangeListener(this.f7DataChangeListener);
        if (this.f7PreChangeListener == null) {
            this.f7PreChangeListener = new PreChangeListener(){

                public void preChange(PreChangeEvent e) {
                    try {
                        BomConvertToPbomOneKeyUI.this.f7PreChange(e);
                    }
                    catch (Exception exc) {
                        BomConvertToPbomOneKeyUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addPreChangeListener(this.f7PreChangeListener);
        this.prmtProject.addPreChangeListener(this.f7PreChangeListener);
        this.prmtTrackNumber.addPreChangeListener(this.f7PreChangeListener);
        this.prmtBOM.addPreChangeListener(this.f7PreChangeListener);
        this.prmtDesignMode.addPreChangeListener(this.f7PreChangeListener);
        if (this.f7SelectorListener == null) {
            this.f7SelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        BomConvertToPbomOneKeyUI.this.f7WillShow(e);
                    }
                    catch (Exception exc) {
                        BomConvertToPbomOneKeyUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addSelectorListener(this.f7SelectorListener);
        this.prmtProject.addSelectorListener(this.f7SelectorListener);
        this.prmtTrackNumber.addSelectorListener(this.f7SelectorListener);
        this.prmtBOM.addSelectorListener(this.f7SelectorListener);
        this.prmtDesignMode.addSelectorListener(this.f7SelectorListener);
        if (this.kdtEditListener == null) {
            this.kdtEditListener = new KDTEditListener(){

                public void editValueChanged(KDTEditEvent e) {
                }

                public void editStopping(KDTEditEvent e) {
                }

                public void editStopped(KDTEditEvent e) {
                    BomConvertToPbomOneKeyUI.this.kdtEditStoppedChanged(e);
                }

                public void editStarting(KDTEditEvent e) {
                }

                public void editStarted(KDTEditEvent e) {
                }

                public void editCanceled(KDTEditEvent e) {
                }
            };
        }
        this.kdConvertStep.addKDTEditListener(this.kdtEditListener);
        if (this.kdtActiveCellListener == null) {
            this.kdtActiveCellListener = new KDTActiveCellListener(){

                public void activeCellChanged(KDTActiveCellEvent e) {
                    BomConvertToPbomOneKeyUI.this.kdtActiveCellChanged(e);
                }
            };
        }
        this.kdConvertStep.addKDTActiveCellListener(this.kdtActiveCellListener);
    }

    protected void kdtActiveCellChanged(KDTActiveCellEvent e) {
        int colIdx = this.kdConvertStep.getSelectManager().getActiveColumnIndex();
        int rowindex = this.kdConvertStep.getSelectManager().getActiveRowIndex();
        if (colIdx < 0 || rowindex < 0) {
            return;
        }
        IRow arow = this.kdConvertStep.getRow(rowindex);
        if (arow.getCell("sourceBomID").getValue() == null) {
            return;
        }
        String fbomid = arow.getCell("sourceBomID").getValue().toString();
        if (this.kdConvertStep.getColumnIndex("standardRooting") == colIdx) {
            this.setStandardRootingFilter(fbomid);
        }
        if (this.kdConvertStep.getColumnIndex("operationNo") == colIdx) {
            StandardRootingInfo stdInfo = null;
            if (arow.getCell("standardRooting").getValue() != null) {
                stdInfo = (StandardRootingInfo)arow.getCell("standardRooting").getValue();
            }
            this.setMrworkProcessFilter(stdInfo);
        }
    }

    protected void kdtEditStoppedChanged(KDTEditEvent e) {
        String fbomid;
        MRWorkProcesEntryInfo mrwInfo;
        StandardRootingInfo stdInfo;
        boolean isDiffrent;
        int colIdx = e.getColIndex();
        int rowindex = e.getRowIndex();
        if (colIdx < 0 || rowindex < 0) {
            return;
        }
        IRow arow = this.kdConvertStep.getRow(rowindex);
        if (arow.getCell("sourceBomID").getValue() == null) {
            return;
        }
        if (this.kdConvertStep.getColumnIndex("standardRooting") == colIdx && (isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getValue(), (Object)e.getOldValue()))) {
            stdInfo = null;
            mrwInfo = null;
            fbomid = arow.getCell("sourceBomID").getValue().toString();
            if (arow.getCell("standardRooting").getValue() != null) {
                stdInfo = (StandardRootingInfo)arow.getCell("standardRooting").getValue();
            }
            if (stdInfo == null) {
                arow.getCell("operationNo").setValue(null);
            } else {
                this.setMrworkProcessFilter(stdInfo);
                try {
                    mrwInfo = bomConvertToPBomFacadeFactory.getRemoteInstance().getMRWorkProcessInfo(stdInfo.getId().toString(), 2);
                }
                catch (EASBizException e1) {
                    e1.printStackTrace();
                    this.handleException((Exception)((Object)e1));
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                    this.handleException((Exception)((Object)e1));
                }
                arow.getCell("operationNo").setValue((Object)mrwInfo);
            }
            this.setKDTStepTableDataError(arow);
            this.setBomConvertEntryInfoValue(fbomid, stdInfo, mrwInfo);
        }
        if (this.kdConvertStep.getColumnIndex("operationNo") == colIdx && (isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getValue(), (Object)e.getOldValue()))) {
            stdInfo = null;
            mrwInfo = null;
            fbomid = arow.getCell("sourceBomID").getValue().toString();
            if (arow.getCell("standardRooting").getValue() != null) {
                stdInfo = (StandardRootingInfo)arow.getCell("standardRooting").getValue();
            }
            if (arow.getCell("operationNo").getValue() != null) {
                mrwInfo = (MRWorkProcesEntryInfo)arow.getCell("operationNo").getValue();
            }
            this.setKDTStepTableDataError(arow);
            this.setBomConvertEntryInfoValue(fbomid, stdInfo, mrwInfo);
        }
    }

    protected void setBomConvertEntryInfoValue(String fsourceBomID, StandardRootingInfo stdInfo, MRWorkProcesEntryInfo mrwInfo) {
        for (int i = 0; i < this.info.getEntrys().size(); ++i) {
            BomConvertLogEntryInfo entryInfo = this.info.getEntrys().get(i);
            if (entryInfo.getSourceBomID() == null || !entryInfo.getSourceBomID().equals(fsourceBomID)) continue;
            entryInfo.setStandardRooting(stdInfo);
            entryInfo.setMRWorkProcesEntry(mrwInfo);
            if (stdInfo == null) {
                entryInfo.setExecResult(EASResource.getString((String)this.RESURL, (String)"No_StandardRooting"));
                entryInfo.setExecStatus(ExecStatusEnum.ERROR);
                continue;
            }
            if (mrwInfo == null) {
                entryInfo.setExecResult(EASResource.getString((String)this.RESURL, (String)"No_MrworkProcess"));
                entryInfo.setExecStatus(ExecStatusEnum.ERROR);
                continue;
            }
            entryInfo.setExecResult(null);
            entryInfo.setExecStatus(ExecStatusEnum.NOExecute);
        }
    }

    protected void setStandardRootingFilter(String fbomid) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append(" Select h.fid ");
        sb.append(" from t_mm_standardrooting h ");
        sb.append(" inner join t_mm_bom d on d.fmaterialid = h.fmaterialid ");
        sb.append(" And d.fstorageorgunitid = h.fstorageorgunitid And h.fstatus = 60 ");
        if (fbomid == null) {
            sb.append(" where h.fid =  '*'");
        } else {
            sb.append(" where d.fid =  '" + fbomid + "'");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        view.setFilter(filterInfo);
        this.prmtStandardRooting.setEntityViewInfo(view);
        this.prmtStandardRooting.getQueryAgent().resetRuntimeEntityView();
    }

    protected void setMrworkProcessFilter(StandardRootingInfo stdInfo) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append(" Select d.fid ");
        sb.append(" from t_mm_standardrooting h ");
        sb.append(" inner join t_mm_materialrwp d on h.fmaterialrootingid = d.fparentid ");
        if (stdInfo == null) {
            sb.append(" where h.fid =  '*'");
        } else {
            sb.append(" where h.fid =  '" + stdInfo.getId().toString() + "'");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("operation.id"));
        sic.add(new SelectorItemInfo("operation.number"));
        sic.add(new SelectorItemInfo("operation.name"));
        this.prmtMRWorkProcess.setSelectorCollection(sic);
        this.prmtMRWorkProcess.setEntityViewInfo(view);
        this.prmtMRWorkProcess.getQueryAgent().resetRuntimeEntityView();
    }

    protected void radioStateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.kDRadioButtonBom) || e.getSource().equals(this.kDRadioButtonBomChild) || e.getSource().equals(this.kDRadioButtonProject) || e.getSource().equals(this.cbx_DispHaveNoEndDatas)) {
            if (e.getSource().equals(this.kDRadioButtonBom) && this.kDRadioButtonBom.isSelected()) {
                this.kDRadioButtonBomChild.setSelected(false);
                this.kDRadioButtonProject.setSelected(false);
            }
            if (e.getSource().equals(this.kDRadioButtonBomChild) && this.kDRadioButtonBomChild.isSelected()) {
                this.kDRadioButtonBom.setSelected(false);
                this.kDRadioButtonProject.setSelected(false);
            }
            if (e.getSource().equals(this.kDRadioButtonProject) && this.kDRadioButtonProject.isSelected()) {
                this.kDRadioButtonBomChild.setSelected(false);
                this.kDRadioButtonBom.setSelected(false);
            }
            if (e.getSource().equals(this.cbx_DispHaveNoEndDatas)) {
                // empty if block
            }
        }
    }

    protected void SetBOMFilter() throws Exception {
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        if (this.prmtStorageOrgUnit.getValue() != null) {
            storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        }
        DesignModeInfo dsInfo = null;
        if (this.prmtDesignMode.getValue() != null) {
            dsInfo = (DesignModeInfo)this.prmtDesignMode.getValue();
        }
        ProjectInfo projectInfo = null;
        if (dsInfo != null && dsInfo.isProject()) {
            projectInfo = (ProjectInfo)this.prmtProject.getValue();
        }
        TrackNumberInfo trackNumberInfo = null;
        if (dsInfo != null && !dsInfo.isProject() && dsInfo.isTrackNumber()) {
            trackNumberInfo = (TrackNumberInfo)this.prmtTrackNumber.getValue();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgUnitInfo == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", null, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        if (dsInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("designMode.id", (Object)dsInfo.getId(), CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        if (projectInfo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectInfo.getId().toString(), CompareType.EQUALS));
        }
        if (trackNumberInfo != null) {
            StringBuilder sql = new StringBuilder();
            sql.append(" Select bd.fparentid from t_mm_bomentry bd inner join t_mm_tracknumber bt on bt.fid = bd.fbegincarnoid inner join t_mm_tracknumber et on et.fid = bd.fendcarnoid where bt.fnumber <= '" + trackNumberInfo.getNumber() + "' and et.fnumber >= '" + trackNumberInfo.getNumber() + "' ");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        }
        view.setFilter(filterInfo);
        this.prmtBOM.setEntityViewInfo(view);
        this.prmtBOM.getQueryAgent().resetRuntimeEntityView();
    }

    protected void SetProjectOrTrackNumberValue() throws Exception {
        BomInfo bomInfo = null;
        DesignModeInfo dsInfo = null;
        if (this.prmtDesignMode.getValue() != null) {
            dsInfo = (DesignModeInfo)this.prmtDesignMode.getValue();
        }
        if (dsInfo != null && dsInfo.isProject() && this.prmtBOM.getValue() != null) {
            ProjectInfo oldProjectinfo = null;
            if (this.prmtProject.getValue() != null) {
                oldProjectinfo = (ProjectInfo)this.prmtProject.getValue();
            }
            bomInfo = (BomInfo)this.prmtBOM.getValue();
            if (oldProjectinfo == null && bomInfo.getProject() == null) {
                return;
            }
            if (oldProjectinfo != null && bomInfo.getProject() != null && bomInfo.getProject().getId().toString().equals(oldProjectinfo.getId().toString())) {
                return;
            }
            if (bomInfo.getProject() == null) {
                this.prmtProject.setValue(null);
            } else if (bomInfo.getProject().getNumber() == null || bomInfo.getProject().getNumber().equals("")) {
                ProjectInfo pInfo = ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(bomInfo.getProject().getId().toString()));
                this.prmtProject.setValue((Object)pInfo);
            } else {
                this.prmtProject.setValue((Object)bomInfo.getProject());
            }
        } else if (dsInfo != null && !dsInfo.isProject() && dsInfo.isTrackNumber() && this.prmtBOM.getValue() != null) {
            TrackNumberInfo oldTrackNumberInfo = null;
            if (this.prmtTrackNumber.getValue() != null) {
                oldTrackNumberInfo = (TrackNumberInfo)this.prmtTrackNumber.getValue();
            }
            bomInfo = (BomInfo)this.prmtBOM.getValue();
            TrackNumberInfo newTrackNumberInfo = this.getBomFirstTrackNumberInfo(bomInfo);
            if (oldTrackNumberInfo == null && newTrackNumberInfo == null) {
                return;
            }
            if (oldTrackNumberInfo != null && newTrackNumberInfo != null && oldTrackNumberInfo.getId().toString().equals(newTrackNumberInfo.getId().toString())) {
                return;
            }
            this.prmtTrackNumber.setValue((Object)newTrackNumberInfo);
        }
    }

    protected TrackNumberInfo getBomFirstTrackNumberInfo(BomInfo bomInfo) throws Exception {
        List<TrackNumberInfo> list;
        TrackNumberInfo info = null;
        if (bomInfo != null && (list = BomUtil.getBomTrackNumberInfoList(null, bomInfo)) != null && list.size() > 0) {
            return list.get(0);
        }
        return info;
    }

    protected void f7DataChange(DataChangeEvent e) throws Exception {
        String name = ((KDBizPromptBox)e.getSource()).getName();
        if (name != null && name.equals(this.prmtStorageOrgUnit.getName())) {
            this.storageOrgUnitDataChange();
        }
        if (name != null && name.equals(this.prmtDesignMode.getName())) {
            this.designModeDataChange();
        }
        if (name != null && name.equals(this.prmtProject.getName())) {
            this.projectDataChange();
        }
        if (name != null && name.equals(this.prmtTrackNumber.getName())) {
            this.trackNumberDataChange();
        }
        if (name != null && name.equals(this.prmtBOM.getName())) {
            this.bomDataChange();
        }
    }

    protected void f7PreChange(PreChangeEvent e) throws BOSException {
    }

    protected void f7WillShow(SelectorEvent e) {
        if (e.getSource() == null || !(e.getSource() instanceof KDBizPromptBox)) {
            e.setCanceled(true);
            return;
        }
        String name = ((KDBizPromptBox)e.getSource()).getName();
        if (name.equals(this.prmtProject.getName()) || name.equals(this.prmtTrackNumber.getName())) {
            if (this.prmtStorageOrgUnit.getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)this.RESURL2, (String)"StorageOrgUnit_NULL"));
                e.setCanceled(true);
                return;
            }
            if (this.prmtDesignMode.getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)this.RESURL2, (String)"DesignMode_IsNull"));
                e.setCanceled(true);
                return;
            }
        }
        if (name.equals(this.prmtBOM.getName()) && this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESURL2, (String)"StorageOrgUnit_NULL"));
            e.setCanceled(true);
            return;
        }
        if (name.equals(this.prmtProject.getName()) || name.equals(this.prmtTrackNumber.getName())) {
            if (this.prmtStorageOrgUnit.getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)this.RESURL2, (String)"StorageOrgUnit_NULL"));
                e.setCanceled(true);
                return;
            }
            if (this.prmtDesignMode.getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)this.RESURL2, (String)"DesignMode_IsNull"));
                e.setCanceled(true);
                return;
            }
        }
        if (name.equals(this.prmtBOM.getName())) {
            try {
                this.SetBOMFilter();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                this.handleException(e1);
            }
        }
    }

    protected void storageOrgUnitDataChange() throws Exception {
        if (this.isBomChange || this.isProjectChange || this.isDesignModeChange || this.isTrackChange) {
            return;
        }
        try {
            this.isStorageOrgUnitChange = true;
            this.prmtProject.setValue(null);
            this.prmtBOM.setValue(null);
            this.SetBOMFilter();
            this.initKDTStepTableData();
        }
        finally {
            this.isStorageOrgUnitChange = false;
        }
    }

    protected void designModeDataChange() throws Exception {
        if (this.isBomChange || this.isProjectChange || this.isTrackChange || this.isStorageOrgUnitChange) {
            return;
        }
        try {
            this.isDesignModeChange = true;
            this.prmtProject.setValue(null);
            this.prmtTrackNumber.setValue(null);
            this.prmtBOM.setValue(null);
            DesignModeInfo dsInfo = (DesignModeInfo)this.prmtDesignMode.getValue();
            if (dsInfo != null && !dsInfo.isProject() && !dsInfo.isTrackNumber()) {
                this.prmtProject.setEnabled(false);
                this.prmtProject.setRequired(false);
                this.prmtTrackNumber.setEnabled(false);
                this.prmtTrackNumber.setRequired(false);
                this.kDRadioButtonProject.setSelected(false);
                this.kDRadioButtonProject.setEnabled(false);
                this.contTrackNumber.setVisible(false);
                this.contProject.setVisible(false);
            } else if (dsInfo != null && !dsInfo.isProject() && dsInfo.isTrackNumber()) {
                this.prmtProject.setEnabled(false);
                this.prmtProject.setRequired(false);
                this.prmtTrackNumber.setEnabled(true);
                this.prmtTrackNumber.setRequired(true);
                this.contTrackNumber.setVisible(true);
                this.contProject.setVisible(false);
                this.kDRadioButtonProject.setEnabled(true);
                this.kDRadioButtonProject.setText("BOM\u8ddf\u8e2a\u53f7\u5bf9\u5e94\u7684\u6240\u6709\u81ea\u5236\u4ef6\u6216\u59d4\u5916\u4ef6 (\u540c\u4e00\u4e2a\u8ddf\u8e2a\u53f7\u4e0b\u7684BOM\u6570\u636e\uff0c\u81ea\u52a8\u5c06\u672a\u5206\u914d\u7684\u6570\u636e\u5206\u914d\u81f3\u5de5\u827a\u8def\u7ebf\u7b2c\u4e00\u9053\u5de5\u5e8f)");
            } else {
                this.prmtProject.setEnabled(true);
                this.prmtProject.setRequired(true);
                this.prmtTrackNumber.setEnabled(false);
                this.prmtTrackNumber.setRequired(false);
                this.contTrackNumber.setVisible(false);
                this.contProject.setVisible(true);
                this.kDRadioButtonProject.setEnabled(true);
                this.kDRadioButtonProject.setText("BOM\u9879\u76ee\u53f7\u5bf9\u5e94\u7684\u6240\u6709\u81ea\u5236\u4ef6\u6216\u59d4\u5916\u4ef6 (\u540c\u4e00\u4e2a\u9879\u76ee\u53f7\u4e0b\u7684BOM\u6570\u636e\uff0c\u81ea\u52a8\u5c06\u672a\u5206\u914d\u7684\u6570\u636e\u5206\u914d\u81f3\u5de5\u827a\u8def\u7ebf\u7b2c\u4e00\u9053\u5de5\u5e8f)");
            }
            this.SetBOMFilter();
            this.initKDTStepTableData();
        }
        finally {
            this.isDesignModeChange = false;
        }
    }

    protected void projectDataChange() throws Exception {
        if (this.isBomChange || this.isStorageOrgUnitChange || this.isDesignModeChange || this.isTrackChange) {
            return;
        }
        try {
            this.isProjectChange = true;
            this.prmtBOM.setValue(null);
            this.SetBOMFilter();
        }
        finally {
            this.isProjectChange = false;
        }
    }

    protected void trackNumberDataChange() throws Exception {
        if (this.isBomChange || this.isStorageOrgUnitChange || this.isDesignModeChange || this.isProjectChange) {
            return;
        }
        try {
            this.isTrackChange = true;
            this.prmtBOM.setValue(null);
            this.SetBOMFilter();
        }
        finally {
            this.isTrackChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bomDataChange() throws Exception {
        if (this.isProjectChange || this.isStorageOrgUnitChange || this.isDesignModeChange) {
            return;
        }
        try {
            this.isBomChange = true;
            this.SetProjectOrTrackNumberValue();
            this.initKDTStepTableData();
            if (this.prmtBOM.getValue() != null) {
                BomInfo bom = (BomInfo)this.prmtBOM.getValue();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("designmode.id"));
                selector.add(new SelectorItemInfo("designmode.number"));
                selector.add(new SelectorItemInfo("designmode.name"));
                BomInfo bomInfo = BomFactory.getRemoteInstance().getBomInfo((IObjectPK)new ObjectUuidPK(bom.getId().toString()), selector);
                if (this.prmtDesignMode.getValue() == null) {
                    this.prmtDesignMode.setValue((Object)bomInfo.getDesignMode());
                }
            }
        }
        finally {
            this.isBomChange = false;
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnStartConvert.setEnabled(true);
        this.btnStopConvert.setEnabled(true);
        this.btnStartConvert.setVisible(true);
        this.btnStopConvert.setVisible(false);
        if (this.uiWindow instanceof JFrame) {
            ((JFrame)this.uiWindow).setExtendedState(6);
        }
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"340_TransUpDownBillHelper") + EASResource.getString((String)"com.kingdee.eas.cp.eip.mc.MessageCenter", (String)"distra"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemAddNew});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemEdit});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemSubmit});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemSave});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemRemove});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemPre});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCopy});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemNext});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemLast});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemFirst});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemPrint});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemPrintPreview});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCancel});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCancelCancel});
    }

    protected void setKDTStepTableDataError(IRow aRow) {
        if (aRow.getCell("standardRooting").getValue() == null) {
            aRow.getCell("execResult").setValue((Object)EASResource.getString((String)this.RESURL, (String)"No_Audit_StandardRooting"));
            aRow.getCell("execStatus").setValue((Object)ExecStatusEnum.ERROR);
            aRow.getCell("execStatus").getStyleAttributes().setBackground(Color.red);
            return;
        }
        if (aRow.getCell("operationNo").getValue() == null) {
            aRow.getCell("execResult").setValue((Object)EASResource.getString((String)this.RESURL, (String)"No_MrworkProcess"));
            aRow.getCell("execStatus").setValue((Object)ExecStatusEnum.ERROR);
            aRow.getCell("execStatus").getStyleAttributes().setBackground(Color.red);
            return;
        }
        aRow.getCell("execResult").setValue((Object)"");
        aRow.getCell("execStatus").setValue((Object)ExecStatusEnum.NOExecute);
        aRow.getCell("execStatus").getStyleAttributes().setBackground(Color.green);
    }

    protected void setKDTStepTableData() {
        BomInfo bomInfo = null;
        if (this.prmtBOM.getValue() == null) {
            if (this.kdConvertStep.getRowCount() > 0) {
                this.kdConvertStep.removeRows();
            }
            this.info = null;
            return;
        }
        int expandType = 1;
        if (this.kDRadioButtonBom.isSelected()) {
            expandType = 1;
        } else if (this.kDRadioButtonBomChild.isSelected()) {
            expandType = 2;
        } else if (this.kDRadioButtonProject.isSelected()) {
            expandType = 3;
        } else {
            return;
        }
        boolean dispHaveNoEndDatas = false;
        if (this.cbx_DispHaveNoEndDatas.isSelected()) {
            dispHaveNoEndDatas = true;
        }
        bomInfo = (BomInfo)this.prmtBOM.getValue();
        HashMap<String, Object> dataParam = new HashMap<String, Object>();
        dataParam.put("expandType", expandType);
        dataParam.put("dispHaveNoEndDatas", dispHaveNoEndDatas);
        dataParam.put("bomInfo", bomInfo);
        dataParam.put("operationType", (Object)operationTypeEnum.pbomOneKey);
        try {
            this.info = this.getBizInterface().initStepEntrys(dataParam);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(e);
        }
        this.setKDTStepTableDataValue();
    }

    protected void setKDTStepTableDataValue() {
        if (this.info == null || this.info.getId() == null) {
            return;
        }
        this.stdInfoCacheMap = new HashMap<String, StandardRootingInfo>();
        this.mrwInfoCacheMap = new HashMap<String, MRWorkProcesEntryInfo>();
        this.combConvertStatus.setSelectedItem((Object)this.info.getConvertStatus());
        this.logID = this.info.getId().toString();
        this.kdConvertStep.removeRows();
        this.okCount = 0;
        IRow addRow = null;
        if (this.info != null && this.info.getEntrys() != null && this.info.getEntrys().size() > 0) {
            for (int i = 0; i < this.info.getEntrys().size(); ++i) {
                BomConvertLogEntryInfo entryInfo = this.info.getEntrys().get(i);
                addRow = this.kdConvertStep.addRow();
                addRow.getCell("stepname").setValue((Object)entryInfo.getStepname());
                addRow.getCell("beginDate").setValue(null);
                addRow.getCell("endDate").setValue(null);
                addRow.getCell("execTimeLong").setValue(null);
                addRow.getCell("execResult").setValue((Object)entryInfo.getExecResult());
                addRow.getCell("execStatus").setValue((Object)entryInfo.getExecStatus());
                addRow.getCell("sourceBomID").setValue((Object)entryInfo.getSourceBomID());
                addRow.getCell("standardRooting").setValue((Object)entryInfo.getStandardRooting());
                addRow.getCell("operationNo").setValue((Object)entryInfo.getMRWorkProcesEntry());
                if (entryInfo.getStandardRooting() != null) {
                    this.stdInfoCacheMap.put(entryInfo.getStandardRooting().getId().toString(), entryInfo.getStandardRooting());
                }
                if (entryInfo.getMRWorkProcesEntry() != null) {
                    this.mrwInfoCacheMap.put(entryInfo.getMRWorkProcesEntry().getId().toString(), entryInfo.getMRWorkProcesEntry());
                }
                addRow.getCell("id").setValue(null);
                if (entryInfo.getExecStatus().equals((Object)ExecStatusEnum.ERROR)) {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.red);
                } else {
                    ++this.okCount;
                }
                if (entryInfo.getExecStatus().equals((Object)ExecStatusEnum.NOExecute)) {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.green);
                }
                this.kdConvertStep.getBody().setRowHeight(addRow.getRowIndex(), 32);
            }
        }
    }

    protected void initKDTStepTableData() {
        Component[] cps;
        if (!this.isExecIng) {
            return;
        }
        if (this.prmtBOM.getValue() == null) {
            return;
        }
        LongTimeDialog dialog = new LongTimeDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public void afterExec(Object result) throws Exception {
            }

            public Object exec() {
                BomConvertToPbomOneKeyUI.this.setKDTStepTableData();
                return EASResource.getString((String)BomConvertToPbomOneKeyUI.this.RESURL2, (String)"LoadDataEnd");
            }
        });
        for (Component cp : cps = dialog.getContentPane().getComponents()) {
            if (!(cp instanceof JLabel)) continue;
            ((JLabel)cp).setText(EASResource.getString((String)this.RESURL2, (String)"LoadDataIng_PleaseWait"));
        }
        dialog.show();
    }

    private void checkBeforeConvert() throws Exception {
        if (this.isConvertIng) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"isDisIng"));
            SysUtil.abort();
        }
        if (this.prmtBOM.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL2, (String)"BOM_NULL"));
            SysUtil.abort();
        }
        if (this.info == null || this.info.getEntrys() == null || this.info.getEntrys().size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoDisEntryData"));
            SysUtil.abort();
        }
        this.okCount = 0;
        for (int i = 0; i < this.info.getEntrys().size(); ++i) {
            if (this.info.getEntrys().get(i).getExecStatus().equals((Object)ExecStatusEnum.ERROR)) continue;
            ++this.okCount;
        }
        if (this.okCount == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoValidDisData"));
            SysUtil.abort();
        }
        if (this.info.getConvertStatus() != null && this.info.getConvertStatus().equals((Object)ConvertStatusEnum.ConvertEnd)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"isDis_Retry"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionStartConvert_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeConvert();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)this.RESURL, (String)"Affirm_StartDis")) == 2) {
            SysUtil.abort();
        }
        this.setConvertIng();
        this.refresher = new BomConvertToPbomOneKeyRunThread();
        this.refresher.start();
    }

    private void setConvertIng() {
        this.isConvertIng = true;
        this.btnStartConvert.setEnabled(false);
        this.btnStartConvert.setVisible(false);
        this.btnStopConvert.setEnabled(true);
        this.btnStopConvert.setVisible(true);
        this.combConvertStatus.setSelectedItem((Object)ConvertStatusEnum.Converting);
    }

    private void setConvertEnd() {
        this.isConvertIng = false;
        this.btnStartConvert.setEnabled(true);
        this.btnStartConvert.setVisible(true);
        this.btnStopConvert.setEnabled(false);
        this.btnStopConvert.setVisible(false);
    }

    private void execConvert() throws Exception {
        HashMap<String, BomConvertLogInfo> dataMap = new HashMap<String, BomConvertLogInfo>();
        dataMap.put("info", this.info);
        this.info = bomConvertFacadeFactory.getRemoteInstance().bomConvert(dataMap);
        this.combConvertStatus.setSelectedItem((Object)this.info.getConvertStatus());
    }

    @Override
    public void actionStopConvert_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isConvertIng) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"ISNoDisIng"));
            SysUtil.abort();
        }
        if (MsgBox.showConfirm2((String)EASResource.getString((String)this.RESURL, (String)"Affirm_StopDis")) == 2) {
            SysUtil.abort();
        }
        if (this.info != null) {
            bomConvertFacadeFactory.getRemoteInstance().stopConvert(this.info.getId().toString());
        }
        this.setConvertEnd();
        this.combConvertStatus.setSelectedItem((Object)ConvertStatusEnum.STOP);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"handStop"));
        SysUtil.abort();
    }

    public boolean destroyWindow() {
        if (this.isConvertIng) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"isRunning_CloseUI"));
            SysUtil.abort();
        }
        if (this.refresher != null) {
            this.refresher.destroy();
        }
        return super.destroyWindow();
    }

    private StandardRootingInfo getStandardRootingInfo(String fid) throws Exception {
        if (fid == null || "".equals(fid)) {
            return null;
        }
        if (this.stdInfoCacheMap != null && this.stdInfoCacheMap.containsKey(fid)) {
            return this.stdInfoCacheMap.get(fid);
        }
        StandardRootingInfo stdInfo = bomConvertToPBomFacadeFactory.getRemoteInstance().getStandardRootingInfo(fid);
        this.stdInfoCacheMap.put(fid, stdInfo);
        return stdInfo;
    }

    private MRWorkProcesEntryInfo getMRWorkProcesEntryInfo(String fid) throws Exception {
        if (fid == null || "".equals(fid)) {
            return null;
        }
        if (this.mrwInfoCacheMap != null && this.mrwInfoCacheMap.containsKey(fid)) {
            return this.mrwInfoCacheMap.get(fid);
        }
        MRWorkProcesEntryInfo mrwInfo = bomConvertToPBomFacadeFactory.getRemoteInstance().getMRWorkProcessInfo(fid, 1);
        this.mrwInfoCacheMap.put(fid, mrwInfo);
        return mrwInfo;
    }

    private void updateEntryDatas() throws Exception {
        IRowSet rs = BomConvertLogFactory.getRemoteInstance().getStepEntrys(this.logID);
        this.kdConvertStep.removeRows();
        IRow addRow = null;
        this.execStep = 0;
        if (rs != null && rs.size() > 0) {
            while (rs.next()) {
                addRow = this.kdConvertStep.addRow();
                addRow.getCell("stepname").setValue((Object)rs.getString("fstepname"));
                addRow.getCell("standardRooting").setValue((Object)this.getStandardRootingInfo(rs.getString("fstandardrootingid")));
                addRow.getCell("operationNo").setValue((Object)this.getMRWorkProcesEntryInfo(rs.getString("fmrwid")));
                if (rs.getDate("fbegindate") != null) {
                    addRow.getCell("beginDate").setValue((Object)this.sdf.format(rs.getDate("fbegindate")));
                }
                if (rs.getDate("fenddate") != null) {
                    addRow.getCell("endDate").setValue((Object)this.sdf.format(rs.getDate("fenddate")));
                }
                addRow.getCell("execTimeLong").setValue((Object)rs.getInt("fexectimelong"));
                addRow.getCell("execResult").setValue((Object)rs.getString("fexecresult"));
                addRow.getCell("execStatus").setValue((Object)ExecStatusEnum.getEnum(rs.getInt("FExecStatus")));
                addRow.getCell("sourceBomID").setValue((Object)rs.getString("fsourcebomid"));
                addRow.getCell("id").setValue((Object)rs.getString("fid"));
                if (rs.getInt("FExecStatus") == -1) {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.red);
                } else if (rs.getInt("FExecStatus") == 0) {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.green);
                } else {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.white);
                }
                if (rs.getInt("FExecStatus") == 1) {
                    this.execStep = addRow.getRowIndex();
                }
                this.kdConvertStep.getBody().setRowHeight(addRow.getRowIndex(), 32);
            }
        }
    }

    @Override
    protected void btnRetrieve_actionPerformed(ActionEvent e) throws Exception {
        this.initKDTStepTableData();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void kdConvertStep_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 2) return;
        if (e.getType() == 0) {
            return;
        }
        if (e.getRowIndex() < 0 || e.getColIndex() < 0) {
            return;
        }
        if (e.getColIndex() != this.kdConvertStep.getColumnIndex("execResult") || this.kdConvertStep.getCell(e.getRowIndex(), "execStatus").getValue() == null || !((ExecStatusEnum)((Object)this.kdConvertStep.getCell(e.getRowIndex(), "execStatus").getValue())).equals((Object)ExecStatusEnum.ERROR)) return;
        UIContext uiContext = new UIContext();
        IUIWindow uiWindow = null;
        String uiClass = "com.kingdee.eas.zjbom.convert.client.BomConvertLogErrTextViewUI";
        if (this.kdConvertStep.getCell(e.getRowIndex(), "id").getValue() == null) {
            if (this.kdConvertStep.getCell(e.getRowIndex(), "execResult").getValue() == null) return;
            uiContext.put((Object)"errorString", (Object)this.kdConvertStep.getCell(e.getRowIndex(), "execResult").getValue().toString());
        } else {
            uiContext.put((Object)"errorEntryID", (Object)this.kdConvertStep.getCell(e.getRowIndex(), "id").getValue().toString());
        }
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.zjbom.convert.client.BomConvertLogErrTextViewUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public void setdefValue() throws Exception {
        if (this.isSetDefaultValue) {
            return;
        }
        if (this.getUIContext().get("bomstdList") != null) {
            this.isSetDefaultValue = true;
            ArrayList bomstdList = (ArrayList)this.getUIContext().get("bomstdList");
            HashSet storageOrgUnitIDSet = null;
            StorageOrgUnitInfo storageOrgUnitInfo = null;
            if (this.getUIContext().get("storageOrgUnitIDSet") != null && (storageOrgUnitIDSet = (HashSet)this.getUIContext().get("storageOrgUnitIDSet")) != null && storageOrgUnitIDSet.size() > 0) {
                storageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageOrgUnitIDSet.toArray()[0].toString()));
            }
            DesignModeInfo designModeInfo = null;
            if (this.getUIContext().get("designModeInfo") != null) {
                designModeInfo = (DesignModeInfo)this.getUIContext().get("designModeInfo");
            }
            BomInfo bomInfo = null;
            if (this.getUIContext().get("bominfo") != null) {
                bomInfo = (BomInfo)this.getUIContext().get("bominfo");
            }
            ProjectInfo projectInfo = null;
            if (this.getUIContext().get("projectInfo") != null) {
                projectInfo = (ProjectInfo)this.getUIContext().get("projectInfo");
            }
            TrackNumberInfo trackNumberInfo = null;
            if (this.getUIContext().get("tracknumberInfo") != null) {
                trackNumberInfo = (TrackNumberInfo)this.getUIContext().get("tracknumberInfo");
            }
            MaterialInfo materialInfo = null;
            if (this.getUIContext().get("materialinfo") != null) {
                materialInfo = (MaterialInfo)this.getUIContext().get("materialinfo");
            }
            int queryBomType = 0;
            if (this.getUIContext().get("queryBomType") != null) {
                queryBomType = Integer.parseInt(this.getUIContext().get("queryBomType").toString());
            }
            this.removeListener(true);
            this.prmtStorageOrgUnit.setValue((Object)storageOrgUnitInfo);
            this.prmtDesignMode.setValue((Object)designModeInfo);
            this.prmtProject.setValue((Object)projectInfo);
            this.prmtBOM.setValue((Object)bomInfo);
            this.prmtTrackNumber.setValue((Object)trackNumberInfo);
            if (queryBomType == 1) {
                this.kDRadioButtonBomChild.setSelected(true);
                this.kDRadioButtonBom.setSelected(false);
                this.kDRadioButtonProject.setSelected(false);
            } else if (queryBomType == 2) {
                this.kDRadioButtonProject.setSelected(true);
                this.kDRadioButtonBom.setSelected(false);
                this.kDRadioButtonBomChild.setSelected(false);
            } else {
                this.kDRadioButtonBom.setSelected(true);
                this.kDRadioButtonProject.setSelected(false);
                this.kDRadioButtonBomChild.setSelected(false);
            }
            this.prmtStorageOrgUnit.setEnabled(false);
            this.prmtDesignMode.setEnabled(false);
            this.prmtProject.setEnabled(false);
            this.prmtBOM.setEnabled(false);
            this.prmtTrackNumber.setEnabled(false);
            this.kDRadioButtonBom.setEnabled(false);
            this.kDRadioButtonProject.setEnabled(false);
            this.kDRadioButtonBomChild.setEnabled(false);
            this.btnRetrieve.setVisible(false);
            this.cbx_DispHaveNoEndDatas.setEnabled(false);
            HashMap<String, Object> dataParam = new HashMap<String, Object>();
            dataParam.put("bomstdList", bomstdList);
            dataParam.put("operationType", (Object)operationTypeEnum.pbomOneKey);
            int expandType = 1;
            if (this.kDRadioButtonBom.isSelected()) {
                expandType = 1;
            } else if (this.kDRadioButtonBomChild.isSelected()) {
                expandType = 2;
            } else if (this.kDRadioButtonProject.isSelected()) {
                expandType = 3;
            } else {
                return;
            }
            dataParam.put("expandType", expandType);
            dataParam.put("dispHaveNoEndDatas", false);
            dataParam.put("bomInfo", bomInfo);
            try {
                this.info = this.getBizInterface().initStepEntrys(dataParam);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                e.printStackTrace();
                this.handleException((Exception)((Object)e));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.handleException(e);
            }
            this.setKDTStepTableDataValue();
        }
    }

    private class EDTUIReloader
    implements Runnable {
        private EDTUIReloader() {
        }

        @Override
        public void run() {
            try {
                BomConvertToPbomOneKeyUI.this.updateEntryDatas();
            }
            catch (Exception e) {
                e.printStackTrace();
                BomConvertToPbomOneKeyUI.this.handleException(e);
            }
            if (BomConvertToPbomOneKeyUI.this.execStep > 0) {
                BomConvertToPbomOneKeyUI.this.kdConvertStep.getLayoutManager().scrollRowToShow(BomConvertToPbomOneKeyUI.this.execStep);
            }
        }
    }

    private class UIRefreshThread
    extends Thread {
        private boolean interrupted = false;
        private int last5RefreshCount = 5;

        private UIRefreshThread() {
        }

        @Override
        public void run() {
            while (!this.interrupted && BomConvertToPbomOneKeyUI.this.isConvertIng) {
                try {
                    Thread.sleep(2000L);
                    ConvertStatusEnum convStatus = bomConvertFacadeFactory.getRemoteInstance().getConvertStatus(BomConvertToPbomOneKeyUI.this.logID);
                    if (convStatus != null && convStatus.equals((Object)ConvertStatusEnum.STOP)) {
                        this.interrupted = true;
                        BomConvertToPbomOneKeyUI.this.isConvertIng = false;
                        return;
                    }
                    SwingUtilities.invokeLater(new EDTUIReloader());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BomConvertToPbomOneKeyUI.this.handleException(e);
                }
            }
        }
    }

    private class BomConvertToPbomOneKeyRunThread
    extends Thread {
        private UIRefreshThread uiThread;

        private BomConvertToPbomOneKeyRunThread() {
        }

        @Override
        public void run() {
            try {
                BomConvertToPbomOneKeyUI.this.isConvertIng = true;
                this.uiThread = new UIRefreshThread();
                this.uiThread.start();
                BomConvertToPbomOneKeyUI.this.execConvert();
                BomConvertToPbomOneKeyUI.this.updateEntryDatas();
                BomConvertToPbomOneKeyUI.this.setSave(true);
                BomConvertToPbomOneKeyUI.this.setSaved(true);
            }
            catch (Exception e) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                AdvMsgBox.createAdvMsgBox((Component)((Object)BomConvertToPbomOneKeyUI.this), (String)EASResource.getString((String)BomConvertToPbomOneKeyUI.this.RESURL, (String)"infoMessage"), (String)EASResource.getString((String)BomConvertToPbomOneKeyUI.this.RESURL, (String)"convertErr"), (String)writer.toString(), (int)0, (int)8188).show();
                if (this.uiThread != null) {
                    this.uiThread.interrupted = true;
                }
                BomConvertToPbomOneKeyUI.this.combConvertStatus.setSelectedItem((Object)ConvertStatusEnum.ERROR);
                BomConvertToPbomOneKeyUI.this.handleException(e);
            }
            finally {
                BomConvertToPbomOneKeyUI.this.isConvertIng = false;
                if (this.uiThread != null) {
                    this.uiThread.interrupted = true;
                }
                BomConvertToPbomOneKeyUI.this.setConvertEnd();
            }
        }

        public void destroy() {
            if (this.uiThread != null) {
                this.uiThread.interrupted = true;
            }
        }
    }
}

