/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.clientUtil.ComponentUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.industry.emm.common.client.OprtState;
import com.kingdee.eas.mm.basedata.PBOMInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.DesignBOMBillInfo;
import com.kingdee.eas.zjbom.DesignBOMMiddleBillInfo;
import com.kingdee.eas.zjbom.DesignBomTempBillInfo;
import com.kingdee.eas.zjbom.ProcessBomBillInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.BomConvertTypeRelationCollection;
import com.kingdee.eas.zjbom.convert.BomConvertTypeRelationFactory;
import com.kingdee.eas.zjbom.convert.ConvertStatusEnum;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.IBomConvertLog;
import com.kingdee.eas.zjbom.convert.bomConvertFacadeFactory;
import com.kingdee.eas.zjbom.convert.client.AbstractBomConvertUI;
import com.kingdee.eas.zjbom.convert.operationTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BomConvertUI
extends AbstractBomConvertUI {
    private static final Logger logger = CoreUIObject.getLogger(BomConvertUI.class);
    private String RESURL = "com.kingdee.eas.zjbom.convert.convertBomResource";
    private String logID;
    private DBOMTypeEnum beforeDBomType;
    private List<String> beforeBomIDList;
    private int okCount = 0;
    private boolean isConvertIng = false;
    private BomConvertLogInfo info = null;
    private ItemListener cmbItemListener = null;
    private static final int REFRESH_INTERVAL = 2000;
    private BomConvertRunThread refresher;
    private DateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    private ChangeListener kDTabbedPane1ChangeListener = null;
    private int execStep = 0;

    public BomConvertUI() throws Exception {
        this.setPreferredSize(new Dimension(950, 600));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected IBomConvertLog getBizInterface() throws Exception {
        return BomConvertLogFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        KDTSortManager sortManager = new KDTSortManager(this.kdConvertStep);
        sortManager.setSortAuto(true);
        sortManager.setClickCount(1);
        for (int i = 0; i < this.kdConvertStep.getColumnCount(); ++i) {
            this.kdConvertStep.getColumn(i).setSortable(true);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnStartConvert.setEnabled(true);
        this.btnStopConvert.setEnabled(true);
        this.btnStartConvert.setVisible(true);
        this.btnStopConvert.setVisible(false);
        this.contConvertStatus.setBoundLabelText(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"ZHJD_INFO"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemAddNew});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemEdit});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemSubmit});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemSave});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemRemove});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemPre});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCopy});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemNext});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemLast});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemFirst});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemPrint});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemPrintPreview});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCancel});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCancelCancel});
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
        this.kdConvertStep.checkParsed();
        this.kDDiff.checkParsed();
        this.kdtEntrysSetEditor();
        try {
            this.initSourceParam();
            this.setHeadValue();
            this.setTargetBomTypeValue();
            this.setInitEntrys();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(e);
        }
    }

    protected void kdtEntrysSetEditor() {
        KDComboBox comboExecStatus = new KDComboBox();
        comboExecStatus.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.zjbom.convert.ExecStatusEnum").toArray());
        this.kdConvertStep.getColumn("execStatus").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboExecStatus));
        this.kdConvertStep.getColumn("stepname").getStyleAttributes().setWrapText(true);
        this.kdConvertStep.getColumn("stepname").getStyleAttributes().setLocked(true);
        this.kdConvertStep.getColumn("execResult").getStyleAttributes().setWrapText(true);
        this.kDDiff.getColumn("parentmaterialnumber").getStyleAttributes().setLocked(true);
        this.kdConvertStep.getHead().setRowHeight(0, 32);
    }

    protected void removeListener() {
        if (this.cmbItemListener != null) {
            this.combSourceBomType.removeItemListener(this.cmbItemListener);
            this.combTargetBomType.removeItemListener(this.cmbItemListener);
        }
        if (this.kDTabbedPane1ChangeListener != null) {
            this.kDTabbedPane1.removeChangeListener(this.kDTabbedPane1ChangeListener);
        }
    }

    protected void addListener() {
        if (this.cmbItemListener == null) {
            this.cmbItemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        BomConvertUI.this.cmbItemStateChanged(e);
                    }
                    catch (Exception e1) {
                        BomConvertUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.combSourceBomType.addItemListener(this.cmbItemListener);
        this.combTargetBomType.addItemListener(this.cmbItemListener);
        if (this.kDTabbedPane1ChangeListener == null) {
            this.kDTabbedPane1ChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    BomConvertUI.this.kDTabbedPane(e);
                }
            };
        }
        this.kDTabbedPane1.addChangeListener(this.kDTabbedPane1ChangeListener);
    }

    protected void setBizStorageOrgUnitInfo(KDBizPromptBox f7PromptBox) {
        if (f7PromptBox == null) {
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        f7PromptBox.setEntityViewInfo(entityViewInfo);
        f7PromptBox.getQueryAgent().resetRuntimeEntityView();
    }

    protected void cmbItemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            KDComboBox combBox;
            KDComboBox kDComboBox = e == null ? null : (e.getSource() == null ? null : (combBox = e.getSource() instanceof KDComboBox ? (KDComboBox)e.getSource() : null));
            if (combBox == null) {
                return;
            }
            String combName = combBox.getName();
            if (this.combSourceBomType.getName().equals(combName)) {
                try {
                    this.setTargetBomTypeValue();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    this.handleException(e1);
                }
                this.DBomTypeChange();
            }
            if (this.combTargetBomType.getName().equals(combName)) {
                this.DBomTypeChange();
            }
        }
    }

    private void initSourceParam() throws Exception {
        this.beforeBomIDList = null;
        this.beforeDBomType = null;
        if (this.getUIContext().get("beforeBomIDList") != null) {
            this.beforeBomIDList = (ArrayList)this.getUIContext().get("beforeBomIDList");
            if (this.beforeBomIDList != null && this.beforeBomIDList.size() > 0) {
                String bomID = this.beforeBomIDList.get(0);
                BOSObjectType type = BOSUuid.getBOSObjectType((String)bomID, (boolean)true);
                if (type.toString().equals(new DesignBOMBillInfo().getBOSType().toString())) {
                    this.beforeDBomType = DBOMTypeEnum.DesignBOM;
                } else if (type.toString().equals(new DesignBomTempBillInfo().getBOSType().toString())) {
                    this.beforeDBomType = DBOMTypeEnum.DesignTempBom;
                } else if (type.toString().equals(new ProcessBomBillInfo().getBOSType().toString())) {
                    this.beforeDBomType = DBOMTypeEnum.ProcessBOM;
                } else if (type.toString().equals(new DesignBOMMiddleBillInfo().getBOSType().toString())) {
                    this.beforeDBomType = DBOMTypeEnum.DesignBomMiddle;
                } else if (type.toString().equals(new PBOMInfo().getBOSType().toString())) {
                    this.beforeDBomType = DBOMTypeEnum.PBom;
                }
            }
        }
    }

    private void setInitEntrys() throws Exception {
        if (this.combSourceBomType.getSelectedItem() == null) {
            return;
        }
        if (this.beforeBomIDList == null || this.beforeBomIDList.size() < 1) {
            return;
        }
        DBOMTypeEnum sourceBomType = (DBOMTypeEnum)((Object)this.combSourceBomType.getSelectedItem());
        HashMap<String, Object> dataParam = new HashMap<String, Object>();
        dataParam.put("beforeDBomType", (Object)sourceBomType);
        dataParam.put("beforeBomIDList", this.beforeBomIDList);
        dataParam.put("operationType", (Object)operationTypeEnum.bomConvert);
        this.info = this.getBizInterface().initStepEntrys(dataParam);
        this.combConvertStatus.setSelectedItem((Object)this.info.getConvertStatus());
        this.logID = this.info.getId().toString();
        this.kdConvertStep.removeRows();
        this.okCount = 0;
        IRow addRow = null;
        if (this.info != null && this.info.getEntrys() != null && this.info.getEntrys().size() > 0) {
            for (int i = 0; i < this.info.getEntrys().size(); ++i) {
                BomConvertLogEntryInfo entryInfo = this.info.getEntrys().get(i);
                addRow = this.kdConvertStep.addRow();
                addRow.getCell("stepname").setValue((Object)entryInfo.getStepname());
                addRow.getCell("beginDate").setValue(null);
                addRow.getCell("endDate").setValue(null);
                addRow.getCell("execTimeLong").setValue(null);
                addRow.getCell("execResult").setValue((Object)entryInfo.getExecResult());
                addRow.getCell("execStatus").setValue((Object)entryInfo.getExecStatus());
                addRow.getCell("sourceBomID").setValue((Object)entryInfo.getSourceBomID());
                addRow.getCell("id").setValue(null);
                if (entryInfo.getExecStatus().equals((Object)ExecStatusEnum.ERROR)) {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.red);
                } else {
                    ++this.okCount;
                }
                if (entryInfo.getExecStatus().equals((Object)ExecStatusEnum.NOExecute)) {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.green);
                }
                this.kdConvertStep.getBody().setRowHeight(addRow.getRowIndex(), 32);
            }
        }
    }

    private void setHeadValue() {
        if (this.beforeDBomType != null) {
            this.combSourceBomType.setSelectedItem((Object)this.beforeDBomType);
        } else {
            this.beforeDBomType = (DBOMTypeEnum)((Object)this.combSourceBomType.getSelectedItem());
        }
        if (this.beforeBomIDList != null && this.beforeBomIDList.size() > 0) {
            this.combSourceBomType.setEnabled(false);
        } else {
            this.combSourceBomType.setEnabled(true);
        }
    }

    private void setTargetBomTypeValue() throws Exception {
        if (this.combSourceBomType.getSelectedItem() == null) {
            return;
        }
        if (this.beforeBomIDList == null || this.beforeBomIDList.size() < 1) {
            return;
        }
        this.combTargetBomType.removeAllItems();
        DBOMTypeEnum sourceBomType = (DBOMTypeEnum)((Object)this.combSourceBomType.getSelectedItem());
        List<DBOMTypeEnum> targetBomTypeEnumList = this.getTargetBomTypeList(sourceBomType);
        if (targetBomTypeEnumList == null || targetBomTypeEnumList.size() < 1) {
            return;
        }
        for (int i = 0; i < targetBomTypeEnumList.size(); ++i) {
            this.combTargetBomType.addItem((Object)targetBomTypeEnumList.get(i));
        }
    }

    private void DBomTypeChange() {
    }

    private List<DBOMTypeEnum> getBomConvertTypeRelation(DBOMTypeEnum sourceBomType) throws Exception {
        ArrayList<DBOMTypeEnum> returnList = new ArrayList<DBOMTypeEnum>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        filterInfo.getFilterItems().add(new FilterItemInfo("beforeDBomType", (Object)sourceBomType.getValue()));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)8));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId()));
        viewInfo.setFilter(filterInfo);
        BomConvertTypeRelationCollection coll = BomConvertTypeRelationFactory.getRemoteInstance().getBomConvertTypeRelationCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                returnList.add(coll.get(i).getAfterDBomType());
            }
        }
        return returnList;
    }

    private List<DBOMTypeEnum> getTargetBomTypeList(DBOMTypeEnum sourceBomType) throws Exception {
        ArrayList<DBOMTypeEnum> returnList = new ArrayList<DBOMTypeEnum>();
        List<DBOMTypeEnum> relationTypeList = this.getBomConvertTypeRelation(sourceBomType);
        if (sourceBomType.equals((Object)DBOMTypeEnum.DesignTempBom)) {
            if (relationTypeList != null && relationTypeList.contains((Object)DBOMTypeEnum.DesignBOM)) {
                returnList.add(DBOMTypeEnum.DesignBOM);
            }
            if (relationTypeList != null && relationTypeList.contains((Object)DBOMTypeEnum.MfgBom)) {
                returnList.add(DBOMTypeEnum.MfgBom);
            }
        } else if (sourceBomType.equals((Object)DBOMTypeEnum.DesignBOM)) {
            if (relationTypeList != null && relationTypeList.contains((Object)DBOMTypeEnum.DesignBomMiddle)) {
                returnList.add(DBOMTypeEnum.DesignBomMiddle);
            }
            if (relationTypeList != null && relationTypeList.contains((Object)DBOMTypeEnum.ProcessBOM)) {
                returnList.add(DBOMTypeEnum.ProcessBOM);
            }
            if (relationTypeList != null && relationTypeList.contains((Object)DBOMTypeEnum.MfgBom)) {
                returnList.add(DBOMTypeEnum.MfgBom);
            }
        } else if (sourceBomType.equals((Object)DBOMTypeEnum.DesignBomMiddle)) {
            if (relationTypeList != null && relationTypeList.contains((Object)DBOMTypeEnum.ProcessBOM)) {
                returnList.add(DBOMTypeEnum.ProcessBOM);
            }
        } else if (sourceBomType.equals((Object)DBOMTypeEnum.ProcessBOM) && relationTypeList != null && relationTypeList.contains((Object)DBOMTypeEnum.MfgBom)) {
            returnList.add(DBOMTypeEnum.MfgBom);
        }
        return returnList;
    }

    private void checkBeforeConvert() throws Exception {
        if (this.isConvertIng) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"isConvertIng"));
            SysUtil.abort();
        }
        if (this.beforeBomIDList == null || this.beforeBomIDList.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"SourceBomIDNull"));
            SysUtil.abort();
        }
        if (this.okCount == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoValidConvertData"));
            SysUtil.abort();
        }
        if (this.combSourceBomType.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoBeforeBomType"));
            SysUtil.abort();
        }
        if (this.combTargetBomType.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoAfterBomType"));
            SysUtil.abort();
        }
        if (this.info == null || this.info.getEntrys() == null || this.info.getEntrys().size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoConvertEntryData"));
            SysUtil.abort();
        }
        if (this.info.getConvertStatus() != null && this.info.getConvertStatus().equals((Object)ConvertStatusEnum.ConvertEnd)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"isConvert_Retry"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionStartConvert_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeConvert();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)this.RESURL, (String)"Affirm_StartConvert")) == 2) {
            SysUtil.abort();
        }
        this.setConvertIng();
        this.refresher = new BomConvertRunThread();
        this.refresher.start();
    }

    private void setConvertIng() {
        this.isConvertIng = true;
        this.btnStartConvert.setEnabled(false);
        this.btnStartConvert.setVisible(false);
        this.btnStopConvert.setEnabled(true);
        this.btnStopConvert.setVisible(true);
        this.combConvertStatus.setSelectedItem((Object)ConvertStatusEnum.Converting);
    }

    private void setConvertEnd() {
        this.isConvertIng = false;
        this.btnStartConvert.setEnabled(true);
        this.btnStartConvert.setVisible(true);
        this.btnStopConvert.setEnabled(false);
        this.btnStopConvert.setVisible(false);
    }

    private void execConvert() throws Exception {
        DBOMTypeEnum beforeDBomtype = (DBOMTypeEnum)((Object)this.combSourceBomType.getSelectedItem());
        DBOMTypeEnum afterDBomtype = (DBOMTypeEnum)((Object)this.combTargetBomType.getSelectedItem());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("beforeDBomtype", (Object)beforeDBomtype);
        dataMap.put("afterDBomtype", (Object)afterDBomtype);
        dataMap.put("info", this.info);
        this.info = bomConvertFacadeFactory.getRemoteInstance().bomConvert(dataMap);
        this.combConvertStatus.setSelectedItem((Object)this.info.getConvertStatus());
    }

    @Override
    public void actionStopConvert_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isConvertIng) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"ISNoCounverIng"));
            SysUtil.abort();
        }
        if (MsgBox.showConfirm2((String)EASResource.getString((String)this.RESURL, (String)"Affirm_StopConvert")) == 2) {
            SysUtil.abort();
        }
        if (this.info != null) {
            bomConvertFacadeFactory.getRemoteInstance().stopConvert(this.info.getId().toString());
        }
        this.setConvertEnd();
        this.combConvertStatus.setSelectedItem((Object)ConvertStatusEnum.STOP);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"handStop"));
        SysUtil.abort();
    }

    public boolean destroyWindow() {
        if (this.isConvertIng) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"isRunning_CloseUI"));
            SysUtil.abort();
        }
        if (this.refresher != null) {
            this.refresher.destroy();
        }
        return super.destroyWindow();
    }

    private void updateEntryDatas() throws Exception {
        IRowSet rs = BomConvertLogFactory.getRemoteInstance().getStepEntrys(this.logID);
        this.kdConvertStep.removeRows();
        IRow addRow = null;
        this.execStep = 0;
        if (rs != null && rs.size() > 0) {
            while (rs.next()) {
                addRow = this.kdConvertStep.addRow();
                addRow.getCell("stepname").setValue((Object)rs.getString("fstepname"));
                if (rs.getDate("fbegindate") != null) {
                    addRow.getCell("beginDate").setValue((Object)this.sdf.format(rs.getDate("fbegindate")));
                }
                if (rs.getDate("fenddate") != null) {
                    addRow.getCell("endDate").setValue((Object)this.sdf.format(rs.getDate("fenddate")));
                }
                addRow.getCell("execTimeLong").setValue((Object)rs.getInt("fexectimelong"));
                addRow.getCell("execResult").setValue((Object)rs.getString("fexecresult"));
                addRow.getCell("execStatus").setValue((Object)ExecStatusEnum.getEnum(rs.getInt("FExecStatus")));
                addRow.getCell("sourceBomID").setValue((Object)rs.getString("fsourcebomid"));
                addRow.getCell("id").setValue((Object)rs.getString("fid"));
                if (rs.getInt("FExecStatus") == -1) {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.red);
                } else if (rs.getInt("FExecStatus") == 0) {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.green);
                } else {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.white);
                }
                if (rs.getInt("FExecStatus") == 1) {
                    this.execStep = addRow.getRowIndex();
                }
                this.kdConvertStep.getBody().setRowHeight(addRow.getRowIndex(), 32);
            }
        }
    }

    private void setDiffQty() throws Exception {
        this.kDDiff.removeRows();
        if (this.combSourceBomType.getSelectedItem() == null || this.combTargetBomType.getSelectedItem() == null || this.beforeBomIDList == null || this.beforeBomIDList.size() < 1) {
            return;
        }
        DBOMTypeEnum beforeDBomtype = (DBOMTypeEnum)((Object)this.combSourceBomType.getSelectedItem());
        DBOMTypeEnum afterDBomtype = (DBOMTypeEnum)((Object)this.combTargetBomType.getSelectedItem());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("beforeDBomtype", (Object)beforeDBomtype);
        dataMap.put("afterDBomtype", (Object)afterDBomtype);
        dataMap.put("beforeBomIDList", this.beforeBomIDList);
        IRowSet rs = bomConvertFacadeFactory.getRemoteInstance().getDiff(dataMap);
        while (rs.next()) {
            IRow addrow = this.kDDiff.addRow();
            addrow.getCell("parentmaterialnumber").setValue((Object)rs.getString("parentmaterialnumber"));
            addrow.getCell("parentmaterialname").setValue((Object)rs.getString("parentmaterialname"));
            addrow.getCell("beforeqty").setValue((Object)rs.getBigDecimal("beforeqty"));
            addrow.getCell("afterqty").setValue((Object)rs.getBigDecimal("afterqty"));
            addrow.getCell("materialnumber").setValue((Object)rs.getString("materialnumber"));
            addrow.getCell("materialname").setValue((Object)rs.getString("materialname"));
            addrow.getCell("model").setValue((Object)rs.getString("model"));
            addrow.getCell("unitname").setValue((Object)rs.getString("unitname"));
            addrow.getCell("projectnumber").setValue((Object)rs.getString("projectnumber"));
            addrow.getCell("projectname").setValue((Object)rs.getString("projectname"));
            addrow.getCell("begintracknumber").setValue((Object)rs.getString("begintracknumber"));
            addrow.getCell("endtracknumber").setValue((Object)rs.getString("endtracknumber"));
            if (rs.getBigDecimal("beforeqty").compareTo(rs.getBigDecimal("afterqty")) == 0) continue;
            addrow.getCell("beforeqty").getStyleAttributes().setBackground(Color.red);
            addrow.getCell("afterqty").getStyleAttributes().setBackground(Color.red);
        }
    }

    private void kDTabbedPane(ChangeEvent e) {
        JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
        int selectedIndex = tabbedPane.getSelectedIndex();
        if (selectedIndex == 1) {
            Component[] cps;
            LongTimeDialog dialog = new LongTimeDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            dialog.setLongTimeTask(new ILongTimeTask(){

                public void afterExec(Object result) throws Exception {
                }

                public Object exec() {
                    try {
                        BomConvertUI.this.setDiffQty();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        BomConvertUI.this.handleException(e1);
                        SysUtil.abort();
                    }
                    return "\u83b7\u53d6\u6570\u636e\u5b8c\u6bd5\uff01";
                }
            });
            for (Component cp : cps = dialog.getContentPane().getComponents()) {
                if (!(cp instanceof JLabel)) continue;
                ((JLabel)cp).setText("\u60a8\u597d,\u6b63\u5728\u83b7\u53d6\u5dee\u5f02\u5bf9\u6bd4\u6570\u636e,\u8bf7\u7a0d\u7b49.......");
            }
            dialog.show();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void kdConvertStep_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 2) return;
        if (e.getType() == 0) {
            return;
        }
        if (e.getRowIndex() < 0 || e.getColIndex() < 0) {
            return;
        }
        if (e.getColIndex() != this.kdConvertStep.getColumnIndex("execResult") || this.kdConvertStep.getCell(e.getRowIndex(), "execStatus").getValue() == null || !((ExecStatusEnum)((Object)this.kdConvertStep.getCell(e.getRowIndex(), "execStatus").getValue())).equals((Object)ExecStatusEnum.ERROR)) return;
        UIContext uiContext = new UIContext();
        IUIWindow uiWindow = null;
        String uiClass = "com.kingdee.eas.zjbom.convert.client.BomConvertLogErrTextViewUI";
        if (this.kdConvertStep.getCell(e.getRowIndex(), "id").getValue() == null) {
            if (this.kdConvertStep.getCell(e.getRowIndex(), "execResult").getValue() == null) return;
            uiContext.put((Object)"errorString", (Object)this.kdConvertStep.getCell(e.getRowIndex(), "execResult").getValue().toString());
        } else {
            uiContext.put((Object)"errorEntryID", (Object)this.kdConvertStep.getCell(e.getRowIndex(), "id").getValue().toString());
        }
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.zjbom.convert.client.BomConvertLogErrTextViewUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private class EDTUIReloader
    implements Runnable {
        private EDTUIReloader() {
        }

        @Override
        public void run() {
            try {
                BomConvertUI.this.updateEntryDatas();
            }
            catch (Exception e) {
                e.printStackTrace();
                BomConvertUI.this.handleException(e);
            }
            if (BomConvertUI.this.execStep > 0) {
                BomConvertUI.this.kdConvertStep.getLayoutManager().scrollRowToShow(BomConvertUI.this.execStep);
            }
        }
    }

    private class UIRefreshThread
    extends Thread {
        private boolean interrupted = false;
        private int last5RefreshCount = 5;

        private UIRefreshThread() {
        }

        @Override
        public void run() {
            while (!this.interrupted && BomConvertUI.this.isConvertIng) {
                try {
                    Thread.sleep(2000L);
                    ConvertStatusEnum convStatus = bomConvertFacadeFactory.getRemoteInstance().getConvertStatus(BomConvertUI.this.logID);
                    if (convStatus != null && convStatus.equals((Object)ConvertStatusEnum.STOP)) {
                        this.interrupted = true;
                        BomConvertUI.this.isConvertIng = false;
                        return;
                    }
                    SwingUtilities.invokeLater(new EDTUIReloader());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BomConvertUI.this.handleException(e);
                }
            }
        }
    }

    private class BomConvertRunThread
    extends Thread {
        private UIRefreshThread uiThread;

        private BomConvertRunThread() {
        }

        @Override
        public void run() {
            try {
                BomConvertUI.this.isConvertIng = true;
                this.uiThread = new UIRefreshThread();
                this.uiThread.start();
                BomConvertUI.this.execConvert();
                BomConvertUI.this.updateEntryDatas();
            }
            catch (Exception e) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                AdvMsgBox.createAdvMsgBox((Component)((Object)BomConvertUI.this), (String)EASResource.getString((String)BomConvertUI.this.RESURL, (String)"infoMessage"), (String)EASResource.getString((String)BomConvertUI.this.RESURL, (String)"convertErr"), (String)writer.toString(), (int)0, (int)8188).show();
                if (this.uiThread != null) {
                    this.uiThread.interrupted = true;
                }
                BomConvertUI.this.combConvertStatus.setSelectedItem((Object)ConvertStatusEnum.ERROR);
                BomConvertUI.this.handleException(e);
            }
            finally {
                BomConvertUI.this.isConvertIng = false;
                if (this.uiThread != null) {
                    this.uiThread.interrupted = true;
                }
                BomConvertUI.this.setConvertEnd();
            }
        }

        public void destroy() {
            if (this.uiThread != null) {
                this.uiThread.interrupted = true;
            }
        }
    }
}

