/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.clientUtil.ComponentUtil;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.industry.emm.common.client.OprtState;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.DesignBOMBillInfo;
import com.kingdee.eas.zjbom.DesignBOMMiddleBillInfo;
import com.kingdee.eas.zjbom.DesignBomTempBillInfo;
import com.kingdee.eas.zjbom.ProcessBomBillInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ConvertStatusEnum;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.IBomConvertLog;
import com.kingdee.eas.zjbom.convert.bomConvertFacadeFactory;
import com.kingdee.eas.zjbom.convert.client.AbstractBomUnConvertUI;
import com.kingdee.eas.zjbom.convert.operationTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BomUnConvertUI
extends AbstractBomUnConvertUI {
    private static final Logger logger = CoreUIObject.getLogger(BomUnConvertUI.class);
    private String RESURL = "com.kingdee.eas.zjbom.convert.unConvertBomResource";
    private String logID;
    private DBOMTypeEnum beforeDBomType;
    private List<String> beforeBomIDList;
    private int okCount = 0;
    private boolean isUnConvertIng = false;
    private BomConvertLogInfo info = null;
    private static final int REFRESH_INTERVAL = 2000;
    private BomUnConvertRunThread refresher;
    private DateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    private int execStep = 0;

    protected IObjectValue createNewData() {
        return null;
    }

    protected IBomConvertLog getBizInterface() throws Exception {
        return BomConvertLogFactory.getRemoteInstance();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnStartConvert.setEnabled(true);
        this.btnStopConvert.setEnabled(true);
        this.btnStartConvert.setVisible(true);
        this.btnStopConvert.setVisible(false);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemAddNew});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemEdit});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemSubmit});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemSave});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemRemove});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemPre});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCopy});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemNext});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemLast});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemFirst});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemPrint});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemPrintPreview});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCancel});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCancelCancel});
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.kdConvertStep.checkParsed();
        this.kdtEntrysSetEditor();
        try {
            this.initSourceParam();
            this.setHeadValue();
            this.setInitEntrys();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(e);
        }
    }

    protected void kdtEntrysSetEditor() {
        KDComboBox comboExecStatus = new KDComboBox();
        comboExecStatus.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.zjbom.convert.ExecStatusEnum").toArray());
        this.kdConvertStep.getColumn("execStatus").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboExecStatus));
        this.kdConvertStep.getColumn("stepname").getStyleAttributes().setWrapText(true);
        this.kdConvertStep.getColumn("execResult").getStyleAttributes().setWrapText(true);
        this.kdConvertStep.getHead().setRowHeight(0, 32);
    }

    private void initSourceParam() throws Exception {
        this.beforeBomIDList = null;
        this.beforeDBomType = null;
        if (this.getUIContext().get("beforeBomIDList") != null) {
            this.beforeBomIDList = (ArrayList)this.getUIContext().get("beforeBomIDList");
            if (this.beforeBomIDList != null && this.beforeBomIDList.size() > 0) {
                String bomID = this.beforeBomIDList.get(0);
                BOSObjectType type = BOSUuid.getBOSObjectType((String)bomID, (boolean)true);
                if (type.toString().equals(new DesignBOMBillInfo().getBOSType().toString())) {
                    this.beforeDBomType = DBOMTypeEnum.DesignBOM;
                } else if (type.toString().equals(new ProcessBomBillInfo().getBOSType().toString())) {
                    this.beforeDBomType = DBOMTypeEnum.ProcessBOM;
                } else if (type.toString().equals(new DesignBOMMiddleBillInfo().getBOSType().toString())) {
                    this.beforeDBomType = DBOMTypeEnum.DesignBomMiddle;
                } else if (type.toString().equals(new DesignBomTempBillInfo().getBOSType().toString())) {
                    this.beforeDBomType = DBOMTypeEnum.DesignTempBom;
                }
            }
        }
    }

    private void setInitEntrys() throws Exception {
        if (this.combSourceBomType.getSelectedItem() == null) {
            return;
        }
        if (this.beforeBomIDList == null || this.beforeBomIDList.size() < 1) {
            return;
        }
        DBOMTypeEnum sourceBomType = (DBOMTypeEnum)((Object)this.combSourceBomType.getSelectedItem());
        HashMap<String, Object> dataParam = new HashMap<String, Object>();
        dataParam.put("beforeDBomType", (Object)sourceBomType);
        dataParam.put("beforeBomIDList", this.beforeBomIDList);
        dataParam.put("operationType", (Object)operationTypeEnum.bomUnConvert);
        this.info = this.getBizInterface().initStepEntrys(dataParam);
        dataParam.put("beforeDBomType", (Object)sourceBomType);
        this.combConvertStatus.setSelectedItem((Object)this.info.getConvertStatus());
        this.logID = this.info.getId().toString();
        this.kdConvertStep.removeRows();
        this.okCount = 0;
        IRow addRow = null;
        if (this.info != null && this.info.getEntrys() != null && this.info.getEntrys().size() > 0) {
            for (int i = 0; i < this.info.getEntrys().size(); ++i) {
                BomConvertLogEntryInfo entryInfo = this.info.getEntrys().get(i);
                addRow = this.kdConvertStep.addRow();
                addRow.getCell("stepname").setValue((Object)entryInfo.getStepname());
                addRow.getCell("beginDate").setValue(null);
                addRow.getCell("endDate").setValue(null);
                addRow.getCell("execTimeLong").setValue(null);
                addRow.getCell("execResult").setValue((Object)entryInfo.getExecResult());
                addRow.getCell("execStatus").setValue((Object)entryInfo.getExecStatus());
                addRow.getCell("sourceBomID").setValue((Object)entryInfo.getSourceBomID());
                addRow.getCell("id").setValue(null);
                if (entryInfo.getExecStatus().equals((Object)ExecStatusEnum.ERROR)) {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.red);
                } else {
                    ++this.okCount;
                }
                if (entryInfo.getExecStatus().equals((Object)ExecStatusEnum.NOExecute)) {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.green);
                }
                this.kdConvertStep.getBody().setRowHeight(addRow.getRowIndex(), 32);
            }
        }
    }

    private void setHeadValue() {
        if (this.beforeDBomType != null) {
            this.combSourceBomType.setSelectedItem((Object)this.beforeDBomType);
        } else {
            this.beforeDBomType = (DBOMTypeEnum)((Object)this.combSourceBomType.getSelectedItem());
        }
        if (this.beforeBomIDList != null && this.beforeBomIDList.size() > 0) {
            this.combSourceBomType.setEnabled(false);
        } else {
            this.combSourceBomType.setEnabled(true);
        }
        this.combOperationType.setSelectedItem((Object)operationTypeEnum.bomUnConvert);
    }

    private void checkBeforeConvert() throws Exception {
        if (this.isUnConvertIng) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"isUnConvertIng"));
            SysUtil.abort();
        }
        if (this.beforeBomIDList == null || this.beforeBomIDList.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"SourceBomIDNull"));
            SysUtil.abort();
        }
        if (this.okCount == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoValidConvertData"));
            SysUtil.abort();
        }
        if (this.combSourceBomType.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoBeforeBomType"));
            SysUtil.abort();
        }
        if (this.info == null || this.info.getEntrys() == null || this.info.getEntrys().size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"NoConvertEntryData"));
            SysUtil.abort();
        }
        if (this.info.getConvertStatus() != null && this.info.getConvertStatus().equals((Object)ConvertStatusEnum.ConvertEnd)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"isUnConvert_Retry"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionStartConvert_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeConvert();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)this.RESURL, (String)"Affirm_StartUnConvert")) == 2) {
            SysUtil.abort();
        }
        this.setConvertIng();
        this.refresher = new BomUnConvertRunThread();
        this.refresher.start();
    }

    private void setConvertIng() {
        this.isUnConvertIng = true;
        this.btnStartConvert.setEnabled(false);
        this.btnStartConvert.setVisible(false);
        this.btnStopConvert.setEnabled(true);
        this.btnStopConvert.setVisible(true);
        this.combConvertStatus.setSelectedItem((Object)ConvertStatusEnum.Converting);
    }

    private void setConvertEnd() {
        this.isUnConvertIng = false;
        this.btnStartConvert.setEnabled(true);
        this.btnStartConvert.setVisible(true);
        this.btnStopConvert.setEnabled(false);
        this.btnStopConvert.setVisible(false);
    }

    private void execConvert() throws Exception {
        DBOMTypeEnum beforeDBomtype = (DBOMTypeEnum)((Object)this.combSourceBomType.getSelectedItem());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("beforeDBomtype", (Object)beforeDBomtype);
        dataMap.put("info", this.info);
        this.info = bomConvertFacadeFactory.getRemoteInstance().unbomConvert(dataMap);
        this.combConvertStatus.setSelectedItem((Object)this.info.getConvertStatus());
    }

    @Override
    public void actionStopConvert_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isUnConvertIng) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"ISNoUnCounverIng"));
            SysUtil.abort();
        }
        if (MsgBox.showConfirm2((String)EASResource.getString((String)this.RESURL, (String)"Affirm_StopUnConvert")) == 2) {
            SysUtil.abort();
        }
        if (this.info != null) {
            bomConvertFacadeFactory.getRemoteInstance().stopConvert(this.info.getId().toString());
        }
        this.setConvertEnd();
        this.combConvertStatus.setSelectedItem((Object)ConvertStatusEnum.STOP);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"handStop"));
        SysUtil.abort();
    }

    public boolean destroyWindow() {
        if (this.isUnConvertIng) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"isRunning_CloseUI"));
            SysUtil.abort();
        }
        if (this.refresher != null) {
            this.refresher.destroy();
        }
        return super.destroyWindow();
    }

    private void updateEntryDatas() throws Exception {
        IRowSet rs = BomConvertLogFactory.getRemoteInstance().getStepEntrys(this.logID);
        this.kdConvertStep.removeRows();
        IRow addRow = null;
        this.execStep = 0;
        if (rs != null && rs.size() > 0) {
            while (rs.next()) {
                addRow = this.kdConvertStep.addRow();
                addRow.getCell("stepname").setValue((Object)rs.getString("fstepname"));
                if (rs.getDate("fbegindate") != null) {
                    addRow.getCell("beginDate").setValue((Object)this.sdf.format(rs.getDate("fbegindate")));
                }
                if (rs.getDate("fenddate") != null) {
                    addRow.getCell("endDate").setValue((Object)this.sdf.format(rs.getDate("fenddate")));
                }
                addRow.getCell("execTimeLong").setValue((Object)rs.getInt("fexectimelong"));
                addRow.getCell("execResult").setValue((Object)rs.getString("fexecresult"));
                addRow.getCell("execStatus").setValue((Object)ExecStatusEnum.getEnum(rs.getInt("FExecStatus")));
                addRow.getCell("sourceBomID").setValue((Object)rs.getString("fsourcebomid"));
                addRow.getCell("id").setValue((Object)rs.getString("fid"));
                if (rs.getInt("FExecStatus") == -1) {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.red);
                } else if (rs.getInt("FExecStatus") == 0) {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.green);
                } else {
                    addRow.getCell("execStatus").getStyleAttributes().setBackground(Color.white);
                }
                if (rs.getInt("FExecStatus") == 1) {
                    this.execStep = addRow.getRowIndex();
                }
                this.kdConvertStep.getBody().setRowHeight(addRow.getRowIndex(), 32);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void kdConvertStep_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 2) return;
        if (e.getType() == 0) {
            return;
        }
        if (e.getRowIndex() < 0 || e.getColIndex() < 0) {
            return;
        }
        if (e.getColIndex() != this.kdConvertStep.getColumnIndex("execResult") || this.kdConvertStep.getCell(e.getRowIndex(), "execStatus").getValue() == null || !((ExecStatusEnum)((Object)this.kdConvertStep.getCell(e.getRowIndex(), "execStatus").getValue())).equals((Object)ExecStatusEnum.ERROR)) return;
        UIContext uiContext = new UIContext();
        IUIWindow uiWindow = null;
        String uiClass = "com.kingdee.eas.zjbom.convert.client.BomConvertLogErrTextViewUI";
        if (this.kdConvertStep.getCell(e.getRowIndex(), "id").getValue() == null) {
            if (this.kdConvertStep.getCell(e.getRowIndex(), "execResult").getValue() == null) return;
            uiContext.put((Object)"errorString", (Object)this.kdConvertStep.getCell(e.getRowIndex(), "execResult").getValue().toString());
        } else {
            uiContext.put((Object)"errorEntryID", (Object)this.kdConvertStep.getCell(e.getRowIndex(), "id").getValue().toString());
        }
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.zjbom.convert.client.BomConvertLogErrTextViewUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private class EDTUIReloader
    implements Runnable {
        private EDTUIReloader() {
        }

        @Override
        public void run() {
            try {
                BomUnConvertUI.this.updateEntryDatas();
            }
            catch (Exception e) {
                e.printStackTrace();
                BomUnConvertUI.this.handleException(e);
            }
            if (BomUnConvertUI.this.execStep > 0) {
                BomUnConvertUI.this.kdConvertStep.getLayoutManager().scrollRowToShow(BomUnConvertUI.this.execStep);
            }
        }
    }

    private class UIRefreshThread
    extends Thread {
        private boolean interrupted = false;
        private int last5RefreshCount = 5;

        private UIRefreshThread() {
        }

        @Override
        public void run() {
            while (!this.interrupted && BomUnConvertUI.this.isUnConvertIng) {
                try {
                    Thread.sleep(2000L);
                    ConvertStatusEnum convStatus = bomConvertFacadeFactory.getRemoteInstance().getConvertStatus(BomUnConvertUI.this.logID);
                    if (convStatus != null && convStatus.equals((Object)ConvertStatusEnum.STOP)) {
                        this.interrupted = true;
                        BomUnConvertUI.this.isUnConvertIng = false;
                        return;
                    }
                    SwingUtilities.invokeLater(new EDTUIReloader());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BomUnConvertUI.this.handleException(e);
                }
            }
        }
    }

    private class BomUnConvertRunThread
    extends Thread {
        private UIRefreshThread uiThread;

        private BomUnConvertRunThread() {
        }

        @Override
        public void run() {
            try {
                BomUnConvertUI.this.isUnConvertIng = true;
                this.uiThread = new UIRefreshThread();
                this.uiThread.start();
                BomUnConvertUI.this.execConvert();
                BomUnConvertUI.this.updateEntryDatas();
            }
            catch (Exception e) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                AdvMsgBox.createAdvMsgBox((Component)((Object)BomUnConvertUI.this), (String)EASResource.getString((String)BomUnConvertUI.this.RESURL, (String)"infoMessage"), (String)EASResource.getString((String)BomUnConvertUI.this.RESURL, (String)"unconvertErr"), (String)writer.toString(), (int)0, (int)8188).show();
                if (this.uiThread != null) {
                    this.uiThread.interrupted = true;
                }
                BomUnConvertUI.this.combConvertStatus.setSelectedItem((Object)ConvertStatusEnum.ERROR);
                BomUnConvertUI.this.handleException(e);
            }
            finally {
                BomUnConvertUI.this.isUnConvertIng = false;
                if (this.uiThread != null) {
                    this.uiThread.interrupted = true;
                }
                BomUnConvertUI.this.setConvertEnd();
            }
        }

        public void destroy() {
            if (this.uiThread != null) {
                this.uiThread.interrupted = true;
            }
        }
    }
}

