/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.process;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.bomConvertToPBomFacadeFactory;
import com.kingdee.eas.zjbom.convert.process.BomConvertBaseProcess;
import java.util.HashMap;
import java.util.Locale;

public class BomConvertPBomBaseProcess
extends BomConvertBaseProcess {
    public static String RESURL2 = "com.kingdee.eas.zjbom.convert.BomConvertToPBOMResource";

    @Override
    public void convert(Context ctx, BomConvertLogEntryInfo entryInfo, BomConvertLogInfo info) throws BOSException, EASBizException {
        super.convert(ctx, entryInfo, info);
        if (this.isException) {
            return;
        }
        if (!this.checkData(ctx)) {
            return;
        }
        this.convertPBom(ctx);
        this.afterConvert(ctx);
    }

    public void convertPBom(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("bomID", this.bomConvertLogEntryInfo.getSourceBomID());
        dataMap.put("standInfo", (String)this.bomConvertLogEntryInfo.getStandardRooting());
        dataMap.put("mrwInfo", (String)this.bomConvertLogEntryInfo.getMRWorkProcesEntry());
        bomConvertToPBomFacadeFactory.getLocalInstance(ctx).convertToPBOM(dataMap);
    }

    public boolean checkData(Context ctx) throws BOSException, EASBizException {
        if (this.bomConvertLogEntryInfo.getStandardRooting() == null) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"No_StandardRootingInfo", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (this.bomConvertLogEntryInfo.getMRWorkProcesEntry() == null) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"No_MrwProcessInfo", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (!this.getBomStatus(ctx, this.bomConvertLogEntryInfo.getSourceBomID()).equals((Object)BillBaseStatusEnum.AUDITED)) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"Bom_NoAudit", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (!this.getStandardRootingStatus(ctx, this.bomConvertLogEntryInfo.getStandardRooting().getId().toString()).equals((Object)MMBasedataStatusEnum.AUDIT)) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"StandardRooting_NoAudit", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        HashMap<String, Object> checkHaveManuMap = new HashMap<String, Object>();
        checkHaveManuMap.put("stdInfo", this.bomConvertLogEntryInfo.getStandardRooting());
        checkHaveManuMap.put("projectInfo", this.getProjectInfo(ctx, this.bomConvertLogEntryInfo.getSourceBomID()));
        if (this.bomConvertLogEntryInfo.getSourceBomID() != null) {
            BomInfo bomInfo = new BomInfo();
            bomInfo.setId(BOSUuid.read((String)this.bomConvertLogEntryInfo.getSourceBomID()));
            checkHaveManuMap.put("bomInfo", bomInfo);
        }
        if (bomConvertToPBomFacadeFactory.getLocalInstance(ctx).checkRtHasManu(checkHaveManuMap)) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL2, (String)"PbomHaveManu", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        return true;
    }

    public BillBaseStatusEnum getBomStatus(Context ctx, String fbomid) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        BomInfo bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(fbomid), sic);
        return bomInfo.getBaseStatus();
    }

    public ProjectInfo getProjectInfo(Context ctx, String fbomid) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("project.id"));
        BomInfo bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(fbomid), sic);
        return bomInfo.getProject();
    }

    public MMBasedataStatusEnum getStandardRootingStatus(Context ctx, String fstdid) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("status"));
        StandardRootingInfo standardRootingInfo = StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingInfo((IObjectPK)new ObjectUuidPK(fstdid), sic);
        return standardRootingInfo.getStatus();
    }

    @Override
    public void afterConvert(Context ctx) throws BOSException, EASBizException {
        super.afterConvert(ctx);
    }
}

