/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.process;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.ProcessBomBillInfo;
import com.kingdee.eas.zjbom.convert.BomChangeBillAuditFacadeFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.bomConvertFacadeFactory;
import com.kingdee.eas.zjbom.convert.process.BomConvertProcessBomBaseProcess;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import java.math.BigDecimal;
import java.util.Locale;

public class BomConvert_ProcessBom_Bom_Process
extends BomConvertProcessBomBaseProcess {
    @Override
    public void convert(Context ctx, BomConvertLogEntryInfo entryInfo, BomConvertLogInfo info) throws BOSException, EASBizException {
        super.convert(ctx, entryInfo, info);
        if (this.isException) {
            return;
        }
        if (!this.checkData_ProcessBom(ctx)) {
            return;
        }
        if (bomConvertFacadeFactory.getLocalInstance(ctx).convertRequired(this.processBomBillInfo, this.bomConvertLogInfo, this.bomConvertLogEntryInfo)) {
            this.afterConvert(ctx);
        }
    }

    protected static BomInfo addBomInfo(Context ctx, ProcessBomBillInfo pbInfo, MaterialInfo parentMaterialInfo, BomConvertLogInfo bclInfo) throws BOSException, EASBizException {
        BomInfo bomInfo = BomUtil.addBomInfo(ctx, parentMaterialInfo, pbInfo.getStorageOrgUnit(), pbInfo.getProject(), pbInfo.getDesignMode(), pbInfo.getParentQty(), BomConvert_ProcessBom_Bom_Process.getMeasureUnitInfo(ctx, pbInfo.getPMUnit(), parentMaterialInfo), pbInfo.getGetSupplier(), pbInfo.getMainTenanceLevel());
        return bomInfo;
    }

    protected static BomEntryInfo getBomEntryInfo(Context ctx, BomInfo bomInfo, ProcessBomBillInfo pbInfo, MaterialInfo materialInfo) throws BOSException, EASBizException {
        BomEntryInfo bomEntryInfo = BomUtil.getBomEntryInfo(ctx, bomInfo, materialInfo, pbInfo.getDrawBillOrg(), pbInfo.getBeginCarno(), pbInfo.getEndCarno());
        return bomEntryInfo;
    }

    protected static BomEntryInfo addBomEntryInfo(Context ctx, BomInfo bomInfo, ProcessBomBillInfo pbInfo, MaterialInfo materialInfo) throws BOSException, EASBizException {
        BomEntryInfo bomEntryInfo = BomUtil.addBomEntryInfo(ctx, bomInfo, materialInfo, BomConvert_ProcessBom_Bom_Process.getMeasureUnitInfo(ctx, pbInfo.getUnit(), materialInfo), pbInfo.getRation(), pbInfo.getDrawBillOrg(), pbInfo.getBeginCarno(), pbInfo.getEndCarno(), pbInfo.getMaterialProperty(), pbInfo.getSupplier(), pbInfo.getIssueProp());
        bomEntryInfo.setSupplier(pbInfo.getSupplier());
        if (pbInfo.getWeight() != null) {
            bomEntryInfo.setNetWeight(pbInfo.getWeight());
        }
        bomEntryInfo.setBlkSize(null);
        bomEntryInfo.setSpecifiedLength(null);
        bomEntryInfo.setSourceBillEntryId(pbInfo.getId().toString());
        bomEntryInfo.setSourceProcessId(pbInfo.getId().toString());
        bomEntryInfo.setSourceBillNumber(pbInfo.getNumber());
        return bomEntryInfo;
    }

    protected static void setBomEntryInfo(Context ctx, BomEntryInfo bomEntryInfo, ProcessBomBillInfo pbInfo) throws BOSException, EASBizException {
        bomEntryInfo.setConsumeFixBaseQty(pbInfo.getRation());
        bomEntryInfo.setConsumeFixQty(pbInfo.getRation());
        bomEntryInfo.setBomFlow(pbInfo.getMakeFlow());
        bomEntryInfo.setGtmeno(pbInfo.getGtmeno());
        bomEntryInfo.setSourceBillEntryId(pbInfo.getId().toString());
        bomEntryInfo.setFixSeq(pbInfo.getSeq());
        bomEntryInfo.setIssueProp(pbInfo.getIssueProp());
        bomEntryInfo.setSourceBillNumber(pbInfo.getNumber());
        bomEntryInfo.setSpecifiedLength(pbInfo.getFixSize());
    }

    public static BomInfo convertBom(Context ctx, ProcessBomBillInfo pbInfo, BomConvertLogInfo bclInfo, BomConvertLogEntryInfo bcleInfo) throws BOSException, EASBizException {
        BomInfo bomInfo;
        MaterialInfo parentMaterialInfo = BomConvert_ProcessBom_Bom_Process.getMaterialInfo(ctx, pbInfo.getParentNo());
        MaterialInfo materialInfo = BomConvert_ProcessBom_Bom_Process.getMaterialInfo(ctx, pbInfo.getPortNo());
        boolean needUpdataNext = false;
        String fprojectid = null;
        if (pbInfo.getProject() != null) {
            fprojectid = pbInfo.getProject().getId().toString();
        }
        String ftrackID = null;
        if (pbInfo.getBeginCarno() != null) {
            ftrackID = pbInfo.getBeginCarno().getId().toString();
        }
        if ((bomInfo = BomUtil.getBomInfo(ctx, parentMaterialInfo.getId().toString(), pbInfo.getStorageOrgUnit().getId().toString(), fprojectid, pbInfo.getDesignMode(), ftrackID, pbInfo.getMainTenanceLevel() == null ? null : pbInfo.getMainTenanceLevel().getId().toString())) == null) {
            bomInfo = BomConvert_ProcessBom_Bom_Process.addBomInfo(ctx, pbInfo, parentMaterialInfo, bclInfo);
        } else {
            int bomValidValue;
            if (bomInfo.getBaseStatus().equals(4)) {
                needUpdataNext = true;
            }
            if ((bomValidValue = BomUtil.checkBomisValid(ctx, pbInfo.getParentQty(), BomConvert_ProcessBom_Bom_Process.getMeasureUnitInfo(ctx, pbInfo.getPMUnit(), parentMaterialInfo), bomInfo)) == -1) {
                throw new BOSException(ResourceBase.getString((String)RESURL, (String)"parent_Qty_NoValid", (Locale)ctx.getLocale(), (Object[])new String[]{parentMaterialInfo.getNumber(), bomInfo.getProductBaseQty().toString(), pbInfo.getParentQty().toString()}));
            }
            if (bomValidValue == -2) {
                throw new BOSException(ResourceBase.getString((String)RESURL, (String)"parent_Unit_NoValid", (Locale)ctx.getLocale(), (Object[])new String[]{parentMaterialInfo.getNumber(), bomInfo.getUnit().getName(), BomConvert_ProcessBom_Bom_Process.getMeasureUnitInfo(ctx, pbInfo.getPMUnit(), parentMaterialInfo).getName()}));
            }
        }
        BomEntryInfo bomEntryInfo = BomConvert_ProcessBom_Bom_Process.getBomEntryInfo(ctx, bomInfo, pbInfo, materialInfo);
        if (bomEntryInfo == null) {
            bomEntryInfo = BomConvert_ProcessBom_Bom_Process.addBomEntryInfo(ctx, bomInfo, pbInfo, materialInfo);
        }
        BomConvert_ProcessBom_Bom_Process.setBomEntryInfo(ctx, bomEntryInfo, pbInfo);
        bomEntryInfo.setParent(bomInfo);
        bomInfo.getEntrys().add(bomEntryInfo);
        BillBaseStatusEnum bomBaseStatusEnum = bomInfo.getBaseStatus();
        if (bomInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            bomInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            if (bomInfo.getId() != null) {
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("baseStatus"));
                BomFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)bomInfo, updateSic);
            }
        }
        if (bomInfo.getId() == null) {
            BomFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)bomInfo);
        } else {
            BomFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)bomInfo);
        }
        if (!bomBaseStatusEnum.equals((Object)bomInfo.getBaseStatus())) {
            bomInfo.setBaseStatus(bomBaseStatusEnum);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("baseStatus"));
            BomFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)bomInfo, updateSic);
        }
        if (needUpdataNext && bomEntryInfo.getConsumeFixQty().compareTo(BigDecimal.ZERO) > 0) {
            BomChangeBillAuditFacadeFactory.getLocalInstance(ctx).updateNextDatasByBomEntrys(bomEntryInfo, null, DBOMTypeEnum.ProcessBOM);
        }
        return bomInfo;
    }

    @Override
    public void afterConvert(Context ctx) throws BOSException, EASBizException {
        super.afterConvert(ctx);
    }
}

