/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.process;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.DesignBOMBillFactory;
import com.kingdee.eas.zjbom.DesignBOMBillInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.bomConvertFacadeFactory;
import com.kingdee.eas.zjbom.convert.process.BomUnConvertBaseProcess;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

public class BomUnConvertDesignBomProcess
extends BomUnConvertBaseProcess {
    public DesignBOMBillInfo designBOMBillInfo = null;

    @Override
    public void unConvert(Context ctx, BomConvertLogEntryInfo entryInfo, BomConvertLogInfo info) throws BOSException, EASBizException {
        super.unConvert(ctx, entryInfo, info);
        if (this.isException) {
            return;
        }
        this.getDesignBomBillInfo(ctx, entryInfo.getSourceBomID());
        if (this.checkData(ctx) && bomConvertFacadeFactory.getLocalInstance(ctx).unconvertRequired(this.designBOMBillInfo, this.bomConvertLogInfo, this.bomConvertLogEntryInfo)) {
            this.afterUnConvert(ctx);
        }
    }

    public DesignBOMBillInfo getDesignBomBillInfo(Context ctx, String fid) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        this.designBOMBillInfo = DesignBOMBillFactory.getLocalInstance(ctx).getDesignBOMBillInfo((IObjectPK)new ObjectUuidPK(fid), sic);
        return this.designBOMBillInfo;
    }

    public boolean checkData(Context ctx) throws BOSException, EASBizException {
        if (this.designBOMBillInfo.getState() == null || !this.designBOMBillInfo.getState().equals((Object)BillBaseStatusEnum.AUDITED)) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"Status_NoAudit", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            this.updateSic = new SelectorItemCollection();
            this.updateSic.add(new SelectorItemInfo("execResult"));
            this.updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
            return false;
        }
        if (!this.designBOMBillInfo.isIsImport()) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoConvertStatus", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            this.updateSic = new SelectorItemCollection();
            this.updateSic.add(new SelectorItemInfo("execResult"));
            this.updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
            return false;
        }
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        if (this.designBOMBillInfo.getConvertBomType() != null && this.designBOMBillInfo.getConvertBomType().equals((Object)DBOMTypeEnum.DesignBomMiddle)) {
            sql.setLength(0);
            sql.append(" Select fid from CT_ZJB_DESIGNBOMMIDDLEBILL where  fsourcebillid = ? And (Cfissplit = 1 or Cfisportnosplit = 1 or Cfflowsplit = 1) ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{this.designBOMBillInfo.getId().toString()});
            if (rs != null && rs.size() > 0) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"designBomMiddle_IsSplit", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execResult"));
                this.updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                return false;
            }
            sql.setLength(0);
            sql.append(" Select fid from ct_zjb_processbombill where  fsourcebillid = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{this.designBOMBillInfo.getId().toString()});
            if (rs != null && rs.size() > 0) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"isConvertToProcessBom", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execResult"));
                this.updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                return false;
            }
            if (!this.checkPermission(ctx, this.designBOMBillInfo.getCU().getId().toString(), "emm_mm_zjbom_gybom_gybommid_delete").booleanValue()) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoPermission_DesignBomMiddle_Delete", (Locale)ctx.getLocale(), (Object[])new String[]{BomUnConvertDesignBomProcess.getOrgUnitName(ctx, this.designBOMBillInfo.getCU().getId().toString())}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execResult"));
                this.updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                return false;
            }
        } else if (this.designBOMBillInfo.getConvertBomType() != null && this.designBOMBillInfo.getConvertBomType().equals((Object)DBOMTypeEnum.ProcessBOM)) {
            sql.setLength(0);
            sql.append(" Select fid from ct_zjb_processbombill where  fsourcebillid = ? And cfstate = 4 ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{this.designBOMBillInfo.getId().toString()});
            if (rs != null && rs.size() > 0) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"processBomIsAudit", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execResult"));
                this.updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                return false;
            }
            sql.setLength(0);
            sql.append(" Select fid from ct_zjb_processbombill where  fsourcebillid = ? And (cfissplit = 1 or cfisportnosplit = 1 or cfflowsplit = 1) ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{this.designBOMBillInfo.getId().toString()});
            if (rs != null && rs.size() > 0) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"ProcessBom_IsSplit", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execResult"));
                this.updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                return false;
            }
            if (!this.checkPermission(ctx, this.designBOMBillInfo.getCU().getId().toString(), "emm_mm_zjbom_gybom_gybom_delete").booleanValue()) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoPermission_ProcessBom_Delete", (Locale)ctx.getLocale(), (Object[])new String[]{BomUnConvertDesignBomProcess.getOrgUnitName(ctx, this.designBOMBillInfo.getCU().getId().toString())}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execResult"));
                this.updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                return false;
            }
        } else if (this.designBOMBillInfo.getConvertBomType() != null && this.designBOMBillInfo.getConvertBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            sql.append(" Select d.fid As fbomentryID,h.fstorageorgunitid ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" where h.fdesignModeID = ? ");
            sql.append(" and d.fsourcebillentryid = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{this.designBOMBillInfo.getDesignMode().getId().toString(), this.designBOMBillInfo.getId().toString()});
            ArrayList<String> bomEntryIDList = new ArrayList<String>();
            ArrayList<String> orgUnitIDList = new ArrayList<String>();
            try {
                while (rs.next()) {
                    bomEntryIDList.add(rs.getString("fbomentryID"));
                    if (rs.getString("fstorageorgunitid") == null || orgUnitIDList.contains(rs.getString("fstorageorgunitid"))) continue;
                    orgUnitIDList.add(rs.getString("fstorageorgunitid"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            String bomCheckResule = BomUtil.checkBomCanUnConvert(ctx, bomEntryIDList);
            if (bomCheckResule == null || !bomCheckResule.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(bomCheckResule);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                this.updateSic = new SelectorItemCollection();
                this.updateSic.add(new SelectorItemInfo("execResult"));
                this.updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                return false;
            }
            if (orgUnitIDList != null && orgUnitIDList.size() > 0) {
                for (int i = 0; i < orgUnitIDList.size(); ++i) {
                    if (this.checkPermission(ctx, ((String)orgUnitIDList.get(i)).toString(), "mm_bom_delete").booleanValue()) continue;
                    this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoPermission_BOM_Delete", (Locale)ctx.getLocale(), (Object[])new String[]{BomUnConvertDesignBomProcess.getOrgUnitName(ctx, ((String)orgUnitIDList.get(i)).toString())}));
                    this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                    this.updateSic = new SelectorItemCollection();
                    this.updateSic.add(new SelectorItemInfo("execResult"));
                    this.updateSic.add(new SelectorItemInfo("execStatus"));
                    this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, this.updateSic);
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean execUnConvert(Context ctx, DesignBOMBillInfo dbomBillInfo) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        if (dbomBillInfo.getConvertBomType() != null && dbomBillInfo.getConvertBomType().equals((Object)DBOMTypeEnum.DesignBomMiddle)) {
            sql.setLength(0);
            sql.append(" delete from CT_ZJB_DESIGNBOMMIDDLEBILL where  fsourcebillid = ? ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{dbomBillInfo.getId().toString()});
            sql.setLength(0);
            sql.append(" delete from t_bot_relation a where a.fsrcobjectid = ? and fdestentityid = ?  ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{dbomBillInfo.getId().toString(), "084B500E"});
        } else if (dbomBillInfo.getConvertBomType() != null && dbomBillInfo.getConvertBomType().equals((Object)DBOMTypeEnum.ProcessBOM)) {
            sql.setLength(0);
            sql.append(" delete from ct_zjb_processbombill where  fsourcebillid = ? ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{dbomBillInfo.getId().toString()});
            sql.setLength(0);
            sql.append(" delete from t_bot_relation a where a.fsrcobjectid = ? and fdestentityid = ?  ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{dbomBillInfo.getId().toString(), "A6CCC268"});
        } else if (dbomBillInfo.getConvertBomType() != null && dbomBillInfo.getConvertBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            sql.append(" Select d.fid As fbomentryID,h.fid As fbomid ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" where h.fdesignModeID = ? ");
            sql.append(" and d.fsourcebillentryid = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{dbomBillInfo.getDesignMode().getId().toString(), dbomBillInfo.getId().toString()});
            ArrayList<String> bomEntryIDList = new ArrayList<String>();
            ArrayList<String> bomIDList = new ArrayList<String>();
            try {
                while (rs.next()) {
                    bomEntryIDList.add(rs.getString("fbomentryID"));
                    bomIDList.add(rs.getString("fbomid"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            sql.setLength(0);
            sql.append(" delete from t_mm_bomentry where  fid in (").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" delete from t_mm_bom where  fid in (").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
            sql.append(" And Not Exists(Select 1 from t_mm_bomentry where fparentid =  t_mm_bom .fid ) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" delete from t_bot_relation a where a.fsrcobjectid = ? and fdestentityid = ?  ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{dbomBillInfo.getId().toString(), "8F409A89"});
        }
        return true;
    }

    @Override
    public void afterUnConvert(Context ctx) throws BOSException, EASBizException {
        super.afterUnConvert(ctx);
        this.updateDesignBomStatus(ctx);
    }

    public void updateDesignBomStatus(Context ctx) throws BOSException, EASBizException {
        this.designBOMBillInfo.setIsImport(false);
        this.designBOMBillInfo.setConvertBomType(DBOMTypeEnum.NULL);
        this.designBOMBillInfo.setConvertDate(null);
        this.designBOMBillInfo.setConverter(null);
        this.updateSic = new SelectorItemCollection();
        this.updateSic.add(new SelectorItemInfo("isImport"));
        this.updateSic.add(new SelectorItemInfo("convertBomType"));
        this.updateSic.add(new SelectorItemInfo("convertDate"));
        this.updateSic.add(new SelectorItemInfo("converter"));
        DesignBOMBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)this.designBOMBillInfo, this.updateSic);
    }
}

