/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.imm.client;

import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.imm.BillStatusEnum;
import com.kingdee.eas.industry.emm.imm.IProjectBillBase;
import com.kingdee.eas.industry.emm.imm.ProjectBillBaseInfo;
import com.kingdee.eas.industry.emm.imm.client.AbstractProjectBillListUI;
import com.kingdee.eas.industry.emm.imm.util.PrjCommonDataProvider;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class ProjectBillListUI
extends AbstractProjectBillListUI {
    private static final long serialVersionUID = 8294563744943071340L;
    public CommonQueryDialog commonQueryDialog = null;
    private String Resource_Name = "com.kingdee.eas.industry.emm.imm.EMMPROJECTImmResource";
    private String PROJECT_BSTJBNSH = com.kingdee.bos.util.EASResource.getString((String)this.Resource_Name, (String)"PROJECT_BSTJBNSH");
    private String PROJECT_DJBSFSH = com.kingdee.bos.util.EASResource.getString((String)this.Resource_Name, (String)"PROJECT_DJBSFSH");

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billID = this.getSelectedKeyValue();
        if (billID == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billID));
        if (!this.getBizInterface().exists((IObjectPK)pk)) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("billStatus"));
        CoreBaseInfo o = this.getBizInterface().getValue((IObjectPK)pk, sc);
        ProjectBillBaseInfo prjBillBaseInfo = (ProjectBillBaseInfo)o;
        if (prjBillBaseInfo.getBillStatus() != BillStatusEnum.SUBMIT) {
            String msg = this.PROJECT_BSTJBNSH;
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        this.auditBill(pk);
        this.refresh(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanEdit();
        super.actionEdit_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.print(false);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.print(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            ArrayList ids = super.getSelectedIdValues();
            if (ids != null) {
                boolean hasException = false;
                ICoreBase prjBillBase = this.getBizInterface();
                int num = ids.size();
                for (int i = 0; i < num; ++i) {
                    try {
                        this.setOprtState("REMOVE");
                        this.pubFireVOChangeListener(ids.get(i).toString());
                    }
                    catch (Throwable ex) {
                        if (num == 1) {
                            this.handUIException(ex);
                            this.abort();
                        }
                        hasException = true;
                        continue;
                    }
                    try {
                        prjBillBase.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids.get(i).toString())));
                    }
                    catch (Exception onfe) {
                        if (num == 1) {
                            this.refreshList();
                            throw onfe;
                        }
                        hasException = true;
                    }
                    try {
                        this.setOprtState("RELEASEALL");
                        this.pubFireVOChangeListener(ids.get(i).toString());
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (hasException) {
                    this.refreshList();
                    throw new SCMBillException(SCMBillException.PARTOFDELETEDBILL_CANNOT_BE_DELETE);
                }
            }
            this.refresh(e);
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.confirmUnAduit()) {
            return;
        }
        String billID = this.getSelectedKeyValue();
        if (billID == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billID));
        if (!this.getBizInterface().exists((IObjectPK)pk)) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("billStatus"));
        CoreBaseInfo o = this.getBizInterface().getValue((IObjectPK)pk, sc);
        ProjectBillBaseInfo prjBillBaseInfo = (ProjectBillBaseInfo)o;
        if (prjBillBaseInfo.getBillStatus() != BillStatusEnum.AUDIT) {
            String msg = this.PROJECT_DJBSFSH;
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        ((IProjectBillBase)this.getBizInterface()).unAudit((IObjectPK)pk);
        this.refresh(e);
    }

    public void auditBill(ObjectUuidPK pk) throws Exception {
        ((IProjectBillBase)this.getBizInterface()).passAudit((IObjectPK)pk, null);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void print(boolean isPreview) {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().getNewPrintManager().getPrinter();
        if (isPreview) {
            this.tblMain.getPrintManager().printPreview();
        } else {
            this.tblMain.getPrintManager().print();
        }
    }

    protected void checkCanEdit() throws Exception {
        String id = this.getSelectedKeyValue();
        if (id != null) {
            ObjectStringPK pk = new ObjectStringPK(id);
            ProjectBillBaseInfo billInfo = ((IProjectBillBase)this.getBizInterface()).getProjectBillBaseInfo((IObjectPK)pk);
            this.checkCanEdit(billInfo);
        }
    }

    protected void checkCanEdit(ProjectBillBaseInfo billInfo) throws Exception {
        if (!(billInfo.getBillStatus().equals((Object)BillStatusEnum.SAVE) || billInfo.getBillStatus().equals((Object)BillStatusEnum.SUBMIT) || billInfo.getBillStatus().equals((Object)BillStatusEnum.ADDNEW))) {
            MsgBox.showError((Component)((Object)this), (String)(SCMClientUtils.getResource((String)"BillAt") + billInfo.getBillStatus().getAlias() + SCMClientUtils.getResource((String)"CantBeEdited")));
            SysUtil.abort();
        }
    }

    protected boolean confirmUnAduit() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.imm.EMMPROJECTImmResource", (String)"0EMMPROJECTImm-0008")));
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        return null;
    }

    protected String getTDFileName() {
        return "mm/pm/imm/ProjectCharter";
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.industry.emm.imm.app.ProjectCharterPrintR1Query");
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        return super.initCommonQueryDialog();
    }

    protected boolean initDefaultFilter() {
        return super.initDefaultFilter();
    }

    protected void invokePrintFunction(boolean isPrint) {
        List idList = new ArrayList();
        idList = this.getSelectedIdForPrint();
        if (idList == null || idList.size() == 0 || this.getTDFileName() == null) {
            return;
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        PrjCommonDataProvider mainQueryData = new PrjCommonDataProvider(idList, this.getTDQueryPK());
        data.put("MainQuery", (BOSQueryDelegate)mainQueryData);
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }
}

