/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.manufacturelocation.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.manufacturelocation.basedata.client.AbstractLDBomFilterUI;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LDBomFilterUI
extends AbstractLDBomFilterUI {
    protected KDCheckBox expandAllNextBOM;

    public LDBomFilterUI() throws Exception {
        this.init();
    }

    public LDBomFilterUI(String order) throws Exception {
        this.init();
    }

    protected void init() {
        this.expandAllNextBOM = new KDCheckBox();
        this.expandAllNextBOM.setName("");
        this.expandAllNextBOM.setText(EASResource.getString((String)"com.kingdee.eas.industry.emm.manufacturelocation.basedata.EMMPROJECTBasedataResource", (String)"0EMMPROJECTBasedata-0013"));
    }

    public void initBomFilterUILayout() {
        super.initBomFilterUILayout();
        this.lblMaterialTo.setVisible(false);
        this.expandAllNextBOM.setBounds(new Rectangle(250, 54, 190, 19));
        this.add((Component)this.expandAllNextBOM, new KDLayout.Constraints(250, 54, 190, 19, 0));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.industry.emm.manufacturelocation.basedata.EMMPROJECTBasedataResource", (String)"0EMMPROJECTBasedata-0014"));
        CompositeFilterElement elements = (CompositeFilterElement)this.getFilterManager().getElement();
        elements.add((FilterElement)new SingleFilterElement("material.number", (Component)this.prmptMaterialFrom));
        elements.add((FilterElement)new SingleFilterElement("expandAllNextBOM", (Component)this.expandAllNextBOM));
        this.cmbBomType.setSelectedItem((Object)BOMTypeEnum.LDBOM);
        SingleFilterElement bomTypeElement = new SingleFilterElement("bomType", (Component)this.cmbBomType);
        bomTypeElement.setDefaultValue((Object)BOMTypeEnum.LDBOM);
        elements.add((FilterElement)bomTypeElement);
        this.cmbBomType.setEnabled(false);
        this.prmtProject.setRequired(true);
    }

    public boolean verify() {
        try {
            if (this.getProjectID() == null || "".equals(this.getProjectID())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.manufacturelocation.basedata.EMMPROJECTBasedataResource", (String)"0EMMPROJECTBasedata-0015"));
                SysUtil.abort();
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        return super.verify();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        if (filter == null) {
            return filter;
        }
        this.removeFilterItem(filter, "expandAllNextBOM");
        if (this.expandAllNextBOM != null && this.expandAllNextBOM.isSelected()) {
            try {
                String projectID = this.getProjectID();
                Set materialIds = this.getMaterialIDs();
                Set bomids = BomFactory.getRemoteInstance().expandBOM(projectID, materialIds);
                if (bomids != null && bomids.size() > 0) {
                    FilterInfo filter_id = new FilterInfo();
                    filter_id.getFilterItems().add(new FilterItemInfo("id", (Object)bomids, CompareType.INCLUDE));
                    this.removeFilterItem(filter, "material.number");
                    filter.setMaskString(null);
                    filter.mergeFilter(filter_id, "and");
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return filter;
    }

    protected boolean removeFilterItem(FilterInfo filter, String ... propertyName) {
        FilterItemCollection items = filter.getFilterItems();
        ArrayList<FilterItemInfo> removes = new ArrayList<FilterItemInfo>();
        List<String> ppns = Arrays.asList(propertyName);
        for (int i = 0; i < items.size(); ++i) {
            String ppn = items.get(i).getPropertyName();
            if (!ppns.contains(ppn)) continue;
            removes.add(items.get(i));
        }
        boolean re = false;
        for (int i = 0; i < removes.size(); ++i) {
            re = items.remove((FilterItemInfo)removes.get(i));
        }
        filter.setMaskString(null);
        return re;
    }

    protected String getProjectID() throws BOSException {
        Object o = this.prmtProject.getValue();
        if (o == null) {
            o = this.prmtProject.getText();
        }
        String projectID = null;
        if (o != null) {
            ProjectCollection pc;
            ProjectInfo pi = null;
            if (Object[].class.isInstance(o)) {
                Object[] os = (Object[])o;
                if (os.length > 0) {
                    pi = (ProjectInfo)os[0];
                }
            } else if (ProjectInfo.class.isInstance(o)) {
                pi = (ProjectInfo)o;
            } else if (String.class.isInstance(o) && (pc = ProjectFactory.getRemoteInstance().getProjectCollection("where number = '" + o + "'")) != null && pc.size() > 0) {
                pi = pc.get(0);
            }
            if (pi != null) {
                projectID = pi.getId().toString();
            }
        }
        return projectID;
    }

    protected Set getMaterialIDs() throws BOSException {
        Object o = this.prmptMaterialFrom.getValue();
        if (o == null) {
            o = this.prmptMaterialFrom.getText();
        }
        String id = null;
        if (o != null) {
            MaterialInfo mi = null;
            if (MaterialInfo.class.isInstance(o)) {
                mi = (MaterialInfo)o;
            } else if (String.class.isInstance(o)) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("id"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", o));
                MaterialCollection mc = MaterialFactory.getRemoteInstance().getMaterialCollection(evi);
                if (mc != null && mc.size() > 0) {
                    mi = mc.get(0);
                }
            }
            if (mi != null) {
                id = mi.getId().toString();
            }
        }
        if (id == null) {
            return null;
        }
        HashSet<String> ids = new HashSet<String>();
        ids.add(id);
        return ids;
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.expandAllNextBOM.setSelected(false);
    }

    protected void bomTypeChanged(ItemEvent e) {
        super.bomTypeChanged(e);
        this.prmtProject.setRequired(true);
    }
}

