/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonFilterPanel;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.industry.emm.project.biz.mrp.client.PMRPPlannerWorkPlatformTotalQureyUI;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class PMRPCommonQueryDialogAdapter {
    public static final String UICONTEXT_KEY_INITPARAMS = "UICONTEXT_KEY_INITPARAMS";
    public static final String CUSTOMERPARAM = "customerParam";
    protected CommonQueryDialog queryDialog = null;
    private SCMBillFilterUI[] userPanels = null;
    private CoreUI owner;
    private IMetaDataPK pk;
    private String title;
    private boolean showFilter;
    private boolean showSorter;
    private RptParams filter;
    private String parentUIName;

    public RptParams getFilter() {
        return this.filter;
    }

    public void setFilter(RptParams filter) {
        this.filter = filter;
    }

    public PMRPCommonQueryDialogAdapter(CoreUI owner) {
        this.owner = owner;
        this.pk = new MetaDataPK("com.kingdee.eas.framework.report.app", "CommRptEmptyQuery");
    }

    public void setCustomerQueryPanel(SCMBillFilterUI[] userPanels) {
        this.userPanels = userPanels;
        if (userPanels != null && userPanels.length > 0) {
            this.parentUIName = userPanels[0].getClass().getName();
        }
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanels != null) {
            int i;
            int n = this.userPanels.length;
            for (i = 0; i < n; ++i) {
                this.userPanels[i].loadFields();
            }
            for (i = 0; i < n; ++i) {
                this.queryDialog.addUserPanel((KDPanel)this.userPanels[i]);
            }
            this.queryDialog.setShowFieldCompare(false);
            this.queryDialog.setOwner((Component)this.owner);
            this.queryDialog.setQueryObjectPK(this.pk);
            this.queryDialog.setDisShowRowCount(true);
            this.queryDialog.setTitle(this.title + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
            this.queryDialog.setShowFilter(true);
            this.queryDialog.setShowSorter(this.showSorter);
            this.queryDialog.setParentUIClassName(this.parentUIName);
            this.initUserPanels(n);
            this.queryDialog.setWidth(this.userPanels[0].getBounds().width);
            this.queryDialog.setHeight(this.userPanels[0].getBounds().height);
        }
    }

    private void initUserPanels(int n) throws Exception, IllegalAccessException, InvocationTargetException {
        CustomerParams cp = null;
        if (this.filter != null) {
            cp = RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.filter);
        }
        for (int i = 0; i < n; ++i) {
            this.userPanels[i].initLayout();
            this.userPanels[i].onInit(this.filter);
            this.userPanels[i].setCustomerParams(cp);
            this.userPanels[i].getUIContext().clear();
            this.userPanels[i].getUIContext().putAll(this.owner.getUIContext());
        }
    }

    protected Dimension getQueryDialogSize(CustomerQueryPanel[] userPanels) {
        Dimension size = new Dimension(100, 100);
        int n = userPanels.length;
        for (int i = 0; i < n; ++i) {
            Dimension d = userPanels[i].getSize();
            if (d.height > size.height) {
                size.height = d.height;
            }
            if (d.width <= size.width) continue;
            size.width = d.width;
        }
        size.height += 35;
        size.width += 228;
        size.height += 105;
        if (size.width <= 290 && size.height <= 280) {
            size.width = 290;
            size.height = 280;
        } else if (size.width <= 580 && size.height <= 435) {
            size.width = 580;
            size.height = 435;
        } else if (size.width <= 680 && size.height <= 510) {
            size.width = 680;
            size.height = 510;
        } else if (size.width <= 792 && size.height <= 566) {
            size.width = 792;
            size.height = 566;
        }
        size.width -= 228;
        size.height -= 105;
        return size;
    }

    public boolean showQueryDialog(boolean useDefaultSolution) throws Exception {
        if (this.queryDialog == null) {
            this.queryDialog = new CommonQueryDialog(){

                public void init() throws UIException {
                    super.init();
                    if (!PMRPCommonQueryDialogAdapter.this.showFilter) {
                        CommonFilterPanel filter = this.getCommonFilterPanel();
                        if (filter == null) {
                            return;
                        }
                        Container p = filter.getParent();
                        if (p instanceof KDTabbedPane) {
                            KDTabbedPane tab = (KDTabbedPane)p;
                            for (int i = 0; i < tab.getTabCount(); ++i) {
                                if (filter != tab.getComponentAt(i)) continue;
                                tab.removeTabAt(i);
                                break;
                            }
                        }
                    }
                }
            };
            if (this.userPanels != null && this.userPanels.length > 0) {
                this.title = this.userPanels[0].getUITitle();
            }
            this.initQueryDialog();
        }
        int n = this.userPanels.length;
        if (useDefaultSolution) {
            this.loadDefaultSolution(n);
        }
        boolean ok = false;
        if ((this.filter == null || !useDefaultSolution) && this.queryDialog.show()) {
            if (this.filter == null) {
                this.filter = new RptParams();
            } else {
                this.filter.clear();
            }
            for (int i = 0; i < n; ++i) {
                RptParams param = this.userPanels[i].getFilterManager().getRptParams();
                if (param == null) continue;
                this.filter.putAll(param.toMap());
            }
            String sid = ((PMRPPlannerWorkPlatformTotalQureyUI)this.userPanels[0]).getStorageOrgUnitID();
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.put("storageOrgID", sid);
            this.filter.putAll(tempMap);
            ok = true;
        }
        if (this.filter != null && (ok || useDefaultSolution)) {
            CustomerParams cp = RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.filter);
            for (int i = 0; i < n; ++i) {
                this.userPanels[i].setCustomerParams(cp);
            }
            if (this.userPanels.length > 0) {
                String sid = ((PMRPPlannerWorkPlatformTotalQureyUI)this.userPanels[0]).getStorageOrgUnitID();
                HashMap<String, String> tempMap = new HashMap<String, String>();
                tempMap.put("storageOrgID", sid);
                this.filter.putAll(tempMap);
            }
            return true;
        }
        return false;
    }

    private void loadDefaultSolution(int n) throws BOSException, EASBizException {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (iQuery.hasDefaultSolution(this.parentUIName, queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.pk).getFullName())) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.parentUIName, queryName);
            QueryPanelInfo[] qpi = new QueryPanelInfo[n];
            for (int i = 0; i < n; ++i) {
                qpi[i] = solution.getQueryPanelInfo().get(i);
            }
            if (qpi[0] != null) {
                try {
                    byte[] bs = qpi[0].getParam();
                    if (bs != null) {
                        this.filter = (RptParams)CommonUtil.getObject((byte[])bs);
                    }
                    if (this.filter != null) {
                        CustomerParams cp = RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.filter);
                        for (int i = 0; i < n; ++i) {
                            this.userPanels[i].setCustomerParams(cp);
                        }
                    } else {
                        CustomerParams[] cp = new CustomerParams[n];
                        for (int i = 0; i < n; ++i) {
                            cp[i] = CustomerParams.getCustomerParams2((String)qpi[i].getCustomerParams());
                            if (cp[i] == null) continue;
                            Object obj = null;
                            if (obj instanceof RptParams) {
                                this.filter = obj;
                                continue;
                            }
                            if (this.filter == null) {
                                this.filter = new RptParams();
                            }
                            for (int j = 0; j < n; ++j) {
                                if (!this.userPanels[j].getClass().toString().endsWith(qpi[i].getPanelClassName().toString())) continue;
                                this.userPanels[j].setCustomerParams(cp[i]);
                                this.userPanels[j].getFilterManager().setCustomerParams(cp[i], false);
                                RptParams param = this.userPanels[j].getFilterManager().getRptParams();
                                if (param == null) continue;
                                this.filter.putAll(param.toMap());
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isShowFilter() {
        return this.showFilter;
    }

    public void setShowFilter(boolean showFilter) {
        this.showFilter = showFilter;
    }

    public boolean isShowSorter() {
        return this.showSorter;
    }

    public void setShowSorter(boolean showSorter) {
        this.showSorter = showSorter;
    }

    public static boolean showFilterDialog(String filterUIName, PMRPCommonQueryDialogAdapter adapter, boolean useDefaultSolution) throws Exception {
        if (adapter.queryDialog == null) {
            String[] uiName = filterUIName.split(",");
            SCMBillFilterUI[] filterUIs = new SCMBillFilterUI[uiName.length];
            for (int i = 0; i < uiName.length; ++i) {
                SCMBillFilterUI filterUI;
                filterUIs[i] = filterUI = (SCMBillFilterUI)Class.forName(uiName[i]).newInstance();
            }
            adapter.setCustomerQueryPanel(filterUIs);
            adapter.setShowFilter(false);
            adapter.setShowSorter(false);
        }
        return adapter.showQueryDialog(useDefaultSolution);
    }
}

