/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedFactory;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPDataAnalysisFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.client.AbstractPMRPDataAnalysisUI;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PMRPDataAnalysisUI
extends AbstractPMRPDataAnalysisUI {
    private static final Logger logger = CoreUIObject.getLogger(PMRPDataAnalysisUI.class);
    private String successful = "\u6210\u529f";
    private int seq = 0;
    private String errorText = "";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionanalysis_actionPerformed(ActionEvent e) throws Exception {
        Component[] cps;
        LongTimeDialog dialog = new LongTimeDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((String)"\u68c0\u67e5\u5b8c\u6bd5");
            }

            public Object exec() throws Exception {
                String obj = "12345";
                PMRPDataAnalysisUI.this.analysisData(null);
                return obj;
            }
        });
        for (Component cp : cps = dialog.getContentPane().getComponents()) {
            if (!(cp instanceof JLabel)) continue;
            ((JLabel)cp).setText("\u60a8\u597d,\u6570\u636e\u68c0\u67e5\u4e2d,\u8bf7\u7a0d\u7b49.......");
        }
        dialog.show();
    }

    public void analysisData(ActionEvent e) throws Exception {
        this.checkData();
        PlanDefinedInfo planDefinedInfo = (PlanDefinedInfo)this.prmtPlanDefine.getValue();
        ProjectInfo projectInfo = null;
        if (this.prmtProject.getValue() != null) {
            projectInfo = (ProjectInfo)this.prmtProject.getValue();
        }
        planDefinedInfo = PMRPDataAnalysisUI.getPlanDefinedInfo(planDefinedInfo.getId().toString());
        this.kDTable1.removeRows();
        this.errorText = "";
        this.seq = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Map returnMap = null;
        paramMap.put("projectInfo", projectInfo);
        paramMap.put("planDefinedInfo", planDefinedInfo);
        returnMap = PMRPDataAnalysisFacadeFactory.getRemoteInstance().billAnalysis(paramMap);
        this.addKdttbale(returnMap);
        if (returnMap.containsKey("ProjectIDList")) {
            ArrayList ProjectIDList = (ArrayList)returnMap.get("ProjectIDList");
            paramMap.put("ProjectIDList", ProjectIDList);
        }
        returnMap = PMRPDataAnalysisFacadeFactory.getRemoteInstance().baseSetAnalysis(paramMap);
        this.addKdttbale(returnMap);
        returnMap = PMRPDataAnalysisFacadeFactory.getRemoteInstance().bomAnalysis(paramMap);
        this.addKdttbale(returnMap);
        returnMap = PMRPDataAnalysisFacadeFactory.getRemoteInstance().otherAnalysis(paramMap);
        this.addKdttbale(returnMap);
    }

    protected void addKdttbale(Map returnMap) throws Exception {
        if (returnMap != null && returnMap.size() > 0) {
            Set set = returnMap.keySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                String key = String.valueOf(it.next());
                if (key.equals("ProjectIDList")) continue;
                String fvalue = (String)returnMap.get(key);
                ++this.seq;
                IRow arow = this.kDTable1.addRow();
                arow.setHeight(50);
                arow.getCell("seq").setValue((Object)this.seq);
                arow.getCell("setpname").setValue((Object)key);
                arow.getCell("result").setValue((Object)fvalue);
                if (fvalue != null && !fvalue.equals(this.successful)) {
                    arow.getCell("result").getStyleAttributes().setBackground(Color.RED);
                }
                arow.getCell("setpname").getStyleAttributes().setWrapText(true);
                arow.getCell("result").getStyleAttributes().setWrapText(true);
                if (this.errorText == null || "".equals(this.errorText)) {
                    this.errorText = key + "----" + fvalue;
                    continue;
                }
                this.errorText = this.errorText + "\r\n\r\n" + key + "----" + fvalue;
            }
        }
    }

    protected void checkData() {
        if (this.prmtPlanDefine.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8ba1\u5212\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SysUtil.abort();
        }
        PlanDefinedInfo planDefinedInfo = (PlanDefinedInfo)this.prmtPlanDefine.getValue();
        ProjectInfo projectInfo = null;
        if (this.prmtProject.getValue() != null) {
            projectInfo = (ProjectInfo)this.prmtProject.getValue();
        }
        try {
            planDefinedInfo = PMRPDataAnalysisUI.getPlanDefinedInfo(planDefinedInfo.getId().toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
            SysUtil.abort();
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
            SysUtil.abort();
        }
        if (planDefinedInfo.getStatus() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8ba1\u5212\u65b9\u6848-\u72b6\u6001\u4e3a\u7a7a\uff01");
            SysUtil.abort();
        }
        if (!planDefinedInfo.getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8ba1\u5212\u65b9\u6848-\u672a\u6838\u51c6\uff01");
            SysUtil.abort();
        }
        if (projectInfo != null && !projectInfo.getBaseStatus().equals((Object)MMBaseStatusEnum.AUDIT)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u9879\u76ee\u53f7\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\uff01");
            SysUtil.abort();
        }
        if (planDefinedInfo.getSupplyRelation() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8ba1\u5212\u65b9\u6848-\u65e0\u4f9b\u5e94\u5173\u7cfb\uff01");
            SysUtil.abort();
        }
        if (!planDefinedInfo.getSupplyRelation().getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8ba1\u5212\u65b9\u6848-\u4f9b\u5e94\u5173\u7cfb-\u672a\u6838\u51c6\uff01");
            SysUtil.abort();
        }
        if (planDefinedInfo.getPurchaseRelation() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8ba1\u5212\u65b9\u6848-\u65e0\u91c7\u8d2d\u5173\u7cfb\uff01");
            SysUtil.abort();
        }
        if (!planDefinedInfo.getPurchaseRelation().getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8ba1\u5212\u65b9\u6848-\u91c7\u8d2d\u5173\u7cfb-\u672a\u6838\u51c6\uff01");
            SysUtil.abort();
        }
    }

    private static PlanDefinedInfo getPlanDefinedInfo(String id) throws BOSException, EASBizException {
        PlanDefinedInfo pdInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("SupplyRelation.*"));
        sic.add(new SelectorItemInfo("SupplyRelation.Entry.*"));
        sic.add(new SelectorItemInfo("SupplyRelation.Entry.productOrgUnit.*"));
        sic.add(new SelectorItemInfo("SupplyRelation.Entry.supplyOrgUnit.*"));
        sic.add(new SelectorItemInfo("PurchaseRelation.*"));
        sic.add(new SelectorItemInfo("PurchaseRelation.Entry.*"));
        sic.add(new SelectorItemInfo("PurchaseRelation.Entry.productOrgUnit.*"));
        sic.add(new SelectorItemInfo("PurchaseRelation.Entry.cenSupplyOrgUnit.*"));
        sic.add(new SelectorItemInfo("PurchaseRelation.Entry.purchaseOrgUnit.*"));
        pdInfo = PlanDefinedFactory.getRemoteInstance().getPlanDefinedInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return pdInfo;
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnAnalysis.setEnabled(true);
        this.btnViewText.setEnabled(true);
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.prmtProject.setRequired(false);
        this.btnBatchException.setEnabled(true);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuBar.remove((Component)this.menuFile);
        this.menuBar.remove((Component)this.menuEdit);
        this.menuBar.remove((Component)this.menuView);
    }

    @Override
    public void actionViewText_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewText_actionPerformed(e);
        if (this.errorText == null || "".equals(this.errorText)) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u65e0\u4fe1\u606f\uff01");
            return;
        }
        UIContext uiContext = new UIContext();
        IUIWindow uiWindow = null;
        uiContext.put((Object)"errorText", (Object)this.errorText);
        String uiClass = "com.kingdee.eas.industry.emm.project.biz.mrp.client.PMRPAnalysisViewTextUI";
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.industry.emm.project.biz.mrp.client.PMRPAnalysisViewTextUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionBatchException_actionPerformed(ActionEvent e) throws Exception {
        this.checkData();
        PlanDefinedInfo planDefinedInfo = (PlanDefinedInfo)this.prmtPlanDefine.getValue();
        ProjectInfo projectInfo = null;
        if (this.prmtProject.getValue() != null) {
            projectInfo = (ProjectInfo)this.prmtProject.getValue();
        }
        planDefinedInfo = PMRPDataAnalysisUI.getPlanDefinedInfo(planDefinedInfo.getId().toString());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("projectInfo", projectInfo);
        paramMap.put("planDefinedInfo", planDefinedInfo);
        UIContext uiContext = new UIContext();
        IUIWindow uiWindow = null;
        String uiClass = "com.kingdee.eas.industry.emm.project.biz.mrp.client.PMRPBatchExceptionTypeUI";
        uiContext.put((Object)"paramMap", paramMap);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClass, (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }
}

