/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedFactory;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.client.AbstractPMRPExecutionLogsFilterUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Date;

public class PMRPExecutionLogsFilterUI
extends AbstractPMRPExecutionLogsFilterUI {
    private static final long serialVersionUID = 1L;
    private String Resource_Name = "com.kingdee.eas.industry.emm.basedata.EMMPROJECTEMMBasedataResource";
    private String JHZZ_NAME = EASResource.getString((String)this.Resource_Name, (String)"JHZZ_NAME");
    private String JHFA_NAME = EASResource.getString((String)this.Resource_Name, (String)"JHFA_NAME");
    private String XQKSRQ_NAME = EASResource.getString((String)this.Resource_Name, (String)"XQKSRQ_NAME");
    private String XQJSRQ_NAME = EASResource.getString((String)this.Resource_Name, (String)"XQJSRQ_NAME");
    private String QTX_INFO = EASResource.getString((String)this.Resource_Name, (String)"QTX_INFO");
    private String JZGLFA_FAIL = EASResource.getString((String)this.Resource_Name, (String)"JZGLFA_FAIL");
    private String WZDCSMC_NAME = EASResource.getString((String)this.Resource_Name, (String)"WZDCSMC_NAME");

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtPlanOrg.setValue((Object)SysContext.getSysContext().getCurrentStorageUnit());
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        StringBuilder mask = new StringBuilder();
        StorageOrgUnitInfo planOrg = (StorageOrgUnitInfo)this.prmtPlanOrg.getValue();
        PlanDefinedInfo pd = (PlanDefinedInfo)this.prmtPlanDefined.getValue();
        MaterialInfo material = (MaterialInfo)this.prmtMaterial.getValue();
        Date from = this.dpDateFrom.getSqlDate();
        Date to = this.dpDateTo.getSqlDate();
        this.filterInfo.getFilterItems().add(new FilterItemInfo("planOrg.id", (Object)planOrg.getId().toString()));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("planDefined.id", (Object)pd.getId().toString()));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("requirementDate", (Object)from, CompareType.GREATER_EQUALS));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("requirementDate", (Object)to, CompareType.LESS_EQUALS));
        mask.append("#0 and #1 and #2 and #3");
        if (material != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString()));
            mask.append(" and #4");
        }
        this.filterInfo.setMaskString(mask.toString());
        return super.getFilterInfo();
    }

    public boolean verify() {
        StringBuilder tips = new StringBuilder();
        StorageOrgUnitInfo planOrg = (StorageOrgUnitInfo)this.prmtPlanOrg.getValue();
        PlanDefinedInfo pd = (PlanDefinedInfo)this.prmtPlanDefined.getValue();
        Date from = this.dpDateFrom.getSqlDate();
        Date to = this.dpDateTo.getSqlDate();
        if (planOrg == null) {
            tips.append("[").append(this.JHZZ_NAME).append("]");
        }
        if (pd == null) {
            if (tips.length() > 0) {
                tips.append(",");
            }
            tips.append("[").append(this.JHFA_NAME).append("]");
        }
        if (from == null) {
            if (tips.length() > 0) {
                tips.append(",");
            }
            tips.append("[").append(this.XQKSRQ_NAME).append("]");
        }
        if (to == null) {
            if (tips.length() > 0) {
                tips.append(",");
            }
            tips.append("[").append(this.XQJSRQ_NAME).append("]");
        }
        if (tips.length() > 0) {
            tips.insert(0, this.QTX_INFO);
            MsgBox.showInfo((Component)((Object)this), (String)tips.toString());
        }
        return planOrg != null && pd != null && from != null && to != null;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            java.util.Date to;
            String planOrgID = cp.getCustomerParam("planOrgID");
            if (!StringUtil.isEmptyString((String)planOrgID)) {
                this.prmtPlanOrg.setValue((Object)StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)planOrgID))));
            } else {
                this.prmtPlanOrg.setValue(null);
            }
            String planDefinedID = cp.getCustomerParam("planDefinedID");
            if (!StringUtil.isEmptyString((String)planDefinedID)) {
                this.prmtPlanDefined.setValue((Object)PlanDefinedFactory.getRemoteInstance().getPlanDefinedInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)planDefinedID))));
            } else {
                this.prmtPlanDefined.setValue(null);
            }
            String materialID = cp.getCustomerParam("materialID");
            if (!StringUtil.isEmptyString((String)materialID)) {
                this.prmtMaterial.setValue((Object)MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)materialID))));
            } else {
                this.prmtMaterial.setValue(null);
            }
            java.util.Date from = cp.getDate("dateFrom");
            if (from != null) {
                this.dpDateFrom.setValue((Object)from);
            }
            if ((to = cp.getDate("dateTo")) != null) {
                this.dpDateTo.setValue((Object)to);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.showError((Component)((Object)this), (String)this.JZGLFA_FAIL);
        }
        super.setCustomerParams(cp);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = new CustomerParams();
        customerParams.putDate("dateFrom", (java.util.Date)this.dpDateFrom.getSqlDate());
        customerParams.putDate("dateTo", (java.util.Date)this.dpDateTo.getSqlDate());
        StorageOrgUnitInfo planOrg = (StorageOrgUnitInfo)this.prmtPlanOrg.getValue();
        PlanDefinedInfo pd = (PlanDefinedInfo)this.prmtPlanDefined.getValue();
        MaterialInfo material = (MaterialInfo)this.prmtMaterial.getValue();
        if (material != null) {
            customerParams.addCustomerParam("materialID", material.getId().toString());
        }
        if (pd != null) {
            customerParams.addCustomerParam("planDefinedID", pd.getId().toString());
        }
        if (planOrg != null) {
            customerParams.addCustomerParam("planOrgID", planOrg.getId().toString());
        }
        return customerParams;
    }

    public Object getFilterParam(String paramName) {
        if ("dateFrom".equals(paramName)) {
            return this.dpDateFrom.getSqlDate();
        }
        if ("dateTo".equals(paramName)) {
            return this.dpDateTo.getSqlDate();
        }
        if ("planOrg".equals(paramName)) {
            return this.prmtPlanOrg.getValue();
        }
        if ("planDefined".equals(paramName)) {
            return this.prmtPlanDefined.getValue();
        }
        throw new IllegalArgumentException(this.WZDCSMC_NAME);
    }
}

